(define (run-benchmark name count run ok?)
  (if (not (ok? (run-bench name count run ok?)))
    (begin
      (display "*** wrong result ***")
      (newline))))

(define (run-bench name count run ok?)
  (let loop ((i 0) (result (list 'undefined)))
    (if (< i count)
      (loop (+ i 1) (run))
      result)))

(define (fatal-error . args)
  (for-each display args)
  (newline)
  (exit 1))

(define FLOAT+ +)
(define FLOAT- -)
(define FLOAT* *)
(define FLOAT/ /)

(define FLOAT= =)
(define FLOAT< <)
(define FLOAT<= <=)
(define FLOAT> >)
(define FLOAT>= >=)

(define (FLOATnegative? x) (< x 0.0)) ; bug in (negative? -2.3)
;(define FLOATnegative? negative?)
(define FLOATpositive? positive?)
(define FLOATzero? zero?)

(define FLOATabs abs)
(define FLOATsin sin)
(define FLOATcos cos)
(define FLOATatan atan)
(define FLOATsqrt sqrt)
(define FLOATmin min)
(define FLOATmax max)
(define FLOATround round)
(define FLOATinexact->exact inexact->exact)

(define bitwise-or bit-or)
(define bitwise-and bit-and)
(define bitwise-not bit-not)
