package biss.jde;

import biss.ObserverSocket;
import biss.PackageProperties;
import biss.awt.BarMenu;
import biss.awt.Border;
import biss.awt.Button;
import biss.awt.Key;
import biss.awt.Label;
import biss.awt.Layouter;
import biss.awt.List;
import biss.awt.Menu;
import biss.awt.TextArea;
import biss.awt.TopWindow;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;

/**
 * physical view for analyzing/modifying CompileUnits (*.java source files)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class CUViewer
  extends TopWindow
  implements Observer
{
	BarMenu BMenu = new BarMenu();
	List TypePane = new List();
	List ImptPane = new List();
	List DataPane = new List();
	List MthdPane = new List();
	TextArea TxtPane = new TextArea();
	Label ModeInfo = new Label();
	Label FileInfo = new Label();
	Label ChangeInfo = new Label();
	Button AcceptBtn = new Button( "~Accept");
	Layouter GM = new Layouter( this);

static {
	Label.setDefaultBorderStyle( Border.BS_INSET);
}

public CUViewer () {
	//  Bounds = Jde.CUBrowserRect;
	open();
}

public CUViewer ( Rectangle openRect) {
	Bounds = openRect;
	open();
}

public void init () {
	setBarMenu();
	setTypeMenu();
	setImptMenu();
	setDataMenu();
	setMthdMenu();
	BMenu.OsCommand.addObserver( this);
}

public static void main ( String[] args ) {
	new CUViewer();
}

public void open () {
	GM.add( BMenu,        0,    0, 1000,    0, true,    0,   0,    0,   140,  0);
	GM.add( TypePane,     0,    0,  250,  250, true,    30, 160,   0,     0,  0);
	GM.add( ImptPane,     0,  250,  250,  500, true,    30,   0,   0,     0,  2);
	GM.add( DataPane,   250,    0,  550,  500, true,    0,  160,   0,     0,  1);
	GM.add( MthdPane,   550,    0, 1000,  500, true,    0,  160,  -30,    0,  1);
	GM.add( TxtPane,      0,  500, 1000, 1000, true,    30,   0,  -30, -160,  2);
	GM.add( ModeInfo,     0, 1000, 1000, 1000, true,    30, -150,-1700,  -20,  0);
	GM.add( FileInfo,  1000, 1000, 1000, 1000, true, -1680, -150, -870,  -20,  0);
	GM.add( ChangeInfo,1000, 1000, 1000, 1000, true,  -850, -150, -620,  -20,  0);
	GM.add( AcceptBtn, 1000, 1000, 1000, 1000, true,  -600, -160,  -20,  -20,  0);

	GM.newLayout();
	GM.addLikeDefault( BMenu);
	GM.add( DataPane,     0,    0,  400,  500,  true,  30,  160,  0,   0,   0);
	GM.add( MthdPane,   400,    0, 1000,  500,  true,  0,   160, -30,  0,   1);
	GM.add( TxtPane,      0,  500, 1000, 1000,  true,  30,    0, -30, -160, 2);
	GM.addLikeDefault( ModeInfo);
	GM.addLikeDefault( FileInfo);
	GM.addLikeDefault( ChangeInfo);
	GM.addLikeDefault( AcceptBtn);

	GM.newLayout();
	GM.addLikeDefault( BMenu);
	GM.add( TxtPane,      0,    0, 1000, 1000,  true,  30,  160, -30, -160,  0);
	GM.addLikeDefault( ModeInfo);
	GM.addLikeDefault( FileInfo);
	GM.addLikeDefault( ChangeInfo);
	GM.addLikeDefault( AcceptBtn);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openIn( 20, 20, 500, 400);
}

void setBarMenu () {
	BMenu.addItem( "File", new Menu( "Format,Print,Print Text"));
	BMenu.addItem( "~Package.");
	BMenu.addItem( "C~lone.");
	BMenu.addItem( "~Save.");
	BMenu.addItem( "~Compile.");
	BMenu.addItem( "C~mt/Src.");
	BMenu.addItem( "~Goto..");
	BMenu.addItem( "~Zoom.");
}

void setDataMenu () {
	Menu m = new Menu();
	m.addItem( "~add");
	m.addItem( "~remove");
	m.addItem( "r~eplace");
	m.addSeparator();
	m.addItem( "a~ttributes");
	m.addSeparator();
	m.addItem( "filter mods");
	m.addItem( "clear filter");
	m.addSeparator();
	m.addItem( "select all");
	m.addItem( "clear selection");
	DataPane.setMenu( m);

	DataPane.addHotKey( Key.Delete, 0, "remove");
}

void setImptMenu () {
	Menu m = new Menu();
	m.addItem( "~add");
	m.addItem( "~remove");
	m.addItem( "r~eplace");
	m.addSeparator();
	m.addItem( "select all");
	m.addItem( "clear selection");
	ImptPane.setMenu( m);

	ImptPane.addHotKey( Key.Delete, 0, "remove");
}

void setMthdMenu () {
	Menu m = new Menu();
	m.addItem( "~add");
	m.addItem( "~remove");
	m.addItem( "r~eplace");
	m.addSeparator();
	m.addItem( "a~ttributes");
	m.addItem( "~format");
	m.addItem( "templates");
	m.addSubItem( "templates", "main", "tmpl.main");
	m.addSubItem( "templates", "ctor", "tmpl.ctor");
	m.addSubItem( "templates", "finalize", "tmpl.finalize");
	m.addSubItem( "templates", "update", "tmpl.update");
	m.addSeparator();
	m.addItem( "filter mods");
	m.addItem( "filter id");
	m.addItem( "clear filter");
	m.addSeparator();
	m.addItem( "select all");
	m.addItem( "clear selection");
	MthdPane.setMenu( m);

	MthdPane.addHotKey( Key.Delete, 0, "remove");
}

void setTypeMenu () {
	Menu m = new Menu();
	m.addItem( "~add");
	m.addItem( "~remove");
	m.addSeparator();
	m.addItem( "attributes");
	m.addItem( "rename");
	m.addSeparator();
	m.addItem( "select all");
	m.addItem( "clear selection");
	TypePane.setMenu( m);

	TypePane.addHotKey( Key.Delete, 0, "remove");
}

public void update ( Observable slot, Object arg ) {
	if ( slot == BMenu.OsCommand ) {
		if ( "Zoom.".equals( arg) ) 
			GM.setNextLayout();
	}
	else
		super.update( slot, arg);
}
}
