package biss.awt.kernel;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.peer.ComponentPeer;

/**
 * kernel implementation of java.awt.FontMetrics.
 * This is mainly a container for various native FontMetric infos, which
 * are set by Lib.initFontMetrics()
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class FontMetrics
  extends java.awt.FontMetrics
{
	NativeLib Lib;
	boolean IsFixed;
	int Widths[] = new int[256];
	int Width;
	int Height;
	int Descent;
	int Ascent;
	int Leading;
	int MaxAdvance;
	int MaxDescent;
	int MaxAscent;
	boolean IsWideFont;
	long PData;

FontMetrics ( NativeLib lib, Font font ) {
	super( font);
	Lib = lib;

	Lib.initFontMetrics( this);
}

public int charsWidth ( char data[], int off, int len ) {
	int i, w;
	int n = off+len;

	for ( i=off, w=0; i <n; i++ )
		w += Widths[data[i]];

	return w;
}

protected void finalize () throws Throwable {
	super.finalize();
	Lib.releaseFontMetrics( this);
}

public int geMaxtDescent() {
	return MaxDescent;
}

public int getAscent() {
	return Ascent;
}

public int getDescent() {
	return Descent;
}

public int getHeight() {
	return Height;
}

public int getLeading() {
	return Leading;
}

public int getMaxAdvance() {
	return MaxAdvance;
}

public int getMaxAscent() {
	return MaxAscent;
}

public int[] getWidths() {
	return Widths;
}

public int stringWidth ( String str ) {
	return Lib.stringWidth( this, str);
}
}
