package biss.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

/**
 * abstract base class for Splitbars ( HSplitBar / VSplitBar)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
abstract public class SplitBar
  extends Canvas
{
	int CursorType;
	boolean Dragging = false;
	int Height;
	int Id;
	int Max;
	int Min;
	Graphics PGr;
	Container Parent;
	boolean ResizeSelf;
	Vector Siblings;
	int Width;
	int X;
	int XPos;
	int Y;
	int YPos;
	PaintCmd RetainPainter = (Awt.FilterPaints > 0) ? new PaintCmd( this)  : null;
	Frame Fr;

public void addNotify () {
	super.addNotify();
	Parent = getParent();
	Fr = getFrame();
}

public void addSibling ( Component c ) {
	if ( Siblings == null )
		Siblings = new Vector(4);
	Siblings.addElement( c);
}

abstract void computeSiblings ();

public Frame getFrame () {
	Container c;
	for ( c = Parent; c!= null; c=c.getParent() ){
		if ( c instanceof Frame)
			return (Frame)c;
	}
	return null;
}

public int getId () {
	return Id;
}

public Vector getSiblings () {
	return Siblings;
}

void hideSiblings () {
	Component c;
	Rectangle r;
	int i, n;

	if ( Siblings == null )
		computeSiblings();
	n = Siblings.size();

	PGr = Parent.getGraphics();
	if ( PGr == null )
		return;
	PGr.setColor( Color.lightGray);

	Min = 100000;
	Max = 0;

	for ( i=0; i<n; i++ ) {
		c = (Component) Siblings.elementAt( i);
		c.hide();
		r = c.bounds();
		if ( ! ( c instanceof SplitBar ) ){
			if ( Awt.AwtToolkit == Awt.TK_WIN ) {
				// Win bug workarounds: inset paint / 3DRect draw sync 
				Insets in = Parent.insets();
				Thread.yield();
				PGr.fill3DRect( r.x-in.left, r.y-in.top, r.width, r.height, true);
			}
			else {
				PGr.fill3DRect( r.x, r.y, r.width, r.height, true);
			}
		}
		updateMoveBoundaries( r);
	}

	PGr.setColor( Color.black);
	PGr.setXORMode( Color.lightGray);
}

public boolean mouseDown ( Event evt, int x, int y ) {
	Dragging = true;
	ResizeSelf = true;

	X = x;
	Y = 0;
	hideSiblings();
	
	Fr.setCursor( CursorType);
	return true;
}

public boolean mouseEnter ( Event evt, int x, int y) {
	Fr.setCursor( CursorType);
	return true;
}

public boolean mouseMove ( Event evt, int x, int y) {
	Fr.setCursor( CursorType);
	return true;
}

public boolean mouseUp ( Event evt, int x, int y ) {
	Dragging = false;

	Fr.setCursor( Frame.DEFAULT_CURSOR);

	if ( ResizeSelf )
		rearrange();

	showSiblings();
	return true;
}

abstract void rearrange ();

public void reshape ( int x, int y, int width, int height ) {
	super.reshape( x, y, width, height);

	XPos = x; YPos = y;
	Width = width; Height = height;
}

public void setBounds( int min, int max ) {
	Min = min;
	Max = max;
}

void showSiblings () {
	int i, n = Siblings.size();
	Component c;
	Dimension s;

	s = Parent.size();
	PGr.setColor( Parent.getBackground());
	PGr.setPaintMode();
	PGr.fillRect( 0, 0, s.width+1, s.height+1);

	for ( i=0; i<n; i++ ) {
		c = (Component) Siblings.elementAt( i);
		c.show();
	}
	
	PGr.dispose();
}

public void skipResize () {
	ResizeSelf = false;
}

abstract void updateMoveBoundaries ( Rectangle r );
}
