package biss.awt;

import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

/**
 * two dimensional scroll widget (like the editres panner widget).
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Panner
  extends Control
{
	Rectangle PanArea;
	Rectangle SliderRect = new Rectangle(0, 0, 10, 10);
	Point DragOffs;
/**
 * triggered by pan drag operation ( mouse1Drag)
 * parameter: current position point( x, y)
 */
	ObserverSocket OsMove = new ObserverSocket( this);
	Point Position = new Point( 0, 0);
	Graphics Gr;

public Panner () {
	this( 0, 0, 100, 100);
}

public Panner (int minX, int minY, int maxX, int maxY) {
	setBackground( Color.white);
	setForeground( Color.blue);
	PanArea = new Rectangle( minX, minY, maxX - minX, maxY - minY);
}

void blankSliderRect ( Graphics g) {
	g.setColor( getBackground() );
	g.fillRect( SliderRect.x, SliderRect.y, SliderRect.width, SliderRect.height);
}

void drawSliderRect ( Graphics g) {
	g.fillRect( SliderRect.x, SliderRect.y, SliderRect.width, SliderRect.height);
}

public void mouse1Down( Event evt) {
	if ( SliderRect.inside( evt.x, evt.y))
		DragOffs = new Point( evt.x - SliderRect.x, evt.y - SliderRect.y);
	else
		DragOffs = null;
	Gr = getGraphics();
	/*
	  Gr.setColor( getForeground() );
	  Gr.setXORMode( getBackground() );
	 */
}

public void mouse1Drag( Event evt) {
	if ( DragOffs == null || Gr == null )
		return;
	blankSliderRect( Gr);
	//  drawSliderRect( Gr);
	SliderRect.x = Math.max( 0, Math.min( evt.x - DragOffs.x, Width - SliderRect.width));
	SliderRect.y = Math.max( 0, Math.min( evt.y - DragOffs.y, Height - SliderRect.height));
	Gr.setColor( Color.red);
	drawSliderRect( Gr);

	Position.x = SliderRect.x * PanArea.width / (Width - SliderRect.width) + PanArea.x;
	Position.y = SliderRect.y * PanArea.height / (Height - SliderRect.height) + PanArea.y;
	OsMove.notifyObservers( Position);
}

public void mouse1Up( Event evt) {
	DragOffs = null;
	
	if ( Gr != null )
		Gr.dispose();
}

protected void posChanged() {
	SliderRect.x = (Width - SliderRect.width) * (Position.x - PanArea.x) / PanArea.width;
	SliderRect.y = (Height - SliderRect.height) * (Position.y - PanArea.y) / PanArea.height;
}

public void redraw( Graphics g) {
	blank( g);
	g.setColor( getForeground());
	drawSliderRect( g);
}

public void setPanDim (int width, int height ) {
	setPanRect( PanArea.x, PanArea.y, width, height);
}

public void setPanRect (int x, int y, int width, int height ) {
	if ( Position.x < x)
		Position.x = x;
	else if ( Position.x > x + width)
		Position.x = x + width;
	if ( Position.y < y)
		Position.y = y;
	else if ( Position.y > y + height)
		Position.y = y + height;

	PanArea.reshape( x, y, width, height);
	updatePosition();
}

public void setPosition( int x, int y) {
	Position.x = x;
	Position.y = y;
	Graphics g = getGraphics();
	
	if ( g != null ) {
		blankSliderRect( g);
		SliderRect.x = (Width - SliderRect.width) * (x - PanArea.x) / PanArea.width;
		SliderRect.y = (Height - SliderRect.height) * (y - PanArea.y) / PanArea.height;
		g.setColor( getForeground() );
		drawSliderRect( g);
		g.dispose();
	}
}

public void setSliderDim (int width, int height ) {
	SliderRect.reshape( 0, 0, width, height);
	updatePosition();
}

public void setXRange (int min, int max ) {
	setPanRect( min, PanArea.y, max-min, PanArea.height);
}

public void setYRange (int min, int max ) {
	setPanRect( PanArea.x, min, PanArea.width, max-min);
}

void updatePosition() {
	if ( isShowing() )
		setPosition( Position.x, Position.y);
}
}
