package biss.awt;


/**
 * simple TextField contents checker to validate time specs. Doesn't have
 * a sophisticated time grammar yet.
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class EntryTimeChecker
  implements EntryKeyFilter, EntryValidator
{

public boolean isValidKey( int pos, char c) {
	switch( pos) {
	case 0: return ( (c >= '0') && (c <='2'));
	case 1: return ( (c >= '0') && (c <='9'));
	case 2: return ( c == ':' );
	case 3: return ( (c >= '0') && (c <='5'));
	case 4: return ( (c >= '0') && (c <='9'));
	}
	return false;
}

public String validateContents( String cont) {

	int hr=0, mn=0;
	int idx, len=cont.length();
	char c;

	for ( idx=0; idx<len; idx++) {
		c = cont.charAt( idx);
		if ( c == ':') break;
		hr=hr*10+c-48;
	}
	for ( idx++; idx<len; idx++) {
		c = cont.charAt( idx);
		mn=mn*10+c-48;
	}

	if ( (len != 5) || ( hr > 23) || ( mn > 59))
		return "???";

	return cont;
}
}
