/*
 * WMMail - Window Maker Mail
 *
 * Copyright (c) 1996, 1997, 1998  Per Liden
 * Copyright (c) 1997, 1998  Bryan Chan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * std_icons.c: routine to load the default WMMail icons
 *
 * $Id: std_icons.c,v 1.4 1998/12/31 05:39:21 bryan.chan Exp $
 *
 */

#include "wmmail.h"
#include "wmutil.h"
#include "std_icons.h"

static char *no_mail_icon[] = 
  {
    "48 48 3 1",
    " 	c None",
    ".	c #000000",
    "+	c #FFFFFF",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "   +++++++++++++++++++++++++++++++++++++++++    ",
    "   +++++++++++++++++++++++++++++++++++++++++.   ",
    "   +..+.+..+++++++++++++++++++++++++++++++++..  ",
    "   ++++++++++++++++++++++++++++++++++.....++... ",
    "   +...+.+..+++++++++++++++++++++++++++.+.++... ",
    "   +++++++++++++++++++++++++++++++++++....++... ",
    "   +...+.+....++++++++++++++++++++++++....++... ",
    "   ++++++++++++++++++++++++++++++++++.....++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++...++....+...+++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++.+++.++.++.+.+++.+++++++++++++++... ",
    "   +++++++++.+..+.+....+.+.+..++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++.+.++.+++.+++.+.+..+.+.+++++++++... ",
    "   +++++++++.++.+....+..+..++...+..+++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   ............................................ ",
    "    ........................................... ",
    "      ......................................... ",
    "                                                ",
    "                                                "
  };

static char *old_mail_icon[] =
  {
    "48 48 3 1",
    " 	c None",
    ".	c #000000",
    "+	c #FFFFFF",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                                ",
    "                                  ++.           ",
    "                                 +  .           ",
    "                               +++++ .          ",
    "                             ++++++++.          ",
    "                           +++++++++++.         ",
    "                         +++++++++++++.         ",
    "                       +++++++++.++++++.        ",
    "                     ++++++++++.+++++++.        ",
    "                   +++++++++.+++++++.+++.       ",
    "                 ++++++++++.++++++.+++++.       ",
    "               +++++++++..++++++..+++++++.      ",
    "             +++++++++..++++++..++++++.++.+     ",
    "            ++.............................     ",
    "   +++++++++++++++++++++++++++++++++++++++++    ",
    "   +++++++++++++++++++++++++++++++++++++++++.   ",
    "   +..+.+..+++++++++++++++++++++++++++++++++..  ",
    "   ++++++++++++++++++++++++++++++++++.....++... ",
    "   +...+.+..+++++++++++++++++++++++++++.+.++... ",
    "   +++++++++++++++++++++++++++++++++++....++... ",
    "   +...+.+....++++++++++++++++++++++++....++... ",
    "   ++++++++++++++++++++++++++++++++++.....++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++...++....+...+++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++.+++.++.++.+.+++.+++++++++++++++... ",
    "   +++++++++.+..+.+....+.+.+..++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++.+.++.+++.+++.+.+..+.+.+++++++++... ",
    "   +++++++++.++.+....+..+..++...+..+++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   ............................................ ",
    "    ........................................... ",
    "      ......................................... ",
    "                                                ",
    "                                                "
  };

static char *new_mail_icon[] =
  {
    "48 48 3 1",
    " 	c None",
    ".	c #000000",
    "+	c #FFFFFF",
    "                                                ",
    "                        +.                      ",
    "                       +++.                     ",
    "                      +++++.                    ",
    "                     +++++++.                   ",
    "                    +++++++++.                  ",
    "                   ++++.++++++.    +.           ",
    "                  ++++.++.+++++.++  .           ",
    "                 ++++++++++.++.+++++ .          ",
    "                ++++.++.++.+.++++++++.          ",
    "               ++++.++++++.+++++++++++.         ",
    "              ++++.++.++.+++++++++++++.         ",
    "             ++++.++.+++++++++++.++++++.        ",
    "            +++++++.+++++++++++.+++++++.        ",
    "           ++++.++++++++++++.+++++++.+++.       ",
    "          ++++.++++++++++++.++++++.+++++.       ",
    "         ++++.++++++++++..++++++..+++++++.      ",
    "        ++++.+++++++++..++++++..++++++.++.+     ",
    "       +...+++.............................     ",
    "   +++++++++++++++++++++++++++++++++++++++++    ",
    "   +++++++++++++++++++++++++++++++++++++++++.   ",
    "   +..+.+..+++++++++++++++++++++++++++++++++..  ",
    "   ++++++++++++++++++++++++++++++++++.....++... ",
    "   +...+.+..+++++++++++++++++++++++++++.+.++... ",
    "   +++++++++++++++++++++++++++++++++++....++... ",
    "   +...+.+....++++++++++++++++++++++++....++... ",
    "   ++++++++++++++++++++++++++++++++++.....++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++...++....+...+++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++.+++.++.++.+.+++.+++++++++++++++... ",
    "   +++++++++.+..+.+....+.+.+..++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++.+.++.+++.+++.+.+..+.+.+++++++++... ",
    "   +++++++++.++.+....+..+..++...+..+++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   +++++++++++++++++++++++++++++++++++++++++... ",
    "   ............................................ ",
    "    ........................................... ",
    "      ......................................... ",
    "                                                ",
    "                                                "
  };

static char **std_icons[] = { no_mail_icon, old_mail_icon, new_mail_icon };


void load_std_icons()
{
  int i;

  for (i = NO_MAIL; i <= NEW_MAIL; i++)
    if (animations[i] == NULL)
    {
      animations[i] = (XpmIcon *) wmalloc(sizeof(XpmIcon));

      animations[i]->attributes.valuemask   = (XpmExactColors | XpmCloseness);
      animations[i]->attributes.exactColors = FALSE;
      animations[i]->attributes.closeness   = 40000;

      if (XpmCreatePixmapFromData(disp, root, std_icons[i], 
                                  &animations[i]->pixmap, 
                                  &animations[i]->mask, 
                                  &animations[i]->attributes) < 0)
      {
        croak("cannot load standard XPM icons");
        exit(-1);
      }
      else
        animations[i]->next = animations[i];
    }
}
