/*
 * WMMail - Window Maker Mail
 *
 * Copyright (c) 1996, 1997, 1998  Per Liden
 * Copyright (c) 1997, 1998  Bryan Chan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * net.c: TCP I/O functions used by both pop3.c and imap.c
 *
 * $Id: net.c,v 1.1 1999/01/16 04:50:24 bryan.chan Exp $
 *
 */

#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "wmmail.h"
#include "wmutil.h"

#if defined(IMAP_SUPPORT) || defined(POP3_SUPPORT)

int socket_read(int socket, char *buf, int bufsize)
{
  int i;

  for (i = 0; i < bufsize; /* see below */ )
  {
    if (recv(socket, &buf[i], 1, 0) == -1)
#ifdef DEBUG
    {
      croak("socket_read() failed!");
      return False;
    }
#else
      return False;
#endif

    if (buf[i] == '\n')
      break;

    if (buf[i] != '\r')
      i++; 
  }

  buf[i] = '\0';

#ifdef DEBUG
  croak("socket_read: %s", buf);
#endif
  return True;
}

 
int socket_write(int socket, char *buf)
{
  int i, length, ret;

#ifdef DEBUG
  croak("socket_write: %s", buf);
#endif
  for (i = 0, length = strlen(buf); i != length; i += ret)
  {
    ret = send(socket, &buf[i], length - i, 0);

    if (ret == -1)
#ifdef DEBUG
    {
      croak("socket_write() failed!");
      return False;
    }
#else
      return False; 
#endif
  }
  return True;
}

#endif
