#include "global.h"
#include "mmedia.h"


static char *mm_types[]=
{
  "gif", (char *) MM_TYPE_GIF,
  "jpg", (char *) MM_TYPE_JPEG,
  "jpeg", (char *) MM_TYPE_JPEG,
  "ppm", (char *) MM_TYPE_PPM,
  "png", (char *) MM_TYPE_PNG,
  "pcx", (char *) MM_TYPE_PCX,
  NULL
};

int MM_getType(char *url)
{
  char *p, **t;

  p = url+strlen(url)-1;
  while (p>url && *p != '.') p--;
  if (*p == '.') {
    p++;
    t = mm_types;
    while (t[0] != NULL) {
      if (strcmp(t[0],p) == 0) return (int)t[1];
      t += 2;
    }
  }
  return MM_TYPE_UNKNOWN;
}

Public
MM_Image *MM_newImage(int xsize, int ysize, int format)
{
  MM_Image *image;

  image = malloc(sizeof(MM_Image));
  image->xsize = xsize;
  image->ysize = ysize;
  image->format = format;
  image->pixmap = calloc(xsize*ysize,3);
  return image;
}

Public
void MM_freeImage(MM_Image *image)
{
  if (image == NULL)
    return;
  free(image->pixmap);
  free(image);
}
    

/************************************************************/
/* Resampling */
/************************************************************/

#define INTERP_NORM_BITS  8
#define INTERP_NORM       (1 << INTERP_NORM_BITS)
#define INTERP_NORM1_BITS  16
#define INTERP_NORM1       (1 << INTERP_NORM_BITS)

/*
 * bilinear interpolation with xf,yf normalized to 2^16
 */
Private inline
int interpolate(int v00, int v01, int v10, int v11, int xf, int yf)
{
  int v0, v1, v;

  v0 = v00+(((v01-v00)*xf) >> INTERP_NORM_BITS);
  v1 = v10+(((v11-v10)*xf) >> INTERP_NORM_BITS);
  v = v0+(((v1-v0)*yf) >> INTERP_NORM_BITS);
  return v;
}

/* 
 * TODO: more accurate resampling 
 */
MM_Image *MM_resizeImage(int xsize_dest, int ysize_dest, MM_Image *src)
{
  MM_Image *image;
  int xsize_src, ysize_src, x, y;
  unsigned char *pix, *pix_src;
  int x1, y1, x1inc, y1inc;
  int xi, yi, j, xf, yf;

  image = MM_newImage(xsize_dest, ysize_dest, MM_IMAGE_RGB);
  pix = (unsigned char *)image->pixmap;

  xsize_src = src->xsize;
  ysize_src = src->ysize;
  pix_src = (unsigned char *)src->pixmap;
  
  x1inc = ( (xsize_src - 1) * INTERP_NORM1 ) / (xsize_dest - 1);
  y1inc = ( (ysize_src - 1) * INTERP_NORM1 ) / (ysize_dest - 1);

  y1=0;
  for (y=0; y < ysize_dest; y++) {
    x1=0;
    for(x=0;x<xsize_dest;x++) {
      xi=x1 >> (INTERP_NORM1_BITS - INTERP_NORM_BITS);
      yi=y1 >> (INTERP_NORM1_BITS - INTERP_NORM_BITS);
      xf=x1 & ((1 << (INTERP_NORM1_BITS - INTERP_NORM_BITS))-1);
      yf=y1 & ((1 << (INTERP_NORM1_BITS - INTERP_NORM_BITS))-1);

      if (xi >= 0 && xi < (xsize_src-1) && yi >= 0 && yi < (ysize_src-1)) {
        for(j=0;j<3;j++) {
          pix[j]=interpolate(pix_src[(yi*xsize_src+xi)*3+j],
                             pix_src[(yi*xsize_src+xi+1)*3+j],
                             pix_src[((yi+1)*xsize_src+xi)*3+j],
                             pix_src[((yi+1)*xsize_src+xi+1)*3+j],
                             xf,yf);
        }
      } else {
        for(j=0;j<3;j++) {
          pix[j]=pix_src[(yi*xsize_src+xi)*3+j];
        }
      }

      pix+=3;
      x1+=x1inc;
    }
    y1+=y1inc;
  }
  return image;
}
