namespace eval preferences {
    variable prefs

    # Define the options database.
    option add *Preferences.borderwidth 1
    option add *Preferences.relief flat

    # Define the preferences data structure
    array set prefs {
	dialog ""
	cc_width 70
	cc_height 5
	lw_width 70
	lw_height 25
    }

    switch $tkWorld(ostype) {
	windows {
	    set prefs(font.title) {helvetica 12 bold}
	    set prefs(font.message) {helvetica 10}
	    set prefs(font.info) {helvetica 10 italic}
	    set prefs(font.contact) {helvetica 10}
	}
	default {
	    set prefs(font.title) {helvetica 14 bold}
	    set prefs(font.message) {helvetica 12}
	    set prefs(font.info) {helvetica 12 italic}
	    set prefs(font.contact) {helvetica 12}
	}
    }
}

# preferences::create --
#
#   Method to create an Preferences information dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::create { } {
    global tkWorld
    variable prefs

    # Put the focus on the preferences dialog if it is already open.
    if [winfo exists $prefs(dialog)] {
	switch -- [wm state $prefs(dialog)] {
	    normal {
		raise $prefs(dialog)
	    }
	    withdrawn -
	    iconic {
		wm deiconify $prefs(dialog)
	    }
	}
	focus $prefs(dialog)
	return
    } else {
	set prefs(dialog) [dialog::create .preferences Preferences]
    }

    # The first tab has the display options like Balloon Help and
    # start finish images in the LW.
    set tab1 [tabnotebook::page \
	    [dialog::interior $prefs(dialog)] "Display"]

    # Use a frame to encapsulate the File and Regexp options so that
    # the frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
	    -class TabnotebookFrame]

    # Create the top frame which allows the user to set the
    # balloon help and the Start/Finish Display
    checkbutton $f1.balloon \
	    -text "Show Balloon Help" \
	    -variable balloonhelp::balloonhelp(active) \
	    -onvalue 1 \
	    -offvalue 0
    checkbutton $f1.start_finish \
	    -text "Show Start/Finish headers in the Log Window" \
	    -variable tkWorld(start_finish_display) \
	    -onvalue 1 \
	    -offvalue 0
    grid $f1.balloon \
	    -padx 5 \
	    -pady 5 \
	    -sticky w
    grid $f1.start_finish \
	    -padx 5 \
	    -pady 5 \
	    -sticky w

    # Build the first tab.
    grid $f1 \
	    -padx 5 \
	    -pady 5 \
	    -sticky news

    # The second tab has the CC properties.
    set tab2 [tabnotebook::page \
	    [dialog::interior $prefs(dialog)] "Command Center"]

    # Use a frame to encapsulate the tab options.
    set f2 [frame $tab2.f2 \
	    -class TabnotebookFrame]
    label $f2.label_height \
	    -text "Height"
    set prefs(entry.cc_height) [entry $f2.entry_height \
	    -width 5 \
	    -textvariable preferences::prefs(cc_height)]
    label $f2.label_width \
	    -text "Width"
    set prefs(entry.cc_width) [entry $f2.entry_width \
	    -width 5 \
	    -textvariable preferences::prefs(cc_width)]
    grid $f2.label_height $f2.entry_height \
	    -padx 5 \
	    -pady 5 \
	    -sticky ew
    grid $f2.label_width $f2.entry_width \
	    -padx 5 \
	    -pady 5 \
	    -sticky ew

    # Build the second tab.
    grid $f2 \
	    -padx 5 \
	    -pady 5 \
	    -sticky news

    # The 3rd tab has the LW properties.
    set tab3 [tabnotebook::page \
	    [dialog::interior $prefs(dialog)] "Log Window"]

    # Use a frame to encapsulate the tab options.
    set f3 [frame $tab3.f3 \
	    -class TabnotebookFrame]
    label $f3.label_height \
	    -text "Height"
    set prefs(entry.lw_height) [entry $f3.entry_height \
	    -width 5 \
	    -textvariable preferences::prefs(lw_height)]
    label $f3.label_width \
	    -text "Width"
    set prefs(entry.lw_width) [entry $f3.entry_width \
	    -width 5 \
	    -textvariable preferences::prefs(lw_width)]
    grid $f3.label_height $f3.entry_height \
	    -padx 5 \
	    -pady 5 \
	    -sticky ew
    grid $f3.label_width $f3.entry_width \
	    -padx 5 \
	    -pady 5 \
	    -sticky ew

    # Build the 3rd tab.
    grid $f3 \
	    -padx 5 \
	    -pady 5 \
	    -sticky news

    # Define the lists for the reset and clear methods
    set prefs(list.reset) ""
    set prefs(list.clear) "cc_height cc_width lw_height lw_width"
    
}

# preferences::ok  --
#
#   Method which invokes preferences::close to close the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::ok { } {
    variable prefs

    # First configure the size of the CC.
    foreach x "width height" {
	cmd_center::resize $x $prefs(cc_$x)
    }

    # Now the LW.
    foreach x "width height" {
	log_window::resize $x $prefs(lw_$x)
    }

    preferences::close
}

# preferences::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::reset { } {
    variable prefs

    set tkWorld(start_finish_display) 1
    set balloonhelp::balloonhelp(active) 1

    # It is easier to list the elements to exclude rather than list
    # all of the values to reset.
    #foreach x $preferences(list.reset) {
	#set preferences($x) ""
    #}
}

# preferences::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::clear { } {
    variable prefs

    # Reset the data structure elements and bg/fg.
    foreach x $prefs(list.clear) {
	set prefs($x) ""
	$prefs(entry.$x) configure -bg #ffffff -fg #000000
    }

    focus $prefs(entry.cc_height)
}

# preferences::help --
#
#   Method to invoke the Preferences Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::help { } {
    global tkWorld

    help::create "help/preferences.html" "Preferences Help"
}

# preferencs::close --
#
#   Method to close the preferences dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::close { } {
    variable prefs

    balloonhelp::cancel
    destroy $prefs(dialog)
}