/* # skkinput (Simple Kana-Kanji Input)
 * skkel.h --- 
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef skkel_h
#define skkel_h

#define upcase_char(ch)	(((ch)>='a' && (ch)<='z')? ((ch)+('A'-'a')) : (ch))

enum {
  J_MINIBUFF_NOT_USING = 0,
  J_HENKAN_IN_MINIBUFF_MODE,
  J_INPUT_BY_CODE_OR_MENU_MODE,
  J_PURGE_YES_OR_NO_P,
} ;

/*
 * ȤƤؿΥץȥ
 */
/* skkel.c */
void err_msg
( struct SKKInputNode *node, char *fmt, ... ) ;
char *charaToString
( int chara ) ;
int j_insert_chara
( struct SKKInputNode *node, int pos, int chara ) ;
int j_kakutei_kana_mode
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_kakutei
( Widget gw, struct SKKInputNode *node ) ;
int rom_kana_rule_list_check
( struct SKKInputNode *node, int chara ) ;
int j_kana_input
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_set_okurigana
( Widget gw, struct skkinputBuffer *sbuffer, 
  struct SKKInputNode *node, struct myChar j_okuri_chara ) ;
int j_insert_a
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_insert_i
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_insert_u
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_insert_e
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_insert_o
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_self_insert
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_insert_zenkaku
( struct SKKInputNode *node, int pos, int chara ) ;
int j_newline
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node ) ;
int j_try_completion
( Widget gw, struct SKKInputNode *node ) ;
int j_display_code_for_char_at_point
( struct SKKInputNode *node ) ;
int j_input_by_code_or_menu_start
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node ) ;
int j_abbrev_input
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int rchara ) ;
int j_forward_char
( struct SKKInputNode *node ) ;
int j_backward_char
( struct SKKInputNode *node ) ;
int j_delete_char
( struct SKKInputNode *node ) ;
int j_insert_comma
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node ) ;
int j_abbrev_comma
( Widget gw, struct SKKInputNode *node ) ;
int j_insert_period
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node ) ;
int j_abbrev_period
( Widget gw, struct SKKInputNode *node ) ;
int j_today
( struct SKKInputNode *node ) ;
int j_zenkaku_henkan
( Widget gw, struct SKKInputNode *node ) ;
int j_toggle_kana
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int arg, int chara ) ;
int j_kanainput_mode_on
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node ) ;
int j_mode_off
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_zenkaku_eiji
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
int j_start_henkan
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node ) ;
int j_previous_candidate
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node ) ;
int j_backward_delete_char
( Widget gw, struct skkinputBuffer *sbuffer, 
  struct SKKInputNode *node, int sbflag ) ;
int j_beginning_of_line
( struct SKKInputNode *node ) ;
int j_end_of_line
( struct SKKInputNode *node ) ;
int j_kill_line
( struct SKKInputNode *node, struct myChar *cutbuffer ) ;
int j_yank
( struct SKKInputNode *node, struct myChar *cutbuffer ) ;
int j_transpose_chars
( struct SKKInputNode *node ) ;
int j_previous_line
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node ) ;
int j_next_line
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node ) ;
int do_Function_jhenkanShowCandidateMode
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node ) ;
int do_function_j_input_by_code_or_menu_jump
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node ) ;
int do_function_j_input_by_code_or_menu_1_jump
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node ) ;
int j_purge_from_jisyo
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node ) ;
int j_set_mark_command
( struct SKKInputNode *node ) ;
int j_kill_region
( struct SKKInputNode *node, struct myChar *cutbuffer ) ;
int j_kill_ring_save
( struct SKKInputNode *node, struct myChar *cutbuffer ) ;
int j_exchange_point_and_mark
( struct SKKInputNode *node ) ;
int j_forward_word
( struct SKKInputNode *node ) ;
int j_caseword
( struct SKKInputNode *node, int pattern ) ;
int j_backward_word
( struct SKKInputNode *node ) ;
void j_delete_kanaprefix
( struct SKKInputNode *node ) ;
void j_set_henkan_point
( Widget gw,  struct skkinputBuffer *buffer, 
  struct SKKInputNode *node, int chara ) ;
void j_set_henkan_point_subr
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int rchara ) ;
void j_keyboard_quit
( Widget gw, struct skkinputBuffer *buffer, 
  struct SKKInputNode *node ) ;
/* skkmbuf.c */
struct SKKInputNode *skkinput_AllocateMinibuffer
( void ) ;
void free_Minibuffer
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node ) ;

void j_completion_close
( struct SKKInputNode *node ) ;
void skkinput_updateLocalJisyo( void ) ;
void j_clear_modified_flag( void ) ;

void j_sendback_keypress( Widget gw, XEvent *xevent ) ;
void j_mode_off_and_self_insert
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara ) ;
void j_oh_check_with_controlcode
( struct SKKInputNode *node, int keyboard_quit_p ) ;
int j_delete_region
( struct SKKInputNode *node, int startpoint, int endpoint ) ;

#endif
