/*
 * Copyright (c) 1994  Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * Author:  Makoto Ishisone, Software Research Associates, Inc., Japan
 */
#include <stdio.h>
#include <stdlib.h>
#if !defined(NEED_EVENTS)
#define NEED_EVENTS
#endif
#include <X11/Xproto.h>
#undef NEED_EVENTS
#include "im.h"
#include "commondef.h"
#include "OverWin.h"
#include "OffWin.h"
#include "SeparateWin.h"
#include "MyDispatch.h"
#include "resrcs.h"
#include "HistMgr.h"

#define XimSYNCHRONUS	(0x0001)

#define sw16(n, s) ((s) ?                    \
		      (((n) << 8 & 0xff00) | \
		       ((n) >> 8 & 0xff)     \
		      ) : n)

#define sw32(n, s) ((s) ?                         \
		      (((n) << 24 & 0xff000000) | \
		       ((n) <<  8 & 0xff0000) |   \
		       ((n) >>  8 & 0xff00) |     \
		       ((n) >> 24 & 0xff)         \
		      ) : n)

/* ctext.c */
extern int string2ctext( struct myChar *string, unsigned char *cstr ) ;

extern void setEventMask
( IMConnection *conn, unsigned int imid,
  unsigned int icid, unsigned long forward_mask,
  unsigned long synchronous_mask) ;

extern int IMSendBufCommit( IMIC *icp, struct myChar *text, int length ) ;
extern int IMSendBufEvent( IMIC *icp, XKeyEvent *ev ) ;
extern void IMSendBufFlush( IMIC *icp ) ;

static void fillDefaultAttributesForStartup( IMIC *icp ) ;
static unsigned long makeConvAttributesForStartup
( IMIC *icp, struct ConvAttrs *attrp ) ;
static void fixCallback
( Widget w, XtPointer client_data, XtPointer call_data ) ;
static void detachConverter( IMIC *icp ) ;
static void endCallback
( Widget w, XtPointer client_data, XtPointer call_data ) ;
static void unusedEventCallback
( Widget w, XtPointer client_data, XtPointer call_data ) ;

/*- fillDefaultAttributesForStartup: put default necessary for conv. start -*/
static void fillDefaultAttributesForStartup( IMIC *icp )
{
  unsigned long cmask, pmask, smask ;

  cmask = ATTR_MASK_FOCUS ;

  switch( icp->style ){
  case IMSTYLE_OVER_THE_SPOT :
    pmask = ATTR_MASK_FOREGROUND | ATTR_MASK_BACKGROUND |
      ATTR_MASK_FONT_SET ;
    smask = 0 ;
    break ;
  case IMSTYLE_OFF_THE_SPOT :
    pmask = ATTR_MASK_FOREGROUND | ATTR_MASK_BACKGROUND |
      ATTR_MASK_FONT_SET | ATTR_MASK_AREA ;
    smask = ATTR_MASK_AREA ;
    break ;
  default :
    pmask = 0 ;
    smask = 0 ;
  }
  IMFillDefault( icp, cmask, pmask, smask ) ;
  return ;
}

/*- makeConvAttributesForStartup: get conv. attrs needed for startup -*/
static unsigned long makeConvAttributesForStartup
( IMIC *icp, struct ConvAttrs *attrp )
{
  icp->common_attr.change_mask  = icp->common_attr.set_mask ;
  icp->preedit_attr.change_mask = icp->preedit_attr.set_mask ;
  icp->status_attr.change_mask  = icp->status_attr.set_mask ;
  return IMMakeConvAttributes( icp, attrp ) ;
}

/*- commitString: commmit converted string to client -*/
void commitString( IMIC *icp, struct myChar *str, int sync )
{
  int offset ;
  IMConnection *conn = icp->im->connection ;
  unsigned int flag, propsize ;

  struct myChar *wptr ;
  unsigned char *text ;

  /*
   * EUC ɤǻäƤƥȤ Compound Text ؤѴ롣
   */
  for( wptr = str ; !IS_END_OF_STRING( *wptr ) ; wptr ++ )
    if( IS_ASCII_EQUAL( *wptr, '\r' ) )
      wptr->chara = '\n' ;

  propsize = string2ctext( str, NULL ) ;
  if( propsize <= 0 )
    return ;
  if( ( text = ( caddr_t )malloc
	( propsize * sizeof( unsigned char ) * 4 ) ) == NULL )
    return ;
  string2ctext( str, ( unsigned char * )text ) ;
  flag = XIM_FLAG_X_LOOKUP_CHARS ;
  if( sync ){
    flag |= XIM_FLAG_SYNCHRONOUS ;
  }
  /* 쵤˥ǡν񤭤ߤ򳫻Ϥ롣*/
  offset = IMPutHeader( conn, XIM_COMMIT, 0, 0 ) ;
  IMPutC16( conn, icp->im->id ) ;
  IMPutC16( conn, icp->id ) ;
  IMPutC16( conn, flag ) ;
  IMPutC16( conn, ( unsigned int )propsize ) ;
  IMPutString( conn, text, propsize ) ;
  IMFinishRequest( conn, offset ) ;
  free( text ) ;
  return ;
}

/*- fixCallback: fix callback -*/
/* ARGSUSED */
static void fixCallback
( Widget w, XtPointer client_data, XtPointer call_data)
{
  IMIC *icp = (IMIC *)client_data ;
  IMConnection *conn = icp->im->connection ;
  struct myChar *text = ( struct myChar *)call_data ;

  if( icp->style == IMSTYLE_OVER_THE_SPOT ||
      icp->style == IMSTYLE_OFF_THE_SPOT ){
    if( !( icp->state & IC_COMMIT_WAIT ) && icp->icfocus ){
      /* ޤ塼ˤޤäƤƥȤɽʤȤʤɡġ
       * ʬ̣Ϥʤ顢äĤ뤳Ȥˤ롣*/
      IMSendBufCommit( icp, text, myCharStrlen( text ) ) ;
      IMSendBufFlush ( icp ) ;
      /* dispatch ƤʤΤʤ顢dispatch Ƥޤ*/
      if( !conn->dispatching &&
	  !IMQueueEmpty( conn->protocol_widget ) ){
	IMProcessQueue( conn->protocol_widget ) ;
      }
    } else {
      /* delay */
      IMSendBufCommit( icp, text, myCharStrlen( text ) ) ;
    }
  } else {
    /* commit  sync reply ʤ顢ľ commit ʳ˼꤬ʤ*/
    commitString( icp, text, False ) ;
    /* dispatch ƤʤΤʤ顢dispatch Ƥޤ*/
    if( !conn->dispatching &&
	!IMQueueEmpty( conn->protocol_widget ) ){
      IMProcessQueue( conn->protocol_widget ) ;
    }
  }
  return ;
}

/*- detachConverter: detach conversion widget from specified IC -*/
static void detachConverter( IMIC *icp )
{
  Widget conv ;

  conv = icp->conversion ;
  XtRemoveCallback
    ( conv, XtNfixNotify, fixCallback, ( XtPointer )icp ) ;
  XtRemoveCallback
    ( conv, XtNendNotify, endCallback, ( XtPointer )icp ) ;
  XtRemoveCallback
    ( conv, XtNkeybackNotify, unusedEventCallback,
     ( XtPointer )icp ) ;
  icp->conversion = NULL ;
  return ;
}

/*- endCallback: conversion end callback -*/
/* ARGSUSED */
static void endCallback
( Widget gw, XtPointer client, XtPointer caller )
{
  IMIC *icp = ( IMIC * )client ;
  IMConnection *conn = icp->im->connection ;

  /* ҥȥĤ롣*/
  if( caller != NULL )
    history_close
      ( XtDisplay( icp->im->connection->protocol_widget ), caller ) ;

  if( icp->state & IC_CONVERTING ){
    setEventMask( conn, icp->im->id, icp->id, 0L, 0L ) ; 
    detachConverter( icp ) ;
    icp->state &= ~IC_CONVERTING ;
    /* IMFlush( conn ) ;*/
  }
  /* ɬפ 塼եå夷ʤϤʤ  *
   * 󡣤줬̵ȡɤĤִ֤Υ򤳤ܤƤޤ *
   * ɬפ˰㤤ʤ󡢤 ᤿*/
  if( !IMQueueEmpty( conn->protocol_widget ) ){
    IMProcessQueue( conn->protocol_widget ) ;
  }
  icp->icfocus = False ;
  return ;
}

void imSendbackKey( IMIC *icp, XKeyEvent *ev, int sync )
{
  IMConnection *conn = icp->im->connection ;
  unsigned char *ptr ;
  xEvent wire_event ;
  int offset, swap_needed ;
  unsigned long one = 1 ;
  char *onep = (char *)&one ;

  if( *onep == 0 ){	/* big endian */
    swap_needed = ( conn->byte_order == ORDER_LITTLE ) ;
  } else {		/* little endian */
    swap_needed = ( conn->byte_order == ORDER_BIG ) ;
  }

  if( icp->im->mask & XIM_EXT_FORWARD_KEYEVENT_MASK ){
    offset = IMPutHeader( conn, XIM_EXT_FORWARD_KEYEVENT, 0, 0 ) ;
    IMPutC16( conn, icp->im->id ) ;
    IMPutC16( conn, icp->id ) ;
    /* Sync Flag ? */
    if( sync ){
      IMPutC16( conn, XimSYNCHRONUS ) ;	/* ?? */
    } else {
      IMPutC16( conn, 0 ) ;
    }
    IMPutC16( conn, ( unsigned int )( ev->serial & 0xffff ) ) ;
    IMPutC8 ( conn, ev->type ) ;
    IMPutC8 ( conn, ( int )ev->keycode ) ;
    IMPutC16( conn, ( unsigned int )ev->state ) ;
    IMPutC32( conn, ev->time ) ;
    if( icp->common_attr.focus != None ){
      IMPutC32( conn, icp->common_attr.focus ) ;
    } else {
      IMPutC32( conn, icp->common_attr.client ) ;
    }
    IMFinishRequest( conn, offset ) ;
  } else {
    offset = IMPutHeader( conn, XIM_FORWARD_EVENT, 0, 0 ) ;
    IMPutC16( conn, icp->im->id ) ;
    IMPutC16( conn, icp->id ) ;
    /* Sync Flag ? */
    if( sync ){
      IMPutC16( conn, XimSYNCHRONUS ) ;	/* ?? */
    } else {
      IMPutC16( conn, 0x0000 ) ;	/* ?? */
    }
    IMPutC16
      ( conn, ( unsigned long )( ( ev->serial >> 16 ) & 0xffff ) ) ;
    /* 饤٥ȤΤϤޤ롣*/
    /* ޤ serial ġ*/
    wire_event.u.keyButtonPointer.root   = sw32( ev->root, swap_needed ) ;
#ifdef DEBUG
    printf
      ( "ev->window:(%ld), priv.x.client:(%ld), ",
	ev->window, conn->transport.priv.x.client ) ;
    printf
      ( "common_attr.client:(%ld), common_attr.focus:(%ld)\n", 
	icp->common_attr.client, icp->common_attr.focus ) ;
#endif
    if( icp->common_attr.focus != None ){
      wire_event.u.keyButtonPointer.event  =
	sw32( icp->common_attr.focus, swap_needed ) ;
    } else {
      wire_event.u.keyButtonPointer.event  =
	sw32( icp->common_attr.client, swap_needed ) ;
    }
    wire_event.u.keyButtonPointer.child  =
      sw32( None, swap_needed ) ;
    wire_event.u.keyButtonPointer.time   = sw32( ev->time, swap_needed ) ;
    wire_event.u.keyButtonPointer.eventX = sw16( ev->x, swap_needed ) ;
    wire_event.u.keyButtonPointer.eventY = sw16( ev->y, swap_needed ) ;
    wire_event.u.keyButtonPointer.rootX  =
      sw16( ev->x_root, swap_needed ) ;
    wire_event.u.keyButtonPointer.rootY  =
      sw16( ev->y_root, swap_needed ) ;
    wire_event.u.keyButtonPointer.state  =
      sw16( ev->state, swap_needed ) ;
    wire_event.u.keyButtonPointer.sameScreen = ev->same_screen ;
    wire_event.u.u.detail                = ev->keycode;
    wire_event.u.u.type                  = ev->type ;
    wire_event.u.u.sequenceNumber =
      ( ev->serial & ( ( unsigned long )0xffff ) ) ;
    wire_event.u.u.sequenceNumber = 
      sw16( wire_event.u.u.sequenceNumber, swap_needed ) ;

    ptr = IMBufAlloc( IM_OUTBUF( conn ), sizeof( wire_event ) ) ; 
    memcpy( ptr, ( char * )&wire_event, sizeof( wire_event ) ) ;
    IMFinishRequest( conn, offset ) ;
  }
  return ;
}

/*- unusedEventCallback: unused key event callback -*/
/* ARGSUSED */
static void unusedEventCallback
( Widget gw, XtPointer client_data, XtPointer call_data )
{
  IMIC *icp = ( IMIC * )client_data ;
  IMConnection *conn = icp->im->connection ;
  XKeyEvent *ev = ( XKeyEvent * )call_data ;

  /* ѴưԤƤǤʤС callback ̵뤹롣*/
  if( !( icp->state & IC_CONVERTING ) )
    return ;
#ifdef DEBUG
  printf( "UnusedEventCallback: Type=%d, Window=%ld.\n",
	  ev->type, ev->window ) ;
#endif
  if( icp->style == IMSTYLE_OVER_THE_SPOT ||
      icp->style == IMSTYLE_OFF_THE_SPOT ){
    if( !( icp->state & IC_COMMIT_WAIT ) && icp->icfocus ){
      /* ޤ塼ˤޤäƤƥȤɽʤȤʤɡġ
       * ʬ̣Ϥʤ顢äĤ뤳Ȥˤ롣*/
      IMSendBufEvent( icp, ev ) ;
      IMSendBufFlush( icp ) ;
      /* dispatch ƤʤΤʤ顢dispatch Ƥޤ*/
      if( !conn->dispatching &&
	  !IMQueueEmpty( conn->protocol_widget ) ){
	IMProcessQueue( conn->protocol_widget ) ;
      }
    } else {
      /* delay */
      IMSendBufEvent( icp, ev ) ;
    }
  } else {
    /* Ѵ饤Ȥؤ롣*/
    imSendbackKey( icp, ev, False ) ;
    /* dispatch ƤʤΤʤ顢dispatch Ƥޤ*/
    if( !conn->dispatching &&
	!IMQueueEmpty( conn->protocol_widget ) ){
      IMProcessQueue( conn->protocol_widget ) ;
    }
  }
  return ;
}


/*
 * Public functions
 */

int IMStartConversion( IMIC *icp )
{
  IMIM *imp = icp->im ;
  Widget protocol = imp->connection->protocol_widget ;
  Widget converter ;
  WidgetClass class ;
  struct ConvAttrsMesg camsg ;
  unsigned char *client_name ;
  HistoryListNode *histNode ;

  if( icp->state & IC_CONVERTING )
    return 0 ;

  /*
   * Check required attributes i.e. client window.
   */
  if( !( icp->common_attr.set_mask & ATTR_MASK_CLIENT ) ){
    IMSendError
      ( icp->im->connection, IMBadSomething, icp->im->id, icp->id,
        "client window required" ) ;
    return -1 ;
  }

  /*
   * Fill in default values for unspecified attributes.
   */
  fillDefaultAttributesForStartup( icp ) ;

  /*
   * Get appropriate converter class.
   */
  if( icp->style == IMSTYLE_OVER_THE_SPOT ){
    client_name = "overthespot" ;
    class = overthespotWinWidgetClass ;
  } else if( icp->style == IMSTYLE_OFF_THE_SPOT ){
    client_name = "offthespot" ;
    class = offthespotWinWidgetClass ;
  } else {
    client_name = "separate" ;
    class = separateWinWidgetClass ;
  }
  /* ҥȥνԤ*/
  histNode = history_setup( icp->conversion, icp->common_attr.client ) ;

  /*
   * Attach converter to this IC.
   */
  converter = XtVaCreateWidget
    ( client_name, class, protocol,
      XtNmappedWhenManaged, False, 
      XtNclientWindow, icp->common_attr.client,
      XtNconversionHistory, histNode, 
      XtNprobeWindow, None, NULL ) ;

  /* ݤǤʤä顢ɤʤ褦⤳ʤ褦ʤ͡*/
  if( converter == NULL ) {
    IMSendError
      ( imp->connection, IMBadSomething, imp->id, icp->id,
        "can't attach converter to this IC" ) ;
    /* ҥȥ롣˺ȡͭäѤʤ *
     * ʤ뤾ȡ*/
    if( histNode != NULL )
      free( histNode ) ;
    return -1 ;
  }
  icp->conversion = converter ;
  /* ҥȥΥȤʤ륦ɥξǤ褦ˤƤ *
   * νϡоݤȤʤ륦ɥ DestroyWindowEvent  *
   * ³롣*/
  add_myeventhandler
    ( XtDisplay( protocol ), icp->common_attr.client,
      XtWindow( converter ), NO_EVENT_HANDLE, StructureNotifyMask ) ;

  /* ƤΤʤåȥå׽Ԥ*/
  XtCallCallbacks
    ( protocol, XtNsetupInputWindowNotify, icp->conversion ) ;

  /*
   * Compute conversion attributes to be passed to the converter.
   */
  camsg.mask = makeConvAttributesForStartup( icp, &( camsg.value ) ) ;

  /*
   * Add callback functions.
   */
  XtAddCallback
    ( converter, XtNfixNotify, fixCallback, ( XtPointer )icp ) ;
  XtAddCallback
    ( converter, XtNendNotify, endCallback, ( XtPointer )icp ) ;
  XtAddCallback
    ( converter, XtNkeybackNotify,
      unusedEventCallback, ( XtPointer )icp ) ;

  /* Ѵ°ꤹ롣*/
  XtVaSetValues( converter, XtNconversionAttribute, &camsg, NULL ) ;
  /* Ǥ Event Capture Method 򤷤ʤ*/
  XtRealizeWidget( converter ) ;

  icp->state    |= IC_CONVERTING ;
  icp->icfocus   = True ;
  return 0 ;
}

void IMStopConversion( IMIC *icp )
{
  IMConnection *conn = icp->im->connection ;

  if ( ! ( icp->state & IC_CONVERTING ) )
    return ;

  /*
   * Terminate conversion.
   */
  XtDestroyWidget( icp->conversion ) ;

  /*
   * ¤ XtDestroyWidget ˤäƤΤǰΤᡣ
   */
  if( icp->conversion != NULL ){
    detachConverter( icp ) ;
    icp->state &= ~IC_CONVERTING ;
    /* Connection ڤ줿ȤȤ򶵤ʤȤʤ*/
    setEventMask( conn, icp->im->id, icp->id, 0L, 0L ) ;
    /* IMFlush( conn ) ; */
  }
  return ;
}

int IMResetIC( IMIC *icp, char **preedit_strp )
{
  int num_bytes = 0 ;
  *preedit_strp = NULL ;
#if 0
  if( icp->state & IC_CONVERTING ){
    /*
     * get input object by asking conversion widget of XtNinputObject
     * resource. however, it is not recommended since protocol widget
     * should interact with input object only through conversion
     * widget.
     */
    CCTextCallbackArg arg ;
    Widget input_obj ;
    Widget w = icp->im->connection->protocol_widget ;
    
    XtVaGetValues
      (icp->conversion, XtNinputObject, &input_obj, NULL ) ;
    arg.encoding = IMCtextAtom( w ) ;
    if( ICGetConvertedString
       ( input_obj, &arg.encoding, &arg.format,
	 &arg.length, &arg.text ) >= 0 ){
      num_bytes = arg.length ;
      *preedit_strp = (char *)arg.text ;
    }
    ICClearConversion( input_obj ) ;
  }
#endif
  return num_bytes ;
}

void IMForwardEvent( IMIC *icp, XEvent *xevent )
{
  if( icp->conversion == NULL ){
    /* ΤʤɡIM Ĥִ֤˼Υ٥ȤǤҤä */
    /* 褦ɤƤΤʤɤ͡顢饤Ȥ */
    /* žɤߤ͡*/
#if defined(DEBUG)
    fprintf( stderr, "IMForward Event: conversion is (NULL).\n" ) ;
#endif
    return ;
  }
#ifdef DEBUG
  printf( "IMForawdEvent: Type=%d, Window=%ld.\n",
	  xevent->type, xevent->xany.window ) ;
#endif
  /* ⽤ɬפꡣevent ФΤ XtDispatch ȤäƤ */
  if( xevent->type == KeyPress || xevent->type == KeyRelease ){
    xevent->xkey.send_event = True ;
    XtCallActionProc
      ( icp->conversion, "KeyDownEventHandler",
        xevent, ( String * )NULL, ( Cardinal )0 ) ;
  }
}

void IMSetFocus( IMIC *icp )
{
  if( icp->style == IMSTYLE_OVER_THE_SPOT ||
      icp->style == IMSTYLE_OFF_THE_SPOT ){
    icp->icfocus = True ;

    if( icp->conversion != NULL ){
      XtVaSetValues( icp->conversion, XtNsetFocus, True, NULL ) ;
    }
    /* ե褿Ȥˤäơåɬפ
     * Τ⤷ʤ*/
    if( !( icp->state & IC_COMMIT_WAIT ) )
      IMSendBufFlush( icp ) ;
  }
  return ;
}

void IMUnsetFocus( IMIC *icp )
{
  /* Root Window Style ˤϥեΥåȡ󥻥åȤ̵ΤǼ
   * ԤʤʤȡĤޤʸʤʤä̵
   * ᤷȤˤʤä*/
  if( icp->style == IMSTYLE_OVER_THE_SPOT ||
      icp->style == IMSTYLE_OFF_THE_SPOT ){
    icp->icfocus = False ;

    if( icp->conversion != NULL ){
      XtVaSetValues( icp->conversion, XtNunsetFocus, True, NULL ) ;
    }
  }
  return ;
}

