/* # skkinput (Simple Kana-Kanji Input)
 * XimP.h --- Private header file for XimWidgetClass
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(XimP_h)
#define XimP_h

#include "Xim.h"
#include "im.h"

typedef struct {
  int dummy ;
} XimClassPart ;

typedef struct _XimClassRec {
  CoreClassPart		core_class ;
  XimClassPart		xim_class ;
} XimClassRec ;

extern XimClassRec ximClassRec ;

typedef struct {
  /* resources */
  char *server_name ;

  String language ;
  String locales ;		/* ݡȤƤ locale Υꥹȡ*/
  String default_fontlist ;		/* default font list to be used */
  String conversionStartKey ;

  Pixel foreground ;			/* default fg pixel */
  Dimension status_width ;		/* default width of status area */

  /* private state */
  Boolean use_x_transport ;
  int no_more_connections ;
  IMConnection *connection_list ;
  IMConverter converter ;
  long last_imid ;
  long last_icid ;
  IMIM *im_hash[ IM_HASH_SIZE ] ;
  IMIC *ic_hash[ IC_HASH_SIZE ] ;
  IMConnection *scheduler_queue ;
  struct XrLikeKey *trigger_keys ;	/* conversion start trigger keys */
  int num_trigger_keys ;

  XFontStruct **default_fonts ;
  int num_default_fonts ;
  
  /* СѤ륢ȥࡣ*/
  Atom xim_xconnect ;			/* "_XIM_XCONNECT" */
  Atom xim_protocol ;			/* "_XIM_PROTOCOL" */
  Atom xim_moredata ;			/* "_XIM_MOREDATA" */
  Atom ctext_atom ;			/* "COMPOUND_TEXT" */
  Atom locales_atom ;			/* "LOCALES" */
  Atom transport_atom ;			/* "TRANSPORT" */
  Atom skkcomm_atom ;			/* "_SKKINPUT_COMM" */
  Atom server_atom ;			/* atom stored in XIM_SERVERS prop. */

  /* 饤ȥɥ˴줿Ȥ롣*/
  XDestroyWindowEvent *destroyWindowEvent ;
  /* ιѤ롣*/
  int jisyo_dirty ;

  XtCallbackList setupInputWindowCallback ;
  XtCallbackList serverCloseCallback ;

} XimPart ;

typedef struct _XimRec {
  CorePart		core ;
  XimPart		xim ;
} XimRec ;

#define IM_IMHASH(w)	(((XimWidget)(w))->xim.im_hash)
#define IM_ICHASH(w)	(((XimWidget)(w))->xim.ic_hash)
#define IM_LASTIMID(w)	(((XimWidget)(w))->xim.last_imid)
#define IM_LASTICID(w)	(((XimWidget)(w))->xim.last_icid)
#define IM_QUEUE(w)	(((XimWidget)(w))->xim.scheduler_queue)

#define ATOM_CTEXT(w)	(((XimWidget)(w))->xim.ctext_atom)
#define ATOM_LOCALES(w)	(((XimWidget)(w))->xim.locales_atom)
#define ATOM_TRANSPORT(w) (((XimWidget)(w))->xim.transport_atom)
#define ATOM_SKKCOMM(w) (((XimWidget)(w))->xim.skkcomm_atom)
#define ATOM_XCONNECT(w) (((XimWidget)(w))->xim.xim_xconnect)
#define ATOM_PROTOCOL(w) (((XimWidget)(w))->xim.xim_protocol)
#define ATOM_MOREDATA(w) (((XimWidget)(w))->xim.xim_moredata)

#endif
