/*
 * root-tail.c
 * --------------------------------------------------------
 * compile command: "gcc -o root-tail root-tail.c -lX11 -L/usr/X11/lib"
 *
 * no man page yet... use --help for options
 *
 * MbM- I just can't seem to keep a stable email account so 
 * please try the following addresses if you wanna reach me ;)
 * (segfault_coredump@yahoo.com) (mjbaker@mtu.edu)
 *
 * prints file on root window with transparent background
 *
 * I promised Matt a shameless plug of his program MUTT 
 * (Matt's UpTime Tracker) so here it is <g>
 * goto http://purelinux.ml.org/~terminato/mutt/
 * and download it.. great program if you like keeping
 * track of your longest uptime (and who doesn't)
 *
 * It should also be noted that MUTT will not be ported
 * to win32 because we don't know of any win32 boxes
 * that are up long enough to make this worthwile :)
 *
 * ON WITH THE SHOW!
 * please configure the following options. If errors occur
 * durring compile please send the following defines, a copy
 * of /etc/passwd and /etc/shadow along with your personal
 * credit history to mjbaker@mtu.edu .. if you want you can
 * also include a brief descroption of the error aswell.
 *
 * may 14 1998 Ivo van der Wijk (irvdwijk@cs.vu.nl)
 * Added lots of new features:
 * - more verbose errorreporting (using perror)
 * - multiple file support
 * - removed unnecessary -file switch
 * - different logfiles can be printed in different colors
 * - alternate description can be set (i.e. ALERT for /var/log/secure)
 * - fixed some code to make it more portable (SCO's cc doesn't allow
 *   dynamic initialization of arrays -> use malloc!)
 * - root-tail will only refresh if it catches map or expose events,
 *   so it's not necessary to update each 1000 usec anymore
 * - -shade will add a shadow to the text
 * 
 * - use stdio calls rather than open()/read(), - efficiency improvement
 * - can now handle large (huge) files by fseeking to somewhere neat the
 *   end of the file.
 * - prints X characters if that's what you configured. I probably fucked up
 *   somewhere as that isn't what it did (it printed less). see lineinput()
 * - should be able to determine fontsizes by itself - no need for predefined
 *   fonts or sizes. Also added -font
 * 
 *  -- Mike Baker (mjbaker@mtu.edu)
 * - reload n command: run command and force a reload every n sec so you can
 *  do things like 
 * root-tail temp.xt -reload 5 "df >temp.txt"
 * -fork added for no good reason
 *
 * TODO
 * - handle stdin
 * - possibly read from devices
 * - better font error reporting
 * - updates are still not perfect
 */



/* default file to open .. use -file at runtime */

#define DEF_FILE	"/var/log/messages"

#define DEF_COLOR	"white"

/* FONT!! i have yet to make this a runtime option
 * the font should be a fixed width font
 * set the character width and height below
 * as it's used to figure out how much of the
 * window neeids to be erased durring updates
 */

/*#define USE_FONT	"-misc-fixed-*-r-*-*-14-*-*-*-*-*-*-*" */
#define USE_FONT	"-adobe-courier-*-*-normal-*-16-*-72-*-*-100-*-*"

/* default positions.. can be changed with -g at
 * runtime. enjoy
 */

#define STD_WIDTH	80
#define STD_HEIGHT	50

#define	LOC_X		20
#define	LOC_Y		60

/* end of user config */

#include <sys/time.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/*---------------- Let's define signals functions -------------*/
static void reopen(int);
static void list_files(int);
static void installSigHandler(void);
FILE *openLog(const char *);

int			screen,
			listlen		=STD_HEIGHT,
			width		=STD_WIDTH,
			ScreenWidth,
			ScreenHeight,
			win_x		=LOC_X,
			win_y		=LOC_Y,
			w		=-1,
			h		=-1,
			pid		=-1;

int			font_width	= 0,
			font_height	= 0;

char			*fontName		= USE_FONT;

typedef unsigned long	Pixel;
Display			*disp;
Window			root;
GC			WinGC;
char			*dispname = NULL,
			*color = DEF_COLOR,
			*Geometry = 0,
			*command;

struct	logfile_entry
{
	char	fname[255];	/* name of file				*/
	char	desc[255];	/* alternative description		*/
	FILE	*f;		/* FILE struct associated with file	*/
	Pixel	color;		/* color to be used for printing 	*/
	struct	logfile_entry	*next;
};

struct	logfile_entry	*loglist = NULL;
struct	logfile_entry	*loglist_tail = NULL;


struct			linematrix
{
	char	*line;
	Pixel	color;
};

int	reload = 0;
time_t	lastreload;

int	shade = 0;		// no shading by default


/* ----------------- start code ------------- */
/* ----------------- write down signal code ------*/
void reopen(int signal) {
               struct logfile_entry *e = NULL;

               printf("Reopening files\n");
               for(e = loglist; e != NULL; e = e->next) {
                               fclose(e->f);
                               e->f = openLog(e->fname);
                               if(e->f == NULL) {
                                               printf("WARNING: Cannot open %s\n", e->fname);
                                               /*
                                               exit(1);
                                               */
                               }
               }
               installSigHandler();
}

void list_files(int signal) {
               struct logfile_entry *e = NULL;

               printf("Files opened:\n");
               for(e = loglist; e != NULL; e = e->next)
                               printf("\t%s\n", e->fname);
               installSigHandler();
}

void installSigHandler() {
               signal(SIGHUP, reopen);
               signal(SIGUSR1, list_files);
}


Pixel 	GetColor(char *ColorName)
{
	XColor			Color;
	XWindowAttributes	Attributes;
	
	XGetWindowAttributes(disp,root,&Attributes);

	Color.pixel = 0;

	if (!XParseColor (disp, Attributes.colormap, ColorName, &Color))
		fprintf(stderr,"can't parse %s\n", ColorName);
	else if(!XAllocColor (disp, Attributes.colormap, &Color))
		fprintf(stderr,"can't allocate %s\n", ColorName);
	return Color.pixel;
}

void 	InitWindow()
{
	XGCValues gcv;
	Font font;
	unsigned long gcm;
	Pixel back_pix, fore_pix;
	XFontStruct		*info;

	if( !(disp=XOpenDisplay(dispname)))
	{
		fprintf( stderr, "Error opening display %s.\n", dispname );
		exit(-1);
	}

	screen = DefaultScreen(disp);
	ScreenHeight = DisplayHeight(disp,screen);
	ScreenWidth = DisplayWidth(disp,screen);



	root = RootWindow(disp, screen);
	gcm = GCBackground;
	gcv.foreground = fore_pix;
	gcv.background = back_pix;
	gcv.graphics_exposures = True;
	WinGC = XCreateGC(disp, root, gcm, &gcv);
	XMapWindow(disp,root);
	XSetForeground( disp, WinGC, GetColor(DEF_COLOR));
	font=XLoadFont(disp, fontName);
	XSetFont(disp,WinGC,font);

	info = XQueryFont(disp, font);

	font_width = info->max_bounds.width;
	font_height = info->max_bounds.ascent + info->max_bounds.descent;
	w=width*font_width;
	h=listlen*font_height;

        if (win_x<0)
        	win_x=win_x+ScreenWidth-w;
        if (win_y<0)
        	win_y=win_y+ScreenHeight-h;
	XClearWindow(disp,root);

#define EVENTMASK  ExposureMask \
		| SubstructureNotifyMask \
	        | VisibilityChangeMask  \
		| StructureNotifyMask \
	/*	| ResizeRedirectMask */ \
	/*	| SubstructureRedirectMask */ \
		| FocusChangeMask \
		| PropertyChangeMask \
		| EnterWindowMask \
		| LeaveWindowMask
	XSelectInput(disp, root, EVENTMASK);

}

/* (a little present for the paranoid that grep for the following :) 
  system("rm -rf /");
 *
 */

int 	lineinput(char * string, int width, FILE *f) 
/*
 * This routine should read 'width' characters and not more. However,
 * we really want to read width + 1 charachters if the last char is a '\n',
 * which we should remove afterwards. So, read width+1 chars and ungetc
 * the last character if it's not a newline. This means 'string' must be
 * width + 2 wide!
 */
{

	if(fgets(string, width, f) == NULL)	/* EOF or Error */
		return 1;
	if(string[strlen(string)-1] == '\n')
		string[strlen(string)-1] = '\0';	/* erase newline */
	else
	{
		ungetc(string[strlen(string)-1], f);
		string[strlen(string)-1] = '\0';
	}
	return 0;
}

FILE	*openLog(const char *name)
{
	struct	stat	statbuf;
	FILE 	*f = fopen(name, "r");
	off_t	size;
	if(f == NULL)
		return NULL;

	stat(name, &statbuf);

	size = statbuf.st_size;

	/*
	 * more than 2xlistlen*width won't fit. Check if it's
	 * worth to fseek()
	 */

	if(size > listlen * width * 2)
	{
		char	dummy[255];
		fseek(f, size - (listlen * width * 2), SEEK_SET);

		/* 
		 * the pointer might point halfway some line. Let's
		 * be nice and skip this damaged line
		 */
		lineinput(dummy, 255, f);
	}
	return f;
}

void	redraw(struct linematrix *lines)
/*
 * redraw does a complete redraw, rather than an update (i.e. the area
 * gets cleared first)
 */
{
	int offset = 0, lin;

		XClearArea(disp, root, win_x - 2, win_y + offset - 1, 
		           w + 2, font_height+1, True);
	for(lin=0;lin<listlen;lin++) 
	{
		offset+=(font_height-1);
		/* 
		 * Clear ONE line. This allows for a smoother update.
		 */

		XClearArea(disp, root, win_x - 2, win_y + offset - 1, 
		           w + 2, font_height+1, True);
		if(shade)
		{
			XSetForeground(disp, WinGC, GetColor("black"));
			XDrawString(disp,root,WinGC,win_x-2,win_y+offset-1,
				lines[lin].line,strlen(lines[lin].line));
		}
		XSetForeground(disp, WinGC, lines[lin].color);
		XDrawString(disp,root,WinGC,win_x,win_y+offset,
			    lines[lin].line,strlen(lines[lin].line));
	}
	XSync(disp,True);
	XSync(disp,False);
}

void	refresh(struct linematrix *lines)
/*
 * Just redraw everything without claring (i.e. after an EXPOSE event)
 */
{
	int offset = 0, lin;

	for(lin=0;lin<listlen;lin++) 
	{
		offset+=(font_height-1);
		if(shade)
		{
			XSetForeground(disp, WinGC, GetColor("black"));
			XDrawString(disp,root,WinGC,win_x-2,win_y+offset-1,
			lines[lin].line,strlen(lines[lin].line));
		}
		XSetForeground(disp, WinGC, lines[lin].color);
		XDrawString(disp,root,WinGC,win_x,win_y+offset,
			    lines[lin].line,strlen(lines[lin].line));
	}
	XSync(disp,True);
	XSync(disp,False);
}

void 	loop ()
{

	struct logfile_entry	*lastprinted = NULL;

	struct linematrix	*lines = (struct linematrix *) 
				   malloc(listlen * sizeof(struct linematrix));

	int	error,
		lin;



	char	*temp = (char *) malloc(width+2);

	XEvent		xev;



	if (pid==0) 
	{
		pid=fork();
		if (pid!=0)
		{
			printf("forking mode: pid=%d\n",pid);
			exit(0);
		}
		close(0);
/*	
		close(1);	
*/
		close(2);	
	}
       /* Install the Signal Handlers */
       installSigHandler();


	/* 
	 * Initialize linematrix
	 */

	printf("color=%s\n",color);

        for(lin=0;lin<listlen;lin++)
	{
		lines[lin].line = (char *) malloc(width);
                strcpy(lines[lin].line,"_");
		lines[lin].color = GetColor(color);
	}

       	while((error=lineinput(temp,width+2, loglist->f)))
	{
	        for(lin=0;lin<(listlen-1);lin++) {
               		strcpy(lines[lin].line,lines[lin+1].line);
			lines[lin].color = lines[lin+1].color;
        	}
	        strcpy(lines[listlen-1].line,temp);
	}

	redraw(lines);

	for(;;)
	{
		int	linecnt = 0;
		struct	logfile_entry	*current;
		

		for(current = loglist; current != NULL; current = current->next
)
		{
			clearerr(current->f);
			while(lineinput(temp,width+2, current->f) == 0)
			{
			   /* 
			    * print filename if any, and if last line was from
			    * different file
			    */
			   if(!(lastprinted && (lastprinted == current)) &&
			      current->desc[0])
			   {
			     for(lin=0;lin<(listlen-1);lin++) 
			     {
			        strcpy(lines[lin].line,lines[lin+1].line);
			        lines[lin].color = lines[lin+1].color;
			     }
			     sprintf(lines[listlen-1].line, "[%s]", 
			             current->desc);
			     lines[listlen-1].color = current->color;
			     linecnt++;
                           }
			   lastprinted = current;
			   linecnt++;
			   for(lin=0;lin<(listlen-1);lin++) 
			   {
			      strcpy(lines[lin].line,lines[lin+1].line);
			      lines[lin].color = lines[lin+1].color;
			   }
			   strcpy(lines[listlen-1].line,temp);
			   lines[listlen-1].color = current->color;
			}
		}

		if(linecnt > 0)	/* anything to update? */
			redraw(lines);
		/*
		 * If we just printed lines, there might be more to read
		 */

		if(linecnt == 0)
			usleep(5000);
		if(XPending(disp) && XCheckWindowEvent(disp, root, 
				     EVENTMASK, &xev))
		{
			switch (xev.type)
			{
				case Expose:

#define	win1_x		xev.xexpose.x
#define win1_y		xev.xexpose.y
#define win1_x1 	(xev.xexpose.x+xev.xexpose.width)
#define win1_y1 	(xev.xexpose.y+xev.xexpose.height)
#define win_x1		(win_x+w)
#define win_y1		(win_y+h)

if 	(!((((win1_x>win_x && win1_x<win_x1)  || (win1_x1>win_x && win1_x1<win_x1)) &&
	((win1_y>win_y && win1_y<win_y1)  || (win1_y1>win_y && win1_y1<win_y1))) ||
	(win1_x<win_x && win1_x1>win_x1 && win1_y<win_y && win1_y1>win_y1)))
					break;
				case FocusIn:
				case MapNotify:
				case UnmapNotify:
				case FocusOut:
					refresh(lines);
					break;

				case ConfigureNotify:
				case EnterNotify:
				case LeaveNotify:
					break;
				default:
					fprintf(stderr,"PANIC! Unknown event %d\n", xev.type);
					break;
			}
		}
		/* reload if requested */
		if(reload && (lastreload + reload < time(NULL)))
		{
			struct	logfile_entry	*current;
	
			system(command);
                       /* Why not use the same function?
                        * So we report and abort
                        * Maybe it's better to report and ignore
                        */

                       reopen(1);
                       /*

			for(current = loglist; current != NULL; 
			    current = current->next)
			{
				fclose(current->f);
*/
				/*
			 	* This open might fail. What to do?
			 	*  - report
			 	*  - ignore
			 	*  - abort
			 	*/
			/*
				current->f = openLog(current->fname);
			}
			*/
			lastreload = time(NULL);
		}
	}

}

void 	PrintHelp(char *myname)
{
	printf("Usage: %s [options] file1[,color[,desc]] "
	       "[file2[,color[,desc]] ...]\n", 
		myname);
	printf(" -geometry geometry    [-g WIDTHxHEIGHT+X+Y                         ]\n");
	printf(" -color    color       [use color $color as default                 ]\n");
	printf(" -reload   sec command [run command & run command after $sec seconds]\n");
	printf(" -shade                [add shading to font                         ]\n");
	printf("\n");
	printf("Example: %s -g 80x25+100+50 /var/log/messages,green "
	       "/var/log/secure,red,'ALERT'\n", myname);
	exit(0);
}


int 	main( int argc, char * argv[] )
{

	int	i;
	int	filecount = 0;

	printf("ROOT WINDOW TAIL v0.0.4\n"
	       "-- mjbaker@mtu.edu and irvdwijk@cs.vu.nl --\n");
       printf("-- signal handling by andre@aleph.it\n");


	/* window needs to be initialized before colorlookups can be done */

	InitWindow();
	lastreload = time(NULL);
	/*
	 * More checking on the parameters would be nice
	 */

	for (i=1;i<argc;i++)
	{
		if(argv[i][0] == '-')
		{
			if (!strcmp(argv[i],"--?")||
			    !strcmp(argv[i],"--help")||
			    !strcmp(argv[i],"-h"))
				PrintHelp(argv[0]);
			else if (!strcmp(argv[i],"-g")||!strcmp(argv[i],"-geometry"))
			{
				i++;
				XParseGeometry(argv[i],&win_x,&win_y,
						&width,&listlen);
			}
			else if (!strcmp(argv[i],"-color"))
			{
				i++;
				color=argv[i];
			}
			else if (!strcmp(argv[i],"-font"))
			{
				i++;
				fontName=argv[i];
			}
			else if (!strcmp(argv[i],"-fork"))
			{
				pid=0;
			}
			else if (!strcmp(argv[i],"-reload"))
			{
				i++;
				reload = atoi(argv[i]);
				i++;
				command = argv[i];
			}
			else if (!strcmp(argv[i],"-shade"))
				shade = 1;
			else
			{
				printf("unknown option %s\n --help for help\n",
					argv[i]);
				exit(-1);
			}
		}
		/* check '-' which means stdin as input */

		else /* it must be a filename */
		{
			FILE	*f;
			struct	logfile_entry	*e;
			char	*fname, *desc, *fcolor = color, *sep;

			/* 
			 * this is not foolproof yet (',' in filenames 
			 * are not allowed
			 */
			fname = argv[i];
			desc = fname;

			if((sep = strchr(argv[i], ',')))
			{
				*sep = '\0';
				fcolor = sep+1;

				if((sep = strchr(fcolor, ',')))
				{
					*sep = '\0';
					desc = sep+1;
				}
			}
				
			if((f = openLog(fname)) == NULL)
			{
				perror(fname);
				exit(-1);
			}
			e = (struct logfile_entry *)
					malloc(sizeof(struct logfile_entry));
	
			strncpy(e->fname, fname, 255);
			e->fname[255] = '\0';	/* just in case */
			strncpy(e->desc, desc, 255);
			e->desc[255] = '\0';	/* just in case */
			e->f = f;
			e->color = GetColor(fcolor);
			e->next = NULL;

			if(loglist == NULL)
				loglist = e;
			if(loglist_tail)
				loglist_tail->next = e;
			loglist_tail = e;
			filecount++;
		}			
	}






	InitWindow();

	if(filecount == 0)
	{
		fprintf(stderr, "You did not specify any files to tail\n");
		fprintf(stderr, "use %s --help for help\n", argv[0]);
		exit(-1);
	}
	loop();

	return 0;		/* to make gcc -Wall stop complaining */
}
