/*
** 1998-12-19 -	Toggle the hide allowed flag of the source pane, update the toggle button
**		accordingly, and do a rescan.
** 1999-03-15 -	Stuck the DpRecenter command in here, and renamed the entire module (was dphide).
*/

#include "gentoo.h"

#include <regex.h>
#include <stdlib.h>

#include "cmdseq.h"
#include "dirpane.h"
#include "cmd_dpmisc.h"

/* ----------------------------------------------------------------------------------------- */

int cmd_dphide(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	DPFormat	*fmt;

	fmt = &min->cfg.dp_format[src->index];
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(src->hide), !fmt->hide_allowed);
	csq_execute(min, "DirRescan");

	return 1;
}

/* 1999-03-15 -	Recenter the horizontal pane betweeen the, er, panes. Very useful.
** 1999-08-28 -	Now handles centering the pane even if the main window has not yet been made visible.
*/
int cmd_dprecenter(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	gint	ww;

	if(GTK_WIDGET_VISIBLE(min->gui->window))
		gdk_window_get_size(min->gui->window->window, &ww, NULL);
	else if(min->cfg.wininfo.size.flags & PSPF_SET)
		ww = min->cfg.wininfo.size.a;
	gtk_paned_set_position(GTK_PANED(min->gui->hpane), ww / 2);

	return 1;
}

/* 1999-09-14 -	This command (or something similar) implemented after suggestion by
**		Jarle Thorsen <jthorsen@iname.com>. It allows you to scroll a pane's
**		contents so that the first row beginning with a specified letter becomes
**		visible.
*/
int cmd_dpgotorow(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	const gchar	*value;
	guint		focus;
	gint		row = -1;

	focus = car_keyword_get_boolean(ca, "focus", FALSE);

	if((value = car_keyword_get_value(ca, "re", NULL)) != NULL)
	{
		regex_t	re;
		guint	nocase;

		nocase = car_keyword_get_boolean(ca, "nocase", FALSE);
		if(regcomp(&re, value, REG_EXTENDED | (nocase ? REG_ICASE : 0)) == 0)
		{
			guint	i;

			for(i = 0; i < src->dir.num_lines && row < 0; i++)
			{
				if(regexec(&re, DP_ROW_NAME(&src->dir.line[i]), 0, NULL, 0) == 0)
					row = i;
			}

			regfree(&re);
		}
	}
	else if((value = car_keyword_get_value(ca, "row", NULL)) != NULL)
		row = strtol(value, NULL, 0);

	if(row != -1)
	{
		gtk_clist_moveto(GTK_CLIST(src->list), row, -1, 0.0, 0.0);
		if(focus)
			dp_focus(src, row);
	}

	return 1;
}
