/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "extension.h"
#include "stringfunctions.h"
#include "global.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include "fnmatch.h"

/* Both functions are only called in the createicon.c file */

/* This function modifies the iconname of the given filename if there is a 
   xvpic for the file. If not GetXVIconName leave icon untouched */
void GetXVIconName(char *filename,char **icon)
{
  char *xvpic;
  /*char *text;*/
  int character=0;
  FILE *xvfile;
  int i;
  if (strlen(filename)!=0) {   /*happens by structure and the topfolder*/
    xvpic=malloc(strlen(GetPath())+strlen(".xvpics/")+
		 strlen(filename)+1);
    strcpy(xvpic,GetPath());
    strcat(xvpic,".xvpics/");
    strcat(xvpic,filename);
    if (xvpic[0]=='~' && xvpic[1]=='/')
      xvpic[0]='.';
    if ((xvfile=fopen(xvpic, "r")) != NULL) {
      for (i=0;i<strlen(xvpic)+100;i++)
	character=fgetc(xvfile);
      fclose(xvfile);
      if (character!=-1) {
	free(*icon);
	*icon=malloc(strlen(xvpic)+1);
	strcpy(*icon,xvpic);
      }
    }
    free(xvpic);
  }
}

/* This Function returns the icon and startcommand as specified in the dfmext
   file. Dfm used this function only if this hasn't already specified (so if
   you save the iconinfo and change dfmext after that nothing happens). Also
   this function is generally used during "re-recognize" */
void GetExtensionParameter(char *fullname,char **icon,char **start)
{
  FILE *pfext=NULL;
  char *text;
  char *filename;
  char *fullname2;
  int i,character;
  int lastline=0;
  struct stat info;
  static int finden=0;
  filename=GenerateLastName(fullname);
  if (filename[0]==0)
    filename="this_is_never_in_dfmext/";
  fullname2=malloc(strlen(fullname)+1);
  strcpy(fullname2,fullname);
  if (fullname2[0]=='~' && fullname2[1]=='/')
    fullname2[0]='.';

  /* search dfmext */
  if ((pfext=fopen("./.dfmext", "r")) == NULL) 
  if ((char*)getenv("DFMEXTFILE")==NULL ||
      (pfext=fopen((char*)getenv("DFMEXTFILE"), "r")) == NULL)
  if ((pfext=fopen(DFMEXTFILE, "r")) == NULL)
       pfext=fopen("/etc/dfmext", "r");
  /* end search */

  if (pfext==NULL) {
    if (finden==0) {
      printf("DFM Warning: dfmext not found. Must be:\n");
      printf("   ~/.dfmext\n");
      printf("or $DFMEXTFILE (shell variable)\n");
      printf("or %s\n",DFMEXTFILE);
      printf("or /etc/dfmext\n");
      finden=1;
    }
  } else {
    text=malloc(1000);
    do {
      i=-1;
      do {
	character=fgetc(pfext);
	i++;
	text[i]=(char)character;
      } while (character!=-1 && text[i]!=';' && character!=10);
      text[i]=0;
      if (text[0]=='#') {
        if (character!=10) {
          do {
            character=fgetc(pfext);
          } while (character!=-1 && character!=10);
	}
      } else {
        if (fnmatch(text,filename,FNM_PATHNAME)==0) {
	  if (strcmp(text,"*")==0) lastline=1;
	  i=-1;
	  do {
	    character=fgetc(pfext);
	    i++;
	    text[i]=(char)character;
	  } while (character!=-1 && text[i]!=';' && character!=10);
	  text[i]=0;
	  *icon=malloc(strlen(text)+1);
	  strcpy(*icon,text);
	  i=-1;
	  do {
	    character=fgetc(pfext);
	    i++;
	    text[i]=(char)character;
	  } while (character!=-1 && text[i]!=';' && character!=10);
	  text[i]=0;
	  *start=malloc(strlen(text)+1);
	  strcpy(*start,text);
        } else {
	  i=-1;
	  do {
	    character=fgetc(pfext);
	    i++;
	    text[i]=(char)character;
	  } while (character!=-1 && text[i]!=';' && character!=10);
	  text[i]=0;
	  i=-1;
	  do {
	    character=fgetc(pfext);
	    i++;
	    text[i]=(char)character;
	  } while (character!=-1 && text[i]!=';' && character!=10);
	  text[i]=0;
        } 
      }
    } while (*icon==NULL && *start==NULL && character!=-1);
    if (lastline==1) {
      stat(fullname2,&info);
      if ((info.st_mode & (S_IXUSR | S_IXGRP | S_IXOTH))!=0) {
	free(*icon);
	free(*start);
	i=-1;
	do {
	  character=fgetc(pfext);
	  i++;
	  text[i]=(char)character;
	} while (character!=-1 && text[i]!=';' && character!=10);
	text[i]=0;
	*icon=malloc(strlen(text)+1);
	strcpy(*icon,text);
	i=-1;
	do {
	  character=fgetc(pfext);
	  i++;
	  text[i]=(char)character;
	} while (character!=-1 && text[i]!=';' && character!=10);
	text[i]=0;
	*start=malloc(strlen(text)+1);
	strcpy(*start,text);
      }
      free(text);
    }
    fclose(pfext);
  }
  if (*icon==NULL || *start==NULL) {
    if (filename[strlen(filename)-1]=='/') {
      *icon=strdup("/usr/lib/X11/dfm/icons/icon_folder.xpm");
      *start=strdup("dfm !0!");
    } else {
      stat(fullname2,&info);
      if ((info.st_mode & (S_IXUSR | S_IXGRP | S_IXOTH))!=0) {
	*icon=strdup("/usr/lib/X11/dfm/icons/icon_binary.xpm");
	*start=strdup("!0!");
      } else {
	*icon=strdup("/usr/lib/X11/dfm/icons/icon_file.xpm");
	*start=strdup("xterm -e vi !0!");
      }
    }
  }
  free(fullname2);
  if ((*icon)[0]=='~' && (*icon)[1]=='/')
    (*icon)[0]='.';
}
