// resource.hh for bbpager - a pager tool for Blackbox
//
//  Copyright (c) 1998-1999 John Kennis, jkennis@chello.nl
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __RESOURCE_HH
#define __RESOURCE_HH

#include "bbpager.hh"
#include "Baseresource.hh"

class BaseResource;

enum {none=0, border=1, texture=2};

enum WHICH_BUTTON { LEFT_BUTTON = 1, MIDDLE_BUTTON, RIGHT_BUTTON,
                    FOURTH_BUTTON, FIFTH_BUTTON};

struct FRAME {
  int width;
  int height;
  BTexture texture;
  int bevelWidth;
  XFontStruct *font;
};

struct POSITION {
  int x;
  int y;
  int mask;
  bool vertical;
  bool horizontal;
};

struct SIZE {
  unsigned int width;
  unsigned int height;
};

struct REPORT {
  bool auto_raise;
};

struct BBPAGERWIN {
  BTexture texture;
  BTexture focusedTexture;
  BColor activeColor;
  BColor inactiveColor;
};

class Resource : public BaseResource {

public:
  Resource(ToolWindow *);
  ~Resource(void);

  struct FRAME frame;
  struct POSITION position;
  struct SIZE desktopSize;
  struct REPORT report;
  struct BBPAGERWIN pagerwin;
  struct BBPAGERWIN desktopwin;
  int columns;
  int rows;
  int getFocusStyle(void) { return focus_style; }
  int getDesktopFocusStyle(void) { return desktop_focus_style; }
  WHICH_BUTTON getWindowMoveButton(void) { return window_move_button; }
  WHICH_BUTTON getDesktopChangeButton(void) { return desktop_change_button; }

protected:
  virtual void  LoadBBToolResource(void);

private:
  void Frame(void);
  void SizeAndPosition(void);
  void PagerWin(void);
  int focus_style;
  int desktop_focus_style;
  WHICH_BUTTON window_move_button;
  WHICH_BUTTON desktop_change_button;
  void Clean(void);
};
#endif /* __RESOURCE_HH */
