
"""ChangeBehaviors module

This is an example of how to use Python's dynamic features to reach into
Zope and change class and object behaviors without having to patch the
source tree.
"""

__version__='$Revision: 0.2.0 $'[11:-2]

def _change_traverse_behaviors():
    def before_traverse(self, object, response):
        # If the top object has a __before_traverse__ attribute, then use it
        # to possibly alter the request, or even raise an exception.
        # It must be a dictionary, with each value a method id of the object.
        # These are called in the sort order of their keys, which thus act as
        # both label and priority.  Keys created within SiteAccess are tuples
        # like (1, 'AccessRule), but they don't have to be in general.
        btrmap = getattr(object, '__before_traverse__', {})
        if btrmap:
            btrs = btrmap.keys()
            btrs.sort()
            for btr in btrs:
                try:  btrmeth = getattr(object, btrmap[btr])
                except: del btrmap[btr]
                else: 
                  btrmeth(object, self, None)

    def traverse(self, path, response=None):
        """Traverse the object space

        The REQUEST must already have a PARENTS item with at least one
        object in it.  This is typically the root object.
        """
        request=self
        request_get=request.get
        if response is None: response=self.response
        debug_mode=response.debug_mode

        # Make sure that REQUEST cannot be traversed.
        if find(path, 'REQUEST') >= 0:
            return response.notFoundError(path)

        self.path = path = filter(None, split(path, '/'))
        i = len(path)
        while i > 0:
          i = i - 1
          if path[i] == '.': del path[i]
          elif path[i] == '..':
            del path[i-1:i+1]
            i = i - 1
        
        allow_btr = (not path or path[0]<>'__no_before_traverse__')
        if not allow_btr: del path[0]
    
        method=req_method=upper(request_get('REQUEST_METHOD', 'GET'))
        baseflag=0
        if method=='GET' or method=='POST':
            method='index_html'
        else: baseflag=1
    
        parents=request['PARENTS']
        object=parents[-1]
        del parents[:]
        try:
            # We build parents in the wrong order, so we
            # need to make sure we reverse it when we're doe.
            if hasattr(object,'__roles__'): roles=object.__roles__
            else:                           roles=UNSPECIFIED_ROLES
        
            # if the top object has a __bobo_traverse__ method, then use it
            # to possibly traverse to an alternate top-level object.
            if hasattr(object,'__bobo_traverse__'):
                try: object=object.__bobo_traverse__(request)
                except: pass            

            URL = request['URL']
            if not path and not method:
                 return response.forbiddenError(URL)

            # Traverse the URL to find the object:
            if hasattr(object, '__of__'): 
                # Try to bind the top-level object to the request
                object=object.__of__(RequestContainer(REQUEST=request))
        
            steps=self.steps
            path.reverse()
            entry_name = ''
            self.URLpath = URLpath = [URL]
            if not allow_btr: self.setURL(path='__no_before_traverse__')
            while 1:
                if allow_btr:
                    self.before_traverse(object, response)
                # Check for method:
                if path:
                    entry_name = path.pop()
                elif (method and hasattr(object,method)
                      and entry_name != method
                      and getattr(object, method) is not None):
                    request._hacked_path=1
                    entry_name = method
                else:
                    if (hasattr(object, '__call__') and
                        hasattr(object.__call__,'__roles__')):
                        roles=object.__call__.__roles__
                    if request._hacked_path:
                        i=rfind(URL,'/')
                        if i > 0: response.setBase(URL[:i])
                    break
                if not entry_name: continue
                URLpath.append(quote(entry_name))
                URL = join(URLpath, '/')
                got = 0
                # CHANGED Oct 18 1999 BY Evan Simpson
                if entry_name[:1]=='_':
                    if debug_mode:
                        return response.debugError(
                          "Object name begins with an underscore at: %s"
                          % URL)
                    else: return response.forbiddenError(entry_name)
    
                if hasattr(object,'__bobo_traverse__'):
                    request['URL']=URL
                    subobject=object.__bobo_traverse__(request,entry_name)
                    if type(subobject) is type(()) and len(subobject) > 1:
                        while len(subobject) > 2:
                            parents.append(subobject[0])
                            subobject=subobject[1:]
                        object, subobject = subobject
                else:
                    try:                            
                        # Note - this is necessary to support
                        # things like DAV.  We have to make sure
                        # that the target object is not acquired
                        # if the request_method is other than GET
                        # or POST. Otherwise, you could never use
                        # PUT to add a new object named 'test' if
                        # an object 'test' existed above it in the
                        # heirarchy -- you'd always get the
                        # existing object :(
                        
                        if baseflag and hasattr(object, 'aq_base'):
                            if hasattr(object.aq_base, entry_name):
                                subobject=getattr(object, entry_name)
                            else: raise AttributeError, entry_name
                        else: subobject=getattr(object, entry_name)
                    except AttributeError:
                        got=1
                        try: subobject=object[entry_name]
                        except (KeyError, IndexError,
                                TypeError, AttributeError):
                            if debug_mode:
                                return response.debugError(
                                    "Cannot locate object at: %s" %URL) 
                            else: return response.notFoundError(URL)
    
                try:
                    try: doc=subobject.__doc__
                    except: doc=getattr(object, entry_name+'__doc__')
                    if not doc: raise AttributeError, entry_name
                except:
                    if debug_mode:
                        return response.debugError(
                            "Missing doc string at: %s" % URL)
                    else: return response.notFoundError("%s" % (URL))

                if hasattr(subobject,'__roles__'):
                    roles=subobject.__roles__
                else:
                    if not got:
                        roleshack=entry_name+'__roles__'
                        if hasattr(object, roleshack):
                            roles=getattr(object, roleshack)

                # Promote subobject to object
            
                parents.append(object)
                object=subobject

                steps.append(entry_name)
        finally:
            # We need to MAKE SURE this happens due to new error handling
            parents.reverse()
    
        # Do authorization checks
        user=groups=None
        i=0
        if roles is not None:
    
            last_parent_index=len(parents)
            if hasattr(object, '__allow_groups__'):
                groups=object.__allow_groups__
                inext=0
            else:
                inext=None
                for i in range(last_parent_index):
                    if hasattr(parents[i],'__allow_groups__'):
                        groups=parents[i].__allow_groups__
                        inext=i+1
                        break
    
            if inext is not None:
                i=inext
    
                if hasattr(groups, 'validate'): v=groups.validate
                else: v=old_validation
    
                auth=request._auth
    
                if v is old_validation and roles is UNSPECIFIED_ROLES:
                    # No roles, so if we have a named group, get roles from
                    # group keys
                    if hasattr(groups,'keys'): roles=groups.keys()
                    else:
                        try: groups=groups()
                        except: pass
                        try: roles=groups.keys()
                        except: pass
    
                    if groups is None:
                        # Public group, hack structures to get it to validate
                        roles=None
                        auth=''
    
                if v is old_validation:
                    user=old_validation(groups, request, auth, roles)
                elif roles is UNSPECIFIED_ROLES: user=v(request, auth)
                else: user=v(request, auth, roles)
    
                while user is None and i < last_parent_index:
                    parent=parents[i]
                    i=i+1
                    if hasattr(parent, '__allow_groups__'): 
                        groups=parent.__allow_groups__
                    else: continue
                    if hasattr(groups,'validate'): v=groups.validate
                    else: v=old_validation
                    if v is old_validation:
                        user=old_validation(groups, request, auth, roles)
                    elif roles is UNSPECIFIED_ROLES: user=v(request, auth)
                    else: user=v(request, auth, roles)
                    
            if user is None and roles != UNSPECIFIED_ROLES:
                response.unauthorized()
    
        steps=join(steps[:-i],'/')
        if user is not None:
            # Try to set a watermark on the user object.
            user._v__marker__=_marker
            request['AUTHENTICATED_USER']=user
            request['AUTHENTICATION_PATH']=steps

        # Remove http request method from the URL.
        request['URL']=URL
    
        return object

    BaseRequest.traverse = traverse
    BaseRequest.before_traverse = before_traverse

from ZPublisher import BaseRequest
exec _change_traverse_behaviors.func_code in BaseRequest.__dict__

def _change_request_behaviors():
    def setURL(self, base=None, path=None):
        if base is not None:
            # Any reason to have distinct script and base? None I can think of.
            self.script = self.base = strip(base)
            self.URLpath[0] = self.script
        if path is not None:
            if type(path) in (type([]), type(())):
                # Even if it's already a list, we want to copy it.
                pathlist = list(path)
            else:
                pathlist = split(path, '/')
            # Replace the *contents* of URLpath and steps *but not the list*
            self.URLpath[:] = pathlist = filter(None, pathlist)
            self.steps[:] = pathlist
            self.URLpath.insert(0, self.script)
            self['URL'] = join(pathlist, '/')
        # flush cached URLs
        for pfx in ('URL%s', 'BASE%s'):
            i = 0
            while self.other.has_key(pfx % i):
                del self.other[pfx % i]
                i = i + 1
    HTTPRequest.setURL = setURL

from ZPublisher import HTTPRequest
exec _change_request_behaviors.func_code in HTTPRequest.__dict__

def _change_absolute_url():
    def absolute_url(self, relative=0):
        absurl = getattr(self, '_v_absolute_url', None)
        if absurl:
            base, path = absurl
            if not relative:
                path = [base] + path
            return join(path, '/')
        id = self.id
        if callable(id): id = quote(id())
        else: id=quote(id)
        
        p = getattr(self, 'aq_inner', None)
        if p is not None: 
            p = p.aq_parent
            if hasattr(p, 'absolute_url'):
                url = p.absolute_url(relative)
            elif not relative:
                url = p.REQUEST.script
            if url[-1:] <> '/': url = url + '/'
            id = url+id
        return id
    Item.absolute_url = absolute_url

from OFS import SimpleItem
exec _change_absolute_url.func_code in SimpleItem.__dict__
