/*  Screem:  siteWizard.c,
 *  A site druid for guiding users through the process of creating a site
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>
#include <gnome.h>

#include <glade/glade.h>

#include "fileops.h"
#include "preferences.h"
#include "site.h"
#include "siteUI.h"
#include "siteTemplate.h"
#include "siteTree.h"
#include "siteTreeUI.h"
#include "support.h"

extern GtkWidget *app;
extern Site *current_site;
extern Preferences *cfg;

extern GList *loaded_sites;

void site_druid_canceled( GtkWidget *widget );
void site_druid_finished(GnomeDruidPage *druid_page, GtkWidget *druid );
gboolean site_druid_next1(GnomeDruidPage *druid_page, GtkWidget *druid );
gboolean site_druid_next2( GnomeDruidPage *druid_page, GtkWidget *druid);
gboolean site_druid_next3( GnomeDruidPage *druid_page, GtkWidget *druid);
gboolean site_druid_next4( GnomeDruidPage *druid_page, GtkWidget *druid);
gboolean site_druid_next5( GnomeDruidPage *druid_page, GtkWidget *druid);
gboolean site_druid_next6(GnomeDruidPage *druid_page, GtkWidget *druid); 

static gchar *site_template;

static GladeXML *xml;
static Site *site;

/*
 * screem_site_wizard:
 * @site:  the site struct to use
 *
 * opens the site wizard dialog, this is a new wizard that replaces
 * the site settings dialog that was also used in site creation
 *
 * return values: none
 */
void screem_site_wizard( Site *s )
{
	GtkWidget *toggle;
	GtkWidget *object;

	xml = glade_xml_new( GLADE_PATH"/sitedruid.glade", 
			     "site_druid_window" );

	/* yep - kludge time again */

	/* page 2 */
	toggle = glade_xml_get_widget( xml, "use_site_template" );
	object = glade_xml_get_widget( xml, "site_template_entry" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	toggle = glade_xml_get_widget( xml, "use_page_template" );
	object = glade_xml_get_widget( xml, "page_template_entry" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	/* page 3 */
	toggle = glade_xml_get_widget( xml, "use_cvs" );
	object = glade_xml_get_widget( xml, "cvs_root_entry" );
	gtk_signal_connect_object( GTK_OBJECT( toggle ), "toggled",
				   GTK_SIGNAL_FUNC( change_state ),
				   (gpointer)object );

	glade_xml_signal_autoconnect( xml );

	site = s;
}

void site_druid_canceled( GtkWidget *widget )
{
	GtkWidget *window;

	window = glade_xml_get_widget( xml, "site_druid_window" );

	gtk_widget_destroy( window );
	screem_site_destroy( site );
}

void site_druid_finished(GnomeDruidPage *widget, GtkWidget *druid )
{
	GtkWidget *window;
	xmlDocPtr doc;
	GtkWidget *file_tree;
	GtkWidget *old_tree;
	GtkWidget *tree_window;
	gchar *default_file;
	FILE *file;
	GtkWidget *combo;

	const gchar *template_path;

	window = glade_xml_get_widget( xml, "site_druid_window" );
	gtk_widget_destroy( window );

	/* create the site */
	if( screem_site_create( site ) ) {
		if( site_template ) {
			/* create site from template */
			build_site_with_template( site, site_template );
			chdir( screem_site_get_pathname( site ) );
		} else {
			/* no site template, create initial page */
			template_path = screem_site_get_template_path( site );
			default_file = cfg->default_filename;
			if( ! template_path ) {
				file = fopen( default_file, "w" );
				fclose( file );
			} else {
				/* copy the template */
				copy_file( template_path, default_file );
			}
		}
		/* add this site to the list of loaded sites */
		loaded_sites = g_list_append( loaded_sites, site );
		/* build the combo options */
		screem_build_sites_combo_list();
		/* set the combo entry to be the name of the current site */
		combo = gtk_object_get_data( GTK_OBJECT( app ), "sitecombo" );
		gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( combo )->entry ),
				    screem_site_get_name( site ) );

		current_site = site;

		/* create the site file tree */
		refresh_file_tree();
	}
}

gboolean site_druid_next1(GnomeDruidPage *druid_page, GtkWidget *druid )
{
	/* page contains site pathname and site name */
	GtkWidget *path_entry;
	GtkWidget *name_entry;
	
	GladeXML *message;

	gchar *p;
	gchar *n;

	path_entry = glade_xml_get_widget( xml, "site_pathname" );
	name_entry = glade_xml_get_widget( xml, "site_name" );

	p = gtk_entry_get_text( GTK_ENTRY( path_entry ) );
	n = gtk_entry_get_text( GTK_ENTRY( name_entry ) );

	/* if either are just "" then we do not advance */
	if( ( ! strlen( p ) ) || ( ! strlen( n ) ) ) {
		message = glade_xml_new( GLADE_PATH"/sitedruid.glade",
					 "message1" );
	
		return TRUE;
	}

	screem_site_set_pathname( site, p );
	screem_site_set_name( site, n );

	return FALSE;
}

gboolean site_druid_next2(GnomeDruidPage *druid_page, GtkWidget *druid )
{
	/* page contains site template path and page template path */
	GtkWidget *spath;
	GtkWidget *ppath;

	spath = glade_xml_get_widget( xml, "site_template" );
	ppath = glade_xml_get_widget( xml, "page_template" );

	if( GTK_WIDGET_IS_SENSITIVE( ppath ) ) {
		screem_site_set_template_path( site, gtk_entry_get_text( GTK_ENTRY( ppath ) ) );
	} else {
		screem_site_set_use_template( site, FALSE );
	}
	if( GTK_WIDGET_IS_SENSITIVE( spath ) ) {
		site_template = g_strdup(gtk_entry_get_text(GTK_ENTRY(spath)));
	} else {
		site_template = NULL;
	}

	return FALSE; 
}

gboolean site_druid_next3(GnomeDruidPage *druid_page, GtkWidget *druid )
{
	/* page contains cvs path */
	GtkWidget *table;
	GtkWidget *path;
	
	path = glade_xml_get_widget( xml, "cvs_root" );
	
	if( GTK_WIDGET_IS_SENSITIVE( path ) ) {
		screem_site_set_cvs_root(site, 
					 gtk_entry_get_text( GTK_ENTRY(path) ));
	} else {
		screem_site_set_use_cvs( site, FALSE );
	}
	
	return FALSE;
}

gboolean site_druid_next4(GnomeDruidPage *druid_page, GtkWidget *druid )
{
	/* page contains remote address + http address */
	GtkWidget *raddress;
	GtkWidget *http;

	GladeXML *message;

	gchar *r;
	gchar *h;

	raddress = glade_xml_get_widget( xml, "remote_address" );
	http = glade_xml_get_widget( xml, "http_url" );

	r = gtk_entry_get_text( GTK_ENTRY( raddress ) );
	h = gtk_entry_get_text( GTK_ENTRY( http ) );

	/* if either are just "" then we do not advance */
	if( ( ! strlen( r ) ) ||  ( ! strlen( h ) ) ) {
		message = glade_xml_new( GLADE_PATH"/sitedruid.glade",
					 "message4" );
	
		return TRUE;
	}

	screem_site_set_remote_url( site, r );
	screem_site_set_http_url( site, h );

	return FALSE; 
}

gboolean site_druid_next5(GnomeDruidPage *druid_page, GtkWidget *druid )
{
	/* page contains remote method + remote path */
	GtkWidget *rmethod;
	GtkWidget *rpath;

	GladeXML *message;

	gchar *m;
	gchar *p;

	rmethod = glade_xml_get_widget( xml, "remote_method" );
	rpath = glade_xml_get_widget( xml, "remote_path" );

	m = gtk_entry_get_text( GTK_ENTRY( rmethod ) );
	p = gtk_entry_get_text( GTK_ENTRY( rpath ) );

	/* we must have an rpath */
	if( ! strlen( p ) ) {
		message = glade_xml_new( GLADE_PATH"/sitedruid.glade",
					 "message5" );

		return TRUE;
	}

	screem_site_set_remote_method( site, m );
	screem_site_set_remote_path( site, p );

	return FALSE; 
}

gboolean site_druid_next6(GnomeDruidPage *druid_page, GtkWidget *druid )
{
	/* page contains remote address + http address */
	GtkWidget *rusername;
	GtkWidget *rpass;
	
	GladeXML *message;

	gchar *u;
	gchar *p;

	rusername = glade_xml_get_widget( xml, "remote_username" );
	rpass = glade_xml_get_widget( xml, "remote_password" );

	u = gtk_entry_get_text( GTK_ENTRY( rusername ) );
	p = gtk_entry_get_text( GTK_ENTRY( rpass ) );

	/* if either are just "" then we do not advance */
	if( ( ! strlen( u ) ) || ( ! strlen( p ) ) ) {
		message = glade_xml_new( GLADE_PATH"/sitedruid.glade",
					 "message6" );
	
		return TRUE;
	}

	screem_site_set_remote_user( site, u );
	screem_site_set_remote_pass( site, p );

	return FALSE; 
}
