/* 
   sitecopy, manage remote web sites.
   Copyright (C) 1998-99, Joe Orton <joe@orton.demon.co.uk>.
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: common.c,v 1.1.1.1 1999/11/21 19:46:55 davek Exp $
*/

#include <config.h>

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif 
#include <time.h>
#include <stdarg.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */

#ifndef HAVE_SNPRINTF
#include "snprintf.h"
#endif /* HAVE_SNPRINTF */

#include "common.h"
#include "md5.h"

#ifdef ENABLE_NLS
#include <libintl.h>
#define _(str) gettext(str)
#else
#define _(str) str
#endif /* ENABLE_NLS */

int debug_mask;

void debug( int ch, char *template, ...) {
#ifdef DEBUGGING
    va_list params;
    if( (ch&debug_mask) != ch ) return;
    fflush( stdout );
    va_start( params, template );
    vfprintf( stderr, template, params );
    va_end( params );
#else
    /* No debugging here */
#endif
}

#ifndef HAVE_STRDUP

char *strdup( const char *s ) {
    char *new;
    new = malloc( strlen(s) + 1 );
    if( new != NULL ) {
	strcpy( new, s );
    }
    return new;
}

#endif

/* Snagged from fetchmail */
# if !HAVE_STRERROR && !defined(strerror)
char *strerror (errnum)
     int errnum;
{
  extern char *sys_errlist[];
  extern int sys_nerr;

  if (errnum > 0 && errnum <= sys_nerr)
    return sys_errlist[errnum];
  return _("Unknown system error");
}
# endif /* HAVE_STRERROR */

#ifdef USE_DAV

char *hexify_md5( unsigned char md5_buf[16] );

/* Useful function for turning a raw MD5 digest into a hex string.
 * 16 bytes, 4 bits per one character... result needs 32 chars */
char *hexify_md5( unsigned char md5_buf[16] ) {
    char *ret, *pnt;
    int count;
    pnt = ret = malloc( 33 );
    for( count = 0; count<16; count++ ) {
	sprintf( pnt, "%02x", md5_buf[count] );
	pnt += 2;
    }
    return ret;
}

/* This does the MD5ization and the hexify all in one.
 * Uses Ulrich Drepper's MD5 implementation */
char *md5_hex( const char *buffer, size_t buflen ) {
    unsigned char md5buf[16];
    md5_buffer( buffer, buflen, md5buf );
    return hexify_md5( md5buf );
}

/* Similarly for md5_hex, except on a stream */
char *md5_hex_stream( FILE *stream ) {
    unsigned char md5buf[16];
    md5_stream( stream, md5buf );
    return hexify_md5( md5buf );
}
#endif

#ifdef MD5_TEST
/* Quicky tester thang for MD5 + hexify MD5 */
int main( int argc, char **argv ) {
    unsigned char *out, md5[16];
    if( argc < 2 ) exit(-1);
    md5_buffer( argv[1], strlen( argv[1] ), md5 );
    out = hexify_md5( md5 );
    printf( "Plain: [%s], MD5: [%s]\n", argv[1], out );
    return 0;
}

#endif

/*  it goes: Sun, 06 Nov 1994 08:49:37 GMT */
#define RFC1123_FORMAT "%3s, %02d %3s %4d %02d:%02d:%02d GMT"
const char *rfc1123_weekdays[7] = { 
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" 
};
const char *short_months[12] = { 
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

/* Returns the time/date GMT, in RFC1123-type format: eg
 *  Sun, 06 Nov 1994 08:49:37 GMT. */
char *rfc1123_date( const time_t anytime ) {
    struct tm *gmt;
    char *ret;
    gmt = gmtime( &anytime );
    ret = malloc( 29 + 1 ); /* dates are 29 chars long */
/*  it goes: Sun, 06 Nov 1994 08:49:37 GMT */
    snprintf( ret, 30, RFC1123_FORMAT,
	      rfc1123_weekdays[gmt->tm_wday], gmt->tm_mday, 
	      short_months[gmt->tm_mon], 1900 + gmt->tm_year, 
	      gmt->tm_hour, gmt->tm_min, gmt->tm_sec );
    
    return ret;
}

/* Takes an RFC1123-formatted date string and returns the time_t.
 * Returns (time_t)-1 if the parse fails. */
time_t rfc1123_parse( const char *date ) {
    struct tm gmt = {0};
    static char wkday[4], mon[4];
    int n;
/*  it goes: Sun, 06 Nov 1994 08:49:37 GMT */
    n = sscanf( date, RFC1123_FORMAT,
	    wkday, &gmt.tm_mday, mon, &gmt.tm_year, &gmt.tm_hour,
	    &gmt.tm_min, &gmt.tm_sec );
    /* Is it portable to check n==7 here? */
    gmt.tm_year -= 1900;
    for( n=0; n<12; n++ )
	if( strcmp( mon, short_months[n] ) == 0 )
	    break;
    /* tm_mon comes out as 12 if the month is corrupt, which is desired,
     * since the mktime will then fail */
    gmt.tm_mon = n;
    return mktime( &gmt );
}

#undef RFC1123_FORMAT

#ifdef RFC1123_TEST

int main( int argc, char **argv ) {
    time_t now, in;
    char *out;
    if( argc > 1 ) {
	printf( "Got: %s\n", argv[1] );
	in = rfc1123_parse( argv[1] );
	printf( "Parsed: %d\n", in );
	out = rfc1123_date( in );
	printf( "Back again: %s\n", out );
    } else {
	now = time(NULL);
	out = rfc1123_date(now);
	in = rfc1123_parse(out);
	printf( "time(NULL) = %d\n", now );
	printf( "RFC1123 Time: [%s]\n", out );
	printf( "Parsed = %d\n", in );
	out = rfc1123_date( in );
	printf( "Back again: [%s]\n", out );
    }
    return 0;
}

#endif
