/*
//
// gif.c
//
// GIF (Graphic Interchange Format) support functions
//
// Copyright (c) 1995-96 Jim Nelson.  Permission to distribute
// granted by the author.  No warranties are made on the fitness of this
// source code.
//
*/

#include "htp.h"

BOOL GifFormatFound(FILE *file)
{
    BYTE header[8];

    /* move to BOF */
    if(fseek(file, 0, SEEK_SET) != 0)
    {
        DEBUG_PRINT(("unable to seek to start of GIF file"));
        return FALSE;
    }

    /* read first six bytes, looking for GIF header + version info */
    if(fread(header, 1, 6, file) != 6)
    {
        DEBUG_PRINT(("could not read GIF image file header"));
        return FALSE;
    }

    /* is this a GIF file? */
    if((memcmp(header, "GIF87a", 6) == 0) || (memcmp(header, "GIF89a", 6) == 0))
    {
        return TRUE;
    }

    /* not a GIF file */
    return FALSE;
}

BOOL GifReadDimensions(FILE *file, WORD *height, WORD *width)
{
    BYTE hi;
    BYTE lo;

    /* move to the image size position in the file header */
    if(fseek(file, 6, SEEK_SET) != 0)
    {
        DEBUG_PRINT(("unable to seek to start of GIF file"));
        return FALSE;
    }

    /* read the width, byte by byte */
    /* this gets around machine endian problems while retaining the */
    /* fact that GIF uses little-endian notation */
    if(fread(&lo, 1, 1, file) != 1)
    {
        return FALSE;
    }

    if(fread(&hi, 1, 1, file) != 1)
    {
        return FALSE;
    }

    *width = MAKE_WORD(hi, lo);

    /* read the height, byte by byte */
    if(fread(&lo, 1, 1, file) != 1)
    {
        return FALSE;
    }

    if(fread(&hi, 1, 1, file) != 1)
    {
        return FALSE;
    }

    *height = MAKE_WORD(hi, lo);

    return TRUE;
}

