/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifndef _VFUOPT_H_
#define _VFUOPT_H_

#include "vfuuti.h"

// view styles
#define VS_VFU 0
#define VS_VF  1

  extern char *NOYES[];
  extern char *FTIMETYPE[];
  extern char *TAGMARKS[];

  struct TOptions {
    // THist10 LastChDirs;
    // THist10 LastGetDirs;
    // THist10 LastMasks;
    // THist10 LastCommands;
    int SortOrder; 
    int Reversed; 
    // char GlobalSelectMask[1024];
    // char LastFindMask[MAX_PATH];
    // char LastFindPath[MAX_PATH];

    char LastCopyPath[3][MAX_PATH]; // for `COPY' `MOVE' `LINK'
    // char LastDir[MAX_PATH];
    // char LastCommand[1024];

    // files info parts

    int fSize;
    int fTime;
    int fAttr;
    int fGroup;
    int fOwner;
    int fType;
    int fTimeType;

    // toggles
    int VFStyle;
    int LongNameView;
    int ShowLinks;
    int AutoTree;
    int CompactTree;

    int TopDirs;

    int DynamicScroll;

    #ifdef _TARGET_GO32_
    int VFFilenames;
    #endif

    int HideDotNames;
    int DirTreeSizes;
    int AutoUpdateDSize;
    int AllowBeep;
    int CDTree;

    int AltMenus;
    int ExitCDHack;

    int AskExit;
    int FileColors;
    int UseDirColors;

    int DOSSlashes;
    int FreeSpaceCheck;

    int TagMark;

    int IntBrowser;
    int IntEditor;

    int FFExpandMask;
    int FMExpandMask;
    int GENExpandMask; // general wherever else
    int CLSonShell;

    int SameCaseKeys;
    int KeepArrangePos;

    // char LastGrep[256];

    int ZapROs; // zap/erase read-only files
    int FileCopyOwner; // should try to preserve file owner.group?

    int RealFreeSpace;
    int NoCaseArcs;
    int MenuBorders;

    int AltArrowsNav; // should <- == - and -> == +

    int AutoMount;
    int PreserveSelection;

    int BashComplete;
  };
  extern TOptions opt;

#define MAX_UX 64 // Max User External commands

typedef char char20[20];
typedef char char255[255];

struct TUX
{
  char des[32];
  char ext[64];
  int  key;
  char sline[512];
};
extern DCluster TUXes;

extern PSZCluster History;
extern PSZCluster SeeFilters;
extern PSZCluster Panelizers;

extern String RCDir;
#ifdef _TARGET_GO32_
  #define OPTFILE     (RCDir + "vfu.opt")
  #define CFGFILE     (RCDir + "vfu.cfg")
  #define HISTFILE    (RCDir + "vfu.hst")
  #define TREEFILE    (RCDir + "vfu_tree." + (tolower(CPath[0]) - 'a' + 1))
#else
  #define OPTFILE     (RCDir + "vfu.options")
  #define CFGFILE     (RCDir + "vfu.conf")
  #define HISTFILE    (RCDir + "vfu.history")
  #define TREEFILE    (RCDir + "vfu.tree")
#endif

#define MAX_TRIMS 24
extern pathstr_t TrimTree[MAX_TRIMS];
extern pathstr_t TrimLocate[MAX_TRIMS];

extern char ArcTempFile[MAX_PATH];

//
// misc functions connected to the opt(ions)
//

time_t OptTime( struct stat st );
time_t OptTime( time_t ctime, time_t mtime, time_t atime );

//
// file: vfuopt.cpp
//
void SetupFiles();
int SetSet( const char *line, const char *keyword, char *target );
int SetSet( const char *line, const char *keyword, int &target );
void LoadSettings();
void SaveSettings();

void EditCfgFile();
void DoToggles( int one = 0 );

#endif //_VFUOPT_H_

