/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

void show_CPU_info_IDT(void)
{
	GtkWidget *vbox;
	GtkWidget *ID_frame;
	GtkWidget *ID_listbox, *item;
	GtkText *InfoTextPtr;
	GtkWidget *scrolled_win;

	gchar *strValue[2];

	char TextBuffer[1024];
	char *TextPtr;
	char *cpuname;

	remove_all_pages(notebook);

/*
 ************
  Page 1: "Information"
 ************
 */

	vbox = gtk_vbox_new(FALSE, 0);

	ID_frame = gtk_frame_new("ID:");
	gtk_box_pack_start (GTK_BOX(vbox), ID_frame, FALSE, FALSE, 0);
	gtk_widget_show(ID_frame);

	ID_listbox = gtk_clist_new(2);
	gtk_clist_set_column_width (GTK_CLIST (ID_listbox), 0, 80);
	gtk_clist_set_column_width (GTK_CLIST (ID_listbox), 1, 80);
	gtk_clist_set_column_justification (GTK_CLIST (ID_listbox),	0, GTK_JUSTIFY_LEFT);
	gtk_clist_set_column_justification (GTK_CLIST (ID_listbox), 1, GTK_JUSTIFY_LEFT);
	gtk_clist_set_selection_mode (GTK_CLIST (ID_listbox), GTK_SELECTION_BROWSE);

	strValue[0] = g_strdup_printf("Vendor:");
	strValue[1] = g_strdup_printf("Centaur Hauls (IDT)");
	(void *)item = gtk_clist_append(GTK_CLIST (ID_listbox), strValue);

	strValue[0] = g_strdup_printf("Family:");
	switch (cpu0_data.family) {

		case 5:
			switch (cpu0_data.model) {
				case 4:		cpuname="C6";
							break;
				case 8:		switch (cpu0_data.stepping) {
								default:		cpuname="2";
												break;
								case 7 ... 9:	cpuname="2A";
												break;
								case 10 ... 15:	cpuname="2B";
												break;
							}
							break;

				case 9:		cpuname="3";
							break;
				case 10:	cpuname="4";
							break;
				default:	cpuname="[Unknown]";
							break;
	    	}
			strValue[1] = g_strdup_printf("Winchip %s", cpuname);
			break;

		default:
	    	strValue[1] = g_strdup_printf("Unknown IDT CPU.");
	    	break;
	}
	(void *)item = gtk_clist_append(GTK_CLIST (ID_listbox), strValue);

	strValue[0] = g_strdup_printf("Model:");
	strValue[1] = g_strdup_printf("%x", cpu0_data.model);
	(void *)item = gtk_clist_append(GTK_CLIST (ID_listbox), strValue);

	strValue[0] = g_strdup_printf("Stepping:");
	strValue[1] = g_strdup_printf("%x", cpu0_data.stepping);
	(void *)item = gtk_clist_append(GTK_CLIST (ID_listbox), strValue);

	gtk_widget_show_all (ID_listbox);
	gtk_container_add (GTK_CONTAINER (ID_frame), ID_listbox);



	gtk_widget_show (vbox);
	scrolled_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vbox), scrolled_win, TRUE, TRUE, 0);
	gtk_widget_set_usize (scrolled_win, 250, 250);
	gtk_widget_show (scrolled_win);

	AddPage (GTK_NOTEBOOK(notebook), "Information");
	gtk_container_add (GTK_CONTAINER (current_pages[current_max_page-1]), vbox);

/*
 ************
  Page 2: "Features"
 ************
 */

	TextPtr = TextBuffer;
	get_features(TextPtr);
	AddPage (GTK_NOTEBOOK(notebook), "Features");
	InfoTextPtr = CreateText(TextPtr);
	gtk_container_add (GTK_CONTAINER (current_pages[current_max_page-1]),
						GTK_WIDGET(InfoTextPtr));
}
