/*
 * dproc.c - Ultrix process access functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dproc.c,v 1.4 99/05/09 14:57:03 abe Exp $";
#endif

#include "lsof.h"


/*
 * Local static values
 */

static int Np = 0;			/* number of processes */
static KA_T Kp;				/* kernel process table */


_PROTOTYPE(static void get_kernel_access,(void));


/*
 * gather_proc_info() -- gather process information
 */

void
gather_proc_info()
{
	KA_T fp;
	int i, n, nb;
	struct proc *p, ps;
	struct pte *pte, upt[UPAGES];
	KA_T pa;
	short pss, sf;
	int px;
	struct text t;
	struct user *u, us;
	int uerr;
	caddr_t upa;

#if	ULTRIXV>=40200
	MALLOC_S bc;
	struct dmap dm;
	static int nufb = 0;
	int j, ubn;
	static struct file **ufb = (struct file **)NULL;
# if	defined(HASFSTRUCT)
#define	HASPOFILE	1
	static int npof = 0;
	static char *pof = (char *)NULL;
	long pv;
# endif	/* defined(HASFSTRUCT) */
#endif	/* ULTRIXV>=40200 */

#if     defined(HASNCACHE)
/*
 * Read the kernel name cache.
 */
	ncache_load();
#endif  /* defined(HASNCACHE) */

/*
 * Clear file lock information.
 */
	(void) clr_flinfo();
/*
 * Scan the proc table.
 */
	for (p = &ps, px = 0, u = &us; px < Np; px++) {

	/*
	 * Read the next proc structure.
	 */
	    pa = (KA_T)(Kp + (long)(px * sizeof(struct proc)));
	    if (kread(pa, (char *)&ps, sizeof(ps)))
		continue;
	    if (p->p_stat == 0 || p->p_stat == SZOMB)
		continue;
	    if (is_proc_excl(p->p_pid, (int)p->p_pgrp, (uid_t)p->p_uid,
		&pss, &sf))
		continue;
	/*
	 * Read the user area.
	 * If the process has been swapped, read its user structure
	 * via its stack segment map's page table address.
	 */

#if     ULTRIXV==20200
	    if ((p->p_flag & SLOAD) == 0) 
#endif  /* ULTRIXV==20200 */

#if     ULTRIXV>=40200
	    if ((p->p_sched & SLOAD) == 0)
#endif  /* ULTRIXV>=40200 */

	    {
		if (Nmlst && strcmp(Nmlst, N_UNIX) == 0)
		    continue;

#if     ULTRIXV==20200
		if (lseek(Swap, (long)dtob(p->p_swaddr), 0) == -1)
		    continue;
#endif  /* ULTRIXV==20200 */

#if     ULTRIXV>=40200
		if (Nmlst && strcmp(Nmlst, N_UNIX) == 0)
		    continue;
		if (kread((KA_T)p->p_smap, (char *)&dm, sizeof(dm)))
		    continue;
		if (kread((KA_T)dm.dm_ptdaddr, (char *)&ubn, sizeof(ubn)))
		    continue;
		if (lseek(Swap, (long)dtob(ubn), 0) == -1)
		    continue;
# endif /* ULTRIXV>=40200 */

		if (read(Swap, (char *)u, U_SIZE) != U_SIZE)
		    continue;
	    } else {

	    /*
	     * Read the user structure via its kernel map.
	     */
		if (kread((KA_T)p->p_addr, (char *)upt, sizeof(upt)))
		    continue;
		for (nb = U_SIZE, pte = upt, uerr = 0, upa = (caddr_t)u;
		     nb > 0;
		     nb -= n, pte++, upa += n)
		{
		    if (lseek(Mem, (long)pte->pg_pfnum * NBPG, 0) == -1) {
			uerr++;
			break;
		    }
		    n = (nb < NBPG) ? nb : NBPG;
		    if (read(Mem, upa, n) != n) {
			uerr++;
			break;
		    }
		}
		if (uerr)
		    continue;
	    }
	/*
	 * Allocate a local process structure.
	 */
	    if (is_cmd_excl(u->u_comm, &pss, &sf))
		continue;
	    alloc_lproc((int)p->p_pid, (int)p->p_pgrp, (int)p->p_ppid,
		(UID_ARG)p->p_uid, u->u_comm, (int)pss, (int)sf);
	    Plf = (struct lfile *)NULL;
	/*
	 * Save current working directory information.
	 */
	    if (u->u_cdir) {
		alloc_lfile(CWD, -1);
		FILEPTR = (struct file *)NULL;
		process_node((KA_T)u->u_cdir);
		if (Lf->sf)
		    link_lfile();
	    }
	/*
	 * Save root directory information.
	 */
	    if (u->u_rdir) {
		alloc_lfile(RTD, -1);
		FILEPTR = (struct file *)NULL;
		process_node((KA_T)u->u_rdir);
		if (Lf->sf)
		    link_lfile();
	    }
	/*
	 * Print information on the text file.
	 */
	    if (p->p_textp)  {
		if (!kread((KA_T)p->p_textp, (char *)&t, sizeof(t))
		&&  t.x_gptr) {
		    alloc_lfile("txt", -1);
		    FILEPTR = (struct file *)NULL;
		    process_node((KA_T)t.x_gptr);
		    if (Lf->sf)
			link_lfile();
		}
	    }
	/*
	 * Save information on file descriptors.
	 */

#if     ULTRIXV==20200
	    for (i = 0; i <= u->u_lastfile; i++)
#endif  /* ULTRIXV==20200 */

#if     ULTRIXV>=40200
	    for (i = j = 0; i <= u->u_lastfile; i++)
#endif  /* ULTRIXV>=40200 */

	    {

# if	ULTRIXV==20200
		fp = (KA_T)u->u_ofile[i];
# endif	/* ULTRIXV==20200 */

# if	ULTRIXV>=40200
		if (i < NOFILE_IN_U) {

#  if	defined(HASPOFILE)
		    pv = (long)u->u_pofile[i];
#  endif	/* defined(HASPOFILE) */

		    fp = (KA_T)u->u_ofile[i];
		} else {
		    if (j == 0) {
			bc = (MALLOC_S)(u->u_of_count * sizeof(struct file *));
			if (bc > nufb) {
			    if (!ufb)
				ufb = (struct file **)malloc(bc);
			    else
				ufb = (struct file **)realloc((MALLOC_P)ufb,bc);
			    if (!ufb) {
				(void) fprintf(stderr,
				    "%s: PID %d, no file * space\n",
				    Pn, p->p_pid);
				Exit(1);
			    }
			    nufb = bc;
			}
			if (kread((KA_T)u->u_ofile_of, (char *)ufb, bc))
			    break;

#  if	defined(HASPOFILE)
			if (Fsv & FSV_FG) {
			    bc = (MALLOC_S)(u->u_of_count);
			    if (bc > npof) {
				if (!pof)
				    pof = (char *)malloc(bc);
				else
				    pof = (char *)realloc((MALLOC_P *)pof, bc);
				if (!pof) {
				    (void) fprintf(stderr,
					"%s: PID %d, no pofile space\n",
					Pn, p->p_pid);
				    Exit(1);
				}
				npof = bc;
			    }
			    if (u->u_pofile_of
			    &&  kread((KA_T)u->u_pofile_of, pof, bc))
				zeromem(pof, bc);
			}
#  endif	/* defined(HASPOFILE) */

		    }

#  if	defined(HASPOFILE)
		    pv = (long)pof[j];
#  endif	/* defined(HASPOFILE) */

		    fp = (KA_T)ufb[j++];
		}
#endif	/* ULTRIXV >= 40200 */

		if (fp) {
		    alloc_lfile(NULL, i);
		    process_file(fp);
		    if (Lf->sf) {

#if	defined(HASPOFILE)
			if (Fsv & FSV_FG)
			    Lf->pof = pv;
#endif	/* defined(HASPOFILE) */

			link_lfile();
		    }
		}
	    }
	/*
	 * Examine results.
	 */
	    if (examine_lproc())
		return;
	}
}


/*
 * get_kernel_access() - get access to kernel memory
 */

static void
get_kernel_access()
{
	KA_T v;
/*
 * Check kernelt version.
 */
	(void) ckkv("ULTRIX", LSOF_VSTR, (char *)NULL, (char *)NULL);
/*
 * Get access to /dev/mem and SWAP.
 */
	if ((Mem = open("/dev/mem", O_RDONLY, 0)) < 0) {
	    (void) fprintf(stderr, "%s: can't open /dev/mem: %s\n",
		Pn, strerror(errno));
	    Exit(1);
	}
	if (Memory == NULL || strcmp(Memory, KMEM) == 0) {
	    if ((Swap = open(SWAP, O_RDONLY, 0)) < 0) {
		(void) fprintf(stderr, "%s: %s: %s\n",
		    Pn, SWAP, strerror(errno));
		Exit(1);
	    }
	}

#if	defined(WILLDROPGID)
/*
 * If kernel memory isn't coming from KMEM, drop setgid permission
 * before attempting to open the (Memory) file.
 */
	if (Memory)
	    (void) dropgid();
#else	/* !defined(WILLDROPGID) */
/*
 * See if the non-KMEM memory file is readable.
 */
	if (Memory && !is_readable(Memory, 1))
	    Exit(1);
#endif	/* defined(WILLDROPGID) */

/*
 * Open kernel memory access.
 */
	if ((Kd = open(Memory ? Memory : KMEM, O_RDONLY, 0)) < 0) {
	    (void) fprintf(stderr, "%s: can't open %s: %s\n", Pn,
		Memory ? Memory : KMEM, strerror(errno));
	    Exit(1);
	}

#if	defined(WILLDROPGID)
/*
 * Drop setgid permission, if necessary.
 */
	if (!Memory)
	    (void) dropgid();
#else	/* !defined(WILLDROPGID) */
/*
 * See if the name list file is readable.
 */
	if (Nmlst && !is_readable(Nmlst, 1))
	    Exit(1);
#endif	/* defined(WILLDROPGID) */

/*
 * Access kernel symbols.
 */
	(void) build_Nl(Drive_Nl);
        if (nlist(Nmlst ? Nmlst : N_UNIX, Nl) == -1) {
	    (void) fprintf(stderr, "%s: can't read kernel name list from %s\n",
		Pn, Nmlst ? Nmlst : N_UNIX);
	    Exit(1);
	}
	if (get_Nl_value("proc", Drive_Nl, &v) < 0 || !v
	||  kread((KA_T)v, (char *)&Kp, sizeof(Kp))
	||  get_Nl_value("nproc", Drive_Nl, &v) < 0 || !v
	||  kread((KA_T)v, (char *)&Np, sizeof(Np))) {
	    (void) fprintf(stderr, "%s: can't read proc table info\n", Pn);
	    Exit(1);
	}
}


/*
 * initialize() - perform all initialization
 */

void
initialize()
{
	get_kernel_access();
}


/*
 * kread() - read from kernel memory
 */

int
kread(addr, buf, len)
	KA_T addr;			/* kernel memory address */
	char *buf;			/* buffer to receive data */
	READLEN_T len;			/* length to read */
{
	int br;

	if (lseek(Kd, (off_t)addr, L_SET) == (off_t)-1L)
	    return(-1);
	br = read(Kd, buf, len);
	return((br == len) ? 0 : 1);
}
