#include "snd.h"
#include "vct.h"

#include "snd-plugin.h"
void call_plug(snd_plug *plug, int over_selection);

#if HAVE_GUILE

/* entire file on HAVE_GUILE switch
 * has replacements for some funcs also found in snd-clm.c 
 * snd-xgh.c has the X/Motif-specific stuff (color support, etc)
 */

/* in 1.3.2, there are hook functions, a new smob interface, and various vector handlers that we should use eventually */

/* save-state internal functions:
 *
 * several functions are intended for the use of the state saver (and aren't in snd.html).
 * since the edit history needs to remember what user-action caused a given edit, the
 *   internal calls have an added argument "origin" -- this is the same as ed->origin
 *   throughout snd-edits.c; also the data in each case is integer, not float.
 *
 *   set-int-samples (samp samps origin vector snd chn)
 *   insert-int-samples (samp samps origin vector snd chn)
 *   delete-int-samples (samp samps origin snd chn)
 *
 * The mark saver calls restore-marks -- see snd-marks.c.
 * The region saver calls restore-region -- see snd-clip.c
 */

static snd_info *get_sp(SCM scm_snd_n);
static chan_info *get_cp(SCM scm_snd_n, SCM scm_chn_n);

#define GH_MAKE_VECTOR(a,b) gh_make_vector(a,b)
#define GH_LIST_LENGTH(a) gh_length(a)
#define GH_VREF(a,b) gh_vector_ref(a,b)
#define GH_VSET(a,b,c) gh_vector_set_x(a,b,c)
#define GH_LOOKUP(a) scm_symbol_value0(a)
#define GH_INT_SET(name,val) SCM_SETCDR(name,gh_int2scm(val))
#define GH_TYPE_OF(a) (SCM_TYP16(a))
/* apparently SCM_CAR here is frowned upon, despite working */

static int bool_or_arg_p(SCM a) {return((gh_number_p(a)) || (a == SCM_BOOL_F) || (a == SCM_BOOL_T) || (a == SCM_UNDEFINED) || (a == SCM_UNSPECIFIED));}

#define ERRN1(a,b) SCM_ASSERT((gh_number_p(a)),a,SCM_ARG1,b)
#define ERRN2(a,b) SCM_ASSERT((gh_number_p(a)),a,SCM_ARG2,b)
#define ERRN3(a,b) SCM_ASSERT((gh_number_p(a)),a,SCM_ARG3,b)
#define ERRN4(a,b) SCM_ASSERT((gh_number_p(a)),a,SCM_ARG4,b)
#define ERRS1(a,b) SCM_ASSERT((gh_string_p(a)),a,SCM_ARG1,b)
#define ERRS2(a,b) SCM_ASSERT((gh_string_p(a)),a,SCM_ARG2,b)
#define ERRS3(a,b) SCM_ASSERT((gh_string_p(a)),a,SCM_ARG3,b)
#define ERRV1(a,b) SCM_ASSERT(((vct_p(a)) || (gh_vector_p(a))),a,SCM_ARG1,b)
#define ERRV2(a,b) SCM_ASSERT(((vct_p(a)) || (gh_vector_p(a))),a,SCM_ARG2,b)
#define ERRV3(a,b) SCM_ASSERT(((vct_p(a)) || (gh_vector_p(a))),a,SCM_ARG3,b)
#define ERRVECT1(a,b) SCM_ASSERT((gh_vector_p(a)),a,SCM_ARG1,b)
#define ERRVECT2(a,b) SCM_ASSERT((gh_vector_p(a)),a,SCM_ARG2,b)
#define ERRVECT4(a,b) SCM_ASSERT((gh_vector_p(a)),a,SCM_ARG4,b)
#define ERRB1(a,b) SCM_ASSERT((bool_or_arg_p(a)),a,SCM_ARG1,b)
#define ERRB2(a,b) SCM_ASSERT((bool_or_arg_p(a)),a,SCM_ARG2,b)
#define ERRB3(a,b) SCM_ASSERT((bool_or_arg_p(a)),a,SCM_ARG3,b)
#define ERRB4(a,b) SCM_ASSERT((bool_or_arg_p(a)),a,SCM_ARG4,b)

#define RTNBOOL(a) return((a) ? SCM_BOOL_T : SCM_BOOL_F)
#define RTNINT(a) return(gh_int2scm(a))
#define RTNFLT(a) return(gh_double2scm(a))
#define RTNSTR(a) return(gh_str02scm(a))

static void ERRSP(char *origin, SCM snd, int off)
{
  if (!((gh_number_p(snd)) || (snd == SCM_BOOL_F) || (snd == SCM_UNDEFINED)))
    scm_wrong_type_arg(origin,off,snd);
}

static void ERRCP(char *origin, SCM snd, SCM chn, int off)
{
  ERRSP(origin,snd,off);
  ERRSP(origin,chn,off+1);
}

#define ERRSB1(a,b) SCM_ASSERT(((gh_string_p(a)) || (a == SCM_BOOL_F) || (a == SCM_UNDEFINED)),a,SCM_ARG1,b)
#define ERRSB3(a,b) SCM_ASSERT(((gh_string_p(a)) || (a == SCM_BOOL_F) || (a == SCM_UNDEFINED)),a,SCM_ARG3,b)



static snd_state *state = NULL;
static int g_error_occurred = 0;

#define MAX_ERROR_STRING_LENGTH 512

#include <libguile/fluids.h>

char* guile_version(void) {return(gh_scm2newstr(scm_version(),NULL));}

static SCM parse_proc_handler(void *data, SCM tag, SCM throw_args)
{
  g_error_occurred = 1;
  return(SCM_BOOL_F);
}

static SCM clm_handler(void *data, SCM tag, SCM throw_args) /* error handler */
{
  snd_info *sp;
  /* it would be nice if this would display the current file + line number when loading scm code */
  /*   there's apparently a line-number function and *load-pathname* */
  SCM port,ans,stack,stmp;
  char *name_buf = NULL;
  port = scm_mkstrport(SCM_INUM0, scm_make_string(SCM_MAKINUM(MAX_ERROR_STRING_LENGTH), SCM_UNDEFINED),SCM_OPN | SCM_WRTNG,"clm-handler");
  /* scm_display_error string is ugly */
  scm_display(gh_car(throw_args), port);
  scm_puts(": ", port);
  stmp = gh_cadr(throw_args);
  if (gh_string_p(stmp)) 
    scm_display_error_message(stmp, gh_caddr(throw_args), port);
  else scm_display(tag, port);
  /* scm_display(gh_car(gh_cdddr(throw_args)), port); */
  /* scm_display_error (scm_the_last_stack_fluid, port, gh_car(throw_args), SCM_CADR(throw_args), SCM_CADDR(throw_args), SCM_EOL); */
  /* this from libguile/backtrace.c */
  stack = scm_fluid_ref(SCM_CDR(scm_the_last_stack_fluid));
  if (SCM_NFALSEP(stack)) scm_display_backtrace(stack,port,SCM_UNDEFINED,SCM_UNDEFINED);
#if HAVE_MAKE_SMOB_TYPE
  scm_force_output(port); /* needed to get rid of trailing garbage chars */
  ans = scm_strport_to_string(port);
#else
  SCM_DEFER_INTS;
  ans = scm_makfromstr (SCM_CHARS (SCM_CDR (SCM_STREAM (port))),SCM_INUM (SCM_CAR (SCM_STREAM (port))),0);
  SCM_ALLOW_INTS;
#endif
  name_buf = gh_scm2newstr(ans,NULL);
  if (state->mx_sp)
    {
      sp = state->mx_sp;
      clear_minibuffer_prompt(sp);
      report_in_minibuffer(sp,name_buf);
    }
  if (state->listening != LISTENER_CLOSED)
    {
      state->result_printout = MESSAGE_WITH_CARET;
      snd_append_command(state,name_buf);
    }
  else 
    if (!(state->mx_sp))
      snd_error(name_buf);
  g_error_occurred = 1;
  if (name_buf) FREE(name_buf);
  return(SCM_BOOL_F);
}

static SCM eval_str_wrapper(void *data)
{
  return(gh_eval_str((char *)data));
}

static SCM eval_file_wrapper(void *data)
{
  return(gh_eval_file((char *)data));
}

static int int_or_zero(SCM n)
{
  if (gh_number_p(n))
    return(gh_scm2int(n));
  return(0);
}

static int int_or_one(SCM n)
{
  if (gh_number_p(n))
    return(gh_scm2int(n));
  return(1);
}

static int bool_int_or_one(SCM n)
{
  if (gh_number_p(n))
    return(gh_scm2int(n));
  else
    if (n == SCM_BOOL_F) 
      return(0);
  return(1);
  /* i.e. SCM_UNDEFINED -> t (which is needed for opt #t args below) */
}

static char *full_filename(SCM file)
{
  char *urn,*filename;
  urn = gh_scm2newstr(file,NULL);
  filename = mus_complete_filename(urn); /* static -- don't free this */
  FREE(urn);
  return(filename);
}

static char *gh_print_1(SCM obj)
{
  SCM str,val;
  SCM port;
  str = scm_makstr (0, 0);
  port = scm_mkstrport (SCM_INUM0, str, SCM_OPN | SCM_WRTNG, "scm_strprint_obj");
  scm_prin1 (obj, port, 1);
  val = scm_strport_to_string (port);
  scm_close_port (port);
  return(gh_scm2newstr(val,NULL));
}

static char *gh_print(SCM result)
{
  char *newbuf = NULL,*str = NULL;
  int i,ilen,savelen,savectr,slen;
  /* specialize vectors which can be enormous in this context */
  if ((!(gh_vector_p(result))) || ((int)(gh_vector_length(result)) <= print_length(state)))
    return(gh_print_1(result));
  ilen=print_length(state); 
  newbuf = (char *)CALLOC(128,sizeof(char));
  savelen = 128;
  savectr = 3;
  sprintf(newbuf,"#("); 
  for (i=0;i<ilen;i++)
    {
      str = gh_print_1(GH_VREF(result,gh_int2scm(i)));
      if ((str) && (*str)) 
	{
	  slen = strlen(str);
	  if ((slen+savectr+1) >= savelen)
	    {
	      savelen += 128;
	      newbuf = (char *)REALLOC(newbuf,savelen * sizeof(char));
	    }
	  if (i != 0) {strcat(newbuf," "); savectr++;}
	  strcat(newbuf,str);
	  savectr+=slen;
	}
      if (str) FREE(str);
    }
  if (savectr+8 > savelen) newbuf = (char *)REALLOC(newbuf,(savectr+8) * sizeof(char));
  strcat(newbuf," ...)");
  return(newbuf);
}

#ifdef __cplusplus
/* what's the "right" way to handle this? */
static SCM gh_new_procedure0_3 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,0,3,0));} /* not provided by gh_funcs.c */
static SCM gh_new_procedure0_4 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,0,4,0));}
static SCM gh_new_procedure1_3 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,1,3,0));}
static SCM gh_new_procedure1_4 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,1,4,0));}
static SCM gh_new_procedure1_5 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,1,5,0));}
static SCM gh_new_procedure1_7 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,1,7,0));}
static SCM gh_new_procedure0_5 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,0,5,0));}
static SCM gh_new_procedure3_1 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,3,1,0));}
static SCM gh_new_procedure3_2 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,3,2,0));}
static SCM gh_new_procedure4_2 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,4,2,0));}
static SCM gh_new_procedure9_0 (char *proc_name,SCM (*fn)(...)) {return(gh_new_procedure(proc_name,fn,9,0,0));}
#else
static SCM gh_new_procedure0_3 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,0,3,0));} /* not provided by gh_funcs.c */
static SCM gh_new_procedure0_4 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,0,4,0));}
static SCM gh_new_procedure1_3 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,1,3,0));}
static SCM gh_new_procedure1_4 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,1,4,0));}
static SCM gh_new_procedure1_5 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,1,5,0));}
static SCM gh_new_procedure1_7 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,1,7,0));}
static SCM gh_new_procedure0_5 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,0,5,0));}
static SCM gh_new_procedure3_1 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,3,1,0));}
static SCM gh_new_procedure3_2 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,3,2,0));}
static SCM gh_new_procedure4_2 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,4,2,0));}
static SCM gh_new_procedure9_0 (char *proc_name,SCM (*fn)()) {return(gh_new_procedure(proc_name,fn,9,0,0));}
#endif

SCM parse_proc(char *buf)
{
  SCM result;
  result = scm_internal_stack_catch(SCM_BOOL_T,eval_str_wrapper,buf,parse_proc_handler,buf);
  if (g_error_occurred)
    {
      g_error_occurred = 0;
      return(SCM_BOOL_F);
    }
  return(result);
}

static SCM g_sp_scan(SCM proc, int chan_choice, SCM s_beg, SCM s_end, int series, int scan, SCM org, SCM snd, SCM chn)
{
  snd_state *ss;
  chan_info *cp;
  snd_info *sp;
  int beg,end;
  SCM result;
  char *origin,*ed_origin = NULL;
  if (scan)
    {
      switch (chan_choice)
	{
	case SCAN_CURRENT_CHAN: origin = S_scan_chan; break;
	case SCAN_SOUND_CHANS: if (series) origin = S_scan_sound_chans; else origin = S_scan_across_sound_chans; break;
	case SCAN_ALL_CHANS: if (series) origin = S_scan_all_chans; else origin = S_scan_across_all_chans; break;
	case SCAN_SYNCD_CHANS: if (series) origin = S_scan_chans; else origin = S_scan_across_chans; break;
	}
    }
  else
    {
      switch (chan_choice)
	{
	case SCAN_CURRENT_CHAN: origin = S_map_chan; break;
	case SCAN_SOUND_CHANS: if (series) origin = S_map_sound_chans; else origin = S_map_across_sound_chans; break;
	case SCAN_ALL_CHANS: if (series) origin = S_map_all_chans; else origin = S_map_across_all_chans; break;
	case SCAN_SYNCD_CHANS: if (series) origin = S_map_chans; else origin = S_map_across_chans; break;
	}
      if (gh_string_p(org)) ed_origin = gh_scm2newstr(org,NULL); else ed_origin = copy_string(origin);
    }
  SCM_ASSERT((gh_procedure_p(proc)),proc,SCM_ARG1,origin);
  SCM_ASSERT((bool_or_arg_p(s_beg)),s_beg,SCM_ARG2,origin);
  SCM_ASSERT((bool_or_arg_p(s_end)),s_end,SCM_ARG3,origin);
  ss = get_global_state();
  sp = get_sp(snd);
  if (sp == NULL) return(SCM_BOOL_T);
  cp = get_cp(snd,chn);
  if (cp == NULL) return(SCM_BOOL_T);
  beg = int_or_zero(s_beg);
  end = int_or_zero(s_end);
  if (scan)
    {
      if (series)
	return(series_scan(ss,cp,proc,chan_choice,beg,end));
      else return(parallel_scan(ss,cp,proc,chan_choice,beg,end));
    }
  else
    {
      if (series)
	result = series_map(ss,cp,proc,chan_choice,beg,end,ed_origin);
      else result = parallel_map(ss,cp,proc,chan_choice,beg,end,ed_origin);
      if (ed_origin) FREE(ed_origin);
      return(result);
    }
}

static SCM g_scan_chan(SCM proc, SCM beg, SCM end, SCM snd, SCM chn) 
{
  ERRCP(S_scan_chan,snd,chn,4); 
  return(g_sp_scan(proc,SCAN_CURRENT_CHAN,beg,end,TRUE,TRUE,SCM_BOOL_F,snd,chn));
}

static SCM g_scan_chans(SCM proc, SCM beg, SCM end) 
{
  return(g_sp_scan(proc,SCAN_SYNCD_CHANS,beg,end,TRUE,TRUE,SCM_BOOL_F,SCM_BOOL_F,SCM_BOOL_F));
}

static SCM g_scan_all_chans(SCM proc, SCM beg, SCM end) 
{
  return(g_sp_scan(proc,SCAN_ALL_CHANS,beg,end,TRUE,TRUE,SCM_BOOL_F,SCM_BOOL_F,SCM_BOOL_F));
}

static SCM g_scan_sound_chans(SCM proc, SCM beg, SCM end, SCM snd) 
{
  ERRSP(S_scan_sound_chans,snd,4); 
  return(g_sp_scan(proc,SCAN_SOUND_CHANS,beg,end,TRUE,TRUE,SCM_BOOL_F,snd,SCM_BOOL_F));
}

static SCM g_scan_across_chans(SCM proc, SCM beg, SCM end) 
{
  return(g_sp_scan(proc,SCAN_SYNCD_CHANS,beg,end,FALSE,TRUE,SCM_BOOL_F,SCM_BOOL_F,SCM_BOOL_F));
}

static SCM g_scan_across_all_chans(SCM proc, SCM beg, SCM end) 
{
  return(g_sp_scan(proc,SCAN_ALL_CHANS,beg,end,FALSE,TRUE,SCM_BOOL_F,SCM_BOOL_F,SCM_BOOL_F));
}

static SCM g_scan_across_sound_chans(SCM proc, SCM beg, SCM end, SCM snd) 
{
  ERRSP(S_scan_across_sound_chans,snd,4); 
  return(g_sp_scan(proc,SCAN_SOUND_CHANS,beg,end,FALSE,TRUE,SCM_BOOL_F,snd,SCM_BOOL_F));
}

static SCM g_map_chan(SCM proc, SCM beg, SCM end, SCM org, SCM snd, SCM chn) 
{
  ERRCP(S_map_chan,snd,chn,5); 
  return(g_sp_scan(proc,SCAN_CURRENT_CHAN,beg,end,TRUE,FALSE,org,snd,chn));
}

static SCM g_map_chans(SCM proc, SCM beg, SCM end, SCM org) 
{
  return(g_sp_scan(proc,SCAN_SYNCD_CHANS,beg,end,TRUE,FALSE,org,SCM_BOOL_F,SCM_BOOL_F));
}

static SCM g_map_all_chans(SCM proc, SCM beg, SCM end, SCM org) 
{
  return(g_sp_scan(proc,SCAN_ALL_CHANS,beg,end,TRUE,FALSE,org,SCM_BOOL_F,SCM_BOOL_F));
}

static SCM g_map_sound_chans(SCM proc, SCM beg, SCM end, SCM org,SCM snd) 
{
  ERRSP(S_map_sound_chans,snd,5); 
  return(g_sp_scan(proc,SCAN_SOUND_CHANS,beg,end,TRUE,FALSE,org,snd,SCM_BOOL_F));
}

static SCM g_map_across_chans(SCM proc, SCM beg, SCM end, SCM org) 
{
  return(g_sp_scan(proc,SCAN_SYNCD_CHANS,beg,end,FALSE,FALSE,org,SCM_BOOL_F,SCM_BOOL_F));
}

static SCM g_map_across_all_chans(SCM proc, SCM beg, SCM end, SCM org) 
{
  return(g_sp_scan(proc,SCAN_ALL_CHANS,beg,end,FALSE,FALSE,org,SCM_BOOL_F,SCM_BOOL_F));
}

static SCM g_map_across_sound_chans(SCM proc, SCM beg, SCM end, SCM org, SCM snd) 
{
  ERRSP(S_map_across_sound_chans,snd,5); 
  return(g_sp_scan(proc,SCAN_SOUND_CHANS,beg,end,FALSE,FALSE,org,snd,SCM_BOOL_F));
}

int clm_doit(snd_state *ss, char *buf, int from_clm)
{
  /* scm_set_current_output_port? */
  snd_info *sp = NULL;
  SCM result;
  int len;
  char *str = NULL;
  result = scm_internal_stack_catch(SCM_BOOL_T,eval_str_wrapper,buf,clm_handler,buf);
  if (g_error_occurred)
    {
      g_error_occurred = 0;
      /* "result" is not interesting in this case, and can erase our error message if just using minibuffer */
      return(-1);  /* -1 is the try-C-parser signal in snd-chn.c */
    }
  str = gh_print(result);
  if (from_clm)
    { /* fix up #t and #f, lists, and various #<> junk for common lisp */
      if (result == SCM_BOOL_T)
	write(ss->to_clm,"T",2);
      else
	{
	  if (result == SCM_BOOL_F)
	    write(ss->to_clm,"NIL",4);
	  else
	    {
	      len = snd_strlen(str);
	      if (gh_list_p(result))
		{
		  write(ss->to_clm,"'",1);
		  write(ss->to_clm,str,len+1);
		}
	      else
		{
		  if ((len > 1) && (str[0] == '#') && (str[1] == '<'))
		    write(ss->to_clm,"NIL",4);
		  else write(ss->to_clm,str,len+1);
		}
	    }
	}
    }
  else
    {
      if (ss->mx_sp)
	{
	  sp = ss->mx_sp;
	  clear_minibuffer_prompt(sp);
	  report_in_minibuffer(sp,str);
	}
      if (ss->listening != LISTENER_CLOSED)
	{
	  snd_append_command(ss,buf);
	  ss->result_printout = MESSAGE_WITH_CARET;
	  snd_append_command(ss,str);
	}
      check_snd_eval_error(ss);
    }
  if (str) FREE(str);
  return(0);
}

int clm_just_doit(snd_state *ss, char *buf)
{
  SCM result;
  char *str;
  result = scm_internal_stack_catch(SCM_BOOL_T,eval_str_wrapper,buf,clm_handler,buf);
  if (g_error_occurred)
    {
      g_error_occurred = 0;
      return(0);
    }
  str = gh_print(result);
  ss->result_printout = MESSAGE_WITH_CARET;
  snd_append_command(ss,str);
  check_snd_eval_error(ss);
  if (str) FREE(str);
  return(0);
}

void snd_load_init_file(snd_state *ss, int nog, int noi)
{
  /* look for ".snd" on the home directory, and load it using the lisp-like CLM syntax given above */
  /* called only in snd-xmain.c at initialization time */
  int fd;
  char *str = NULL;
#ifdef SND_CONF
  if (nog == 0)
    {
      fd = open(SND_CONF,O_RDONLY,0);
      if (fd != -1)
	{
	  close(fd);
	  scm_internal_stack_catch(SCM_BOOL_T,eval_file_wrapper,SND_CONF,clm_handler,NULL);
	}
    }
#endif
  if ((ss->init_file) && (noi == 0))
    {
      str = mus_complete_filename(ss->init_file);
      fd = open(str,O_RDONLY,0);
      if (fd != -1) 
	{
	  close(fd);
	  scm_internal_stack_catch(SCM_BOOL_T,eval_file_wrapper,str,clm_handler,NULL);
	}
    }
}

int snd_load_file(snd_state *ss,char *filename)
{
  int fd;
  char *str = NULL;
  str = mus_complete_filename(filename);
  fd = open(str,O_RDONLY,0);
  if (fd != -1) 
    {
      close(fd);
      scm_internal_stack_catch(SCM_BOOL_T,eval_file_wrapper,str,clm_handler,NULL);
      return(0);
    }
  return(-1);
}

static SCM g_snd_print(SCM msg)
{
  ERRS1(msg,S_snd_print);
  state->result_printout = MESSAGE_WITHOUT_CARET;
  snd_append_command(state,gh_scm2newstr(msg,0));
  return(msg);
}

static SCM g_ask_before_overwrite(void) {RTNBOOL(ask_before_overwrite(state));}
static SCM g_set_ask_before_overwrite(SCM val) {int n; ERRB1(val,S_set_ask_before_overwrite); set_ask_before_overwrite(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_audio_output_device(void) {RTNINT(audio_output_device(state));}
static SCM g_set_audio_output_device(SCM val) {ERRN1(val,S_set_audio_output_device); set_audio_output_device(state,gh_scm2int(val)); return(val);}
static SCM g_dac_size(void) {RTNINT(dac_size(state));}
static SCM g_set_dac_size(SCM val) {ERRN1(val,S_set_dac_size); set_dac_size(state,gh_scm2int(val)); return(val);}
static SCM g_auto_resize(void) {RTNBOOL(auto_resize(state));}
static SCM g_set_auto_resize(SCM val) {int n; ERRB1(val,S_set_auto_resize); set_auto_resize(state,n = bool_int_or_one(val)); reflect_resize(state); RTNBOOL(n);}
static SCM g_auto_update(void) {RTNBOOL(auto_update(state));}
static SCM g_set_auto_update(SCM val) {int n; ERRB1(val,S_set_auto_update); set_auto_update(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_channel_style(void) {RTNINT(channel_style(state));}
static SCM g_set_channel_style(SCM style) {ERRN1(style,S_set_channel_style); set_channel_style(state,gh_scm2int(style)); return(style);}
static SCM g_color_cutoff(void) {RTNFLT(color_cutoff(state));}
static SCM g_set_color_cutoff(SCM val) {ERRN1(val,S_set_color_cutoff); set_color_cutoff(state,gh_scm2double(val)); return(val);}
static SCM g_color_inverted(void) {RTNBOOL(color_inverted(state));}
static SCM g_set_color_inverted(SCM val) {int n; ERRB1(val,S_set_color_inverted); set_color_inverted(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_color_scale(void) {RTNFLT(color_scale(state));}
static SCM g_set_color_scale(SCM val) {ERRN1(val,S_set_color_scale); set_color_scale(state,gh_scm2double(val)); return(val);}
static SCM g_corruption_time(void) {RTNFLT(corruption_time(state));}
static SCM g_set_corruption_time(SCM val) {ERRN1(val,S_set_corruption_time); set_corruption_time(state,gh_scm2double(val)); return(val);}
static SCM g_default_amp(void) {RTNFLT(default_amp(state));}
static SCM g_set_default_amp(SCM val) {ERRN1(val,S_set_default_amp); set_default_amp(state,gh_scm2double(val)); return(val);}
static SCM g_default_contrast(void) {RTNFLT(default_contrast(state));}
static SCM g_set_default_contrast(SCM val) {ERRN1(val,S_set_default_contrast); set_default_contrast(state,gh_scm2double(val)); return(val);}
static SCM g_default_contrast_amp(void) {RTNFLT(default_contrast_amp(state));}
static SCM g_set_default_contrast_amp(SCM val) {ERRN1(val,S_set_default_contrast_amp); set_default_contrast_amp(state,gh_scm2double(val)); return(val);}
static SCM g_default_contrasting(void) {RTNBOOL(default_contrasting(state));}
static SCM g_set_default_contrasting(SCM val) {int n; ERRB1(val,S_set_default_contrasting); set_default_contrasting(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_default_expand(void) {RTNFLT(default_expand(state));}
static SCM g_set_default_expand(SCM val) {ERRN1(val,S_set_default_expand); set_default_expand(state,gh_scm2double(val)); return(val);}
static SCM g_default_expand_hop(void) {RTNFLT(default_expand_hop(state));}
static SCM g_set_default_expand_hop(SCM val) {ERRN1(val,S_set_expand_hop); set_default_expand_hop(state,gh_scm2double(val)); return(val);}
static SCM g_default_expand_length(void) {RTNFLT(default_expand_length(state));}
static SCM g_set_default_expand_length(SCM val) {ERRN1(val,S_set_expand_length); set_default_expand_length(state,gh_scm2double(val)); return(val);}
static SCM g_default_expand_ramp(void) {RTNFLT(default_expand_ramp(state));}
static SCM g_set_default_expand_ramp(SCM val) {ERRN1(val,S_set_expand_ramp); set_default_expand_ramp(state,gh_scm2double(val)); return(val);}
static SCM g_default_expanding(void) {RTNBOOL(default_expanding(state));}
static SCM g_set_default_expanding(SCM val) {int n; ERRB1(val,S_set_default_expanding); set_default_expanding(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_default_filter_dBing(void) {RTNBOOL(default_filter_dBing(state));}
static SCM g_set_default_filter_dBing(SCM val) {ERRN1(val,S_set_default_filter_dBing); set_default_filter_dBing(state,gh_scm2int(val)); return(val);}
static SCM g_default_filter_order(void) {RTNINT(default_filter_order(state));}
static SCM g_set_default_filter_order(SCM val) {ERRN1(val,S_set_default_filter_order); set_default_filter_order(state,gh_scm2int(val)); return(val);}
static SCM g_default_filtering(void) {RTNBOOL(default_filtering(state));}
static SCM g_set_default_filtering(SCM val) {int n; ERRB1(val,S_set_default_filtering); set_default_filtering(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_default_output_type(void) {RTNINT(default_output_type(state));}
static SCM g_set_default_output_type(SCM val) {ERRN1(val,S_set_default_output_type); set_default_output_type(state,gh_scm2int(val)); return(val);}
static SCM g_default_reverb_feedback(void) {RTNFLT(default_reverb_feedback(state));}
static SCM g_set_default_reverb_feedback(SCM val) {ERRN1(val,S_set_default_reverb_feedback); set_default_reverb_feedback(state,gh_scm2double(val)); return(val);}
static SCM g_default_reverb_length(void) {RTNFLT(default_reverb_length(state));}
static SCM g_set_default_reverb_length(SCM val) {ERRN1(val,S_set_default_reverb_length); set_default_reverb_length(state,gh_scm2double(val)); return(val);}
static SCM g_default_reverb_lowpass(void) {RTNFLT(default_reverb_lowpass(state));}
static SCM g_set_default_reverb_lowpass(SCM val) {ERRN1(val,S_set_default_reverb_lowpass); set_default_reverb_lowpass(state,gh_scm2double(val)); return(val);}
static SCM g_default_reverb_scale(void) {RTNFLT(default_reverb_scale(state));}
static SCM g_set_default_reverb_scale(SCM val) {ERRN1(val,S_set_default_reverb_scale); set_default_reverb_scale(state,gh_scm2double(val)); return(val);}
static SCM g_default_reverbing(void) {RTNBOOL(default_reverbing(state));}
static SCM g_set_default_reverbing(SCM val) {int n; ERRB1(val,S_set_default_reverbing); set_default_reverbing(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_default_speed(void) {RTNFLT(default_speed(state));}
static SCM g_set_default_speed(SCM val) {ERRN1(val,S_set_default_speed); set_default_speed(state,gh_scm2double(val)); return(val);}
static SCM g_dot_size(void) {RTNINT(dot_size(state));}
static SCM g_set_dot_size(SCM size) {ERRN1(size,S_set_dot_size); set_dot_size(state,gh_scm2int(size)); return(size);}
static SCM g_enved_base(void) {RTNFLT(enved_base(state));}
static SCM g_set_enved_base(SCM val) {ERRN1(val,S_set_enved_base); set_enved_base(state,gh_scm2double(val)); return(val);}
static SCM g_enved_power(void) {RTNFLT(enved_power(state));}
static SCM g_set_enved_power(SCM val) {ERRN1(val,S_set_enved_power); set_enved_power(state,gh_scm2double(val)); return(val);}
static SCM g_enved_clipping(void) {RTNBOOL(enved_clipping(state));}
static SCM g_set_enved_clipping(SCM on) {int n; ERRB1(on,S_set_enved_clipping); set_enved_clipping(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_enved_exping(void) {RTNBOOL(enved_exping(state));}
static SCM g_set_enved_exping(SCM val) {int n; ERRB1(val,S_set_enved_exping); set_enved_exping(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_enved_target(void) {RTNINT(enved_target(state));}
static SCM g_set_enved_target(SCM val) {int n; ERRB1(val,S_set_enved_target); set_enved_target(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_enved_waving(void) {RTNBOOL(enved_waving(state));}
static SCM g_set_enved_waving(SCM val) {int n; ERRB1(val,S_set_enved_waving); set_enved_waving(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_enved_dBing(void) {RTNBOOL(enved_dBing(state));}
static SCM g_set_enved_dBing(SCM val) {int n; ERRB1(val,S_set_enved_dBing); set_enved_dBing(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_eps_file(void) {RTNSTR(eps_file(state));}
static SCM g_set_eps_file(SCM val) {ERRS1(val,S_set_eps_file); set_eps_file(state,gh_scm2newstr(val,0)); return(val);}
static SCM g_listener_prompt(void) {RTNSTR(listener_prompt(state));}
static SCM g_set_listener_prompt(SCM val) {ERRS1(val,S_set_listener_prompt); set_listener_prompt(state,gh_scm2newstr(val,0)); return(val);}
static SCM g_mixer_save_state_file(void) {RTNSTR(mixer_save_state_file(state));}
static SCM g_set_mixer_save_state_file(SCM val) {ERRS1(val,S_set_mixer_save_state_file); set_mixer_save_state_file(state,gh_scm2newstr(val,0)); return(val);}
static SCM g_fft_beta(void) {RTNFLT(fft_beta(state));}
static SCM g_set_fft_beta(SCM val) {ERRN1(val,S_set_fft_beta); set_fft_beta(state,gh_scm2double(val)); return(val);}
static SCM g_fft_log_frequency(void) {RTNBOOL(fft_log_frequency(state));}
static SCM g_set_fft_log_frequency(SCM on) {int n; ERRB1(on,S_set_fft_log_frequency); set_fft_log_frequency(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_fft_log_magnitude(void) {RTNBOOL(fft_log_magnitude(state));}
static SCM g_set_fft_log_magnitude(SCM on) {int n; ERRB1(on,S_set_fft_log_magnitude); set_fft_log_magnitude(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_fft_size(void) {RTNINT(fft_size(state));}
static SCM g_set_fft_size(SCM val) {ERRN1(val,S_set_fft_size); set_fft_size(state,gh_scm2int(val)); return(val);}
static SCM g_fft_style(void) {RTNINT(fft_style(state));}
static SCM g_set_fft_style(SCM val) {ERRN1(val,S_set_fft_style); set_fft_style(state,gh_scm2int(val)); return(val);}
static SCM g_fft_window(void) {RTNINT(fft_window(state));}
static SCM g_set_fft_window(SCM val) {ERRN1(val,S_set_fft_window); set_fft_window(state,gh_scm2int(val)); return(val);}
static SCM g_filter_env_order(void) {RTNINT(filter_env_order(state));}
static SCM g_set_filter_env_order(SCM val) {ERRN1(val,S_set_filter_env); set_filter_env_order(state,gh_scm2int(val)); return(val);}
static SCM g_fit_data_on_open(void) {RTNBOOL(fit_data_on_open(state));}
static SCM g_set_fit_data_on_open(SCM val) {int n; ERRB1(val,S_set_fit_data_on_open); set_fit_data_on_open(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_graph_style(void) {RTNINT(graph_style(state));}
static SCM g_set_graph_style(SCM style) {ERRN1(style,S_set_graph_style); set_graph_style(state,gh_scm2int(style)); return(style);}
static SCM g_initial_x0(void) {RTNFLT(initial_x0(state));}
static SCM g_set_initial_x0(SCM val) {ERRN1(val,S_set_initial_x0); set_initial_x0(state,gh_scm2double(val)); return(val);}
static SCM g_initial_x1(void) {RTNFLT(initial_x1(state));}
static SCM g_set_initial_x1(SCM val) {ERRN1(val,S_set_initial_x1); set_initial_x1(state,gh_scm2double(val)); return(val);}
static SCM g_initial_y0(void) {RTNFLT(initial_y0(state));}
static SCM g_set_initial_y0(SCM val) {ERRN1(val,S_set_initial_y0); set_initial_y0(state,gh_scm2double(val)); return(val);}
static SCM g_initial_y1(void) {RTNFLT(initial_y1(state));}
static SCM g_set_initial_y1(SCM val) {ERRN1(val,S_set_initial_y1); set_initial_y1(state,gh_scm2double(val)); return(val);}
static SCM g_line_size(void) {RTNINT(line_size(state));}
static SCM g_set_line_size(SCM val) {ERRN1(val,S_set_line_size); set_line_size(state,gh_scm2int(val)); return(val);}
static SCM g_mix_amp_scaler(void) {RTNFLT(get_mix_amp_scaler());}
static SCM g_set_mix_amp_scaler(SCM val) {ERRN1(val,S_set_mix_amp_scaler); set_mix_amp_scaler(gh_scm2double(val)); return(val);}
static SCM g_mix_speed_scaler(void) {RTNFLT(get_mix_speed_scaler());}
static SCM g_set_mix_speed_scaler(SCM val) {ERRN1(val,S_set_mix_speed_scaler); set_mix_speed_scaler(gh_scm2double(val)); return(val);}
static SCM g_mix_tempo_scaler(void) {RTNFLT(get_mix_tempo_scaler());}
static SCM g_set_mix_tempo_scaler(SCM val) {ERRN1(val,S_set_mix_tempo_scaler); set_mix_tempo_scaler(gh_scm2double(val)); return(val);}
static SCM g_mix_waveform_height(void) {RTNINT(mix_waveform_height(state));}
static SCM g_set_mix_waveform_height(SCM val) {ERRN1(val,S_set_mix_waveform_height); set_mix_waveform_height(state,gh_scm2int(val)); return(val);}
static SCM g_mixer_group_max_out_chans(void) {RTNINT(mixer_group_max_out_chans(state));}
static SCM g_set_mixer_group_max_out_chans(SCM val) {ERRN1(val,S_set_mixer_group_max_out_chans); set_mixer_group_max_out_chans(state,gh_scm2int(val)); return(val);}
static SCM g_mixer_groups(void) {RTNINT(mixer_groups(state));}
static SCM g_set_mixer_groups(SCM val) {ERRN1(val,S_set_mixer_groups); set_mixer_groups(state,gh_scm2int(val)); return(val);}
static SCM g_movies(void) {RTNBOOL(movies(state));}
static SCM g_set_movies(SCM val) {int n; ERRB1(val,S_set_movies); set_movies(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_normalize_fft(void) {RTNBOOL(normalize_fft(state));}
static SCM g_set_normalize_fft(SCM val) {int n; ERRB1(val,S_set_normalize_fft); set_normalize_fft(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_normalize_on_open(void) {RTNBOOL(normalize_on_open(state));}
static SCM g_set_normalize_on_open(SCM val) {int n; ERRB1(val,S_set_normalize_on_open); set_normalize_on_open(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_prefix_arg(void) {RTNINT(prefix_arg(state));}
static SCM g_set_prefix_arg(SCM val) {ERRN1(val,S_set_prefix_arg); set_prefix_arg(state,gh_scm2int(val)); return(val);}
static SCM g_print_length(void) {RTNINT(print_length(state));}
static SCM g_set_print_length(SCM val) {ERRN1(val,S_set_print_length); set_print_length(state,gh_scm2int(val)); set_vct_print_length(gh_scm2int(val)); return(val);}
static SCM g_previous_files_sort(void) {RTNINT(previous_files_sort(state));}
static SCM g_set_previous_files_sort(SCM val) {ERRN1(val,S_set_previous_files_sort); set_previous_files_sort(state,gh_scm2int(val)); update_prevfiles(state); return(val);}
static SCM g_raw_chans(void) {RTNINT(raw_chans(state));}
static SCM g_set_raw_chans(SCM val) {ERRN1(val,S_set_raw_chans); set_raw_chans(state,gh_scm2int(val)); return(val);}
static SCM g_raw_format(void) {RTNINT(raw_format(state));}
static SCM g_set_raw_format(SCM val) {ERRN1(val,S_set_raw_format); set_raw_format(state,gh_scm2int(val)); return(val);}
static SCM g_raw_srate(void) {RTNINT(raw_srate(state));}
static SCM g_set_raw_srate(SCM val) {ERRN1(val,S_set_raw_srate); set_raw_srate(state,gh_scm2int(val)); return(val);}
static SCM g_raw_type(void) {RTNINT(raw_type(state));}
static SCM g_set_raw_type(SCM val) {ERRN1(val,S_set_raw_type); set_raw_type(state,gh_scm2int(val)); return(val);}
static SCM g_recorder_autoload(void) {RTNBOOL(recorder_autoload(state));}
static SCM g_set_recorder_autoload(SCM val) {int n; ERRB1(val,S_set_recorder_autoload); set_autoload(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_recorder_buffer_size(void) {RTNINT(recorder_buffer_size(state));}
static SCM g_set_recorder_buffer_size(SCM val) {ERRN1(val,S_set_recorder_buffer_size); in_set_recorder_buffer_size(state,gh_scm2int(val)); return(val);}
static SCM g_recorder_file(void) {RTNSTR(recorder_file(state));}
static SCM g_set_recorder_file(SCM val) {ERRS1(val,S_set_recorder_file); in_set_recorder_file(state,gh_scm2newstr(val,0)); return(val);}
static SCM g_recorder_in_format(void) {RTNINT(recorder_in_format(state));}
static SCM g_set_recorder_in_format(SCM val) {ERRN1(val,S_set_recorder_in_format); in_set_recorder_in_format(state,gh_scm2int(val)); return(val);}
static SCM g_recorder_out_chans(void) {RTNINT(recorder_out_chans(state));}
static SCM g_set_recorder_out_chans(SCM val) {ERRN1(val,S_set_recorder_out_chans); in_set_recorder_out_chans(state,gh_scm2int(val)); return(val);}
static SCM g_recorder_out_format(void) {RTNINT(recorder_out_format(state));}
static SCM g_set_recorder_out_format(SCM val) {ERRN1(val,S_set_recorder_out_format); in_set_recorder_out_format(state,gh_scm2int(val)); return(val);}
static SCM g_recorder_srate(void) {RTNINT(recorder_srate(state));}
static SCM g_set_recorder_srate(SCM val) {ERRN1(val,S_set_recorder_srate); set_recorder_srate(state,gh_scm2int(val)); return(val);}
static SCM g_recorder_trigger(void) {RTNFLT(recorder_trigger(state));}
static SCM g_set_recorder_trigger(SCM val) {ERRN1(val,S_set_recorder_trigger); set_recorder_trigger(state,gh_scm2double(val)); return(val);}
static SCM g_recorder_max_duration(void) {RTNFLT(recorder_max_duration(state));}
static SCM g_set_recorder_max_duration(SCM val) {ERRN1(val,S_set_recorder_max_duration); set_recorder_max_duration(state,gh_scm2double(val)); return(val);}
static SCM g_reverb_decay(void) {RTNFLT(reverb_decay(state));}
static SCM g_set_reverb_decay(SCM val) {ERRN1(val,S_set_reverb_decay); set_reverb_decay(state,gh_scm2double(val)); return(val);}
static SCM g_save_state_on_exit(void) {RTNBOOL(save_state_on_exit(state));}
static SCM g_set_save_state_on_exit(SCM val) {int n; ERRB1(val,S_set_save_state_on_exit); set_save_state_on_exit(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_save_state_file(void) {RTNSTR(save_state_file(state));}
static SCM g_set_save_state_file(SCM val) {ERRS1(val,S_set_save_state_file); set_save_state_file(state,gh_scm2newstr(val,0)); return(val);}
static SCM g_show_fft_peaks(void) {RTNBOOL(show_fft_peaks(state));}
static SCM g_set_show_fft_peaks(SCM val) {int n; ERRB1(val,S_set_show_fft_peaks); set_show_fft_peaks(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_show_marks(void) {RTNBOOL(show_marks(state));}
static SCM g_set_show_marks(SCM on) {int n; ERRB1(on,S_set_show_marks); set_show_marks(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_show_usage_stats(void) {RTNBOOL(show_usage_stats(state));}
static SCM g_set_show_usage_stats(SCM on) {int n; ERRB1(on,S_set_show_usage_stats); set_show_usage_stats(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_update_usage_stats(void) {update_stats(state); return(SCM_BOOL_T);}
static SCM g_show_mix_consoles(void) {RTNBOOL(show_mix_consoles(state));}
static SCM g_set_show_mix_consoles(SCM on) {int n; ERRB1(on,S_set_show_mix_consoles); set_show_mix_consoles(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_show_mix_waveforms(void) {RTNBOOL(show_mix_waveforms(state));}
static SCM g_set_show_mix_waveforms(SCM on) {int n; ERRB1(on,S_set_show_mix_waveforms); set_show_mix_waveforms(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_show_y_zero(void) {RTNBOOL(show_y_zero(state));}
static SCM g_set_show_y_zero(SCM on) {int n; ERRB1(on,S_set_show_y_zero); set_show_y_zero(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_show_axes(void) {RTNBOOL(show_axes(state));}
static SCM g_set_show_axes(SCM on) {int n; ERRB1(on,S_set_show_axes); set_show_axes(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_sinc_width(void) {RTNINT(sinc_width(state));}
static SCM g_set_sinc_width(SCM val) {ERRN1(val,S_set_sinc_width); set_sinc_width(state,gh_scm2int(val)); return(val);}
static SCM g_color_map(void) {RTNINT(color_map(state));}
static SCM g_set_color_map(SCM val) {ERRN1(val,S_set_colormap); set_color_map(state,gh_scm2int(val)); return(val);}
static SCM g_spectro_cutoff(void) {RTNFLT(spectro_cutoff(state));}
static SCM g_set_spectro_cutoff(SCM val) {ERRN1(val,S_set_spectro_cutoff); set_spectro_cutoff(state,gh_scm2double(val)); return(val);}
static SCM g_spectro_hop(void) {RTNINT(spectro_hop(state));}
static SCM g_set_spectro_hop(SCM val) {ERRN1(val,S_set_spectro_hop); set_spectro_hop(state,gh_scm2int(val)); return(val);}
static SCM g_spectro_x_angle(void) {RTNFLT(spectro_x_angle(state));}
static SCM g_set_spectro_x_angle(SCM val) {ERRN1(val,S_set_spectro_x_angle); set_spectro_x_angle(state,gh_scm2double(val)); return(val);}
static SCM g_spectro_x_scale(void) {RTNFLT(spectro_x_scale(state));}
static SCM g_set_spectro_x_scale(SCM val) {ERRN1(val,S_set_spectro_x_scale); set_spectro_x_scale(state,gh_scm2double(val)); return(val);}
static SCM g_spectro_y_angle(void) {RTNFLT(spectro_y_angle(state));}
static SCM g_set_spectro_y_angle(SCM val) {ERRN1(val,S_set_spectro_y_angle); set_spectro_y_angle(state,gh_scm2double(val)); return(val);}
static SCM g_spectro_y_scale(void) {RTNFLT(spectro_y_scale(state));}
static SCM g_set_spectro_y_scale(SCM val) {ERRN1(val,S_set_spectro_y_scale); set_spectro_y_scale(state,gh_scm2double(val)); return(val);}
static SCM g_spectro_z_angle(void) {RTNFLT(spectro_z_angle(state));}
static SCM g_set_spectro_z_angle(SCM val) {ERRN1(val,S_set_spectro_z_angle); set_spectro_z_angle(state,gh_scm2double(val)); return(val);}
static SCM g_spectro_z_scale(void) {RTNFLT(spectro_z_scale(state));}
static SCM g_set_spectro_z_scale(SCM val) {ERRN1(val,S_set_spectro_z_scale); set_spectro_z_scale(state,gh_scm2double(val)); return(val);}
static SCM g_speed_style(void) {RTNINT(speed_style(state));}
static SCM g_set_speed_style(SCM speed) {ERRN1(speed,S_set_speed_style); activate_speed_in_menu(state,gh_scm2int(speed)); return(speed);}
static SCM g_speed_tones(void) {RTNINT(speed_tones(state));}
static SCM g_set_speed_tones(SCM val) {ERRN1(val,S_set_speed_tones); set_speed_tones(state,gh_scm2int(val)); return(val);}
static SCM g_temp_dir(void) {RTNSTR(temp_dir(state));}
static SCM g_set_temp_dir(SCM val) {ERRS1(val,S_set_temp_dir); set_temp_dir(state,gh_scm2newstr(val,0)); return(val);}
static SCM g_transform_type(void) {RTNINT(transform_type(state));}
static SCM g_set_transform_type(SCM val) {ERRN1(val,S_set_transform_type); set_transform_type(state,gh_scm2int(val)); return(val);}
static SCM g_trap_segfault(void) {RTNBOOL(trap_segfault(state));}
static SCM g_set_trap_segfault(SCM val) {int n; ERRB1(val,S_set_trap_segfault); set_trap_segfault(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_show_selection_transform(void) {RTNBOOL(show_selection_transform(state));}
static SCM g_set_show_selection_transform(SCM val) {int n; ERRB1(val,S_set_show_selection_transform); set_show_selection_transform(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_use_raw_defaults(void) {RTNBOOL(use_raw_defaults(state));}
static SCM g_set_use_raw_defaults(SCM val) {int n; ERRB1(val,S_set_use_raw_defaults); set_use_raw_defaults(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_verbose_cursor(void) {RTNBOOL(verbose_cursor(state));}
static SCM g_set_verbose_cursor(SCM on) {int n; ERRB1(on,S_set_verbose_cursor); set_verbose_cursor(state,n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_vu_font(void) {RTNSTR(vu_font(state));}
static SCM g_set_vu_font(SCM val) {ERRS1(val,S_set_vu_font); set_vu_font(state,gh_scm2newstr(val,0)); return(val);}
static SCM g_vu_font_size(void) {RTNFLT(vu_font_size(state));}
static SCM g_set_vu_font_size(SCM val) {ERRN1(val,S_set_vu_font_size); set_vu_font_size(state,gh_scm2double(val)); return(val);}
static SCM g_vu_size(void) {RTNFLT(vu_size(state));}
static SCM g_set_vu_size(SCM val) {ERRN1(val,S_set_vu_size); set_vu_size(state,gh_scm2double(val)); return(val);}
static SCM g_wavelet_type(void) {RTNINT(wavelet_type(state));}
static SCM g_set_wavelet_type(SCM val) {ERRN1(val,S_set_wavelet_type); set_wavelet_type(state,gh_scm2int(val)); return(val);}
static SCM g_wavo(void) {RTNBOOL(wavo(state));}
static SCM g_set_wavo(SCM val) {int n; ERRB1(val,S_set_wavo); set_wavo(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_wavo_hop(void) {RTNINT(wavo_hop(state));}
static SCM g_set_wavo_hop(SCM val) {ERRN1(val,S_set_wavo_hop); set_wavo_hop(state,gh_scm2int(val)); return(val);}
static SCM g_wavo_trace(void) {RTNINT(wavo_trace(state));}
static SCM g_set_wavo_trace(SCM val) {ERRN1(val,S_set_wavo_trace); set_wavo_trace(state,gh_scm2int(val)); return(val);}
static SCM g_set_window_height(SCM height) {ERRN1(height,S_set_window_height); set_snd_window_height(state,gh_scm2int(height)); return(height);}
static SCM g_set_window_width(SCM width) {ERRN1(width,S_set_window_width); set_snd_window_width(state,gh_scm2int(width)); return(width);}
static SCM g_window_x(void) {RTNINT(snd_window_x(state));}
static SCM g_set_window_x(SCM val) {ERRN1(val,S_set_window_x); set_snd_window_x(state,gh_scm2int(val)); return(val);}
static SCM g_window_y(void) {RTNINT(snd_window_y(state));}
static SCM g_set_window_y(SCM val) {ERRN1(val,S_set_window_y); set_snd_window_y(state,gh_scm2int(val)); return(val);}
static SCM g_x_axis_style(void) {RTNINT(x_axis_style(state));}
static SCM g_set_x_axis_style(SCM val) {ERRN1(val,S_set_x_axis_style); set_x_axis_style(state,gh_scm2int(val)); return(val);}
static SCM g_xmax(void) {RTNFLT(xmax(state));}
static SCM g_set_xmax(SCM val) {ERRN1(val,S_set_xmax); set_xmax(state,gh_scm2double(val)); return(val);}
static SCM g_xmin(void) {RTNFLT(xmin(state));}
static SCM g_set_xmin(SCM val) {ERRN1(val,S_set_xmin); set_xmin(state,gh_scm2double(val)); return(val);}
static SCM g_ymax(void) {RTNFLT(ymax(state));}
static SCM g_set_ymax(SCM val) {ERRN1(val,S_set_ymax); set_ymax(state,gh_scm2double(val)); return(val);}
static SCM g_ymin(void) {RTNFLT(ymin(state));}
static SCM g_set_ymin(SCM val) {ERRN1(val,S_set_ymin); set_ymin(state,gh_scm2double(val)); return(val);}
static SCM g_zero_pad(void) {RTNINT(zero_pad(state));}
static SCM g_set_zero_pad(SCM val) {SCM n; ERRB1(val,S_set_zero_pad); set_zero_pad(state,n = bool_int_or_one(val)); RTNBOOL(n);}
static SCM g_zoom_focus_style(void) {RTNINT(zoom_focus_style(state));}
static SCM g_set_zoom_focus_style(SCM focus) {ERRN1(focus,S_set_zoom_focus_style); activate_focus_menu(state,gh_scm2int(focus)); return(focus);}
static SCM g_set_just_sounds(SCM on) {int n; ERRB1(on,S_set_just_sounds); toggle_just_sounds(n = bool_int_or_one(on)); RTNBOOL(n);}
static SCM g_edit_history_width(void) {RTNINT(edit_history_width(state));}
static SCM g_set_edit_history_width(SCM val) {ERRN1(val,S_set_edit_history_width); set_edit_history_width(state,gh_scm2int(val)); return(val);}
static SCM g_recorder_gain (SCM num) {RTNFLT(read_record_state(AUDIO_GAINS,gh_scm2int(num),0));}
static SCM g_recorder_in_amp (SCM in, SCM out) {RTNFLT(read_record_state(REC_IN_AMPS,gh_scm2int(in),gh_scm2int(out)));}
static SCM g_recorder_out_amp (SCM num) {RTNFLT(read_record_state(REC_OUT_AMPS,gh_scm2int(num),0));}
static SCM g_set_recorder_gain (SCM num, SCM amp) 
{
  ERRN1(num,S_set_recorder_gain);
  ERRN2(amp,S_set_recorder_gain); 
  write_record_state(AUDIO_GAINS,gh_scm2int(num),0,gh_scm2double(amp)); 
  return(amp);
}
static SCM g_set_recorder_in_amp (SCM in, SCM out, SCM amp) 
{
  ERRN1(in,S_set_recorder_in_amp);
  ERRN2(out,S_set_recorder_in_amp);
  ERRN3(amp,S_set_recorder_in_amp);
  write_record_state(REC_IN_AMPS,gh_scm2int(in),gh_scm2int(out),gh_scm2double(amp)); 
  return(amp);
}
static SCM g_set_recorder_out_amp (SCM num, SCM amp) 
{
  ERRN1(num,S_set_recorder_out_amp);
  ERRN2(amp,S_set_recorder_out_amp); 
  write_record_state(REC_OUT_AMPS,gh_scm2int(num),0,gh_scm2double(amp)); 
  return(amp);
}
static SCM g_graph2ps(void) {snd_print(state,eps_file(state),1); RTNSTR(eps_file(state));}
static SCM g_version(void) {RTNSTR(SND_VERSION);}
static SCM g_save_state(SCM filename) {if (save_state(state,gh_scm2newstr(filename,NULL)) == -1) return(SCM_BOOL_F); else return(filename);}
static SCM g_save_macros(void) {save_macros(state); return(SCM_BOOL_F);}
static SCM g_max_sounds(void) {RTNINT(state->max_sounds);}
static SCM g_max_regions(void) {RTNINT(max_regions(state));}
static SCM g_set_max_regions(SCM n) {ERRN1(n,S_set_max_regions); set_max_regions(state,gh_scm2int(n)); return(n);}
static SCM g_max_fft_peaks(void) {RTNINT(max_fft_peaks(state));}
static SCM g_set_max_fft_peaks(SCM n) {ERRN1(n,S_set_max_fft_peaks); set_max_fft_peaks(state,gh_scm2int(n)); return(n);}
static SCM g_max_fft_size(void) {RTNINT(max_fft_size(state));}
static SCM g_set_max_fft_size(SCM n) {ERRN1(n,S_set_max_fft_size); set_max_fft_size(state,gh_scm2int(n)); return(n);}
static SCM g_normalize_view(void) {normalize_all_sounds(state); return(SCM_BOOL_F);}
static SCM g_window_width(void) {RTNINT(snd_window_width(state));}
static SCM g_window_height(void) {RTNINT(snd_window_height(state));}
static SCM g_show_listener(void) {if (state->listening != LISTENER_OPEN) handle_listener(state,LISTENER_OPEN); return(SCM_BOOL_F);}
static SCM g_hide_listener(void) {if (state->listening == LISTENER_OPEN) handle_listener(state,LISTENER_LISTENING); return(SCM_BOOL_F);}
static SCM g_activate_listener(void) {handle_listener(state,LISTENER_LISTENING); state->listening = LISTENER_LISTENING; return(SCM_BOOL_F);}
static SCM g_min_dB(void) {RTNFLT(state->min_dB);}
static SCM g_set_min_dB(SCM val) {ERRN1(val,S_set_min_dB); set_min_dB(state,gh_scm2double(val)); return(val);}

static SCM g_exit(void) 
{
  if (dont_exit(state)) return(SCM_BOOL_T);
  snd_exit_cleanly(state); 
  snd_exit(1); 
  return(SCM_BOOL_F);
}

static SCM g_abort(void)
{
  abort();
  return(SCM_BOOL_F);
}

static SCM g_dismiss_all(void)
{
  dismiss_all(state);
  return(SCM_BOOL_F);
}

static SCM g_abortq(void)
{
  check_for_event(state);
  if (state->stopped_explicitly)
    {
      state->stopped_explicitly = 0;
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static snd_info *get_sp(SCM scm_snd_n)
{
  int snd_n;
  if (gh_number_p(scm_snd_n))
    {
      snd_n = gh_scm2int(scm_snd_n);
      if ((snd_n >= 0) && (snd_n < state->max_sounds) && (snd_ok(state->sounds[snd_n])))
	return(state->sounds[snd_n]);
      else
	{
	  /* user asked for specific sound and it's closed or non-existent */
	  state->eval_error = SND_NO_SUCH_SOUND;
	  return(NULL);
	}
    }
  /* use default sound, if any */
  return(any_selected_sound(state));
}

static chan_info *get_cp(SCM scm_snd_n, SCM scm_chn_n)
{
  snd_info *sp;
  int chn_n;
  sp = get_sp(scm_snd_n);
  if (sp) 
    {
      if (gh_number_p(scm_chn_n))
	chn_n = gh_scm2int(scm_chn_n);
      else
	if (sp->selected_channel != NO_SELECTION) 
	  chn_n = sp->selected_channel;
	else chn_n = 0;
      if ((chn_n >= 0) && (chn_n < sp->nchans)) 
	return(sp->chans[chn_n]);
      state->eval_error = SND_NO_SUCH_CHANNEL;
    }
  return(NULL);
}


enum {SYNCF,UNITEF,READONLYF,NCHANSF,CONTRASTINGF,EXPANDINGF,REVERBINGF,FILTERINGF,FILTERORDERF,
      SRATEF,DATAFORMATF,DATALOCATIONF,HEADERTYPEF,CONTROLPANELSAVEF,CONTROLPANELRESTOREF,SELECTEDCHANNELF,
      COMMENTF,FILENAMEF,SHORTFILENAMEF,CLOSEF,UPDATEF,SAVEF,CURSORFOLLOWSPLAYF,SHOWCONTROLSF,SAVEMARKSF,
      FILTERDBING};

static SCM sp_iread(SCM snd_n, int fld)
{
  snd_info *sp;
  sp = get_sp(snd_n);
  if (sp) 
    switch (fld)
      {
      case SYNCF: RTNINT(sp->syncing); break;
      case UNITEF: RTNINT(sp->combining); break;
      case READONLYF: RTNBOOL(sp->read_only); break;
      case NCHANSF: RTNINT(sp->nchans); break;
      case EXPANDINGF: RTNBOOL(sp->expanding); break;
      case CONTRASTINGF: RTNBOOL(sp->contrasting); break;
      case REVERBINGF: RTNBOOL(sp->reverbing); break;
      case FILTERINGF: RTNBOOL(sp->filtering); break;
      case FILTERDBING: RTNBOOL(sp->filter_dBing); break;
      case FILTERORDERF: RTNINT(sp->filter_order); break;
      case SRATEF: RTNINT((sp->hdr)->srate); break;
      case DATAFORMATF: return(gh_cons(gh_int2scm((sp->hdr)->format),gh_str02scm(sound_format_name((sp->hdr)->format)))); break;
      case HEADERTYPEF: return(gh_cons(gh_int2scm((sp->hdr)->type),gh_str02scm(sound_type_name((sp->hdr)->type)))); break;
      case DATALOCATIONF: RTNINT((sp->hdr)->data_location); break;
      case CONTROLPANELSAVEF: save_control_state(sp); break;
      case CONTROLPANELRESTOREF: restore_control_state(sp); break;
      case SELECTEDCHANNELF: if (sp->selected_channel != NO_SELECTION) RTNINT(sp->selected_channel); break;
      case FILENAMEF: RTNSTR(sp->fullname); break;
      case SHORTFILENAMEF: RTNSTR(sp->shortname); break;
      case COMMENTF: RTNSTR(sound_comment(sp->fullname)); break;
      case CLOSEF: snd_close_file(sp,state); break;
      case SAVEF: save_edits(sp,NULL); break;
      case UPDATEF: snd_update(state,sp); break;
      case CURSORFOLLOWSPLAYF: RTNBOOL(sp->cursor_follows_play); break;
      case SHOWCONTROLSF: RTNBOOL(control_panel_open(sp)); break;
      case SAVEMARKSF: save_marks(sp); break;
    }
  return(SCM_BOOL_F);
}

static SCM sp_iwrite(SCM snd_n, SCM val, int fld)
{
  snd_info *sp;
  int ival;
  sp = get_sp(snd_n);
  if (sp)
    {
      ival = bool_int_or_one(val);
      switch (fld)
	{
	case SYNCF: syncb(sp,ival); break;
	case UNITEF: combineb(sp,ival); break;
	case READONLYF: sp->read_only = ival; snd_file_lock_icon(sp,ival); break;
	case EXPANDINGF: toggle_expand_button(sp,ival); break;
	case CONTRASTINGF: toggle_contrast_button(sp,ival); break;
	case REVERBINGF: toggle_reverb_button(sp,ival); break;
	case FILTERINGF: toggle_filter_button(sp,ival); break;
	case FILTERDBING: set_filter_dBing(sp,ival); break;
	case FILTERORDERF: filter_order_changed(sp,ival); break;
	case CURSORFOLLOWSPLAYF: sp->cursor_follows_play = ival; break;
	case SHOWCONTROLSF: if (ival) sound_show_ctrls(sp); else sound_hide_ctrls(sp); break;
	}
    }
  RTNBOOL(ival);
}

static SCM g_ok(SCM snd_n)
{
  snd_info *sp;
  sp = get_sp(snd_n);
  state->eval_error = SND_NO_EVAL_ERROR; 
  if ((sp) && snd_ok(sp))
    return(SCM_BOOL_T); 
  else return(SCM_BOOL_F);
}

static SCM g_bomb(SCM snd, SCM on)
{
  snd_info *sp;
  sp = get_sp(snd);
  if (sp) x_bomb(sp,bool_int_or_one(on));
  return(on);
}


static SCM g_syncing(SCM snd_n) {ERRSP(S_syncing,snd_n,1); return(sp_iread(snd_n,SYNCF));}
static SCM g_set_syncing(SCM on, SCM snd_n) {ERRB1(on,S_set_syncing); ERRSP(S_set_syncing,snd_n,2); return(sp_iwrite(snd_n,on,SYNCF));}
static SCM g_uniting(SCM snd_n) {ERRSP(S_uniting,snd_n,1); return(sp_iread(snd_n,UNITEF));}
static SCM g_set_uniting(SCM on, SCM snd_n) {ERRB1(on,S_set_uniting); ERRSP(S_set_uniting,snd_n,2); return(sp_iwrite(snd_n,on,UNITEF));}
static SCM g_read_only(SCM snd_n) {ERRSP(S_read_only,snd_n,1); return(sp_iread(snd_n,READONLYF));}
static SCM g_set_read_only(SCM on, SCM snd_n) {ERRB1(on,S_set_read_only); ERRSP(S_set_read_only,snd_n,2); return(sp_iwrite(snd_n,on,READONLYF));}
static SCM g_channels(SCM snd_n) {ERRSP(S_channels,snd_n,1); return(sp_iread(snd_n,NCHANSF));}
static SCM g_srate(SCM snd_n) {ERRSP(S_srate,snd_n,1); return(sp_iread(snd_n,SRATEF));}
static SCM g_data_location(SCM snd_n) {ERRSP(S_data_location,snd_n,1); return(sp_iread(snd_n,DATALOCATIONF));}
static SCM g_data_format(SCM snd_n) {ERRSP(S_data_format,snd_n,1); return(sp_iread(snd_n,DATAFORMATF));}
static SCM g_header_type(SCM snd_n) {ERRSP(S_header_type,snd_n,1); return(sp_iread(snd_n,HEADERTYPEF));}
static SCM g_contrasting(SCM snd_n) {ERRSP(S_contrasting,snd_n,1); return(sp_iread(snd_n,CONTRASTINGF));}
static SCM g_set_contrasting(SCM on, SCM snd_n) {ERRB1(on,S_set_contrasting); ERRSP(S_set_contrasting,snd_n,2); return(sp_iwrite(snd_n,on,CONTRASTINGF));}
static SCM g_expanding(SCM snd_n) {ERRSP(S_expanding,snd_n,1); return(sp_iread(snd_n,EXPANDINGF));}
static SCM g_set_expanding(SCM on, SCM snd_n) {ERRB1(on,S_set_expanding); ERRSP(S_set_expanding,snd_n,2); return(sp_iwrite(snd_n,on,EXPANDINGF));}
static SCM g_reverbing(SCM snd_n) {ERRSP(S_reverbing,snd_n,1); return(sp_iread(snd_n,REVERBINGF));}
static SCM g_set_reverbing(SCM on, SCM snd_n) {ERRB1(on,S_set_reverbing); ERRSP(S_set_reverbing,snd_n,2); return(sp_iwrite(snd_n,on,REVERBINGF));}
static SCM g_filtering(SCM snd_n) {ERRSP(S_filtering,snd_n,1); return(sp_iread(snd_n,FILTERINGF));}
static SCM g_set_filtering(SCM on, SCM snd_n) {ERRB1(on,S_set_filtering); ERRSP(S_set_filtering,snd_n,2); return(sp_iwrite(snd_n,on,FILTERINGF));}
static SCM g_filter_dBing(SCM snd_n) {ERRSP(S_filter_dBing,snd_n,1); return(sp_iread(snd_n,FILTERDBING));}
static SCM g_set_filter_dBing(SCM on, SCM snd_n) {ERRB1(on,S_set_filter_dBing); ERRSP(S_set_filter_dBing,snd_n,2); return(sp_iwrite(snd_n,on,FILTERDBING));}
static SCM g_filter_order(SCM snd_n) {ERRSP(S_filter_order,snd_n,1); return(sp_iread(snd_n,FILTERORDERF));}
static SCM g_set_filter_order(SCM on, SCM snd_n) {ERRB1(on,S_set_filter_order); ERRSP(S_set_filter_order,snd_n,2); return(sp_iwrite(snd_n,on,FILTERORDERF));}
static SCM g_control_panel_save(SCM snd_n) {ERRSP(S_save_control_panel,snd_n,1); return(sp_iread(snd_n,CONTROLPANELSAVEF));}
static SCM g_control_panel_restore(SCM snd_n) {ERRSP(S_restore_control_panel,snd_n,1); return(sp_iread(snd_n,CONTROLPANELRESTOREF));}
static SCM g_selected_channel(SCM snd_n) {ERRSP(S_selected_channel,snd_n,1); return(sp_iread(snd_n,SELECTEDCHANNELF));}
static SCM g_file_name(SCM snd_n) {ERRSP(S_file_name,snd_n,1); return(sp_iread(snd_n,FILENAMEF));}
static SCM g_short_file_name(SCM snd_n) {ERRSP(S_short_file_name,snd_n,1); return(sp_iread(snd_n,SHORTFILENAMEF));}
static SCM g_comment(SCM snd_n) {ERRSP(S_comment,snd_n,1); return(sp_iread(snd_n,COMMENTF));}
static SCM g_close(SCM snd_n) {ERRSP(S_close_sound,snd_n,1); return(sp_iread(snd_n,CLOSEF));}
static SCM g_update(SCM snd_n) {ERRSP(S_update_sound,snd_n,1); return(sp_iread(snd_n,UPDATEF));}
static SCM g_save(SCM snd_n) {ERRSP(S_save_sound,snd_n,1); return(sp_iread(snd_n,SAVEF));}
static SCM g_cursor_follows_play(SCM snd_n) {ERRSP(S_cursor_follows_play,snd_n,1); return(sp_iread(snd_n,CURSORFOLLOWSPLAYF));}
static SCM g_set_cursor_follows_play(SCM on, SCM snd_n) {ERRB1(on,S_set_cursor_follows_play); ERRSP(S_set_cursor_follows_play,snd_n,2); return(sp_iwrite(snd_n,on,CURSORFOLLOWSPLAYF));}
static SCM g_showing_controls(SCM snd_n) {ERRSP(S_showing_controls,snd_n,1); return(sp_iread(snd_n,SHOWCONTROLSF));}
static SCM g_set_show_controls(SCM on, SCM snd_n) {ERRB1(on,S_set_showing_controls); ERRSP(S_set_showing_controls,snd_n,2); return(sp_iwrite(snd_n,on,SHOWCONTROLSF));}
static SCM g_save_marks(SCM snd_n) {ERRSP(S_save_marks,snd_n,1); return(sp_iread(snd_n,SAVEMARKSF));}

static SCM g_override_data_location(SCM loc, SCM snd) 
{
  snd_info *sp;
  ERRN1(loc,S_override_data_location);
  ERRSP(S_override_data_location,snd,2);
  sp = get_sp(snd);
  if (sp)
    {
      override_sound_header(sp->fullname,-1,-1,-1,-1,gh_scm2int(loc),-1);
      snd_update(sp->state,sp);
    }
  return(loc);
}

static SCM g_override_data_format(SCM frm, SCM snd) 
{
  snd_info *sp;
  ERRN1(frm,S_override_data_format);
  ERRSP(S_override_data_format,snd,2);
  sp = get_sp(snd);
  if (sp)
    {
      override_sound_header(sp->fullname,-1,-1,gh_scm2int(frm),-1,-1,-1);
      snd_update(sp->state,sp);
    }
  return(frm);
}

static SCM g_override_data_size(SCM over, SCM snd) 
{
  snd_info *sp;
  ERRN1(over,S_override_data_size);
  ERRSP(S_override_data_size,snd,2);
  sp = get_sp(snd);
  if (sp)
    {
      override_sound_header(sp->fullname,-1,-1,-1,-1,-1,gh_scm2int(over));
      snd_update(sp->state,sp);
    }
  return(over);
}


static file_info **temp_sound_headers = NULL;
static int *temp_sound_fds = NULL;
static int temp_sound_size = 0;

static void set_temp_fd(int fd, file_info *hdr)
{
  int i,pos;
  if (temp_sound_size == 0)
    {
      temp_sound_size = 4;
      temp_sound_fds = (int *)CALLOC(temp_sound_size,sizeof(int));
      temp_sound_headers = (file_info **)CALLOC(temp_sound_size,sizeof(file_info *));
      pos = 0;
    }
  else
    {
      pos = -1;
      for (i=0;i<temp_sound_size;i++)
	if (temp_sound_headers[i] == NULL) {pos=i; break;}
      if (pos == -1)
	{
	  pos = temp_sound_size;
	  temp_sound_size += 4;
	  temp_sound_fds = (int *)REALLOC(temp_sound_fds,temp_sound_size * sizeof(int));
	  temp_sound_headers = (file_info **)REALLOC(temp_sound_headers,temp_sound_size * sizeof(file_info *));
	  for (i=pos;i<temp_sound_size;i++) temp_sound_headers[i] = NULL;
	}
    }
  temp_sound_fds[pos] = fd;
  temp_sound_headers[pos] = hdr;
}

static file_info *get_temp_header(int fd)
{
  int i;
  for (i=0;i<temp_sound_size;i++)
    if (fd == temp_sound_fds[i]) return(temp_sound_headers[i]);
  return(NULL);
}

static void unset_temp_fd(int fd)
{
  int i;
  for (i=0;i<temp_sound_size;i++)
    if (fd == temp_sound_fds[i])
      {
	temp_sound_fds[i] = 0;
	temp_sound_headers[i] = NULL;
      }
}

static SCM g_open_sound_file(SCM g_name, SCM g_chans, SCM g_srate, SCM g_comment)
{ /* assume user temp files are writing floats in native format */
  char *name = NULL,*comment = NULL;
  file_info *hdr;
  int chans = 1,srate = 22050,result;
#ifdef SNDLIB_LITTLE_ENDIAN
  int type = RIFF_sound_file,format = SNDLIB_32_FLOAT_LITTLE_ENDIAN;
#else
  int type = NeXT_sound_file,format = SNDLIB_32_FLOAT;
#endif
  if (gh_string_p(g_name)) name = gh_scm2newstr(g_name,NULL); else if (g_name != SCM_UNDEFINED) scm_wrong_type_arg(S_open_sound_file,1,g_name);
  if (gh_number_p(g_chans)) chans = gh_scm2int(g_chans); else if (g_chans != SCM_UNDEFINED) scm_wrong_type_arg(S_open_sound_file,2,g_chans);
  if (gh_number_p(g_srate)) srate = gh_scm2int(g_srate); else if (g_srate != SCM_UNDEFINED) scm_wrong_type_arg(S_open_sound_file,3,g_srate);
  if (gh_string_p(g_comment)) comment = gh_scm2newstr(g_comment,NULL); else if (g_comment != SCM_UNDEFINED) scm_wrong_type_arg(S_open_sound_file,4,g_comment);
  if (name == NULL)
#ifdef SNDLIB_LITTLE_ENDIAN
    name = copy_string("test.wav");
#else
    name = copy_string("test.snd");
#endif
  hdr = (file_info *)CALLOC(1,sizeof(file_info));
  hdr->s_type = FILE_INFO;
  hdr->name = copy_string(name);
  hdr->samples = 0;
  hdr->data_location = 28;
  hdr->srate = srate;
  hdr->chans = chans;
  hdr->format = format;
  hdr->type = type;
  hdr->comment = comment;
  result = open_temp_file(name,chans,hdr,state);
  set_temp_fd(result,hdr);
  return(gh_int2scm(result)); /* -1 for error */
}

static SCM g_close_sound_file(SCM g_fd, SCM g_bytes)
{
  file_info *hdr;
  int result,fd,bytes;
  ERRN1(g_fd,S_close_sound_file);
  ERRN2(g_bytes,S_close_sound_file);
  fd = gh_scm2int(g_fd);
  bytes = gh_scm2int(g_bytes);
  hdr = get_temp_header(fd);
  if (hdr == NULL) 
    {
      snd_error("can't find %d's header!",fd);
      close(fd);
      return(SCM_BOOL_F);
    }
  else
    {
      result = close_temp_file(fd,hdr,bytes,any_selected_sound(state));
      unset_temp_fd(fd);
      return(gh_int2scm(result));
    }
}

static SCM g_save_envelopes(SCM filename)
{
  char *name = NULL;
  FILE *fd;
  ERRSB1(filename,S_save_envelopes);
  if (gh_string_p(filename)) 
    name = full_filename(filename);
  else name = "envs.save";
  fd = fopen(name,"w");
  if (fd)
    {
      save_envelope_editor_state(state,fd);
      fclose(fd);
      return(filename);
    }
  else make_eval_error(state," (can't open envelope file: %s)",name);
  return(SCM_BOOL_F);
}

static SCM g_save_options(SCM filename)
{
  char *name = NULL;
  FILE *fd;
  ERRS1(filename,S_save_options);
  name = full_filename(filename);
  fd = fopen(name,"w");
  if (fd) 
    {
      save_snd_state_options(state,fd);
      fclose(fd);
    }
  else make_eval_error(state," (can't open options file: %s)",name);
  return(filename);
}

static SCM g_select_sound(SCM snd_n)
{
  int val;
  snd_info *osp,*sp;
  ERRSP(S_select_sound,snd_n,1);
  if (gh_number_p(snd_n))
    val = gh_scm2int(snd_n);
  else val = 0;
  if ((val >= 0) && (val < state->max_sounds))
    {
      sp = state->sounds[val];
      if (snd_ok(sp))
	{
	  osp = any_selected_sound(state);
	  select_channel(sp,0);
	  normalize_sound(state,sp,osp,sp->chans[0]);
	  /* goto_graph(sp->chans[0]); */
	}
      map_over_chans(state,update_graph,NULL);
    }
  else state->eval_error = SND_NO_SUCH_SOUND;
  return(snd_n);
}

static SCM g_select_channel(SCM chn_n)
{
  snd_info *sp;
  int chan;
  ERRSP(S_select_channel,chn_n,1);
  if (gh_number_p(chn_n))
    chan = gh_scm2int(chn_n);
  else chan = 0;
  sp = any_selected_sound(state);
  if ((sp) && (chan < sp->nchans)) 
    select_channel(sp,chan);
  else state->eval_error = SND_NO_SUCH_CHANNEL;
  return(chn_n);
}

enum {AMPF,CONTRASTF,CONTRASTAMPF,EXPANDF,EXPANDLENGTHF,EXPANDRAMPF,EXPANDHOPF,
      SPEEDF,REVERBLENGTHF,REVERBFEEDBACKF,REVERBSCALEF,REVERBLOWPASSF};

static SCM sp_fread(SCM snd_n, int fld)
{
  snd_info *sp;
  sp = get_sp(snd_n);
  if (sp) 
    switch (fld)
      {
      case AMPF: RTNFLT(sp->amp); break;
      case CONTRASTF: RTNFLT(sp->contrast); break;
      case CONTRASTAMPF: RTNFLT(sp->contrast_amp); break;
      case EXPANDF: RTNFLT(sp->expand); break;
      case EXPANDLENGTHF: RTNFLT(sp->local_explen); break;
      case EXPANDRAMPF: RTNFLT(sp->local_exprmp); break;
      case EXPANDHOPF: RTNFLT(sp->local_exphop); break;
      case SPEEDF: if (sp->play_direction == -1) RTNFLT((-(sp->srate))); else RTNFLT(sp->srate); break;
      case REVERBLENGTHF: RTNFLT(sp->revlen); break;
      case REVERBFEEDBACKF: RTNFLT(sp->local_revfb); break;
      case REVERBSCALEF: RTNFLT(sp->revscl); break;
      case REVERBLOWPASSF: RTNFLT(sp->local_revlp); break;
      }
  return(SCM_BOOL_F);
}

static SCM sp_fwrite(SCM snd_n, SCM val, int fld)
{
  snd_info *sp;
  float fval;
  int dir;
  sp = get_sp(snd_n);
  if (sp)
    {
      fval = gh_scm2double(val);
      switch (fld)
	{
	case AMPF: snd_amp_changed(sp,set_raw_value(w_snd_amp(sp),snd_amp_to_int(fval))); break;
	case CONTRASTF: snd_contrast_changed(sp,set_raw_value(w_snd_contrast(sp),snd_contrast_to_int(fval))); break;
	case CONTRASTAMPF: sp->contrast_amp = fval; break;
	case EXPANDF: snd_expand_changed(sp,set_raw_value(w_snd_expand(sp),snd_expand_to_int(fval))); break;
	case EXPANDLENGTHF: sp->local_explen = fval; break;
	case EXPANDRAMPF: sp->local_exprmp = fval; break;
	case EXPANDHOPF: sp->local_exphop = fval; break;
	case SPEEDF: 
	  if (fval > 0.0) dir=1; else dir=-1;
	  snd_srate_changed(sp,set_raw_value(w_snd_srate(sp),snd_srate_to_int(dir*fval))); 
	  toggle_direction_arrow(sp,(dir == -1));
	  break;
	case REVERBLENGTHF: snd_revlen_changed(sp,set_raw_value(w_snd_revlen(sp),snd_revlen_to_int(fval))); break;
	case REVERBFEEDBACKF: sp->local_revfb = fval; break;
	case REVERBSCALEF: snd_revscl_changed(sp,set_raw_value(w_snd_revscl(sp),snd_revscl_to_int(fval))); break;
	case REVERBLOWPASSF: sp->local_revlp = fval; break;
	}
    }
  return(val);
}

static SCM g_amp(SCM snd_n) {ERRSP(S_amp,snd_n,1); return(sp_fread(snd_n,AMPF));}
static SCM g_set_amp(SCM on, SCM snd_n) {ERRN1(on,S_set_amp); ERRSP(S_set_amp,snd_n,2); return(sp_fwrite(snd_n,on,AMPF));}
static SCM g_contrast(SCM snd_n) {ERRSP(S_contrast,snd_n,1); return(sp_fread(snd_n,CONTRASTF));}
static SCM g_set_contrast(SCM on, SCM snd_n) {ERRN1(on,S_set_contrast); ERRSP(S_set_contrast,snd_n,2); return(sp_fwrite(snd_n,on,CONTRASTF));}
static SCM g_contrast_amp(SCM snd_n) {ERRSP(S_contrast_amp,snd_n,1); return(sp_fread(snd_n,CONTRASTAMPF));}
static SCM g_set_contrast_amp(SCM on, SCM snd_n) {ERRN1(on,S_set_contrast_amp); ERRSP(S_set_contrast_amp,snd_n,2); return(sp_fwrite(snd_n,on,CONTRASTAMPF));}
static SCM g_expand(SCM snd_n) {ERRSP(S_expand,snd_n,1); return(sp_fread(snd_n,EXPANDF));}
static SCM g_set_expand(SCM on, SCM snd_n) {ERRN1(on,S_set_expand); ERRSP(S_set_expand,snd_n,2); return(sp_fwrite(snd_n,on,EXPANDF));}
static SCM g_expand_length(SCM snd_n) {ERRSP(S_expand_length,snd_n,1); return(sp_fread(snd_n,EXPANDLENGTHF));}
static SCM g_set_expand_length(SCM on, SCM snd_n) {ERRN1(on,S_set_expand_length); ERRSP(S_set_expand_length,snd_n,2); return(sp_fwrite(snd_n,on,EXPANDLENGTHF));}
static SCM g_expand_ramp(SCM snd_n) {ERRSP(S_expand_ramp,snd_n,1); return(sp_fread(snd_n,EXPANDRAMPF));}
static SCM g_set_expand_ramp(SCM on, SCM snd_n) {ERRN1(on,S_set_expand_ramp); ERRSP(S_set_expand_ramp,snd_n,2); return(sp_fwrite(snd_n,on,EXPANDRAMPF));}
static SCM g_expand_hop(SCM snd_n) {ERRSP(S_expand_hop,snd_n,1); return(sp_fread(snd_n,EXPANDHOPF));}
static SCM g_set_expand_hop(SCM on, SCM snd_n) {ERRN1(on,S_set_expand_hop); ERRSP(S_set_expand_hop,snd_n,2); return(sp_fwrite(snd_n,on,EXPANDHOPF));}
static SCM g_speed(SCM snd_n) {ERRSP(S_speed,snd_n,1); return(sp_fread(snd_n,SPEEDF));}
static SCM g_set_speed(SCM on, SCM snd_n) {ERRN1(on,S_set_speed); ERRSP(S_set_speed,snd_n,2); return(sp_fwrite(snd_n,on,SPEEDF));}
static SCM g_reverb_length(SCM snd_n) {ERRSP(S_reverb_length,snd_n,1); return(sp_fread(snd_n,REVERBLENGTHF));}
static SCM g_set_reverb_length(SCM on, SCM snd_n) {ERRN1(on,S_set_reverb_length); ERRSP(S_set_reverb_length,snd_n,2); return(sp_fwrite(snd_n,on,REVERBLENGTHF));}
static SCM g_reverb_feedback(SCM snd_n) {ERRSP(S_reverb_feedback,snd_n,1); return(sp_fread(snd_n,REVERBFEEDBACKF));}
static SCM g_set_reverb_feedback(SCM on, SCM snd_n) {ERRN1(on,S_set_reverb_feedback); ERRSP(S_set_reverb_feedback,snd_n,2); return(sp_fwrite(snd_n,on,REVERBFEEDBACKF));}
static SCM g_reverb_scale(SCM snd_n) {ERRSP(S_reverb_scale,snd_n,1); return(sp_fread(snd_n,REVERBSCALEF));}
static SCM g_set_reverb_scale(SCM on, SCM snd_n) {ERRN1(on,S_set_reverb_scale); ERRSP(S_set_reverb_scale,snd_n,2); return(sp_fwrite(snd_n,on,REVERBSCALEF));}
static SCM g_reverb_lowpass(SCM snd_n) {ERRSP(S_reverb_lowpass,snd_n,1); return(sp_fread(snd_n,REVERBLOWPASSF));}
static SCM g_set_reverb_lowpass(SCM on, SCM snd_n) {ERRN1(on,S_set_reverb_lowpass); ERRSP(S_set_reverb_lowpass,snd_n,2); return(sp_fwrite(snd_n,on,REVERBLOWPASSF));}

enum {FFTF,WAVEF,LENGTHF,CURSORF,MARKSF,MAXAMPF,GRAPHINGF,LOSAMPF,HISAMPF,SQUELCH_UPDATE};

static SCM cp_iread(SCM snd_n, SCM chn_n, int fld)
{
  chan_info *cp;
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    switch(fld)
      {
      case FFTF: RTNBOOL(cp->ffting); break;
      case WAVEF: RTNBOOL(cp->waving); break;
      case CURSORF: RTNINT(cp->cursor); break;
      case LENGTHF: RTNINT(current_ed_samples(cp)); break;
      case MARKSF: if (cp->marks) RTNINT(1+(cp->mark_ctr[cp->edit_ctr])); else RTNINT(0); break;
      case MAXAMPF: RTNFLT(get_maxamp(state,cp->sound,cp)); break;
      case GRAPHINGF: RTNBOOL(cp->lisp_graphing); break;
      case LOSAMPF: if (cp->axis) RTNINT((cp->axis)->losamp); break;
      case HISAMPF: if (cp->axis) RTNINT((cp->axis)->hisamp); break;
      case SQUELCH_UPDATE: RTNBOOL(cp->squelch_update); break;
      }
  return(SCM_BOOL_F);
}

static SCM graph_hook;

static SCM cp_iwrite(SCM snd_n, SCM chn_n, SCM on, int fld)
{
  chan_info *cp;
  int val = 0;
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      switch (fld)
	{
	case FFTF: fftb(cp,val = bool_int_or_one(on)); update_graph(cp,NULL); break;
	case WAVEF: waveb(cp,val = bool_int_or_one(on)); update_graph(cp,NULL); break;
	case CURSORF: cp->cursor_on = 1; handle_cursor(cp,cursor_moveto(cp,val = int_or_one(on))); break;
	case GRAPHINGF: 
	  cp->lisp_graphing = bool_int_or_one(on); 
	  val = cp->lisp_graphing;
#if HAVE_MAKE_SMOB_TYPE
	  if (!(cp->lisp_graphing)) scm_reset_hook_x(graph_hook);
#endif
	  update_graph(cp,NULL); 
	  break;
	case LOSAMPF: clm_left_axis(cp,val = int_or_zero(on)); break;
	case HISAMPF: clm_right_axis(cp,val = int_or_one(on)); break;
	case SQUELCH_UPDATE: cp->squelch_update = bool_int_or_one(on); break;
	}
    }
  RTNBOOL(val);
}

static SCM g_ffting(SCM snd_n, SCM chn_n) {ERRCP(S_ffting,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,FFTF));}
static SCM g_set_ffting(SCM on, SCM snd_n, SCM chn_n) {ERRB1(on,S_set_ffting); ERRCP(S_set_ffting,snd_n,chn_n,2); return(cp_iwrite(snd_n,chn_n,on,FFTF));}
static SCM g_waving(SCM snd_n, SCM chn_n) {ERRCP(S_waving,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,WAVEF));}
static SCM g_set_waving(SCM on, SCM snd_n, SCM chn_n) {ERRB1(on,S_set_waving); ERRCP(S_set_waving,snd_n,chn_n,2); return(cp_iwrite(snd_n,chn_n,on,WAVEF));}
static SCM g_graphing(SCM snd_n, SCM chn_n) {ERRCP(S_graphing,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,GRAPHINGF));}
static SCM g_set_graphing(SCM on, SCM snd_n, SCM chn_n) {ERRB1(on,S_set_graphing); ERRCP(S_set_graphing,snd_n,chn_n,2); return(cp_iwrite(snd_n,chn_n,on,GRAPHINGF));}
static SCM g_cursor(SCM snd_n, SCM chn_n) {ERRCP(S_cursor,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,CURSORF));}
static SCM g_set_cursor(SCM on, SCM snd_n, SCM chn_n) {ERRB1(on,S_set_cursor); ERRCP(S_set_cursor,snd_n,chn_n,2); return(cp_iwrite(snd_n,chn_n,on,CURSORF));}
static SCM g_length(SCM snd_n, SCM chn_n) {ERRCP(S_frames,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,LENGTHF));}
static SCM g_marks(SCM snd_n, SCM chn_n) {ERRCP(S_marks,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,MARKSF));}
static SCM g_maxamp(SCM snd_n, SCM chn_n) {ERRCP(S_maxamp,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,MAXAMPF));}
static SCM g_squelch_update(SCM snd_n, SCM chn_n) {ERRCP(S_squelch_update,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,SQUELCH_UPDATE));}
static SCM g_set_squelch_update(SCM on, SCM snd_n, SCM chn_n) 
{
  ERRB1(on,S_set_squelch_update); 
  ERRCP(S_set_squelch_update,snd_n,chn_n,2); 
  return(cp_iwrite(snd_n,chn_n,on,SQUELCH_UPDATE));
}

static SCM g_peaks(SCM filename, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  char *name = NULL;
  int err;
  ERRSB1(filename,S_peaks);
  ERRCP(S_peaks,snd_n,chn_n,2);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      if (gh_string_p(filename)) 
	name = full_filename(filename);
      else name = NULL;
      err = display_fft_peaks(cp,name);
      if ((gh_string_p(filename)) && (err == 0)) return(filename);
    }
  return(SCM_BOOL_F);
}

static SCM g_left_sample(SCM snd_n, SCM chn_n) {ERRCP(S_left_sample,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,LOSAMPF));}
static SCM g_set_left_sample(SCM on, SCM snd_n, SCM chn_n) {ERRB1(on,S_set_left_sample); ERRCP(S_set_left_sample,snd_n,chn_n,2); return(cp_iwrite(snd_n,chn_n,on,LOSAMPF));}
static SCM g_right_sample(SCM snd_n, SCM chn_n) {ERRCP(S_right_sample,snd_n,chn_n,1); return(cp_iread(snd_n,chn_n,HISAMPF));}
static SCM g_set_right_sample(SCM on, SCM snd_n, SCM chn_n) {ERRB1(on,S_set_right_sample); ERRCP(S_set_right_sample,snd_n,chn_n,2); return(cp_iwrite(snd_n,chn_n,on,HISAMPF));}

static SCM g_edits(SCM snd_n, SCM chn_n)
{ /* returns vector: (current edit (i.e. undo-able edits), redo-able edits) */
  chan_info *cp;
  int i;
  SCM vect;
  ERRCP(S_edits,snd_n,chn_n,1);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      vect = GH_MAKE_VECTOR(gh_int2scm(2),gh_int2scm(cp->edit_ctr));
      for (i=cp->edit_ctr+1;i<cp->edit_size;i++)
	if (!(cp->edits[i])) break;
      GH_VSET(vect,gh_int2scm(1),gh_int2scm(i-cp->edit_ctr-1));
      return(vect);
    }
  return(SCM_BOOL_F);
}

static SCM g_find(SCM expr, SCM sample, SCM snd_n, SCM chn_n)
{
  /* no free here -- it's handled as ss->search_expr in snd-find.c */
  chan_info *cp = NULL;
  SCM_ASSERT((gh_string_p(expr) || gh_procedure_p(expr)),expr,SCM_ARG1,S_find);
  ERRB2(sample,S_find);
  ERRCP(S_find,snd_n,chn_n,3);
  if (gh_string_p(expr))
    {
      cp = get_cp(snd_n,chn_n);
      if (cp) RTNINT(snd_find_1(cp,gh_scm2newstr(expr,NULL),int_or_zero(sample),FALSE)); else return(SCM_BOOL_F);
    }
  else return(g_scan_chan(expr,sample,SCM_BOOL_F,snd_n,chn_n));
  return(SCM_BOOL_F);
}

static SCM g_count_matches(SCM expr, SCM sample, SCM snd_n, SCM chn_n)
{
  chan_info *cp = NULL;
  int samp = 0,matches,lim;
  SCM match,cursamp;
  SCM_ASSERT((gh_string_p(expr) || gh_procedure_p(expr)),expr,SCM_ARG1,S_count_matches);
  ERRB2(sample,S_count_matches);
  ERRCP(S_count_matches,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (gh_number_p(sample)) samp = gh_scm2int(sample);
  if (cp) 
    {
      if (gh_string_p(expr))
	RTNINT(snd_find_1(cp,gh_scm2newstr(expr,NULL),int_or_zero(sample),TRUE));
      else
	{
	  matches = 0;
	  lim = current_ed_samples(cp);
	  while (samp < lim)
	    {
	      cursamp = gh_int2scm(samp);
	      match = g_scan_chan(expr,cursamp,SCM_BOOL_F,snd_n,chn_n);
	      if ((gh_list_p(match)) && (scm_list_ref(match,gh_int2scm(0)) == SCM_BOOL_T))
		{
		  matches++;
		  samp = gh_scm2int(scm_list_ref(match,gh_int2scm(1))) + 1;
		}
	      else break;
	    }
	  return(gh_int2scm(matches));
	}
    }
  return(SCM_BOOL_F);
}

enum {MARKSAMPLEF,MARKNAMEF,MARKFINDF,MARKADDF,MARKDELETEF};

static SCM iread_mark(SCM snd_n, SCM chn_n, SCM ms_n, int fld)
{
  chan_info *cp;
  int msn = -1,i;
  mark *m;
  mark **mps = NULL;
  char *name = NULL;
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      if (gh_string_p(ms_n))
	name = gh_scm2newstr(ms_n,NULL);
      else msn = int_or_zero(ms_n);
      if (fld == MARKADDF)
	{
	  m = add_mark(msn,NULL,cp);
	  update_graph(cp,NULL);
	  RTNINT(mark_id(m));
	}
      else
	if ((cp->marks) && (cp->marks[cp->edit_ctr]))
	  {
	    switch (fld)
	      {
	      case MARKSAMPLEF: 
		m = find_mark_id(cp,msn);
		if (m)
		  RTNINT(m->samp);
		else state->eval_error = SND_NO_SUCH_MARK;
		break;
	      case MARKNAMEF: 
		m = find_mark_id(cp,msn);
		if (m) 
		  {if (m->name) RTNSTR(m->name);}
		else state->eval_error = SND_NO_SUCH_MARK;
		break;
	      case MARKFINDF:
		mps = cp->marks[cp->edit_ctr];
		for (i=0;i<=cp->mark_ctr[cp->edit_ctr];i++) 
		  if (((name) && (strcmp(name,mps[i]->name) == 0)) || (mps[i]->samp == msn)) RTNINT(mark_id(mps[i]));
		state->eval_error = SND_NO_SUCH_MARK;
		break;
	      case MARKDELETEF:
		delete_mark_id(msn,cp);
		update_graph(cp,NULL);
		break;
	      }
	  }
      else state->eval_error = SND_NO_SUCH_MARK;
      if (name) FREE(name);
    }
  return(SCM_BOOL_F);
}

static SCM iwrite_mark(SCM snd_n, SCM chn_n, SCM mark_n, SCM val, int fld)
{
  chan_info *cp;
  mark *m;
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      m = find_mark_id(cp,int_or_zero(mark_n));
      if (m)
	{
	  switch (fld)
	    {
	    case MARKSAMPLEF: 
	      ERRN2(val,S_set_mark_sample); /* 2->original arg order */
	      m->samp = gh_scm2int(val);
	      finish_moving_mark(cp,m); /* update and re-sort current mark list */
	      update_graph(cp,NULL);
	      break;
	    case MARKNAMEF:
	      ERRS2(val,S_set_mark_name);
	      if (m->name) FREE(m->name);
	      m->name = gh_scm2newstr(val,NULL);
	      update_graph(cp,NULL);
	      break;
	    }
	}
      else state->eval_error = SND_NO_SUCH_MARK;
    }
  return(val);
}

static SCM g_mark_sample(SCM mark_n, SCM snd_n, SCM chn_n) 
{
  ERRB1(mark_n,S_mark_sample);
  ERRCP(S_mark_sample,snd_n,chn_n,2);
  return(iread_mark(snd_n,chn_n,mark_n,MARKSAMPLEF));
}

static SCM g_set_mark_sample(SCM mark_n, SCM samp_n, SCM snd_n, SCM chn_n) 
{
  ERRB1(mark_n,S_mark_sample); 
  ERRB2(samp_n,S_mark_sample); 
  ERRCP(S_set_mark_sample,snd_n,chn_n,3);
  return(iwrite_mark(snd_n,chn_n,mark_n,samp_n,MARKSAMPLEF));
}

static SCM g_mark_name(SCM mark_n, SCM snd_n, SCM chn_n) 
{
  ERRB1(mark_n,S_mark_name); 
  ERRCP(S_mark_name,snd_n,chn_n,2);
  return(iread_mark(snd_n,chn_n,mark_n,MARKNAMEF));
}

static SCM g_set_mark_name(SCM mark_n, SCM name, SCM snd_n, SCM chn_n) 
{  
  ERRB1(mark_n,S_set_mark_name); 
  ERRS2(name,S_set_mark_name);
  ERRCP(S_set_mark_name,snd_n,chn_n,3);
  return(iwrite_mark(snd_n,chn_n,mark_n,name,MARKNAMEF));
}

static SCM g_find_mark(SCM samp_n, SCM snd_n, SCM chn_n) 
{
  SCM_ASSERT((gh_number_p(samp_n) || gh_string_p(samp_n) || (samp_n == SCM_UNDEFINED) || (samp_n == SCM_BOOL_F)),samp_n,SCM_ARG1,S_find_mark);
  ERRCP(S_find_mark,snd_n,chn_n,2); 
  return(iread_mark(snd_n,chn_n,samp_n,MARKFINDF));
}

static SCM g_add_mark(SCM samp_n, SCM snd_n, SCM chn_n) 
{
  ERRB1(samp_n,S_add_mark); 
  ERRCP(S_add_mark,snd_n,chn_n,2);
  return(iread_mark(snd_n,chn_n,samp_n,MARKADDF));
}

static SCM g_delete_mark(SCM id_n, SCM snd_n, SCM chn_n) 
{
  ERRB1(id_n,S_delete_mark); 
  ERRCP(S_delete_mark,snd_n,chn_n,2);
  return(iread_mark(snd_n,chn_n,id_n,MARKDELETEF));
}

static SCM g_delete_marks(SCM snd_n, SCM chn_n) 
{
  chan_info *cp;
  ERRCP(S_delete_marks,snd_n,chn_n,1);
  cp = get_cp(snd_n,chn_n);
  if (cp) delete_marks(cp);
  return(SCM_BOOL_F);
}

static SCM g_find_sound(SCM filename)
{
  /* scan active sounds looking for full then partial match, return index if found else nil */
  char *fname = NULL;
  snd_info *sp;
  ERRS1(filename,S_find_sound);
  fname = gh_scm2newstr(filename,NULL);
  sp = find_sound(state,fname);
  if (fname) FREE(fname);
  if (sp) RTNINT(sp->index);
  return(SCM_BOOL_F);
}

static SCM g_set_x_bounds(SCM beg, SCM end, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  float x0,x1;
  ERRN1(beg,S_set_x_bounds);
  ERRN2(end,S_set_x_bounds);
  ERRCP(S_set_x_bounds,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      x0 = gh_scm2double(beg);
      x1 = gh_scm2double(end);
      if (x1 > x0)
	clm_x_axis(cp,x0,x1);
      else make_eval_error(state," (impossible bounds)","");
    }
  return(SCM_BOOL_F);
}

static SCM g_set_y_bounds(SCM y0, SCM y1, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  float low,hi;
  ERRB1(y0,S_set_x_bounds);
  ERRB2(y1,S_set_x_bounds);
  ERRCP(S_set_y_bounds,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      if (gh_number_p(y0))
	{
	  low = gh_scm2double(y0);
	  if (gh_number_p(y1))
	    hi = gh_scm2double(y1);
	  else
	    {
	      if (low < 0.0)
		hi = -low;
	      else
		{
		  hi = low;
		  low = -low;
		}
	    }
	}
      else
	{
	  /* if no bounds given, use maxamp */
	  hi = get_maxamp(cp->state,cp->sound,cp);
	  if (hi < 0.0) hi = -hi;
	  if (hi == 0.0) hi = .001;
	  low = -hi;
	}
      if (hi > low)
	clm_y_axis(cp,low,hi);
      else make_eval_error(state," (impossible bounds)","");
    }
  return(SCM_BOOL_F);
}

static SCM g_set_y_limits(SCM low, SCM high, SCM which_graph, SCM snd_n, SCM chn_n)
{ /* experimental and doesn't work correctly yet */
  chan_info *cp;
  int grf;
  float y0,y1;
  ERRCP(S_set_y_limits,snd_n,chn_n,4);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      grf = gh_scm2int(which_graph);
      y1 = gh_scm2double(high);
      y0 = gh_scm2double(low);
      if (grf == 0)
	clm_y_axis(cp,y0,y1);
      else
	if (grf == 1)
	  set_y_limits(cp,(cp->fft)->axis,y0,y1);
	else set_y_limits(cp,(cp->lisp_info)->axis,y0,y1);
    }
  return(SCM_BOOL_F);
}

static SCM g_x_bounds(SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  axis_info *ap;
  ERRCP(S_x_bounds,snd_n,chn_n,1);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      ap = cp->axis;
      return(gh_cons(gh_double2scm(ap->x0),gh_double2scm(ap->x1)));
    }
  return(SCM_BOOL_F);
}

static SCM g_y_bounds(SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  axis_info *ap;
  ERRCP(S_y_bounds,snd_n,chn_n,1);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      ap = cp->axis;
      return(gh_cons(gh_double2scm(ap->y0),gh_double2scm(ap->y1)));
    }
  return(SCM_BOOL_F);
}

static SCM samples2vct(SCM samp_0, SCM samps, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  int *ivals;
  float *fvals;
  int i,len,beg;
  ERRB1(samp_0,S_samples_vct);
  ERRB2(samps,S_samples_vct);
  ERRCP(S_samples_vct,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      beg = int_or_zero(samp_0);
      if (gh_number_p(samps)) len = gh_scm2int(samps); else len = (current_ed_samples(cp) - beg);
      ivals = load_samples(beg,len,cp);
      fvals = (float *)CALLOC(len,sizeof(float));
      for (i=0;i<len;i++) fvals[i] = SNDLIB_SNDFLT * ivals[i];
      FREE(ivals);
      return(make_vct(len,fvals));
    }
  return(SCM_BOOL_F);
}

static SCM transform_samples2vct(SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  fft_info *fp;
  int i,len;
  float *fvals;
  ERRCP(S_transform_samples_vct,snd_n,chn_n,1);
  cp = get_cp(snd_n,chn_n);
  if ((cp) && (cp->ffting) && (cp->fft) && (!(chan_fft_in_progress(cp))) && (fft_style(state) == NORMAL_FFT))
    {
      fp = cp->fft;
      len = fp->current_size;
      fvals = (float *)CALLOC(len,sizeof(float));
      for (i=0;i<len;i++) fvals[i] = fp->data[i];
      return(make_vct(len,fvals));
    }
  return(SCM_BOOL_F);
}  

static SCM region_samples2vct(SCM beg_n, SCM num, SCM reg_n, SCM chn_n)
{
  float *data;
  int len,reg,chn;
  finish_keyboard_selection();
  ERRB1(beg_n,S_region_samples_vct);
  ERRB2(num,S_region_samples_vct);
  ERRB3(reg_n,S_region_samples_vct);
  ERRB4(chn_n,S_region_samples_vct);
  reg = int_or_zero(reg_n);
  chn = int_or_zero(chn_n);
  if (chn < region_chans(reg))
    {
      len = int_or_zero(num);
      if (len == 0) len = region_len(reg);
      if (len > 0)
	{
	  data = (float *)CALLOC(len,sizeof(float));
	  region_samples(reg,chn,int_or_zero(beg_n),len,data);
	  return(make_vct(len,data));
	}
    }
  else state->eval_error = SND_NO_SUCH_CHANNEL;
  return(SCM_BOOL_F);
}



static SCM vct2soundfile(SCM g_fd, SCM obj, SCM g_nums)
{
  int fd,nums;
  vct *v;
  ERRN1(g_fd,S_vct_sound_file);
  ERRVCT2(obj,S_vct_sound_file);
  ERRN3(g_nums,S_vct_sound_file);
  fd = gh_scm2int(g_fd);
  nums = gh_scm2int(g_nums);
  v = get_vct(obj);
  lseek(fd,0L,SEEK_END);
  nums = write(fd,v->data,nums * 4);
  return(gh_int2scm(nums>>2));
}

int *g_arr2int(SCM obj, int *size)
{
  int *vals = NULL;
  vct *v;
  int i,num = 0;
  if (gh_list_p(obj))
    {
      num = GH_LIST_LENGTH(obj);
      vals = (int *)CALLOC(num,sizeof(int));
      for (i=0;i<num;i++) vals[i] = (int)(SNDLIB_SNDFIX * gh_scm2double(scm_list_ref(obj,gh_int2scm(i))));
    }
  else
    {
      if (gh_vector_p(obj))
	{
	  num = gh_vector_length(obj);
	  vals = (int *)CALLOC(num,sizeof(int));
	  for (i=0;i<num;i++) vals[i] = (int)(SNDLIB_SNDFIX * gh_scm2double(GH_VREF(obj,gh_int2scm(i))));
	}
      else
	{
	  if (vct_p(obj))
	    {
	      v = get_vct(obj);
	      num = v->length;
	      vals = (int *)CALLOC(num,sizeof(int));
	      for (i=0;i<num;i++) vals[i] = (int)(SNDLIB_SNDFIX * v->data[i]);
	    }
	}
    }
  (*size) = num;
  return(vals);
}

static SCM g_sample(SCM samp_n, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  ERRN1(samp_n,S_sample);
  ERRCP(S_sample,snd_n,chn_n,2);
  cp = get_cp(snd_n,chn_n);
  if (cp) RTNFLT(sample(gh_scm2int(samp_n),cp));
  return(SCM_BOOL_F);
}

static void add_zeros(chan_info *cp, int beg, int count)
{
  int *zeros;
  zeros = (int *)CALLOC(count,sizeof(int));
  insert_samples(beg,count,zeros,cp,S_zero_pad);
  check_for_first_edit(cp);
  FREE(zeros);
}

static SCM g_set_sample(SCM samp_n, SCM val, SCM snd_n, SCM chn_n)
{
  /* each call consitutes a separate edit from the undo/redo point-of-view */
  chan_info *cp;
  int curlen,beg;
  int ival[1];
  ERRN1(samp_n,S_set_sample);
  ERRN2(val,S_set_sample);
  ERRCP(S_set_sample,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      curlen = current_ed_samples(cp);
      beg = gh_scm2int(samp_n);
      if (beg >= curlen) add_zeros(cp,curlen-1,beg-curlen+1);
      ival[0] = (int)(SNDLIB_SNDFIX * gh_scm2double(val));
      change_samples(beg,1,ival,cp,LOCK_MIXES,S_set_sample);
      check_for_first_edit(cp);
      update_graph(cp,NULL);
      return(val);
    }
  return(SCM_BOOL_F);
}

static SCM g_samples(SCM samp_0, SCM samps, SCM snd_n, SCM chn_n)
{
  /* return the filled vector for scm to free? */
  chan_info *cp;
  int *ivals;
  int i,len,beg;
  SCM new_vect;
  ERRB1(samp_0,S_samples);
  ERRB2(samps,S_samples);
  ERRCP(S_samples,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      beg = int_or_zero(samp_0);
      if (gh_number_p(samps)) len = gh_scm2int(samps); else len = (current_ed_samples(cp) - beg);
      ivals = load_samples(beg,len,cp);
      new_vect = GH_MAKE_VECTOR(samps,gh_double2scm(0.0));
      for (i=0;i<len;i++)
	GH_VSET(new_vect,gh_int2scm(i),gh_double2scm(SNDLIB_SNDFLT * ivals[i]));
      FREE(ivals);
      return(new_vect);
    }
  return(SCM_BOOL_F);
}

static SCM g_set_samples(SCM samp_0, SCM samps, SCM vect, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  int *ivals;
  int i,len,beg,curlen;
  char *fname;
  vct *v = NULL;
  ERRN1(samp_0,S_set_samples);
  ERRN2(samps,S_set_samples);
  ERRCP(S_set_samples,snd_n,chn_n,4);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      beg = gh_scm2int(samp_0);
      len = gh_scm2int(samps);
      curlen = current_ed_samples(cp);
      if (beg >= curlen) add_zeros(cp,curlen-1,beg-curlen+1);
      if (gh_string_p(vect))
	{
	  fname = gh_scm2newstr(vect,NULL);
	  if ((beg == 0) && (len > curlen))
	    file_override_samples(len,fname,cp,0,DELETE_ME,LOCK_MIXES,S_set_samples);
	  else file_change_samples(beg,len,fname,cp,0,DELETE_ME,LOCK_MIXES,S_set_samples);
	  FREE(fname);
	}
      else
	{
	  ivals = (int *)CALLOC(len,sizeof(int));
	  if (vct_p(vect))
	    {
	      v = get_vct(vect);
	      for (i=0;i<len;i++) ivals[i] = (int)(SNDLIB_SNDFIX * v->data[i]);
	    }
	  else 
	    {
	      if (gh_vector_p(vect))
		for (i=0;i<len;i++) ivals[i] = (int)(SNDLIB_SNDFIX * gh_scm2double(GH_VREF(vect,gh_int2scm(i))));
	      else scm_wrong_type_arg(S_set_samples,3,vect);
	    }
	  change_samples(beg,len,ivals,cp,LOCK_MIXES,S_set_samples);
	  FREE(ivals);
	}
      check_for_first_edit(cp);
      update_graph(cp,NULL);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_set_int_samples(SCM samp_0, SCM samps, SCM origin, SCM vect, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  int *ivals;
  char *str;
  int i,len,beg;
  ERRN1(samp_0,S_set_int_samples);
  ERRN2(samps,S_set_int_samples);
  ERRS3(origin,S_set_int_samples);
  ERRVECT4(vect,S_set_int_samples);
  ERRCP(S_set_int_samples,snd_n,chn_n,5);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      beg = gh_scm2int(samp_0);
      len = gh_scm2int(samps);
      ivals = (int *)CALLOC(len,sizeof(int));
      for (i=0;i<len;i++) ivals[i] = gh_scm2int(GH_VREF(vect,gh_int2scm(i)));
      str = gh_scm2newstr(origin,NULL);
      change_samples(beg,len,ivals,cp,LOCK_MIXES,str);
      FREE(str);
      check_for_first_edit(cp);
      update_graph(cp,NULL);
      FREE(ivals);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_clm_samples(SCM file)
{
  /* if file, find_sound else use currently selected sound.
   * write current contents as temp file
   * return temp file name to clm
   */
  char *filename;
  file_info *hdr;
  snd_info *sp = NULL;
  if (gh_string_p(file))
    {
      filename = gh_scm2newstr(file,NULL);
      sp = find_sound(state,filename);
      FREE(filename);
    }
  if (!sp) sp = any_selected_sound(state);
  if (sp)
    {
      filename = snd_tempnam(state);
      hdr = sp->hdr;
      save_edits_2(sp,filename,hdr->type,hdr->format,hdr->srate,NULL);
      RTNSTR(filename);
    }
  return(SCM_BOOL_F);
}

static SCM g_clm_region(SCM n)
{
  char *filename;
  if (selection_is_current())
    {
      filename = snd_tempnam(state);
      save_region(state,gh_scm2int(n),filename,SNDLIB_NO_SND); /* SNDLIB_NO_SND => use whatever seems best given header type */
      RTNSTR(filename);
    }
  else
    return(SCM_BOOL_F);
}

static SCM g_clm_snd_update(SCM data)
{
  char *file;
  snd_info *sp;
  if (gh_string_p(data))
    {
      file = gh_scm2newstr(data,NULL);
      sp = find_sound(state,file);
      if (sp)
	snd_update(state,sp);
      else snd_open_file(file,state);
      FREE(file);
    }
  return(data);
}

static SCM g_clm_snd_close(SCM data)
{
  char *file;
  snd_info *sp;
  if (gh_string_p(data))
    {
      file = gh_scm2newstr(data,NULL);
      sp = find_sound(state,file);
      if (sp) snd_close_file(sp,state);
      FREE(file);
    }
  return(data);
}

static SCM g_clm_snd_set_samples(SCM samp_0)
{
  chan_info *cp;
  int *ivals;
  int len,beg,curlen;
  cp = current_channel(state);
  if (cp)
    {
      beg = gh_scm2int(samp_0);
      curlen = current_ed_samples(cp);
      if (beg >= curlen) add_zeros(cp,curlen-1,beg-curlen+1);      
      ivals = clm_snd_data(state,&len);
      change_samples(beg,len,ivals,cp,LOCK_MIXES,S_clm_snd_set_samples);
      check_for_first_edit(cp);
      update_graph(cp,NULL);
      FREE(ivals);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_clm_snd_replace_samples(SCM tempf, SCM oldf)
{
  char *tempfile;
  snd_info *sp;
  SCM index;
  tempfile = gh_scm2newstr(tempf,NULL);
  index = g_find_sound(oldf);
  if (gh_number_p(index)) 
    sp = state->sounds[gh_scm2int(index)];
  else sp = any_selected_sound(state);
  clm_snd_replace_samples(state,tempfile,sp);
  FREE(tempfile);
  return(SCM_BOOL_F);
}

static SCM g_clm_snd_samples(SCM sbeg, SCM slen)
{
  int *data;
  int beg,len;
  chan_info *cp;
  beg = gh_scm2int(sbeg);
  len = gh_scm2int(slen);
  cp = current_channel(state);
  if (cp)
    {
      data = load_samples(beg,len,cp);
      snd_clm_data(state,len,data);
      FREE(data);
    }
  return(SCM_BOOL_F);
}

static SCM g_delete_sample(SCM samp_n, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  int samp;
  ERRN1(samp_n,S_delete_sample);
  ERRCP(S_delete_sample,snd_n,chn_n,2);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      samp = gh_scm2int(samp_n);
      if ((samp >= 0) && (samp <= current_ed_samples(cp)))
	{
	  delete_samples(samp,1,cp,S_delete_sample);
	  check_for_first_edit(cp);
	  update_graph(cp,NULL);
	}
      else state->eval_error = SND_NO_SUCH_SAMPLE;
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_delete_samples(SCM samp_n, SCM samps, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  ERRN1(samp_n,S_delete_samples);
  ERRN2(samps,S_delete_samples);
  ERRCP(S_delete_samples,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      delete_samples(gh_scm2int(samp_n),gh_scm2int(samps),cp,S_delete_samples);
      check_for_first_edit(cp);
      update_graph(cp,NULL);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_delete_int_samples(SCM samp_n, SCM samps, SCM origin, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  char *str;
  ERRN1(samp_n,S_delete_int_samples);
  ERRN2(samps,S_delete_int_samples);
  ERRS3(origin,S_delete_int_samples);
  ERRCP(S_delete_int_samples,snd_n,chn_n,4);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      str = gh_scm2newstr(origin,NULL);
      delete_samples(gh_scm2int(samp_n),gh_scm2int(samps),cp,str);
      FREE(str);
      check_for_first_edit(cp);
      update_graph(cp,NULL);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_insert_sample(SCM samp_n, SCM val, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  int beg;
  int ival[1];
  ERRN1(samp_n,S_insert_sample);
  ERRN2(val,S_insert_sample);
  ERRCP(S_insert_sample,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      beg = gh_scm2int(samp_n);
      if (beg >= 0)
	{
	  ival[0] = (int)(SNDLIB_SNDFIX * gh_scm2double(val));
	  insert_samples(gh_scm2int(samp_n),1,ival,cp,S_insert_sample);
	  check_for_first_edit(cp);
	  update_graph(cp,NULL);
	  return(SCM_BOOL_T);
	}
      else state->eval_error = SND_NO_SUCH_SAMPLE;
    }
  return(SCM_BOOL_F);
}

static SCM g_insert_samples(SCM samp, SCM samps, SCM vect, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  int *ivals;
  char *fname;
  int i,beg,len;
  vct *v = NULL;
  ERRN1(samp,S_insert_samples);
  ERRN2(samps,S_insert_samples);
  ERRCP(S_insert_samples,snd_n,chn_n,4);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      beg = gh_scm2int(samp);
      len = gh_scm2int(samps);
      if (gh_string_p(vect))
	{
	  fname = gh_scm2newstr(vect,NULL);
	  file_insert_samples(beg,len,fname,cp,0,DELETE_ME,S_insert_samples);
	  FREE(fname);
	}
      else
	{
	  ivals = (int *)CALLOC(len,sizeof(int));
	  if (vct_p(vect))
	    {
	      v = get_vct(vect);
	      for (i=0;i<len;i++) ivals[i] = (int)(SNDLIB_SNDFIX * v->data[i]);
	    }
	  else
	    {
	      if (gh_vector_p(vect))
		for (i=0;i<len;i++) ivals[i] = (int)(SNDLIB_SNDFIX * gh_scm2double(GH_VREF(vect,gh_int2scm(i))));
	      else scm_wrong_type_arg(S_insert_samples,3,vect);
	    }
	  insert_samples(beg,len,ivals,cp,S_insert_samples);
	  FREE(ivals);
	}
      check_for_first_edit(cp);
      update_graph(cp,NULL);
      RTNINT(len);
    }
  return(SCM_BOOL_F);
}

static SCM g_insert_int_samples(SCM samp, SCM samps, SCM origin, SCM vect, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  int *ivals;
  char *str;
  int i,beg,len;
  ERRN1(samp,S_insert_int_samples);
  ERRN2(samps,S_insert_int_samples);
  ERRS3(origin,S_insert_int_samples);
  ERRVECT4(vect,S_insert_int_samples);
  ERRCP(S_insert_int_samples,snd_n,chn_n,5);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      beg = gh_scm2int(samp);
      len = gh_scm2int(samps);
      ivals = (int *)CALLOC(len,sizeof(int));
      for (i=0;i<len;i++) ivals[i] = gh_scm2int(GH_VREF(vect,gh_int2scm(i)));
      str = gh_scm2newstr(origin,NULL);
      insert_samples(beg,len,ivals,cp,str);
      FREE(str);
      check_for_first_edit(cp);
      update_graph(cp,NULL);
      FREE(ivals);
      RTNINT(len);
    }
  return(SCM_BOOL_F);
}

static SCM g_active_sounds(void)
{
  int i,num;
  num = 0;
  for (i=0;i<state->max_sounds;i++) if (snd_ok(state->sounds[i])) num++;
  RTNINT(num);
}

static SCM g_undo(SCM ed_n, SCM snd_n, SCM chn_n) /* opt ed_n */
{ 
  chan_info *cp;
  ERRCP(S_undo,snd_n,chn_n,2);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      if (gh_number_p(ed_n))
	undo_EDIT(cp,gh_scm2int(ed_n));
      else undo_EDIT(cp,1);
      update_graph(cp,NULL);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_redo(SCM ed_n, SCM snd_n, SCM chn_n) /* opt ed_n */
{ 
  chan_info *cp;
  ERRCP(S_redo,snd_n,chn_n,2);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      if (gh_number_p(ed_n))
	redo_EDIT(cp,gh_scm2int(ed_n));
      else redo_EDIT(cp,1);
      update_graph(cp,NULL);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_insert_region(SCM samp_n, SCM reg_n, SCM snd_n, SCM chn_n) /* opt reg_n */
{ 
  chan_info *cp;
  int rg,samp;
  ERRB1(samp_n,S_insert_region);
  ERRB2(reg_n,S_insert_region);
  ERRCP(S_insert_region,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      finish_keyboard_selection();
      rg = int_or_zero(reg_n);
      if (region_ok(rg))
	{
	  samp = int_or_zero(samp_n);
	  insert_region(rg,samp,cp,S_insert_region);
	  update_graph(cp,NULL);
	}
      else state->eval_error = SND_NO_SUCH_REGION;
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_insert_file(SCM file, SCM file_chn, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  char *filename = NULL;
  int nc,len,fchn;
  ERRS1(file,S_insert_sound);
  ERRB2(file_chn,S_insert_sound);
  ERRCP(S_insert_sound,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      filename = full_filename(file);
      nc = sound_chans(filename);
      if (nc != -1)
	{
	  len = sound_samples(filename)/nc;
	  fchn = int_or_zero(file_chn);
	  if (fchn < sound_chans(filename))
	    {
	      file_insert_samples(0,len,filename,cp,fchn,DONT_DELETE_ME,S_insert_sound);
	      check_for_first_edit(cp);
	      update_graph(cp,NULL);
	      RTNINT(len);
	    }
	}
      else state->eval_error = SND_NO_SUCH_FILE;
    }
  return(SCM_BOOL_F);
}

static SCM g_cut(void)
{ /* weird... */
  finish_keyboard_selection();
  if (region_ok(0))
    {
      delete_selection(S_cut,UPDATE_DISPLAY);
      return(SCM_BOOL_T);
    }
  else state->eval_error = SND_NO_ACTIVE_SELECTION;
  return(SCM_BOOL_F);
}

static SCM g_selected_sound(void)
{
  if ((state->selected_sound != NO_SELECTION) && (snd_ok(state->sounds[state->selected_sound])))
    RTNINT(state->selected_sound);
  return(SCM_BOOL_F);
}

static SCM g_report_in_minibuffer(SCM msg, SCM snd_n)
{
  snd_info *sp;
  char *str;  
  ERRS1(msg,S_report_in_minibuffer);
  ERRSP(S_report_in_minibuffer,snd_n,2);
  sp = get_sp(snd_n);
  if (sp) 
    {
      str = gh_scm2newstr(msg,NULL);
      report_in_minibuffer(sp,str);
      FREE(str);
      return(msg);
    }
  return(SCM_BOOL_F);
}

static SCM g_append_to_minibuffer(SCM msg, SCM snd_n)
{
  snd_info *sp;
  char *str;
  ERRS1(msg,S_append_to_minibuffer);
  ERRSP(S_append_to_minibuffer,snd_n,2);
  sp = get_sp(snd_n);
  if (sp) 
    {
      str = gh_scm2newstr(msg,NULL);
      append_to_minibuffer(sp,str);
      FREE(str);
      return(msg);
    }
  return(SCM_BOOL_F);
}

static SCM g_open(SCM filename)
{ /* returns index of new sound if successful */
  char *fname;
  snd_info *sp;
  ERRS1(filename,S_open_sound);
  fname = full_filename(filename);
  sp = snd_open_file(fname,state);
  if (sp) RTNINT(sp->index);
  return(SCM_BOOL_F);
}

static SCM g_open_raw_sound(SCM filename, SCM chans, SCM srate, SCM format)
{
  char *fname;
  snd_info *sp;
  int os,oc,ofr,ou,ofit;
  ERRS1(filename,S_open_raw_sound);
  ERRN2(srate,S_open_raw_sound);
  ERRN3(chans,S_open_raw_sound);
  ERRN4(format,S_open_raw_sound);
  ou=use_raw_defaults(state);
  os=raw_srate(state);
  oc=raw_chans(state);
  ofr=raw_format(state);
  ofit=fit_data_on_open(state);
  set_raw_srate(state,gh_scm2int(srate));
  set_raw_chans(state,gh_scm2int(chans));
  set_raw_format(state,gh_scm2int(format));
  set_use_raw_defaults(state,1);
  set_fit_data_on_open(state,1);
  mus_set_raw_header_defaults(gh_scm2int(srate),gh_scm2int(chans),gh_scm2int(format));
  fname = full_filename(filename);
  sp = snd_open_file(fname,state);
  set_raw_srate(state,os);
  set_raw_chans(state,oc);
  set_raw_format(state,ofr);
  set_use_raw_defaults(state,ou);
  set_fit_data_on_open(state,ofit);
  if (sp) RTNINT(sp->index);
  return(SCM_BOOL_F);
}

static SCM g_open_alternate(SCM filename)
{ /* returns index of new sound if successful */
  char *fname;
  snd_info *sp;
  ERRS1(filename,S_open_alternate_sound);
  sp = any_selected_sound(state);
  if (sp) snd_close_file(sp,state); /* should we ask about saving edits here? */
  fname = full_filename(filename);
  sp = snd_open_file(fname,state);
  if (sp) RTNINT(sp->index);
  return(SCM_BOOL_F);
}

static SCM g_view(SCM filename)
{
  char *fname;
  snd_info *sp;
  ERRS1(filename,S_view_sound);
  fname = full_filename(filename);
  state->viewing = 1;
  sp = snd_open_file(fname,state);
  state->viewing = 0;
  if (sp) RTNINT(sp->index);
  return(SCM_BOOL_F);
}

static SCM g_save_as(SCM newfile, SCM index, SCM type, SCM format, SCM srate)
{ 
  snd_info *sp;
  file_info *hdr;
  int ht,df,sr;
  char *fname;
  ERRS1(newfile,S_save_sound_as);
  sp = get_sp(index);
  if (sp)
    {
      fname = full_filename(newfile);
      hdr = sp->hdr;
      if (gh_number_p(type)) ht = gh_scm2int(type); else ht = hdr->type;
      if (gh_number_p(srate)) sr = gh_scm2int(srate); else sr = hdr->srate;
      if (gh_number_p(format)) 
	df = gh_scm2int(format);
      else
	{
	  if (mus_header_writable(ht,hdr->format))
	    df = hdr->format;
	  else
	    {
	      if (ht == RIFF_sound_file)
		df = SNDLIB_16_LINEAR_LITTLE_ENDIAN;
	      else df = SNDLIB_16_LINEAR;
	    }
	}
      save_edits_2(sp,fname,ht,df,sr,NULL); /* last arg is comment */
      return(newfile);
    }
  return(SCM_BOOL_F);
}

static SCM g_revert(SCM index)
{ 
  snd_info *sp;
  int i;
  sp = get_sp(index);
  if (sp)
    {
      for (i=0;i<sp->nchans;i++) 
	{
	  revert_edits(sp->chans[i],NULL); 
	  update_graph(sp->chans[i],NULL);
	}
      reflect_file_revert_in_label(sp);
      reflect_file_revert_in_menu(state);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_new_file(SCM name, SCM type, SCM format, SCM srate, SCM chans) 
{
  snd_info *sp; 
  int ht,df,sr,ch;
  char *str = NULL;
  ERRS1(name,S_new_sound);
  str = full_filename(name);
  if ((!(gh_number_p(type))) || (gh_scm2int(type) == unsupported_sound_file))
    sp = snd_new_file(state,str,unsupported_sound_file,SNDLIB_UNSUPPORTED,0,0);
  else 
    {
      ht = gh_scm2int(type);
      if (gh_number_p(format))
	df = gh_scm2int(format);
      else
	{
	  if (ht == RIFF_sound_file)
	    df = SNDLIB_16_LINEAR_LITTLE_ENDIAN;
	  else df = SNDLIB_16_LINEAR;
	}
      if (gh_number_p(srate))
	sr = gh_scm2int(srate);
      else sr = 22050;
      if (gh_number_p(chans))
	ch = gh_scm2int(chans);
      else ch = 1;
      sp = snd_new_file(state,str,ht,df,sr,ch);
    }
  if (sp) RTNINT(sp->index);
  return(SCM_BOOL_F);
}

static SCM g_play_1(SCM samp_n, SCM snd_n, SCM chn_n, int background) /* all chans if chn_n omitted, arbitrary file if snd_n is name */
{
  snd_info *sp;
  chan_info *cp;
  char *name = NULL;
  int samp = 0;
  if (gh_string_p(samp_n))
    {
      name = full_filename(samp_n);
      sp = make_sound_readable(state,name,FALSE);
      if (sp)
	{
	  sp->shortname = filename_without_home_directory(name);
	  sp->fullname = NULL;
	  sp->delete_me = 1;
	  if (background)
	    start_playing(sp,0);
	  else play_to_end(sp,0);
	  return(SCM_BOOL_T);
	}
    }
  else
    {
      ERRB1(samp_n,S_play);
      ERRCP(S_play,snd_n,chn_n,2);
      sp = get_sp(snd_n);
      if (sp)
	{
	  if (gh_number_p(samp_n)) samp = gh_scm2int(samp_n);
	  if (!(gh_number_p(chn_n)))
	    {
	      if (background)
		start_playing(sp,samp);
	      else play_to_end(sp,samp);
	    }
	  else 
	    {
	      cp = get_cp(snd_n,chn_n);
	      if (cp) 
		{
		  if (background)
		    start_playing(cp,samp);
		  play_to_end(cp,samp);
		}
	    }
	  return(SCM_BOOL_T);
	}
    }
  return(SCM_BOOL_F);
}

static SCM g_play(SCM samp_n, SCM snd_n, SCM chn_n) {return(g_play_1(samp_n,snd_n,chn_n,TRUE));}
static SCM g_play_and_wait(SCM samp_n, SCM snd_n, SCM chn_n) {return(g_play_1(samp_n,snd_n,chn_n,FALSE));}

static SCM g_stop_playing(SCM snd_n)
{
  snd_info *sp;
  ERRSP(S_stop_playing,snd_n,1);
  sp = get_sp(snd_n);
  if (sp) stop_playing_sound(sp);
  return(SCM_BOOL_F);
}

void add_or_edit_symbol(char *name, env *val)
{
  /* called from envelope editor -- pass new definition into scheme */
  SCM e;
  char *buf,*tmpstr=NULL;
  buf = (char *)CALLOC(256,sizeof(char));
  e = GH_LOOKUP(name);
  if ((e) && (e != SCM_BOOL_F) && (e != SCM_UNDEFINED) && (gh_list_p(e)))
    sprintf(buf,"(set! %s %s)",name,tmpstr=env_to_string(val));
  else sprintf(buf,"(define %s %s)",name,tmpstr=env_to_string(val));
  scm_internal_stack_catch(SCM_BOOL_T,eval_str_wrapper,buf,clm_handler,buf);
  FREE(buf);
  if (tmpstr) FREE(tmpstr);
}

static env *scm2env(SCM res)
{
  SCM el;
  int i,len;
  float *data;
  env *rtn = NULL;
  if (gh_list_p(res))
    {
      len = GH_LIST_LENGTH(res);
      if (len > 0)
	{
	  data = (float *)CALLOC(len,sizeof(float));
	  for (i=0;i<len;i++)
	    {
	      el = scm_list_ref(res,gh_int2scm(i));
	      if (gh_number_p(el))
		data[i] = gh_scm2double(el);
	      else data[i] = 0.0;
	    }
	  rtn = make_envelope(data,len);
	  FREE(data);
	}
      return(rtn);
    }
  return(NULL);
}

env *name_to_env(char *str)
{
  /* called to see if str is a known envelope -- return its current value or nil if unknown */
  /* get str as list var and turn into env */
  return(scm2env(GH_LOOKUP(str)));
}

static SCM g_save_defvar(SCM a, SCM b)
{
  char *name;
  name = gh_scm2newstr(a,0);
  gh_define(name,b);
  if (gh_list_p(b)) alert_envelope_editor(state,name,scm2env(b));
  return(SCM_BOOL_F);
}

static SCM g_set_env_base(SCM name, SCM val) 
{
  char *urn = NULL;
  int rtnval;
  ERRS1(name,S_set_env_base);
  ERRN2(val,S_set_env_base);
  urn = gh_scm2newstr(name,NULL);
  rtnval = set_env_base(urn,gh_scm2double(val));
  FREE(urn);
  RTNINT(rtnval);
}

static SCM g_update_graph(SCM snd, SCM chn) 
{
  chan_info *cp;
  ERRCP(S_update_graph,snd,chn,1); 
  cp = get_cp(snd,chn);
  if (cp) update_graph(cp,NULL); 
  return(SCM_BOOL_F);
}

static SCM g_update_fft(SCM snd, SCM chn) 
{
  chan_info *cp;
  ERRCP(S_update_fft,snd,chn,1); 
  cp = get_cp(snd,chn);
  if (cp) calculate_fft(cp,NULL); 
  return(SCM_BOOL_F);
}

enum {REGION_LENGTH,REGION_SRATE,REGION_CHANS,REGION_MAXAMP,REGION_SELECT,REGION_DELETE,REGION_PLAY};

static SCM region_read(int field, SCM n)
{
  int rg;
  rg = int_or_zero(n);
  if (region_ok(rg))
    {
      switch (field)
	{
	case REGION_LENGTH: RTNINT(region_len(rg)); break;
	case REGION_SRATE:  RTNINT(region_srate(rg)); break;
	case REGION_CHANS:  RTNINT(region_chans(rg)); break;
	case REGION_MAXAMP: RTNFLT(region_maxamp(rg)); break;
	case REGION_SELECT: select_region_and_update_browser(state,rg); return(n); break;
	case REGION_DELETE: delete_region_and_update_browser(state,rg); return(n); break;
	case REGION_PLAY:   play_region(state,rg,NULL); return(n); break;
	}
    }
  else state->eval_error = SND_NO_SUCH_REGION;
  RTNINT(0);
}

static SCM g_region_length (SCM n) {ERRB1(n,S_region_length); return(region_read(REGION_LENGTH,n));}
static SCM g_region_srate (SCM n) {ERRB1(n,S_region_srate); return(region_read(REGION_SRATE,n));}
static SCM g_region_chans (SCM n) {ERRB1(n,S_region_chans); return(region_read(REGION_CHANS,n));}
static SCM g_region_maxamp (SCM n) {ERRB1(n,S_region_maxamp); return(region_read(REGION_MAXAMP,n));}
static SCM g_select_region (SCM n) {ERRB1(n,S_select_region); return(region_read(REGION_SELECT,n));}
static SCM g_delete_region (SCM n) {ERRB1(n,S_delete_region); return(region_read(REGION_DELETE,n));}
static SCM g_play_region (SCM n) {ERRB1(n,S_play_region); return(region_read(REGION_PLAY,n));}

static SCM g_protect_region (SCM n, SCM protect) 
{
  ERRN1(n,S_protect_region);
  ERRN2(protect,S_protect_region);
  set_region_protect(gh_scm2int(n),gh_scm2int(protect)); 
  return(protect);
}

static SCM g_regions(void) {RTNINT(snd_regions());}

static SCM g_make_region (SCM beg, SCM end, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  ERRN1(beg,S_make_region);
  ERRN2(end,S_make_region);
  ERRCP(S_make_region,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) {define_region(cp,gh_scm2int(beg),gh_scm2int(end),FALSE); return(SCM_BOOL_T);}
  return(SCM_BOOL_F);
}

static SCM g_selection_beg(void)
{
  if (selection_is_current())
    return(gh_int2scm(selection_beg(NULL)));
  return(SCM_BOOL_F);
}

static SCM g_selection_length(void)
{
  if (selection_is_current())
    return(gh_int2scm(region_len(0)));
  return(SCM_BOOL_F);
}

static SCM g_selection_member(SCM snd, SCM chn)
{
  chan_info *cp;
  ERRCP(S_selection_member,snd,chn,1);
  cp = get_cp(snd,chn);
  if ((cp) && (selection_is_current_in_channel(cp)))
    return(SCM_BOOL_T);
  return(SCM_BOOL_F);
}

static SCM g_select_all (SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  ERRCP(S_select_all,snd_n,chn_n,1);
  cp = get_cp(snd_n,chn_n);
  if (cp) {define_region(cp,0,current_ed_samples(cp),FALSE); return(SCM_BOOL_T);}
  return(SCM_BOOL_F);
}

static SCM g_save_region (SCM n, SCM filename, SCM format) 
{
  char *name;
  int res,rg;
  ERRN1(n,S_save_region);
  ERRS2(filename,S_save_region);
  ERRB3(format,S_save_region);
  rg = gh_scm2int(n);
  if (region_ok(rg))
    {
      name = full_filename(filename);
      res = save_region(state,rg,name,int_or_zero(format));
    }
  else state->eval_error = SND_NO_SUCH_REGION;
  if (res != SND_NO_ERROR)
    return(SCM_BOOL_F);
  return(SCM_BOOL_T);
}

static SCM g_mix_region(SCM chn_samp_n, SCM scaler, SCM reg_n, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  int rg;
  ERRB1(chn_samp_n,S_mix_region);
  ERRB2(scaler,S_mix_region);
  ERRB3(reg_n,S_mix_region);
  ERRCP(S_mix_region,snd_n,chn_n,4);
  rg = int_or_zero(reg_n);
  if (region_ok(rg))
    {
      cp = get_cp(snd_n,chn_n);
      if (cp)
	mix_region(rg,cp,
		   (gh_number_p(chn_samp_n) ? (gh_scm2int(chn_samp_n)) : (cp->cursor)),
		   (gh_number_p(scaler) ? (gh_scm2double(scaler)) : 1.0));
      else state->eval_error = SND_NO_SUCH_CHANNEL;
    }
  else state->eval_error = SND_NO_SUCH_REGION;
  return(SCM_BOOL_F);
}

static SCM g_region_sample(SCM samp_n, SCM reg_n, SCM chn_n)
{
  ERRB1(samp_n,S_region_sample);
  ERRB2(reg_n,S_region_sample);
  ERRB3(chn_n,S_region_sample);
  finish_keyboard_selection();
  RTNFLT(region_sample(int_or_zero(reg_n),int_or_zero(chn_n),int_or_zero(samp_n)));
}

static SCM g_region_samples(SCM beg_n, SCM num, SCM reg_n, SCM chn_n)
{
  SCM new_vect;
  float *data;
  int len,reg,i,chn;
  ERRB1(beg_n,S_region_samples);
  ERRB2(num,S_region_samples);
  ERRB3(reg_n,S_region_samples);
  ERRB4(chn_n,S_region_samples);
  finish_keyboard_selection();
  reg = int_or_zero(reg_n);
  chn = int_or_zero(chn_n);
  if (chn < region_chans(reg))
    {
      len = int_or_zero(num);
      if (len == 0) len = region_len(reg);
      if (len > 0)
	{
	  new_vect = GH_MAKE_VECTOR(gh_int2scm(len),gh_double2scm(0.0));
	  data = (float *)CALLOC(len,sizeof(float));
	  region_samples(reg,chn,int_or_zero(beg_n),len,data);
	  for (i=0;i<len;i++) GH_VSET(new_vect,gh_int2scm(i),gh_double2scm(data[i]));
	  FREE(data);
	  return(new_vect);
	}
    }
  else state->eval_error = SND_NO_SUCH_CHANNEL;
  return(SCM_BOOL_F);
}

static SCM g_group_ok(SCM n)
{
  if ((gh_number_p(n)) && (group_ok(state,gh_scm2int(n)))) return(SCM_BOOL_T);
  return(SCM_BOOL_F);
}

static SCM g_groups(void) {RTNINT(active_groups(state));}


static SCM g_transform_sample(SCM bin, SCM slice, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  fft_info *fp;
  sono_info *si;
  int fbin,fslice;
  ERRB1(bin,S_transform_sample);
  ERRB2(slice,S_transform_sample);
  ERRCP(S_transform_sample,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if ((cp) && (cp->ffting) && (!(chan_fft_in_progress(cp))))
    {
      fbin = int_or_zero(bin);
      fp = cp->fft;
      if ((fp) && (fbin < fp->current_size))
	{
	  if (fft_style(state) == NORMAL_FFT)
	    RTNFLT(fp->data[fbin]);
	  else 
	    {
	      fslice = int_or_zero(slice);
	      si = (sono_info *)(cp->sonogram_data);
	      if ((si) && (fbin < si->target_bins) && (fslice < si->active_slices))
		RTNFLT(si->data[fslice][fbin]);
	      else state->eval_error = SND_NO_SUCH_SAMPLE;
	    }
	}
    }
  return(SCM_BOOL_F);
}  

static SCM g_transform_samples(SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  fft_info *fp;
  sono_info *si;
  int bins,slices,i,j,len;
  SCM new_vect,tmp_vect;
  ERRCP(S_transform_samples,snd_n,chn_n,1);
  cp = get_cp(snd_n,chn_n);
  if ((cp) && (cp->ffting) && (!(chan_fft_in_progress(cp))))
    {
      fp = cp->fft;
      if (fp)
	{
	  bins = fp->current_size;
	  if (fft_style(state) == NORMAL_FFT)
	    {
	      len = fp->current_size;
	      new_vect = GH_MAKE_VECTOR(gh_int2scm(len),gh_double2scm(0.0));
	      for (i=0;i<len;i++) GH_VSET(new_vect,gh_int2scm(i),gh_double2scm(fp->data[i]));
	      return(new_vect);
	    }

	  else 
	    {
	      si = (sono_info *)(cp->sonogram_data);
	      if (si)
		{
		  slices = si->active_slices;
		  bins = si->target_bins;
		  new_vect = GH_MAKE_VECTOR(gh_int2scm(slices),gh_double2scm(0.0));
		  for (i=0;i<slices;i++)
		    {
		      tmp_vect = GH_MAKE_VECTOR(gh_int2scm(bins),gh_double2scm(0.0));
		      GH_VSET(new_vect,gh_int2scm(i),tmp_vect);
		      for (j=0;j<bins;j++)
			GH_VSET(tmp_vect,gh_int2scm(j),gh_double2scm(si->data[i][j]));
		    }
		  return(new_vect);
		}
	    }
	}
    }
  return(SCM_BOOL_F);
}  

static SCM g_forward_graph(SCM count) 
{
  SCM val; 
  chan_info *cp;
  ERRB1(count,S_forward_graph);
  cp = current_channel(state);
  if (cp) goto_next_graph(cp,val = int_or_one(count)); 
  RTNINT(val);
}

static SCM g_backward_graph(SCM count) 
{
  SCM val;
  chan_info *cp;
  ERRB1(count,S_backward_graph);
  cp = current_channel(state);
  if (cp) goto_previous_graph(cp,val = -(int_or_one(count)));
  RTNINT(val);
}

static SCM g_forward_mark(SCM count) 
{
  SCM val; 
  chan_info *cp;
  ERRB1(count,S_forward_mark);
  cp = current_channel(state);
  if (cp) handle_cursor(cp,goto_mark(cp,val = int_or_one(count))); 
  RTNINT(val);
}

static SCM g_backward_mark(SCM count) 
{
  SCM val; 
  chan_info *cp;
  ERRB1(count,S_backward_mark);
  cp = current_channel(state);
  if (cp) handle_cursor(cp,goto_mark(cp,val = -(int_or_one(count)))); 
  RTNINT(val);
}

static SCM g_forward_mix(SCM count) 
{
  SCM val;
  chan_info *cp;
  ERRB1(count,S_forward_mix); 
  cp = current_channel(state);
  handle_cursor(cp,goto_mix(cp,val = int_or_one(count))); 
  RTNINT(val);
}

static SCM g_backward_mix(SCM count) 
{
  SCM val; 
  chan_info *cp;
  ERRB1(count,S_backward_mix); 
  cp = current_channel(state);
  if (cp) handle_cursor(cp,goto_mix(cp,val = -(int_or_one(count)))); 
  RTNINT(val);
}

static SCM g_forward_sample(SCM count) 
{
  chan_info *cp;
  ERRB1(count,S_forward_sample); 
  cp = current_channel(state);
  if (cp) 
    {
      handle_cursor(cp,cursor_move(cp,int_or_one(count))); 
      RTNINT(cp->cursor);
    }
  return(SCM_BOOL_F);
}

static SCM g_backward_sample(SCM count) 
{
  chan_info *cp;
  ERRB1(count,S_backward_sample); 
  cp = current_channel(state);
  if (cp) 
    {
      handle_cursor(cp,cursor_move(cp,-(int_or_one(count)))); 
      RTNINT(cp->cursor);
    }
  return(SCM_BOOL_F);
}

static float *load_floats(SCM scalers, int *result_len)
{
  int len,i;
  float *scls;
  if (gh_vector_p(scalers))
    len = gh_vector_length(scalers);
  else
    if (gh_list_p(scalers))
      len = GH_LIST_LENGTH(scalers);
    else len = 1;
  if (len<=0) len=1;
  scls = (float *)CALLOC(len,sizeof(float));
  if (gh_vector_p(scalers))
    {
      for (i=0;i<len;i++) scls[i] = (float)gh_scm2double(GH_VREF(scalers,gh_int2scm(i)));
    }
  else
    if (gh_list_p(scalers))
      {
	for (i=0;i<len;i++) scls[i] = (float)gh_scm2double(scm_list_ref(scalers,gh_int2scm(i)));
      }
    else
      if (gh_number_p(scalers))
	scls[0] = (float)gh_scm2double(scalers);
      else scls[0] = 1.0;
  result_len[0] = len;
  return(scls);
}

static SCM g_scale_to(SCM scalers, SCM snd_n, SCM chn_n)
{
  /* chn_n irrelevant if syncing */
  snd_info *sp;
  chan_info *cp;
  int len[1];
  float *scls;
  ERRCP(S_scale_to,snd_n,chn_n,2);
  sp = get_sp(snd_n);
  if (sp)
    {
      cp = get_cp(snd_n,chn_n);
      if (cp)
	{
	  scls = load_floats(scalers,len);
	  scale_to(state,sp,cp,scls,len[0],FALSE); /* last arg for selection */
	  FREE(scls);
	}
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_scale_by(SCM scalers, SCM snd_n, SCM chn_n)
{
  /* chn_n irrelevant if syncing */
  snd_info *sp;
  chan_info *cp;
  int len[1];
  float *scls;
  ERRCP(S_scale_by,snd_n,chn_n,2);
  sp = get_sp(snd_n);
  if (sp)
    {
      cp = get_cp(snd_n,chn_n);
      if (cp)
	{
	  scls = load_floats(scalers,len);
	  scale_by(state,sp,cp,scls,len[0],FALSE);
	  FREE(scls);
	}
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_scale_selection_to(SCM scalers)
{
  int len[1];
  float *scls;
  if (region_ok(0))
    {
      scls = load_floats(scalers,len);
      scale_to(state,NULL,NULL,scls,len[0],TRUE);
      FREE(scls);
      return(SCM_BOOL_T);
    }
  else state->eval_error = SND_NO_ACTIVE_SELECTION;
  return(SCM_BOOL_F);
}

static SCM g_scale_selection_by(SCM scalers)
{
  int len[1];
  float *scls;
  if (region_ok(0))
    {
      scls = load_floats(scalers,len);
      scale_by(state,NULL,NULL,scls,len[0],TRUE);
      FREE(scls);
      return(SCM_BOOL_T);
    }
  else state->eval_error = SND_NO_ACTIVE_SELECTION;
  return(SCM_BOOL_F);
}

static SCM g_preload_directory(SCM directory) 
{
  char *str;
  ERRS1(directory,S_preload_directory);
  str = gh_scm2newstr(directory,NULL);
  if (str) add_directory_to_prevlist(state,str);
  FREE(str);
  return(SCM_BOOL_F);
}

static SCM g_preload_file(SCM file) 
{
  char *name;
  ERRS1(file,S_preload_file);
  name = full_filename(file);
  remember_me(state,filename_without_home_directory(name),name);
  return(SCM_BOOL_F);
}

static SCM g_mix_position(SCM n) {ERRB1(n,S_mix_position); RTNINT(mix_position(state,int_or_zero(n)));}
static SCM g_mix_length(SCM n) {ERRB1(n,S_mix_length); RTNINT(mix_length(state,int_or_zero(n)));}
static SCM g_mix_anchor(SCM n) {ERRB1(n,S_mix_anchor); RTNINT(mix_anchor(state,int_or_zero(n)));}
static SCM g_mix_groups(SCM n) {ERRB1(n,S_mix_groups); RTNINT(mix_groups(state,int_or_zero(n)));}
static SCM g_mix_state(SCM n) {ERRB1(n,S_mix_state); RTNINT(in_mix_state(state,int_or_zero(n)));}
static SCM g_mix_speed(SCM n) {ERRB1(n,S_mix_speed); RTNFLT(in_mix_speed(state,int_or_zero(n)));}
static SCM g_mix_amp(SCM n, SCM chan) 
{
  ERRB1(n,S_mix_amp);
  ERRB2(chan,S_mix_amp);
  RTNFLT(in_mix_amp(state,int_or_zero(n),int_or_zero(chan)));
}

static SCM g_set_mix_position(SCM n, SCM val) 
{
  ERRN1(n,S_set_mix_position);
  ERRN2(val,S_set_mix_position);
  RTNINT(set_mix_position(state,gh_scm2int(n),gh_scm2int(val)));
}

static SCM g_set_mix_length(SCM n, SCM val) 
{
  ERRN1(n,S_set_mix_length);
  ERRN2(val,S_set_mix_length);
  RTNINT(set_mix_length(state,gh_scm2int(n),gh_scm2int(val)));
}

static SCM g_set_mix_anchor(SCM n, SCM val) 
{
  ERRN1(n,S_set_mix_anchor);
  ERRN2(val,S_set_mix_anchor);
  RTNINT(set_mix_anchor(state,gh_scm2int(n),gh_scm2int(val)));
}

static SCM g_set_mix_groups(SCM n, SCM val) 
{
  ERRN1(n,S_set_mix_groups);
  ERRN2(val,S_set_mix_groups);
  RTNINT(set_mix_groups(state,gh_scm2int(n),gh_scm2int(val)));
}

static SCM g_set_mix_state(SCM n, SCM val) 
{
  ERRN1(n,S_set_mix_state);
  ERRN2(val,S_set_mix_state);
  RTNINT(in_set_mix_state(state,gh_scm2int(n),gh_scm2int(val)));
}

static SCM g_set_mix_speed(SCM n, SCM val) 
{
  ERRN1(n,S_set_mix_speed);
  ERRN2(val,S_set_mix_speed);
  RTNFLT(in_set_mix_speed(state,gh_scm2int(n),gh_scm2double(val)));
}

static SCM g_set_mix_amp(SCM n, SCM chan, SCM val) 
{
  ERRN1(n,S_set_mix_amp);
  ERRN2(chan,S_set_mix_amp);
  ERRN3(val,S_set_mix_amp);
  RTNFLT(in_set_mix_amp(state,gh_scm2int(n),gh_scm2int(chan),gh_scm2double(val)));
}

static SCM g_group_tempo(SCM n) {ERRB1(n,S_group_tempo); RTNFLT(mx_get_group_tempo(state,int_or_zero(n)));}
static SCM g_group_speed(SCM n) {ERRB1(n,S_group_speed); RTNFLT(mx_get_group_speed(state,int_or_zero(n)));}
static SCM g_group_beg(SCM n) {ERRB1(n,S_group_beg); RTNFLT(mx_get_group_beg(state,int_or_zero(n)));}
static SCM g_group_end(SCM n) {ERRB1(n,S_group_end); RTNFLT(mx_get_group_end(state,int_or_zero(n)));}
static SCM g_group_amp(SCM n, SCM row) 
{
  ERRB1(n,S_group_amp);
  ERRB2(row,S_group_amp);
  RTNFLT(mx_get_group_amp(state,int_or_zero(n),int_or_zero(row)));
}

static SCM g_set_group_tempo(SCM n, SCM val) 
{
  ERRN1(n,S_set_group_tempo);
  ERRN2(val,S_set_group_tempo);
  mx_set_group_tempo(state,gh_scm2int(n),gh_scm2double(val));
  return(val);
}

static SCM g_set_group_speed(SCM n, SCM val) 
{
  ERRN1(n,S_set_group_speed);
  ERRN2(val,S_set_group_speed);
  mx_set_group_speed(state,gh_scm2int(n),gh_scm2double(val)); 
  return(val);
}

static SCM g_set_group_beg(SCM n, SCM val) 
{
  ERRN1(n,S_set_group_beg);
  ERRN2(val,S_set_group_beg);
  mx_set_group_beg(state,gh_scm2int(n),gh_scm2double(val)); 
  return(val);
}

static SCM g_set_group_end(SCM n, SCM val) 
{
  ERRN1(n,S_set_group_end);
  ERRN2(val,S_set_group_end);
  mx_set_group_end(state,gh_scm2int(n),gh_scm2double(val)); 
  return(val);
}

static SCM g_set_group_amp(SCM n, SCM row, SCM val) 
{
  ERRN1(n,S_set_group_amp);
  ERRN2(row,S_set_group_amp);
  ERRN3(val,S_set_group_amp);
  mx_set_group_amp(state,gh_scm2int(n),gh_scm2int(row),gh_scm2double(val)); 
  return(val);
}


static SCM g_help_dialog(SCM subject, SCM msg)
{
  char *nmsg,*nsubj;
  ERRS1(subject,S_help_dialog);
  ERRS2(msg,S_help_dialog);
  nsubj = gh_scm2newstr(subject,NULL);
  nmsg = gh_scm2newstr(msg,NULL);
  snd_help(state,nsubj,nmsg);
  FREE(nsubj);
  FREE(nmsg);
  return(SCM_BOOL_F);
}

static SCM g_enved_dialog(void) {create_envelope_editor(state); return(SCM_BOOL_F);}
static SCM g_color_dialog(void) {start_color_dialog(state,0,0); return(SCM_BOOL_F);}
static SCM g_orientation_dialog(void) {start_orientation_dialog(state,0,0); return(SCM_BOOL_F);}
static SCM g_transform_dialog(void) {fire_up_transform_dialog(state); return(SCM_BOOL_F);}
static SCM g_file_dialog(void) {start_file_dialog(state,0,0); return(SCM_BOOL_F);}
static SCM g_region_dialog(void) {if (snd_regions() > 0) View_Region_Callback(main_PANE(state),(XtPointer)state,NULL); return(SCM_BOOL_F);}
static SCM g_edit_header_dialog(SCM snd_n) {snd_info *sp; sp = get_sp(snd_n); if (sp) edit_header(sp); return(SCM_BOOL_F);}
static SCM g_record_dialog(void) {snd_record_file(state); return(SCM_BOOL_F);}
static SCM g_group_dialog(void) {fire_up_group_browser(state); return(SCM_BOOL_F);}
static SCM g_clm_dialog(SCM msg) {start_clm_dialog(state,gh_scm2newstr(msg,NULL),NULL); return(SCM_BOOL_F);}
static SCM g_yes_or_no_p(SCM msg) {RTNBOOL(snd_yes_or_no_p(state,gh_scm2newstr(msg,NULL)));}

#if (XmVERSION == 1)
static SCM g_show_edit_history(void) {RTNBOOL(show_edit_history(state));}
static SCM g_set_show_edit_history(SCM on) {ERRB1(on,S_set_show_edit_history); edit_history(state,bool_int_or_one(on)); return(on);}
#endif

#if (HAVE_OSS || HAVE_ALSA)
static SCM g_clear_audio_inputs (void) 
{
  clear_soundcard_inputs(); 
  return(SCM_BOOL_F);
}

void set_dsp_reset(int val);
static SCM g_set_dsp_reset(SCM val) {set_dsp_reset(gh_scm2int(val)); return(val);}

static SCM g_dsp_devices(SCM cards, SCM dsps, SCM mixers)
{
  int i,ncards;
  int *gdsps,*gmixers;
  SCM_ASSERT((gh_number_p(cards)),cards,SCM_ARG1,S_dsp_devices);
  SCM_ASSERT((gh_vector_p(dsps)),dsps,SCM_ARG2,S_dsp_devices);
  SCM_ASSERT((gh_vector_p(mixers)),mixers,SCM_ARG3,S_dsp_devices);
  ncards = gh_scm2int(cards);
  gdsps = (int *)CALLOC(ncards,sizeof(int));
  gmixers = (int *)CALLOC(ncards,sizeof(int));
  dsp_devices(ncards,gdsps,gmixers);
  for (i=0;i<ncards;i++)
    {
      GH_VSET(dsps,gh_int2scm(i),gh_int2scm(gdsps[i]));
      GH_VSET(mixers,gh_int2scm(i),gh_int2scm(gmixers[i]));
    }
  FREE(gdsps);
  FREE(gmixers);
  return(cards);
}
  
static SCM g_set_dsp_devices(SCM cards, SCM dsps, SCM mixers)
{
  int i,ncards;
  int *gdsps,*gmixers;
  SCM_ASSERT((gh_number_p(cards)),cards,SCM_ARG1,S_dsp_devices);
  SCM_ASSERT((gh_vector_p(dsps)),dsps,SCM_ARG2,S_dsp_devices);
  SCM_ASSERT((gh_vector_p(mixers)),mixers,SCM_ARG3,S_dsp_devices);
  ncards = gh_scm2int(cards);
  gdsps = (int *)CALLOC(ncards,sizeof(int));
  gmixers = (int *)CALLOC(ncards,sizeof(int));
  for (i=0;i<ncards;i++)
    {
      gdsps[i] = GH_VREF(dsps,gh_int2scm(i));
      gmixers[i] = GH_VREF(mixers,gh_int2scm(i));
    }
  set_dsp_devices(ncards,gdsps,gmixers);
  FREE(gdsps);
  FREE(gmixers);
  return(cards);
}
  
#endif

static env *get_env(SCM e, SCM base, char *origin) /* list or vector in e */
{
  float *buf = NULL;
  int i,len;
  env *newenv;
  SCM_ASSERT(((gh_vector_p(e)) || (gh_list_p(e))),e,SCM_ARG1,origin);
  if (gh_vector_p(e))
    {
      len = gh_vector_length(e);
      buf = (float *)CALLOC(len,sizeof(float));
      for (i=0;i<len;i++) buf[i] = gh_scm2double(GH_VREF(e,gh_int2scm(i)));
    }
  else
    if (gh_list_p(e))
      {
	len = GH_LIST_LENGTH(e);
	buf = (float *)CALLOC(len,sizeof(float));
        for (i=0;i<len;i++) buf[i] = gh_scm2double(scm_list_ref(e,gh_int2scm(i)));
      }
    else return(NULL);
  newenv = make_envelope(buf,len);
  if (gh_number_p(base)) newenv->base = gh_scm2double(base); else newenv->base = 1.0;
  if (buf) FREE(buf);
  return(newenv);
}

static SCM array_to_list(float *arr, int i, int len)
{
  if (i < (len-1))
    return(gh_cons(gh_double2scm(arr[i]),array_to_list(arr,i+1,len)));
  else return(gh_cons(gh_double2scm(arr[i]),SCM_EOL));
}

static SCM env2scm (env *e)
{
  if (e) return(array_to_list(e->data,0,e->pts*2));
  return(SCM_BOOL_F);
}

static SCM g_set_filter_env(SCM edata, SCM snd_n)
{
  snd_info *sp;
  sp = get_sp(snd_n);
  if (sp)
    {
      if (sp->filter_env) free_env(sp->filter_env);
      sp->filter_env = get_env(edata,SCM_BOOL_F,S_set_filter_env);
      filter_env_changed(sp,sp->filter_env);
    }
  return(edata);
}

static SCM g_filter_env(SCM snd_n)
{
  snd_info *sp;
  ERRSP(S_filter_env,snd_n,1);
  sp = get_sp(snd_n);
  if (sp) return(env2scm(sp->filter_env));
  return(SCM_BOOL_F);
}

static SCM g_env_selection(SCM edata, SCM base, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  env *e;
  ERRCP(S_env_selection,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if ((cp) && (active_selection(cp)))
    {
      e = get_env(edata,base,S_env_selection);
      if (e)
	{
	  apply_env(cp,e,0,0,1.0,TRUE,FALSE,S_env_selection);
	  free_env(e);
	  return(SCM_BOOL_T);
	}
    }
  return(SCM_BOOL_F);
}

static SCM g_env_sound(SCM edata, SCM samp_n, SCM samps, SCM base, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  env *e;
  int dur;
  ERRB2(samp_n,S_env_sound);
  ERRB3(samps,S_env_sound);
  ERRCP(S_env_sound,snd_n,chn_n,5);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      e = get_env(edata,base,S_env_sound);
      if (e)
	{
	  dur = int_or_zero(samps);
	  if (dur == 0) dur = current_ed_samples(cp);
	  apply_env(cp,e,int_or_zero(samp_n),dur,1.0,FALSE,FALSE,S_env_sound);
	  free_env(e);
	  return(SCM_BOOL_T);
	}
    }
  return(SCM_BOOL_F);
}

static SCM g_mix_file(SCM file, SCM chn_samp_n, SCM file_chn, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  char *name;
  int chans;
  ERRS1(file,S_mix);
  ERRB2(chn_samp_n,S_mix);
  ERRB3(file_chn,S_mix);
  ERRCP(S_mix,snd_n,chn_n,4);
  name = full_filename(file);
  if (chn_samp_n == SCM_UNDEFINED)
    {
      mix_complete_file(any_selected_sound(state),name,S_mix);
    }
  else
    {
      cp = get_cp(snd_n,chn_n);
      if (cp)
	{
	  chans = sound_chans(name);
	  if (chans > 0)
	    file_mix_samples(int_or_zero(chn_samp_n),sound_samples(name)/chans,name,cp,int_or_zero(file_chn),DONT_DELETE_ME,FALSE,1,S_mix);
	  else state->eval_error = SND_NO_SUCH_FILE;
	}
    }
  return(SCM_BOOL_T);
}

static SCM g_mix_overlay(SCM file, SCM samp_n, SCM snd_n)
{ /* for CLM's explode option, I think (this used to be buried in clm_add_mixes -- currently unused, undocumented) */
  char *name;
  int beg;
  snd_info *sp;
  ERRS1(file,S_mix_overlay);
  ERRB2(samp_n,S_mix_overlay);
  ERRSP(S_mix_overlay,snd_n,3);
  sp = get_sp(snd_n);
  if (sp)
    {
      name = full_filename(file);
      if (samp_n == SCM_UNDEFINED) beg = 0; else beg = gh_scm2int(samp_n);
      mix_overlay(state,sp,name,beg,1.0);
    }
  return(SCM_BOOL_T);
}

static SCM g_key(SCM kbd, SCM buckybits)
{
  chan_info *cp;
  ERRN1(kbd,S_key);
  cp = current_channel(state);
  if (cp) {RTNINT(keyboard_command(cp,gh_scm2int(kbd),gh_scm2int(buckybits)));}
  return(SCM_BOOL_F);
}

static SCM g_add_to_main_menu(SCM label)
{
  char *name = NULL;
  int val;
  ERRS1(label,S_add_to_main_menu);
  name = gh_scm2newstr(label,NULL);
  val = add_to_main_menu(state,name);
  FREE(name);
  RTNINT(val);
}

static char **callbacks = NULL;
static int callbacks_size = 0;
static int callb = 0;
#define CALLBACK_INCR 16

static SCM g_add_to_menu(SCM menu, SCM label, SCM callstr)
{
  char *name;
  ERRS2(label,S_add_to_menu);
  ERRS3(callstr,S_add_to_menu);
  ERRN1(menu,S_add_to_menu);
  if (callbacks_size == callb)
    {
      callbacks_size += CALLBACK_INCR;
      if (callb == 0) 
	callbacks = (char **)CALLOC(callbacks_size,sizeof(char *));
      else callbacks = (char **)REALLOC(callbacks,callbacks_size * sizeof(char *));
    }
  name = gh_scm2newstr(label,NULL);
  add_to_menu(state,gh_scm2int(menu),name,callb);
  FREE(name);
  callbacks[callb] = gh_scm2newstr(callstr,NULL);
  callb++;
  return(label);
}

void g_snd_callback(snd_state *ss, int callb)
{
  char *buf;
  buf = callbacks[callb];
  scm_internal_stack_catch(SCM_BOOL_T,eval_str_wrapper,buf,clm_handler,buf);
}

static SCM g_remove_from_menu(SCM menu, SCM label)
{
  char *name;
  int val;
  ERRS2(label,S_remove_from_menu);
  ERRN1(menu,S_remove_from_menu);
  name = gh_scm2newstr(label,NULL);
  val = remove_from_menu(state,gh_scm2int(menu),name);
  FREE(name);
  RTNINT(val);
}

static SCM g_change_menu_label(SCM menu, SCM old_label, SCM new_label)
{
  char *old_name,*new_name;
  int val;
  ERRS2(old_label,S_change_menu_label);
  ERRS3(new_label,S_change_menu_label);
  ERRN1(menu,S_change_menu_label);
  old_name = gh_scm2newstr(old_label,NULL);
  new_name = gh_scm2newstr(new_label,NULL);
  val = change_menu_label(gh_scm2int(menu),old_name,new_name);
  FREE(old_name);
  FREE(new_name);
  RTNINT(val);
}

static SCM g_set_menu_sensitive(SCM menu, SCM label, SCM on)
{
  char *name;
  int val;
  ERRN1(menu,S_set_menu_sensitive);
  ERRS2(label,S_set_menu_sensitive);
  ERRN3(on,S_set_menu_sensitive);
  name = gh_scm2newstr(label,NULL);
  val = set_menu_sensitive(gh_scm2int(menu),name,gh_scm2int(on));
  FREE(name);
  RTNINT(val);
}

static SCM g_autocorrelate(SCM reals)
{
  /* assumes length is power of 2 */
  vct *v1 = NULL;
  int n,i;
  float *rl;
  ERRV1(reals,S_autocorrelate);
  if (vct_p(reals))
    {
      v1 = (vct *)gh_cdr(reals);
      rl = v1->data;
      n = v1->length;
    }
  else
    {
      n = gh_vector_length(reals);
      rl = (float *)CALLOC(n,sizeof(float));
      for (i=0;i<n;i++) rl[i] = gh_scm2double(GH_VREF(reals,gh_int2scm(i)));
    }
  autocorrelation(rl,n);
  if (v1 == NULL) 
    {
      for (i=0;i<n;i++) GH_VSET(reals,gh_int2scm(i),gh_double2scm(rl[i]));
      FREE(rl);
    }
  return(reals);
}

static SCM g_fft_1(SCM reals, SCM imag, SCM sign, int use_fft)
{
  vct *v1 = NULL,*v2 = NULL;
  int n,n2,ipow,i,isign = 1;
  float *rl,*im;
  ERRV1(reals,((use_fft) ? S_fft : S_convolve_arrays));
  ERRV2(imag,((use_fft) ? S_fft : S_convolve_arrays));
  if ((vct_p(reals)) && (vct_p(imag)))
    {
      v1 = (vct *)gh_cdr(reals);
      v2 = (vct *)gh_cdr(imag);
      n = v1->length;
    }
  else
    n = gh_vector_length(reals);
  ipow = (int)ceil(log((float)n)/log(2.0));
  n2 = (int)pow(2.0,(float)ipow);
  if ((!v1) || (n != n2))
    {
      rl = (float *)CALLOC(n2,sizeof(float));
      im = (float *)CALLOC(n2,sizeof(float));
    }
  else
    {
      rl = v1->data;
      im = v2->data;
    }
  if (gh_number_p(sign)) isign = gh_scm2int(sign);
  if (isign == 0) isign = 1;
  if (v1 == NULL)
    {
      for (i=0;i<n;i++)
	{
	  rl[i] = gh_scm2double(GH_VREF(reals,gh_int2scm(i)));
	  im[i] = gh_scm2double(GH_VREF(imag,gh_int2scm(i)));
	}
    }
  else
    {
      if (n != n2)
	{
	  for (i=0;i<n;i++)
	    {
	      rl[i] = v1->data[i];
	      im[i] = v2->data[i];
	    }
	}
    }
  if (use_fft) 
    {
      c_fft(rl,im,n2,isign,ipow);
      if (v1 == NULL)
	{
	  for (i=0;i<n;i++)
	    {
	      GH_VSET(reals,gh_int2scm(i),gh_double2scm(rl[i]));
	      GH_VSET(imag,gh_int2scm(i),gh_double2scm(im[i]));
	    }
	}
      else
	{
	  if (n != n2)
	    {
	      for (i=0;i<n;i++)
		{
		  v1->data[i] = rl[i];
		  v2->data[i] = im[i];
		}
	    }
	}
    }
  else 
    {
      convolve(rl,im,n2,ipow);
      if (v1 == NULL)
	{
	  for (i=0;i<n;i++)
	    {
	      GH_VSET(reals,gh_int2scm(i),gh_double2scm(rl[i]));
	    }
	}
      else
	{
	  if (n != n2)
	    {
	      for (i=0;i<n;i++) v1->data[i] = rl[i];
	    }
	}
    }
  if ((!v1) || (n != n2))
    {
      FREE(rl);
      FREE(im);
    }
  return(reals);
}

static SCM g_fft(SCM reals, SCM imag, SCM sign)
{
  return(g_fft_1(reals,imag,sign,TRUE));
}

static SCM g_convolve_with(SCM file, SCM new_amp, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  float amp;
  char *fname;
  ERRS1(file,S_convolve_with);
  ERRCP(S_convolve_with,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) 
    {
      if (gh_number_p(new_amp)) 
	amp = gh_scm2double(new_amp);
      else
	{
	  if (new_amp == SCM_BOOL_F)
	    amp = 0.0;
	  else amp = 1.0;
	}
      fname = full_filename(file);
      if (snd_probe_file(cp->state,fname) == FILE_EXISTS)
	convolve_with(fname,amp,cp);
    }
  return(SCM_BOOL_F);
}

static SCM g_snd_spectrum(SCM data, SCM win, SCM len, SCM linear_or_dB)
{
  int ipow,i,n,linear;
  float maxa,todb,lowest,val;
  float *idat,*rdat,*window;
  vct *v;
  SCM_ASSERT((vct_p(data)),data,SCM_ARG1,S_snd_spectrum);
  SCM_ASSERT((gh_number_p(win)),win,SCM_ARG2,S_snd_spectrum);
  SCM_ASSERT((gh_number_p(len)),len,SCM_ARG3,S_snd_spectrum);
  ERRB1(linear_or_dB,S_snd_spectrum);
  v = get_vct(data);
  rdat = v->data;
  n = gh_scm2int(len);
  if (linear_or_dB == SCM_BOOL_T) linear=1; else linear=0;
  ipow = (int)(log((float)(n+1))/log(2.0)); /* n+1 for linux rounding problem */
  idat = (float *)CALLOC(n,sizeof(float));
  window = (float *)CALLOC(n,sizeof(float));
  make_fft_window_1(window,n,gh_scm2int(win),0.0,0);
  for (i=0;i<n;i++) rdat[i] *= window[i];
  FREE(window);
  c_fft(rdat,idat,n,1,ipow);
  lowest = 0.001;
  maxa = 0.0;
  n = n/2;
  for (i=0;i<n;i++)
    {
      val = rdat[i]*rdat[i]+idat[i]*idat[i];
      if (val < lowest)
	idat[i] = lowest;
      else 
	{
	  idat[i]=sqrt(val);
	  if (idat[i] > maxa) maxa=idat[i];
	}
    }
  if (maxa>0.0)
    {
      maxa=1.0/maxa;
      if (linear == 0) /* dB */
	{
	  todb=20.0/log(10.0);
	  for (i=0;i<n;i++) idat[i]=todb*log(idat[i]*maxa);
	}
      else for (i=0;i<n;i++) idat[i] *= maxa;
    }
  return(make_vct(n,idat));
}

static SCM g_convolve_selection_with(SCM file, SCM new_amp)
{
  float amp;
  char *fname;
  ERRS1(file,S_convolve_selection_with);
  if (gh_number_p(new_amp)) 
    amp = gh_scm2double(new_amp);
  else
    {
      if (new_amp == SCM_BOOL_F)
	amp = 0.0;
      else amp = 1.0;
    }
  fname = full_filename(file);
  if (snd_probe_file(state,fname) == FILE_EXISTS)
    convolve_with(fname,amp,NULL);
  return(SCM_BOOL_F);
}

static SCM g_convolve(SCM reals, SCM imag)
{
  /* if reals is a string=filename and imag is a float (or nada), assume user missppelledd convolve-with */
  if (gh_string_p(reals))
    return(g_convolve_with(reals,imag,SCM_BOOL_F,SCM_BOOL_F));
  /* result in reals (which needs to be big enough and zero padded) */
  else return(g_fft_1(reals,imag,1,FALSE));
}

static SCM g_src_sound(SCM ratio_or_env, SCM base)
{
  /* follows sync and applies to current chan -- not the way everything else works */
  if (gh_number_p(ratio_or_env))
    src_env_or_num(state,NULL,gh_scm2double(ratio_or_env),TRUE,FALSE,S_src_sound,FALSE);
  else src_env_or_num(state,get_env(ratio_or_env,base,S_src_sound),1.0,FALSE,FALSE,S_src_sound,FALSE);
  return(SCM_BOOL_F);
}

static SCM g_src_selection(SCM ratio_or_env, SCM base)
{
  /* follows sync and applies to current chan -- not the way everything else works */
  if (gh_number_p(ratio_or_env))
    src_env_or_num(state,NULL,gh_scm2double(ratio_or_env),TRUE,FALSE,S_src_selection,TRUE);
  else src_env_or_num(state,get_env(ratio_or_env,base,S_src_selection),1.0,FALSE,FALSE,S_src_selection,TRUE);
  return(SCM_BOOL_F);
}

static SCM g_filter_sound(SCM filter_env, SCM order, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  ERRN2(order,S_filter_sound);
  ERRCP(S_filter_sound,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) {apply_filter(cp,gh_scm2int(order),get_env(filter_env,gh_double2scm(1.0),S_filter_sound),FALSE,S_filter_sound,TRUE); return(SCM_BOOL_T);}
  return(SCM_BOOL_F);
}

static SCM g_filter_selection(SCM filter_env, SCM order)
{
  chan_info *cp;
  ERRN2(order,S_filter_selection);
  cp = get_cp(SCM_BOOL_F,SCM_BOOL_F);
  if (cp) {apply_filter(cp,gh_scm2int(order),get_env(filter_env,gh_double2scm(1.0),S_filter_selection),FALSE,S_filter_selection,TRUE); return(SCM_BOOL_T);}
  return(SCM_BOOL_F);
}

static SCM g_smooth(SCM beg, SCM num, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  ERRN1(beg,S_smooth);
  ERRN2(num,S_smooth);
  ERRCP(S_smooth,snd_n,chn_n,3);
  cp = get_cp(snd_n,chn_n);
  if (cp) {cos_smooth(cp,gh_scm2int(beg),gh_scm2int(num),FALSE,S_smooth); return(SCM_BOOL_T);}
  return(SCM_BOOL_F);
}

static SCM g_smooth_selection(void)
{
  chan_info *cp;
  cp = get_cp(SCM_BOOL_F,SCM_BOOL_F);
  if (cp) {cos_smooth(cp,0,0,TRUE,S_smooth_selection); return(SCM_BOOL_T);}
  return(SCM_BOOL_F);
}

static SCM g_reverse(SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  ERRCP(S_reverse_sound,snd_n,chn_n,1);
  cp = get_cp(snd_n,chn_n);
  if (cp) reverse_sound(cp,FALSE);
  return(SCM_BOOL_F);
}

static SCM g_reverse_selection(void)
{
  chan_info *cp;
  cp = get_cp(SCM_BOOL_F,SCM_BOOL_F);
  if (cp) reverse_sound(cp,TRUE);
  return(SCM_BOOL_F);
}

static SCM g_save_selection(SCM filename, SCM header_type, SCM data_format, SCM srate, SCM comment)
{
  snd_state *ss;
  int type,format,sr,err;
  char *com = NULL, *fname = NULL;
  ERRS1(filename,S_save_selection);
  ss = get_global_state();
  if (gh_number_p(header_type)) type = gh_scm2int(header_type); else type = NeXT_sound_file;
  if (gh_number_p(data_format)) format = gh_scm2int(data_format); else format = SNDLIB_16_LINEAR;
  if (gh_number_p(srate)) sr = gh_scm2int(srate); else sr = region_srate(0);
  if (gh_string_p(comment)) com = gh_scm2newstr(comment,NULL); else com = NULL;
  fname = full_filename(filename);
  err = save_selection(ss,fname,type,format,sr,com);
  if (com) FREE(com);
  if (err == 0) return(filename);
  return(SCM_BOOL_F);
}
  
static SCM g_graph(SCM data, SCM xlabel, SCM x0, SCM x1, SCM y0, SCM y1, SCM snd_n, SCM chn_n)
{
  chan_info *cp;
  lisp_grf *lg;
  char *label = NULL;
  vct *v = NULL;
  int i;
  float ymin,ymax,val,nominal_x0,nominal_x1;
  ERRV1(data,S_graph);
  ERRCP(S_graph,snd_n,chn_n,7);
  cp = get_cp(snd_n,chn_n);
  if (cp)
    {
      if ((cp->sound_ctr == -1) || 
	  (cp->sounds == NULL) || 
	  (cp->sounds[cp->sound_ctr] == NULL) ||
	  (cp->axis == NULL))
	return(SCM_BOOL_F);
      if (!(cp->lisp_info))
	cp->lisp_info = (lisp_grf *)CALLOC(1,sizeof(lisp_grf));
      lg = cp->lisp_info;
      if (vct_p(data))
	{
	  v = (vct *)gh_cdr(data);
	  lg->length = v->length;
	}
      else
	lg->length = gh_vector_length(data);
      if (lg->data_size < lg->length)
	{
	  if (lg->data_size > 0) FREE(lg->data);
	  lg->data_size = lg->length;
	  lg->data = (float *)CALLOC(lg->length,sizeof(float));
	}
      if ((gh_number_p(y0)) && (gh_number_p(y1)))
	{
	  ymin = gh_scm2double(y0);
	  ymax = gh_scm2double(y1);
	  if (v)
	    for (i=0;i<lg->length;i++) lg->data[i] = v->data[i];
	  else for (i=0;i<lg->length;i++) lg->data[i] = gh_scm2double(GH_VREF(data,gh_int2scm(i)));
	}
      else
	{
	  if (v)
	    lg->data[0] = v->data[0];
	  else lg->data[0] = gh_scm2double(GH_VREF(data,gh_int2scm(0)));
	  ymin = lg->data[0]; 
	  ymax = lg->data[0]; 
	  if (v)
	    {
	      for (i=1;i<lg->length;i++)
		{
		  val = v->data[i];
		  lg->data[i] = val; 
		  if (ymin > val) ymin = val;
		  if (ymax < val) ymax = val;
		}
	    }
	  else
	    {
	      for (i=1;i<lg->length;i++)
		{
		  val = gh_scm2double(GH_VREF(data,gh_int2scm(i)));
		  lg->data[i] = val; 
		  if (ymin > val) ymin = val;
		  if (ymax < val) ymax = val;
		}
	    }
	}
      if (gh_string_p(xlabel)) label = gh_scm2newstr(xlabel,NULL); 
      if (gh_number_p(x0)) nominal_x0 = gh_scm2double(x0); else nominal_x0 = 0.0;
      if (gh_number_p(x1)) nominal_x1 = gh_scm2double(x1); else nominal_x1 = 1.0;
      lg->axis = make_axis_info(cp,nominal_x0,nominal_x1,ymin,ymax,label,nominal_x0,nominal_x1,ymin,ymax,lg->axis);
      if (label) FREE(label);
      lg->peaks_ok = 1;
      lg->scaler = 1.0;
      cp->lisp_graphing = 1;
      display_channel_data(cp,cp->sound,cp->state);
    }
  return(SCM_BOOL_F);
}

static SCM g_bindkey(SCM key, SCM state, SCM code, SCM ignore_prefix)
{
  char *cstr;
  int ip;
  ERRN1(key,S_bind_key);
  ERRN2(state,S_bind_key);
  SCM_ASSERT((gh_string_p(code) || gh_procedure_p(code)),code,SCM_ARG3,S_bind_key);
  if ((ignore_prefix == SCM_BOOL_F) || (ignore_prefix == SCM_UNDEFINED) ||  
      ((gh_number_p(ignore_prefix)) && (gh_scm2int(ignore_prefix) == 0)))
    ip = 0;
  else ip = 1;
  if (gh_string_p(code))
    {
      cstr = gh_scm2newstr(code,NULL);
      set_keymap_entry(gh_scm2int(key),gh_scm2int(state),cstr,ip,SCM_UNDEFINED);
      FREE(cstr);
    }
  else set_keymap_entry(gh_scm2int(key),gh_scm2int(state),NULL,ip,code);
  return(SCM_BOOL_T);
}

static SCM g_save_edit_history(SCM filename, SCM snd, SCM chn)
{
  FILE *fd;
  int i,j;
  snd_info *sp;
  chan_info *cp;
  ERRS1(filename,S_save_edit_history);
  ERRCP(S_save_edit_history,snd,chn,2);
  fd = fopen(full_filename(filename),"w");
  if (fd)
    {
      if ((gh_number_p(chn)) && (gh_number_p(snd)))
	{
	  cp = get_cp(snd,chn);
	  if (cp) edit_history_to_file(fd,cp);
	}
      else
	{
	  if (gh_number_p(snd))
	    {
	      sp = get_sp(snd);
	      if (sp)
		for (i=0;i<sp->nchans;i++)
		  edit_history_to_file(fd,sp->chans[i]);
	    }
	  else
	    {
	      for (i=0;i<state->max_sounds;i++)
		{
		  if ((sp=((snd_info *)(state->sounds[i]))))
		    {
		      if (sp->inuse)
			{
			  for (j=0;j<sp->nchans;j++)
			    edit_history_to_file(fd,sp->chans[j]);
			}
		    }
		}
	    }
	}
      fclose(fd);
      return(SCM_BOOL_T);
    }
  return(SCM_BOOL_F);
}

static SCM g_set_oss_buffers(SCM num, SCM size)
{
#if (HAVE_OSS || HAVE_ALSA)
  ERRN1(num,S_set_oss_buffers);
  ERRN2(size,S_set_oss_buffers);
  set_oss_buffers(gh_scm2int(num),gh_scm2int(size));
#endif
  return(SCM_BOOL_F);
}

static SCM g_describe_audio(void) {snd_help(state,"Audio State",report_audio_state()); return(SCM_BOOL_T);}

static SCM g_add_sound_file_extension(SCM ext)
{
  char *name;
  ERRS1(ext,S_add_sound_file_extension);
  name = gh_scm2newstr(ext,NULL);
  add_sound_file_extension(name);
  FREE(name);
  return(ext);
}

static SCM g_string_length(SCM str)
{
  char *val = NULL;
  if (gh_string_p(str)) val = gh_scm2newstr(str,NULL);
  if (val)
    {
      if (*val) RTNINT(strlen(val));
      FREE(val);
    }
  RTNINT(0);
}

static SCM g_call_plug(SCM plug)
{
  call_plug((snd_plug *)(gh_scm2ulong(plug)),0);
  return(SCM_BOOL_F);
}

static SCM g_call_plug_selection(SCM plug)
{
  call_plug((snd_plug *)(gh_scm2ulong(plug)),1);
  return(SCM_BOOL_F);
}

static SCM g_describe_plug(SCM plug)
{
  RTNSTR(((snd_plug *)plug)->documentation);
}

static SCM g_call_apply(SCM snd)
{
  snd_info *sp;
  ERRSP(S_call_apply,snd,1);
  sp = get_sp(snd);
  if (sp) run_apply_to_completion(sp);
  return(SCM_BOOL_F);
}


/* -------- EXTERNAL PROGRAMS -------- */

#define USE_FULL_FILE 0
#define USE_SELECTION 1
#define USE_ONE_FILE 1
#define USE_MANY_FILES 0

static SCM g_temp_filenames(SCM data)
{
  snd_exf *program_data;
  int i;
  SCM lst;
  program_data = (snd_exf *)(gh_scm2ulong(data));
  lst = GH_MAKE_VECTOR(gh_int2scm(program_data->files),SCM_BOOL_F);
  for (i=0;i<program_data->files;i++)
    GH_VSET(lst,gh_int2scm(i),gh_str02scm(program_data->old_filenames[i]));
  return(lst);
}

static SCM g_sound_to_temp_1(SCM ht, SCM df, int selection, int one_file)
{
  snd_exf *program_data;
  chan_info *cp;
  int type = unsupported_sound_file,format = SNDLIB_UNSUPPORTED;
  cp = current_channel(state);
  if (cp)
    {
      if (gh_number_p(ht)) type = gh_scm2int(ht);
      if (gh_number_p(df)) format = gh_scm2int(df);
      program_data = snd_to_temp(cp,selection,one_file,type,format);
      if (program_data)
	return((SCM)(gh_ulong2scm((unsigned long)program_data)));
    }
  return(SCM_BOOL_F);
}

static SCM g_sound_to_temp(SCM ht, SCM df) {return(g_sound_to_temp_1(ht,df,USE_FULL_FILE,USE_ONE_FILE));}
static SCM g_sound_to_temps(SCM ht, SCM df) {return(g_sound_to_temp_1(ht,df,USE_FULL_FILE,USE_MANY_FILES));}
static SCM g_selection_to_temp(SCM ht, SCM df) {return(g_sound_to_temp_1(ht,df,USE_SELECTION,USE_ONE_FILE));}
static SCM g_selection_to_temps(SCM ht, SCM df) {return(g_sound_to_temp_1(ht,df,USE_SELECTION,USE_MANY_FILES));}

static SCM g_temp_to_sound(SCM data, SCM new_name, SCM origin)
{
  snd_exf *program_data;
  ERRS2(new_name,S_temp_to_sound);
  ERRS3(origin,S_temp_to_sound);
  program_data = (snd_exf *)(gh_scm2ulong(data));
  program_data->new_filenames[0] = gh_scm2newstr(new_name,NULL);
  temp_to_snd(state,program_data,gh_scm2newstr(origin,NULL));
  return(SCM_BOOL_T);
}

static SCM g_temps_to_sound(SCM data, SCM new_names, SCM origin)
{
  snd_exf *program_data;
  int i;
  ERRVECT2(new_names,S_temps_to_sound);
  ERRS3(origin,S_temps_to_sound);
  program_data = (snd_exf *)(gh_scm2ulong(data));
  for (i=0;i<(int)gh_vector_length(new_names);i++)
    program_data->new_filenames[i] = gh_scm2newstr(GH_VREF(new_names,gh_int2scm(i)),NULL);
  temp_to_snd(state,program_data,gh_scm2newstr(origin,NULL));
  return(SCM_BOOL_T);
}

static SCM g_start_progress_report(SCM snd)
{
  snd_info *sp;
  ERRB1(snd,S_start_progress_report);
  ERRSP(S_start_progress_report,snd,1);
  sp = get_sp(snd);
  if (sp) start_progress_report(state,sp,NOT_FROM_ENVED);
  RTNBOOL(sp);
}

static SCM g_finish_progress_report(SCM snd)
{
  snd_info *sp;
  ERRB1(snd,S_finish_progress_report);
  ERRSP(S_finish_progress_report,snd,1);
  sp = get_sp(snd);
  if (sp) finish_progress_report(state,sp,NOT_FROM_ENVED);
  RTNBOOL(sp);
}

static SCM g_progress_report(SCM pct, SCM name, SCM cur_chan, SCM chans, SCM snd)
{
  snd_info *sp;
  char *str;
  ERRN1(pct,S_progress_report);
  ERRSP(S_progress_report,snd,5);
  sp = get_sp(snd);
  if (sp) 
    {
      if (gh_string_p(name)) str = gh_scm2newstr(name,NULL); else str = copy_string("something useful");
      progress_report(state,sp,str,
		      int_or_zero(cur_chan),
		      (gh_number_p(chans)) ? gh_scm2int(chans) : sp->nchans,
		      gh_scm2double(pct),
		      NOT_FROM_ENVED);
      FREE(str);
    }
  RTNBOOL(sp);
}

#if WITH_MUS_MODULE
  void init_mus2scm_module(void);
#endif

static SCM fft_hook,open_hook,close_hook,exit_hook,start_hook,mouse_press_hook;
static SCM mouse_release_hook,mouse_drag_hook,key_press_hook,stop_playing_hook;
static SCM mark_click_hook,start_playing_hook;
static SCM memo_sound;

void g_initialize_gh(snd_state *ss)
{
  state = ss;

  init_sndlib2scm();

  gh_eval_str("(define guile? (lambda nil 1))");
#if WITH_MUS_MODULE
  gh_eval_str("(define clm? (lambda nil 1))");
#else
  gh_eval_str("(define clm? (lambda nil 0))");
#endif

  gh_new_procedure2_0(S_set_oss_buffers,g_set_oss_buffers);
  gh_new_procedure0_0(S_ask_before_overwrite,g_ask_before_overwrite);
  gh_new_procedure0_1(S_set_ask_before_overwrite,g_set_ask_before_overwrite);
  gh_new_procedure0_0(S_audio_output_device,g_audio_output_device);
  gh_new_procedure1_0(S_set_audio_output_device,g_set_audio_output_device);
  gh_new_procedure0_0(S_dac_size,g_dac_size);
  gh_new_procedure1_0(S_set_dac_size,g_set_dac_size);
  gh_new_procedure0_0(S_auto_resize,g_auto_resize);
  gh_new_procedure0_1(S_set_auto_resize,g_set_auto_resize);
  gh_new_procedure0_0(S_auto_update,g_auto_update);
  gh_new_procedure0_1(S_set_auto_update,g_set_auto_update);
  gh_new_procedure0_0(S_channel_style,g_channel_style);
  gh_new_procedure1_0(S_set_channel_style,g_set_channel_style);
  gh_new_procedure0_0(S_color_cutoff,g_color_cutoff);
  gh_new_procedure1_0(S_set_color_cutoff,g_set_color_cutoff);
  gh_new_procedure0_0(S_color_inverted,g_color_inverted);
  gh_new_procedure0_1(S_set_color_inverted,g_set_color_inverted);
  gh_new_procedure0_0(S_color_scale,g_color_scale);
  gh_new_procedure1_0(S_set_color_scale,g_set_color_scale);
  gh_new_procedure0_0(S_corruption_time,g_corruption_time);
  gh_new_procedure1_0(S_set_corruption_time,g_set_corruption_time);
  gh_new_procedure0_0(S_default_amp,g_default_amp);
  gh_new_procedure1_0(S_set_default_amp,g_set_default_amp);
  gh_new_procedure0_0(S_default_contrast,g_default_contrast);
  gh_new_procedure1_0(S_set_default_contrast,g_set_default_contrast);
  gh_new_procedure0_0(S_default_contrast_amp,g_default_contrast_amp);
  gh_new_procedure1_0(S_set_default_contrast_amp,g_set_default_contrast_amp);
  gh_new_procedure0_0(S_default_contrasting,g_default_contrasting);
  gh_new_procedure0_1(S_set_default_contrasting,g_set_default_contrasting);
  gh_new_procedure0_0(S_default_expand,g_default_expand);
  gh_new_procedure1_0(S_set_default_expand,g_set_default_expand);
  gh_new_procedure0_0(S_default_expand_hop,g_default_expand_hop);
  gh_new_procedure1_0(S_set_default_expand_hop,g_set_default_expand_hop);
  gh_new_procedure0_0(S_default_expand_length,g_default_expand_length);
  gh_new_procedure1_0(S_set_default_expand_length,g_set_default_expand_length);
  gh_new_procedure0_0(S_default_expand_ramp,g_default_expand_ramp);
  gh_new_procedure1_0(S_set_default_expand_ramp,g_set_default_expand_ramp);
  gh_new_procedure0_0(S_default_expanding,g_default_expanding);
  gh_new_procedure0_1(S_set_default_expanding,g_set_default_expanding);
  gh_new_procedure0_0(S_default_filter_dBing,g_default_filter_dBing);
  gh_new_procedure1_0(S_set_default_filter_dBing,g_set_default_filter_dBing);
  gh_new_procedure0_0(S_default_filter_order,g_default_filter_order);
  gh_new_procedure1_0(S_set_default_filter_order,g_set_default_filter_order);
  gh_new_procedure0_0(S_default_filtering,g_default_filtering);
  gh_new_procedure0_1(S_set_default_filtering,g_set_default_filtering);
  gh_new_procedure0_0(S_default_output_type,g_default_output_type);
  gh_new_procedure1_0(S_set_default_output_type,g_set_default_output_type);
  gh_new_procedure0_0(S_default_reverb_feedback,g_default_reverb_feedback);
  gh_new_procedure1_0(S_set_default_reverb_feedback,g_set_default_reverb_feedback);
  gh_new_procedure0_0(S_default_reverb_length,g_default_reverb_length);
  gh_new_procedure1_0(S_set_default_reverb_length,g_set_default_reverb_length);
  gh_new_procedure0_0(S_default_reverb_lowpass,g_default_reverb_lowpass);
  gh_new_procedure1_0(S_set_default_reverb_lowpass,g_set_default_reverb_lowpass);
  gh_new_procedure0_0(S_default_reverb_scale,g_default_reverb_scale);
  gh_new_procedure1_0(S_set_default_reverb_scale,g_set_default_reverb_scale);
  gh_new_procedure0_0(S_default_reverbing,g_default_reverbing);
  gh_new_procedure0_1(S_set_default_reverbing,g_set_default_reverbing);
  gh_new_procedure0_0(S_default_speed,g_default_speed);
  gh_new_procedure1_0(S_set_default_speed,g_set_default_speed);
  gh_new_procedure0_0(S_dot_size,g_dot_size);
  gh_new_procedure1_0(S_set_dot_size,g_set_dot_size);
  gh_new_procedure0_0(S_enved_base,g_enved_base);
  gh_new_procedure1_0(S_set_enved_base,g_set_enved_base);
  gh_new_procedure0_0(S_enved_power,g_enved_power);
  gh_new_procedure1_0(S_set_enved_power,g_set_enved_power);
  gh_new_procedure0_0(S_enved_clipping,g_enved_clipping);
  gh_new_procedure0_1(S_set_enved_clipping,g_set_enved_clipping);
  gh_new_procedure0_0(S_enved_exping,g_enved_exping);
  gh_new_procedure0_1(S_set_enved_exping,g_set_enved_exping);
  gh_new_procedure0_0(S_enved_target,g_enved_target);
  gh_new_procedure1_0(S_set_enved_target,g_set_enved_target);
  gh_new_procedure0_0(S_enved_waving,g_enved_waving);
  gh_new_procedure0_1(S_set_enved_waving,g_set_enved_waving);
  gh_new_procedure0_0(S_enved_dBing,g_enved_dBing);
  gh_new_procedure0_1(S_set_enved_dBing,g_set_enved_dBing);
  gh_new_procedure0_0(S_eps_file,g_eps_file);
  gh_new_procedure1_0(S_set_eps_file,g_set_eps_file);
  gh_new_procedure0_0(S_listener_prompt,g_listener_prompt);
  gh_new_procedure1_0(S_set_listener_prompt,g_set_listener_prompt);
  gh_new_procedure0_0(S_mixer_save_state_file,g_mixer_save_state_file);
  gh_new_procedure1_0(S_set_mixer_save_state_file,g_set_mixer_save_state_file);
  gh_new_procedure0_0(S_fft_beta,g_fft_beta);
  gh_new_procedure1_0(S_set_fft_beta,g_set_fft_beta);
  gh_new_procedure0_0(S_fft_log_frequency,g_fft_log_frequency);
  gh_new_procedure0_1(S_set_fft_log_frequency,g_set_fft_log_frequency);
  gh_new_procedure0_0(S_fft_log_magnitude,g_fft_log_magnitude);
  gh_new_procedure0_1(S_set_fft_log_magnitude,g_set_fft_log_magnitude);
  gh_new_procedure0_0(S_fft_size,g_fft_size);
  gh_new_procedure1_0(S_set_fft_size,g_set_fft_size);
  gh_new_procedure0_0(S_fft_style,g_fft_style);
  gh_new_procedure1_0(S_set_fft_style,g_set_fft_style);
  gh_new_procedure0_0(S_fft_window,g_fft_window);
  gh_new_procedure1_0(S_set_fft_window,g_set_fft_window);
  gh_new_procedure0_0(S_filter_env_order,g_filter_env_order);
  gh_new_procedure1_0(S_set_filter_env_order,g_set_filter_env_order);
  gh_new_procedure0_0(S_fit_data_on_open,g_fit_data_on_open);
  gh_new_procedure0_1(S_set_fit_data_on_open,g_set_fit_data_on_open);
  gh_new_procedure0_0(S_graph_style,g_graph_style);
  gh_new_procedure1_0(S_set_graph_style,g_set_graph_style);
  gh_new_procedure0_0(S_initial_x0,g_initial_x0);
  gh_new_procedure1_0(S_set_initial_x0,g_set_initial_x0);
  gh_new_procedure0_0(S_initial_x1,g_initial_x1);
  gh_new_procedure1_0(S_set_initial_x1,g_set_initial_x1);
  gh_new_procedure0_0(S_initial_y0,g_initial_y0);
  gh_new_procedure1_0(S_set_initial_y0,g_set_initial_y0);
  gh_new_procedure0_0(S_initial_y1,g_initial_y1);
  gh_new_procedure1_0(S_set_initial_y1,g_set_initial_y1);
  gh_new_procedure0_0(S_line_size,g_line_size);
  gh_new_procedure1_0(S_set_line_size,g_set_line_size);
  gh_new_procedure0_0(S_mix_amp_scaler,g_mix_amp_scaler);
  gh_new_procedure1_0(S_set_mix_amp_scaler,g_set_mix_amp_scaler);
  gh_new_procedure0_0(S_mix_speed_scaler,g_mix_speed_scaler);
  gh_new_procedure1_0(S_set_mix_speed_scaler,g_set_mix_speed_scaler);
  gh_new_procedure0_0(S_mix_tempo_scaler,g_mix_tempo_scaler);
  gh_new_procedure1_0(S_set_mix_tempo_scaler,g_set_mix_tempo_scaler);
  gh_new_procedure0_0(S_mix_waveform_height,g_mix_waveform_height);
  gh_new_procedure1_0(S_set_mix_waveform_height,g_set_mix_waveform_height);
  gh_new_procedure0_0(S_mixer_group_max_out_chans,g_mixer_group_max_out_chans);
  gh_new_procedure1_0(S_set_mixer_group_max_out_chans,g_set_mixer_group_max_out_chans);
  gh_new_procedure0_0(S_mixer_groups,g_mixer_groups);
  gh_new_procedure1_0(S_set_mixer_groups,g_set_mixer_groups);
  gh_new_procedure0_0(S_movies,g_movies);
  gh_new_procedure0_1(S_set_movies,g_set_movies);
  gh_new_procedure0_0(S_normalize_fft,g_normalize_fft);
  gh_new_procedure0_1(S_set_normalize_fft,g_set_normalize_fft);
  gh_new_procedure0_0(S_normalize_on_open,g_normalize_on_open);
  gh_new_procedure0_1(S_set_normalize_on_open,g_set_normalize_on_open);
  gh_new_procedure0_0(S_prefix_arg,g_prefix_arg);
  gh_new_procedure1_0(S_set_prefix_arg,g_set_prefix_arg);
  gh_new_procedure0_0(S_print_length,g_print_length);
  gh_new_procedure1_0(S_set_print_length,g_set_print_length);
  gh_new_procedure0_0(S_previous_files_sort,g_previous_files_sort);
  gh_new_procedure1_0(S_set_previous_files_sort,g_set_previous_files_sort);
  gh_new_procedure0_0(S_raw_chans,g_raw_chans);
  gh_new_procedure1_0(S_set_raw_chans,g_set_raw_chans);
  gh_new_procedure0_0(S_raw_format,g_raw_format);
  gh_new_procedure1_0(S_set_raw_format,g_set_raw_format);
  gh_new_procedure0_0(S_raw_srate,g_raw_srate);
  gh_new_procedure1_0(S_set_raw_srate,g_set_raw_srate);
  gh_new_procedure0_0(S_raw_type,g_raw_type);
  gh_new_procedure1_0(S_set_raw_type,g_set_raw_type);
  gh_new_procedure0_0(S_recorder_autoload,g_recorder_autoload);
  gh_new_procedure0_1(S_set_recorder_autoload,g_set_recorder_autoload);
  gh_new_procedure0_0(S_recorder_buffer_size,g_recorder_buffer_size);
  gh_new_procedure1_0(S_set_recorder_buffer_size,g_set_recorder_buffer_size);
  gh_new_procedure0_0(S_recorder_file,g_recorder_file);
  gh_new_procedure1_0(S_set_recorder_file,g_set_recorder_file);
  gh_new_procedure0_0(S_recorder_in_format,g_recorder_in_format);
  gh_new_procedure1_0(S_set_recorder_in_format,g_set_recorder_in_format);
  gh_new_procedure0_0(S_recorder_out_chans,g_recorder_out_chans);
  gh_new_procedure1_0(S_set_recorder_out_chans,g_set_recorder_out_chans);
  gh_new_procedure0_0(S_recorder_out_format,g_recorder_out_format);
  gh_new_procedure1_0(S_set_recorder_out_format,g_set_recorder_out_format);
  gh_new_procedure0_0(S_recorder_srate,g_recorder_srate);
  gh_new_procedure1_0(S_set_recorder_srate,g_set_recorder_srate);
  gh_new_procedure0_0(S_recorder_trigger,g_recorder_trigger);
  gh_new_procedure1_0(S_set_recorder_trigger,g_set_recorder_trigger);
  gh_new_procedure0_0(S_recorder_max_duration,g_recorder_max_duration);
  gh_new_procedure1_0(S_set_recorder_max_duration,g_set_recorder_max_duration);
  gh_new_procedure0_0(S_reverb_decay,g_reverb_decay);
  gh_new_procedure1_0(S_set_reverb_decay,g_set_reverb_decay);
  gh_new_procedure0_0(S_save_state_on_exit,g_save_state_on_exit);
  gh_new_procedure0_1(S_set_save_state_on_exit,g_set_save_state_on_exit);
  gh_new_procedure0_0(S_save_state_file,g_save_state_file);
  gh_new_procedure1_0(S_set_save_state_file,g_set_save_state_file);
  gh_new_procedure0_0(S_show_fft_peaks,g_show_fft_peaks);
  gh_new_procedure0_1(S_set_show_fft_peaks,g_set_show_fft_peaks);
  gh_new_procedure0_0(S_show_marks,g_show_marks);
  gh_new_procedure0_1(S_set_show_marks,g_set_show_marks);
  gh_new_procedure0_0(S_show_usage_stats,g_show_usage_stats);
  gh_new_procedure0_1(S_set_show_usage_stats,g_set_show_usage_stats);
  gh_new_procedure0_0(S_update_usage_stats,g_update_usage_stats);
  gh_new_procedure0_0(S_show_mix_consoles,g_show_mix_consoles);
  gh_new_procedure0_1(S_set_show_mix_consoles,g_set_show_mix_consoles);
  gh_new_procedure0_0(S_show_mix_waveforms,g_show_mix_waveforms);
  gh_new_procedure0_1(S_set_show_mix_waveforms,g_set_show_mix_waveforms);
  gh_new_procedure0_0(S_show_y_zero,g_show_y_zero);
  gh_new_procedure0_1(S_set_show_y_zero,g_set_show_y_zero);
  gh_new_procedure0_0(S_show_axes,g_show_axes);
  gh_new_procedure0_1(S_set_show_axes,g_set_show_axes);
  gh_new_procedure0_0(S_sinc_width,g_sinc_width);
  gh_new_procedure1_0(S_set_sinc_width,g_set_sinc_width);
  gh_new_procedure0_0(S_colormap,g_color_map);
  gh_new_procedure1_0(S_set_colormap,g_set_color_map);
  gh_new_procedure0_0(S_spectro_cutoff,g_spectro_cutoff);
  gh_new_procedure1_0(S_set_spectro_cutoff,g_set_spectro_cutoff);
  gh_new_procedure0_0(S_spectro_hop,g_spectro_hop);
  gh_new_procedure1_0(S_set_spectro_hop,g_set_spectro_hop);
  gh_new_procedure0_0(S_spectro_x_angle,g_spectro_x_angle);
  gh_new_procedure1_0(S_set_spectro_x_angle,g_set_spectro_x_angle);
  gh_new_procedure0_0(S_spectro_x_scale,g_spectro_x_scale);
  gh_new_procedure1_0(S_set_spectro_x_scale,g_set_spectro_x_scale);
  gh_new_procedure0_0(S_spectro_y_angle,g_spectro_y_angle);
  gh_new_procedure1_0(S_set_spectro_y_angle,g_set_spectro_y_angle);
  gh_new_procedure0_0(S_spectro_y_scale,g_spectro_y_scale);
  gh_new_procedure1_0(S_set_spectro_y_scale,g_set_spectro_y_scale);
  gh_new_procedure0_0(S_spectro_z_angle,g_spectro_z_angle);
  gh_new_procedure1_0(S_set_spectro_z_angle,g_set_spectro_z_angle);
  gh_new_procedure0_0(S_spectro_z_scale,g_spectro_z_scale);
  gh_new_procedure1_0(S_set_spectro_z_scale,g_set_spectro_z_scale);
  gh_new_procedure0_0(S_speed_style,g_speed_style);
  gh_new_procedure1_0(S_set_speed_style,g_set_speed_style);
  gh_new_procedure0_0(S_speed_tones,g_speed_tones);
  gh_new_procedure1_0(S_set_speed_tones,g_set_speed_tones);
  gh_new_procedure0_0(S_temp_dir,g_temp_dir);
  gh_new_procedure1_0(S_set_temp_dir,g_set_temp_dir);
  gh_new_procedure0_0(S_transform_type,g_transform_type);
  gh_new_procedure1_0(S_set_transform_type,g_set_transform_type);
  gh_new_procedure0_0(S_trap_segfault,g_trap_segfault);
  gh_new_procedure1_0(S_set_trap_segfault,g_set_trap_segfault);
  gh_new_procedure0_0(S_show_selection_transform,g_show_selection_transform);
  gh_new_procedure1_0(S_set_show_selection_transform,g_set_show_selection_transform);
  gh_new_procedure0_0(S_use_raw_defaults,g_use_raw_defaults);
  gh_new_procedure1_0(S_set_use_raw_defaults,g_set_use_raw_defaults);
  gh_new_procedure0_0(S_verbose_cursor,g_verbose_cursor);
  gh_new_procedure0_1(S_set_verbose_cursor,g_set_verbose_cursor);
  gh_new_procedure0_0(S_vu_font,g_vu_font);
  gh_new_procedure1_0(S_set_vu_font,g_set_vu_font);
  gh_new_procedure0_0(S_vu_font_size,g_vu_font_size);
  gh_new_procedure1_0(S_set_vu_font_size,g_set_vu_font_size);
  gh_new_procedure0_0(S_vu_size,g_vu_size);
  gh_new_procedure1_0(S_set_vu_size,g_set_vu_size);
  gh_new_procedure0_0(S_wavelet_type,g_wavelet_type);
  gh_new_procedure1_0(S_set_wavelet_type,g_set_wavelet_type);
  gh_new_procedure0_0(S_wavo,g_wavo);
  gh_new_procedure1_0(S_set_wavo,g_set_wavo);
  gh_new_procedure0_0(S_wavo_hop,g_wavo_hop);
  gh_new_procedure1_0(S_set_wavo_hop,g_set_wavo_hop);
  gh_new_procedure0_0(S_wavo_trace,g_wavo_trace);
  gh_new_procedure1_0(S_set_wavo_trace,g_set_wavo_trace);
  gh_new_procedure0_0(S_window_x,g_window_x);
  gh_new_procedure1_0(S_set_window_x,g_set_window_x);
  gh_new_procedure0_0(S_window_y,g_window_y);
  gh_new_procedure1_0(S_set_window_y,g_set_window_y);
  gh_new_procedure0_0(S_x_axis_style,g_x_axis_style);
  gh_new_procedure1_0(S_set_x_axis_style,g_set_x_axis_style);
  gh_new_procedure0_0(S_xmax,g_xmax);
  gh_new_procedure1_0(S_set_xmax,g_set_xmax);
  gh_new_procedure0_0(S_xmin,g_xmin);
  gh_new_procedure1_0(S_set_xmin,g_set_xmin);
  gh_new_procedure0_0(S_ymax,g_ymax);
  gh_new_procedure1_0(S_set_ymax,g_set_ymax);
  gh_new_procedure0_0(S_ymin,g_ymin);
  gh_new_procedure1_0(S_set_ymin,g_set_ymin);
  gh_new_procedure0_0(S_min_dB,g_min_dB);
  gh_new_procedure1_0(S_set_min_dB,g_set_min_dB);
  gh_new_procedure0_0(S_zero_pad,g_zero_pad);
  gh_new_procedure1_0(S_set_zero_pad,g_set_zero_pad);
  gh_new_procedure0_0(S_zoom_focus_style,g_zoom_focus_style);
  gh_new_procedure1_0(S_set_zoom_focus_style,g_set_zoom_focus_style);
  gh_new_procedure0_0(S_edit_history_width,g_edit_history_width);
  gh_new_procedure1_0(S_set_edit_history_width,g_set_edit_history_width);
  
  /* end simple state vars */

  gh_new_procedure1_0(S_recorder_gain,g_recorder_gain);
  gh_new_procedure2_0(S_recorder_in_amp,g_recorder_in_amp);
  gh_new_procedure1_0(S_recorder_out_amp,g_recorder_out_amp);
  gh_new_procedure2_0(S_set_recorder_gain,g_set_recorder_gain);
  gh_new_procedure3_0(S_set_recorder_in_amp,g_set_recorder_in_amp);
  gh_new_procedure2_0(S_set_recorder_out_amp,g_set_recorder_out_amp);

#if (HAVE_OSS || HAVE_ALSA)
  gh_new_procedure0_0(S_clear_audio_inputs,g_clear_audio_inputs);
  gh_new_procedure1_0("set-dsp-reset",g_set_dsp_reset);
  gh_new_procedure3_0(S_dsp_devices,g_dsp_devices);
  gh_new_procedure3_0(S_set_dsp_devices,g_set_dsp_devices);
#endif

  gh_new_procedure0_1(S_set_just_sounds,g_set_just_sounds);

  gh_new_procedure0_1(S_mix_position,g_mix_position);
  gh_new_procedure0_1(S_mix_length,g_mix_length);
  gh_new_procedure0_1(S_mix_anchor,g_mix_anchor);
  gh_new_procedure0_1(S_mix_groups,g_mix_groups);
  gh_new_procedure0_1(S_mix_state,g_mix_state);
  gh_new_procedure0_1(S_mix_speed,g_mix_speed);
  gh_new_procedure0_2(S_mix_amp,g_mix_amp);

  gh_new_procedure2_0(S_set_mix_position,g_set_mix_position);
  gh_new_procedure2_0(S_set_mix_length,g_set_mix_length);
  gh_new_procedure2_0(S_set_mix_anchor,g_set_mix_anchor);
  gh_new_procedure2_0(S_set_mix_groups,g_set_mix_groups);
  gh_new_procedure2_0(S_set_mix_state,g_set_mix_state);
  gh_new_procedure2_0(S_set_mix_speed,g_set_mix_speed);
  gh_new_procedure3_0(S_set_mix_amp,g_set_mix_amp);

  gh_new_procedure0_1(S_group_tempo,g_group_tempo);
  gh_new_procedure0_1(S_group_speed,g_group_speed);
  gh_new_procedure0_1(S_group_beg,g_group_beg);
  gh_new_procedure0_1(S_group_end,g_group_end);
  gh_new_procedure0_2(S_group_amp,g_group_amp);

  gh_new_procedure2_0(S_set_group_tempo,g_set_group_tempo);
  gh_new_procedure2_0(S_set_group_speed,g_set_group_speed);
  gh_new_procedure2_0(S_set_group_beg,g_set_group_beg);
  gh_new_procedure2_0(S_set_group_end,g_set_group_end);
  gh_new_procedure3_0(S_set_group_amp,g_set_group_amp);

  gh_new_procedure0_0(S_enved_dialog,g_enved_dialog);
  gh_new_procedure0_0(S_color_dialog,g_color_dialog);
  gh_new_procedure0_0(S_orientation_dialog,g_orientation_dialog);
  gh_new_procedure0_0(S_transform_dialog,g_transform_dialog);
  gh_new_procedure0_0(S_file_dialog,g_file_dialog);
  gh_new_procedure0_0(S_region_dialog,g_region_dialog);
  gh_new_procedure0_1(S_edit_header_dialog,g_edit_header_dialog);
  gh_new_procedure0_0(S_recorder_dialog,g_record_dialog);
  gh_new_procedure0_0(S_group_dialog,g_group_dialog);
  gh_new_procedure1_0(S_clm_dialog,g_clm_dialog);
  gh_new_procedure2_0(S_help_dialog,g_help_dialog);
#if (XmVERSION == 1)
  gh_new_procedure0_0(S_show_edit_history,g_show_edit_history);
  gh_new_procedure0_1(S_set_show_edit_history,g_set_show_edit_history);
#endif
  gh_new_procedure1_2(S_sample,g_sample);
  gh_new_procedure2_2(S_set_sample,g_set_sample);
  gh_new_procedure2_2(S_samples,g_samples);
  gh_new_procedure3_2(S_set_samples,g_set_samples);
  gh_new_procedure3_2(S_vct_samples,g_set_samples);
  gh_new_procedure4_2(S_set_int_samples,g_set_int_samples);
  gh_new_procedure2_0(S_clm_snd_samples,g_clm_snd_samples);
  gh_new_procedure1_0(S_clm_snd_set_samples,g_clm_snd_set_samples);
  gh_new_procedure1_1(S_clm_snd_replace_samples,g_clm_snd_replace_samples);
  gh_new_procedure1_0(S_clm_snd_update,g_clm_snd_update);
  gh_new_procedure1_0(S_clm_snd_close,g_clm_snd_close);
  gh_new_procedure0_1(S_snd_clm_samples,g_clm_samples);
  gh_new_procedure1_0(S_snd_clm_region,g_clm_region);
  gh_new_procedure1_2(S_delete_sample,g_delete_sample);
  gh_new_procedure2_2(S_delete_samples,g_delete_samples);
  gh_new_procedure3_2(S_delete_int_samples,g_delete_int_samples);
  gh_new_procedure2_2(S_insert_sample,g_insert_sample);
  gh_new_procedure3_2(S_insert_samples,g_insert_samples);
  gh_new_procedure4_2(S_insert_int_samples,g_insert_int_samples);
  gh_new_procedure0_2(S_cursor,g_cursor);
  gh_new_procedure1_2(S_set_cursor,g_set_cursor);
  gh_new_procedure0_2(S_left_sample,g_left_sample);
  gh_new_procedure1_2(S_set_left_sample,g_set_left_sample);
  gh_new_procedure0_2(S_right_sample,g_right_sample);
  gh_new_procedure1_2(S_set_right_sample,g_set_right_sample);
  gh_new_procedure0_1(S_channels,g_channels);
  gh_new_procedure0_1(S_chans,g_channels);
  gh_new_procedure0_1(S_srate,g_srate);
  gh_new_procedure0_1(S_data_location,g_data_location);
  gh_new_procedure0_1(S_data_format,g_data_format);
  gh_new_procedure0_1(S_header_type,g_header_type);
  gh_new_procedure0_1(S_comment,g_comment);
  gh_new_procedure0_2(S_frames,g_length);
  /* for backwards compatibility */ gh_new_procedure0_2("snd-length",g_length);
  gh_new_procedure0_0(S_active_sounds,g_active_sounds);
  gh_new_procedure0_0(S_max_sounds,g_max_sounds);
  gh_new_procedure0_0(S_max_regions,g_max_regions);
  gh_new_procedure1_0(S_set_max_regions,g_set_max_regions);
  gh_new_procedure0_0(S_max_fft_peaks,g_max_fft_peaks);
  gh_new_procedure1_0(S_set_max_fft_peaks,g_set_max_fft_peaks);
  gh_new_procedure0_0(S_max_fft_size,g_max_fft_size);
  gh_new_procedure1_0(S_set_max_fft_size,g_set_max_fft_size);
  gh_new_procedure0_2(S_ffting,g_ffting);
  gh_new_procedure0_3(S_set_ffting,g_set_ffting);
  gh_new_procedure0_2(S_waving,g_waving);
  gh_new_procedure0_3(S_set_waving,g_set_waving);
  gh_new_procedure0_2(S_graphing,g_graphing);
  gh_new_procedure0_3(S_set_graphing,g_set_graphing);
  gh_new_procedure0_2(S_squelch_update,g_squelch_update);
  gh_new_procedure0_3(S_set_squelch_update,g_set_squelch_update);
  gh_new_procedure0_2(S_edits,g_edits);
  gh_new_procedure0_2(S_maxamp,g_maxamp);
  gh_new_procedure0_3(S_peaks,g_peaks);
  gh_new_procedure0_2(S_marks,g_marks);
  gh_new_procedure0_3(S_mark_sample,g_mark_sample);
  gh_new_procedure1_3(S_set_mark_sample,g_set_mark_sample);
  gh_new_procedure0_3(S_mark_name,g_mark_name);
  gh_new_procedure1_3(S_set_mark_name,g_set_mark_name);
  gh_new_procedure0_3(S_add_mark,g_add_mark);
  gh_new_procedure0_3(S_delete_mark,g_delete_mark);
  gh_new_procedure0_2(S_delete_marks,g_delete_marks);
  gh_new_procedure1_2(S_find_mark,g_find_mark);
  gh_new_procedure0_3(S_undo,g_undo);
  gh_new_procedure0_3(S_redo,g_redo);
  gh_new_procedure0_4(S_insert_region,g_insert_region);
  gh_new_procedure0_0(S_cut,g_cut);
  gh_new_procedure0_0(S_selected_sound,g_selected_sound);
  gh_new_procedure0_1(S_selected_channel,g_selected_channel);
  gh_new_procedure0_1(S_select_sound,g_select_sound);
  gh_new_procedure0_1(S_select_channel,g_select_channel);
  gh_new_procedure0_1(S_save_control_panel,g_control_panel_save);
  gh_new_procedure0_1(S_restore_control_panel,g_control_panel_restore);
  gh_new_procedure0_2(S_x_bounds,g_x_bounds);
  gh_new_procedure0_2(S_y_bounds,g_y_bounds);
  gh_new_procedure2_2(S_set_x_bounds,g_set_x_bounds);
  gh_new_procedure0_4(S_set_y_bounds,g_set_y_bounds);
  gh_new_procedure3_2(S_set_y_limits,g_set_y_limits);

  gh_new_procedure1_3(S_insert_sound,g_insert_file);
  gh_new_procedure1_0(S_open_sound,g_open);
  gh_new_procedure4_0(S_open_raw_sound,g_open_raw_sound);
  gh_new_procedure1_0(S_open_alternate_sound,g_open_alternate);
  gh_new_procedure1_0(S_view_sound,g_view);
  gh_new_procedure1_4(S_new_sound,g_new_file);
  gh_new_procedure0_1(S_close_sound,g_close);
  gh_new_procedure0_1(S_update_sound,g_update);
  gh_new_procedure0_1(S_revert_sound,g_revert);
  gh_new_procedure0_1(S_save_sound,g_save);
  gh_new_procedure1_4(S_save_sound_as,g_save_as);
  gh_new_procedure1_0(S_preload_directory,g_preload_directory);
  gh_new_procedure1_0(S_preload_file,g_preload_file);
  gh_new_procedure1_0(S_yes_or_no_p,g_yes_or_no_p);

  gh_new_procedure0_1(S_forward_sample,g_forward_sample);
  gh_new_procedure0_1(S_backward_sample,g_backward_sample);
  gh_new_procedure0_1(S_forward_graph,g_forward_graph);
  gh_new_procedure0_1(S_backward_graph,g_backward_graph);
  gh_new_procedure0_1(S_forward_mark,g_forward_mark);
  gh_new_procedure0_1(S_backward_mark,g_backward_mark);
  gh_new_procedure0_1(S_forward_mix,g_forward_mix);
  gh_new_procedure0_1(S_backward_mix,g_backward_mix);

  gh_new_procedure0_0(S_regions,g_regions);
  gh_new_procedure0_1(S_region_length,g_region_length);
  gh_new_procedure0_1(S_region_srate,g_region_srate);
  gh_new_procedure0_1(S_region_chans,g_region_chans);
  gh_new_procedure0_1(S_region_maxamp,g_region_maxamp);
  gh_new_procedure2_1(S_save_region,g_save_region);
  gh_new_procedure0_1(S_select_region,g_select_region);
  gh_new_procedure0_1(S_delete_region,g_delete_region);
  gh_new_procedure2_0(S_protect_region,g_protect_region);
  gh_new_procedure0_1(S_play_region,g_play_region);
  gh_new_procedure2_2(S_make_region,g_make_region);
  gh_new_procedure0_0(S_selection_beg,g_selection_beg);
  gh_new_procedure0_0(S_selection_length,g_selection_length);
  gh_new_procedure2_0(S_selection_member,g_selection_member);
  gh_new_procedure0_2(S_select_all,g_select_all);
  gh_new_procedure9_0(S_restore_region,g_restore_region);
  gh_new_procedure0_1(S_scale_selection_to,g_scale_selection_to);
  gh_new_procedure0_1(S_scale_selection_by,g_scale_selection_by);
  gh_new_procedure0_5(S_mix_region,g_mix_region);
  gh_new_procedure0_3(S_region_sample,g_region_sample);
  gh_new_procedure0_4(S_region_samples,g_region_samples);

  gh_new_procedure0_2(S_update_graph,g_update_graph);
  gh_new_procedure0_2(S_update_fft,g_update_fft);
  gh_new_procedure0_3(S_play,g_play);
  gh_new_procedure0_3(S_play_and_wait,g_play_and_wait);
  gh_new_procedure0_1(S_stop_playing,g_stop_playing);
  gh_new_procedure0_0(S_groups,g_groups);
  gh_new_procedure1_0(S_group_okQ,g_group_ok);

  gh_new_procedure0_0(S_exit,g_exit);
  gh_new_procedure0_0(S_abort,g_abort);
  gh_new_procedure0_0(S_dismiss_all_dialogs,g_dismiss_all);
  gh_new_procedure0_0(S_abortQ,g_abortq);
  gh_new_procedure0_0(S_version,g_version);
  gh_new_procedure0_0(S_show_listener,g_show_listener);
  gh_new_procedure0_0(S_hide_listener,g_hide_listener);
  gh_new_procedure0_0(S_activate_listener,g_activate_listener);
  gh_new_procedure0_0(S_graph_ps,g_graph2ps);
  gh_new_procedure1_0(S_save_state,g_save_state);
  gh_new_procedure0_0(S_save_macros,g_save_macros);
  gh_new_procedure0_1(S_save_marks,g_save_marks);
  gh_new_procedure1_0(S_save_options,g_save_options);
  gh_new_procedure0_1(S_save_envelopes,g_save_envelopes);
  gh_new_procedure0_3(S_scale_to,g_scale_to);
  gh_new_procedure0_3(S_scale_by,g_scale_by);

  gh_new_procedure0_0(S_window_width,g_window_width);
  gh_new_procedure0_0(S_window_height,g_window_height);
  gh_new_procedure1_0(S_set_window_width,g_set_window_width);
  gh_new_procedure1_0(S_set_window_height,g_set_window_height);
  gh_new_procedure0_0(S_normalize_view,g_normalize_view);

  gh_new_procedure0_1(S_syncing,g_syncing);
  gh_new_procedure0_2(S_set_syncing,g_set_syncing);
  gh_new_procedure0_1(S_uniting,g_uniting);
  gh_new_procedure0_2(S_set_uniting,g_set_uniting);
  gh_new_procedure0_1(S_read_only,g_read_only);
  gh_new_procedure0_2(S_set_read_only,g_set_read_only);
  gh_new_procedure0_1(S_expanding,g_expanding);
  gh_new_procedure0_2(S_set_expanding,g_set_expanding);
  gh_new_procedure0_1(S_contrasting,g_contrasting);
  gh_new_procedure0_2(S_set_contrasting,g_set_contrasting);
  gh_new_procedure0_1(S_reverbing,g_reverbing);
  gh_new_procedure0_2(S_set_reverbing,g_set_reverbing);
  gh_new_procedure0_1(S_filtering,g_filtering);
  gh_new_procedure0_2(S_set_filtering,g_set_filtering);
  gh_new_procedure0_1(S_filter_dBing,g_filter_dBing);
  gh_new_procedure1_1(S_set_filter_dBing,g_set_filter_dBing);
  gh_new_procedure0_1(S_filter_order,g_filter_order);
  gh_new_procedure1_1(S_set_filter_order,g_set_filter_order);
  gh_new_procedure0_1(S_file_name,g_file_name);
  gh_new_procedure0_1(S_short_file_name,g_short_file_name);
  gh_new_procedure0_1(S_contrast,g_contrast);
  gh_new_procedure1_1(S_set_contrast,g_set_contrast);
  gh_new_procedure0_1(S_contrast_amp,g_contrast_amp);
  gh_new_procedure1_1(S_set_contrast_amp,g_set_contrast_amp);
  gh_new_procedure0_1(S_expand,g_expand);
  gh_new_procedure1_1(S_set_expand,g_set_expand);
  gh_new_procedure0_1(S_expand_length,g_expand_length);
  gh_new_procedure1_1(S_set_expand_length,g_set_expand_length);
  gh_new_procedure0_1(S_expand_ramp,g_expand_ramp);
  gh_new_procedure1_1(S_set_expand_ramp,g_set_expand_ramp);
  gh_new_procedure0_1(S_expand_hop,g_expand_hop);
  gh_new_procedure1_1(S_set_expand_hop,g_set_expand_hop);
  gh_new_procedure0_1(S_speed,g_speed);
  gh_new_procedure1_1(S_set_speed,g_set_speed);
  gh_new_procedure0_1(S_reverb_length,g_reverb_length);
  gh_new_procedure1_1(S_set_reverb_length,g_set_reverb_length);
  gh_new_procedure0_1(S_reverb_scale,g_reverb_scale);
  gh_new_procedure1_1(S_set_reverb_scale,g_set_reverb_scale);
  gh_new_procedure0_1(S_reverb_feedback,g_reverb_feedback);
  gh_new_procedure1_1(S_set_reverb_feedback,g_set_reverb_feedback);
  gh_new_procedure0_1(S_reverb_lowpass,g_reverb_lowpass);
  gh_new_procedure1_1(S_set_reverb_lowpass,g_set_reverb_lowpass);
  gh_new_procedure0_1(S_cursor_follows_play,g_cursor_follows_play);
  gh_new_procedure0_2(S_set_cursor_follows_play,g_set_cursor_follows_play);
  gh_new_procedure0_1(S_amp,g_amp);
  gh_new_procedure1_1(S_set_amp,g_set_amp);
  gh_new_procedure0_1(S_okQ,g_ok);
  gh_new_procedure1_1(S_report_in_minibuffer,g_report_in_minibuffer);
  gh_new_procedure1_1(S_append_to_minibuffer,g_append_to_minibuffer);
  gh_new_procedure0_1(S_showing_controls,g_showing_controls);
  gh_new_procedure0_2(S_set_showing_controls,g_set_show_controls);
  gh_new_procedure0_1(S_filter_env,g_filter_env);
  gh_new_procedure1_1(S_set_filter_env,g_set_filter_env);
  gh_new_procedure2_0(S_set_env_base,g_set_env_base);

  gh_new_procedure1_1(S_override_data_location,g_override_data_location);
  gh_new_procedure1_1(S_override_data_format,g_override_data_format);
  gh_new_procedure1_1(S_override_data_size,g_override_data_size);
  gh_new_procedure0_4(S_open_sound_file,g_open_sound_file);
  gh_new_procedure2_0(S_close_sound_file,g_close_sound_file);
  gh_new_procedure3_0(S_vct_sound_file,vct2soundfile);

  gh_new_procedure1_0(S_find_sound,g_find_sound);
  gh_new_procedure0_2(S_transform_samples,g_transform_samples);
  gh_new_procedure0_4(S_transform_sample,g_transform_sample);

  gh_new_procedure1_3(S_env_selection,g_env_selection);
  gh_new_procedure1_5(S_env_sound,g_env_sound);
  gh_new_procedure1_4(S_mix,g_mix_file);
  gh_new_procedure1_2(S_mix_overlay,g_mix_overlay);
  gh_new_procedure2_1(S_fft,g_fft);
  gh_new_procedure3_1(S_snd_spectrum,g_snd_spectrum);
  gh_new_procedure1_0(S_autocorrelate,g_autocorrelate);
  gh_new_procedure1_1(S_convolve_arrays,g_convolve);
  gh_new_procedure1_3(S_convolve_with,g_convolve_with);
  gh_new_procedure1_1(S_convolve_selection_with,g_convolve_selection_with);
  gh_new_procedure0_0(S_reverse_selection,g_reverse_selection);
  gh_new_procedure1_4(S_save_selection,g_save_selection);
  gh_new_procedure0_2(S_reverse_sound,g_reverse);
  gh_new_procedure2_2(S_smooth,g_smooth);
  gh_new_procedure0_0(S_smooth_selection,g_smooth_selection);
  gh_new_procedure1_1(S_src_sound,g_src_sound);
  gh_new_procedure1_1(S_src_selection,g_src_selection);
  gh_new_procedure2_2(S_filter_sound,g_filter_sound);
  gh_new_procedure2_0(S_filter_selection,g_filter_selection);
  gh_new_procedure1_0(S_call_plug,g_call_plug);
  gh_new_procedure1_0(S_call_plug_selection,g_call_plug_selection);
  gh_new_procedure1_0(S_describe_plug,g_describe_plug);
  gh_new_procedure0_1(S_call_apply,g_call_apply);

  gh_new_procedure1_0(S_temp_filenames,g_temp_filenames);
  gh_new_procedure0_2(S_sound_to_temp,g_sound_to_temp);
  gh_new_procedure0_2(S_sound_to_temps,g_sound_to_temps);
  gh_new_procedure0_2(S_selection_to_temp,g_selection_to_temp);
  gh_new_procedure0_2(S_selection_to_temps,g_selection_to_temps);
  gh_new_procedure3_0(S_temp_to_sound,g_temp_to_sound);
  gh_new_procedure3_0(S_temps_to_sound,g_temps_to_sound);
  gh_new_procedure3_0(S_temp_to_selection,g_temp_to_sound);
  gh_new_procedure3_0(S_temps_to_selection,g_temps_to_sound);

  gh_new_procedure2_0(S_key,g_key);
  gh_new_procedure1_3(S_find,g_find);
  gh_new_procedure1_3(S_count_matches,g_count_matches);
  gh_new_procedure1_0(S_add_to_main_menu,g_add_to_main_menu);
  gh_new_procedure3_0(S_add_to_menu,g_add_to_menu);
  gh_new_procedure2_0(S_remove_from_menu,g_remove_from_menu);
  gh_new_procedure3_0(S_change_menu_label,g_change_menu_label);
  gh_new_procedure3_0(S_set_menu_sensitive,g_set_menu_sensitive);

  gh_new_procedure2_0(S_update_var,g_save_defvar);
  gh_new_procedure1_2(S_save_edit_history,g_save_edit_history);
  gh_new_procedure1_7(S_graph,g_graph);
  gh_new_procedure3_1(S_bind_key,g_bindkey);
  gh_eval_str("(define unbind-key (lambda (key state) (bind-key key state \"cursor-no-action\")))");
  gh_new_procedure1_0(S_add_sound_file_extension,g_add_sound_file_extension);
  gh_new_procedure1_0(S_string_length,g_string_length);

#if HAVE_MAKE_SMOB_TYPE
  open_hook = scm_create_hook(S_open_hook,1);                 /* arg = filename */
  close_hook = scm_create_hook(S_close_hook,1);               /* arg = sound index */
  fft_hook = scm_create_hook(S_fft_hook,3);                   /* args = sound channel scaler */
  graph_hook = scm_create_hook(S_graph_hook,4);               /* args = sound channel y0 y1 */
  exit_hook = scm_create_hook(S_exit_hook,0);
  start_hook = scm_create_hook(S_start_hook,1);               /* arg = argv filename if any */
  mouse_press_hook = scm_create_hook(S_mouse_press_hook,6);     /* args = sound channel button state x y */
  mouse_release_hook = scm_create_hook(S_mouse_release_hook,6); /* args = sound channel button state x y */
  mouse_drag_hook = scm_create_hook(S_mouse_drag_hook,6);       /* args = sound channel button state x y */
  key_press_hook = scm_create_hook(S_key_press_hook,4);         /* args = sound channel key state */
  stop_playing_hook = scm_create_hook(S_stop_playing_hook,1); /* arg = sound */
  start_playing_hook = scm_create_hook(S_start_playing_hook,1); /* arg = sound file name */
  mark_click_hook = scm_create_hook(S_mark_click_hook,1);     /* arg = id */
#else
  open_hook = gh_define(S_open_hook,SCM_BOOL_F);
  close_hook = gh_define(S_close_hook,SCM_BOOL_F);
  fft_hook = gh_define(S_fft_hook,SCM_BOOL_F);
  graph_hook = gh_define(S_graph_hook,SCM_BOOL_F);
  exit_hook = gh_define(S_exit_hook,SCM_BOOL_F);
  start_hook = gh_define(S_start_hook,SCM_BOOL_F);
  mouse_press_hook = gh_define(S_mouse_press_hook,SCM_BOOL_F);
  mouse_release_hook = gh_define(S_mouse_release_hook,SCM_BOOL_F);
  mouse_drag_hook = gh_define(S_mouse_drag_hook,SCM_BOOL_F);
  key_press_hook = gh_define(S_key_press_hook,SCM_BOOL_F);
  stop_playing_hook = gh_define(S_stop_playing_hook,SCM_BOOL_F);
  start_playing_hook = gh_define(S_start_playing_hook,SCM_BOOL_F);
  mark_click_hook = gh_define(S_mark_click_hook,SCM_BOOL_F);
#endif

  memo_sound = gh_define(S_memo_sound,SCM_BOOL_F);

  gh_eval_str("(defmacro defvar (a b) `(update-var (symbol->string ',a) ,b))");
  /* this is trying to keep track of envelopes for the envelope editor */

  gh_define(S_amplitude_env,gh_int2scm(AMPLITUDE_ENV));
  gh_define(S_spectrum_env,gh_int2scm(SPECTRUM_ENV));
  gh_define(S_srate_env,gh_int2scm(SRATE_ENV));

  gh_define(S_graph_lines,gh_int2scm(GRAPH_LINES));
  gh_define(S_graph_dots,gh_int2scm(GRAPH_DOTS));
  gh_define(S_graph_filled,gh_int2scm(GRAPH_FILLED));
  gh_define(S_graph_dots_and_lines,gh_int2scm(GRAPH_DOTS_AND_LINES));
  gh_define(S_graph_lollipops,gh_int2scm(GRAPH_LOLLIPOPS));

  gh_define(S_normal_fft,gh_int2scm(NORMAL_FFT));
  gh_define(S_sonogram,gh_int2scm(SONOGRAM));
  gh_define(S_spectrogram,gh_int2scm(SPECTROGRAM));

  gh_define(S_focus_left,gh_int2scm(FOCUS_LEFT));
  gh_define(S_focus_right,gh_int2scm(FOCUS_RIGHT));
  gh_define(S_focus_active,gh_int2scm(FOCUS_ACTIVE));
  gh_define(S_focus_middle,gh_int2scm(FOCUS_MIDDLE));

  gh_define(S_x_in_seconds,gh_int2scm(X_IN_SECONDS));
  gh_define(S_x_in_samples,gh_int2scm(X_IN_SAMPLES));
  gh_define(S_x_to_one,gh_int2scm(X_TO_ONE));

  gh_define(S_speed_as_float,gh_int2scm(SPEED_AS_FLOAT));
  gh_define(S_speed_as_ratio,gh_int2scm(SPEED_AS_RATIO));
  gh_define(S_speed_as_semitone,gh_int2scm(SPEED_AS_SEMITONE));

  gh_define(S_channels_separate,gh_int2scm(CHANNELS_SEPARATE));
  gh_define(S_channels_combined,gh_int2scm(CHANNELS_COMBINED));
  gh_define(S_channels_superimposed,gh_int2scm(CHANNELS_SUPERIMPOSED));

  gh_define(S_fourier_transform,gh_int2scm(FOURIER));
  gh_define(S_wavelet_transform,gh_int2scm(WAVELET));
  gh_define(S_hankel_transform,gh_int2scm(HANKEL));
  gh_define(S_chebyshev_transform,gh_int2scm(CHEBYSHEV));
  gh_define(S_legendre_transform,gh_int2scm(LEGENDRE));
  gh_define(S_hadamard_transform,gh_int2scm(HADAMARD));
  gh_define(S_walsh_transform,gh_int2scm(WALSH));
  gh_define(S_autocorrelation,gh_int2scm(AUTOCORRELATION));

  gh_init_fft();
  gh_init_marks();
  init_vct();

  gh_define(S_cursor_in_view,gh_int2scm(CURSOR_IN_VIEW));
  gh_define(S_cursor_on_left,gh_int2scm(CURSOR_ON_LEFT));
  gh_define(S_cursor_on_right,gh_int2scm(CURSOR_ON_RIGHT));
  gh_define(S_cursor_in_middle,gh_int2scm(CURSOR_IN_MIDDLE));
  gh_define(S_cursor_update_display,gh_int2scm(CURSOR_UPDATE_DISPLAY));
  gh_define(S_cursor_no_action,gh_int2scm(CURSOR_NO_ACTION));
  gh_define(S_cursor_claim_selection,gh_int2scm(CURSOR_CLAIM_SELECTION));
  gh_define(S_keyboard_no_action,gh_int2scm(KEYBOARD_NO_ACTION));

  gh_new_procedure0_4(S_samples_vct,samples2vct);
  gh_new_procedure0_2(S_transform_samples_vct,transform_samples2vct);
  gh_new_procedure0_4(S_region_samples_vct,region_samples2vct);

  gh_new_procedure0_1(S_start_progress_report,g_start_progress_report);
  gh_new_procedure0_1(S_finish_progress_report,g_finish_progress_report);
  gh_new_procedure1_4(S_progress_report,g_progress_report);

  gh_new_procedure1_4(S_scan_chan,g_scan_chan);
  gh_new_procedure1_2(S_scan_chans,g_scan_chans);
  gh_new_procedure1_2(S_scan_all_chans,g_scan_all_chans);
  gh_new_procedure1_3(S_scan_sound_chans,g_scan_sound_chans);
  gh_new_procedure1_2(S_scan_across_chans,g_scan_across_chans);
  gh_new_procedure1_2(S_scan_across_all_chans,g_scan_across_all_chans);
  gh_new_procedure1_3(S_scan_across_sound_chans,g_scan_across_sound_chans);
  gh_new_procedure1_5(S_map_chan,g_map_chan);
  gh_new_procedure1_3(S_map_chans,g_map_chans);
  gh_new_procedure1_3(S_map_all_chans,g_map_all_chans);
  gh_new_procedure1_4(S_map_sound_chans,g_map_sound_chans);
  gh_new_procedure1_3(S_map_across_chans,g_map_across_chans);
  gh_new_procedure1_3(S_map_across_all_chans,g_map_across_all_chans);
  gh_new_procedure1_4(S_map_across_sound_chans,g_map_across_sound_chans);
  gh_new_procedure1_0(S_snd_print,g_snd_print);
  gh_new_procedure0_0(S_describe_audio,g_describe_audio);
  gh_new_procedure0_2(S_bomb,g_bomb);

#if WITH_MUS_MODULE
  init_mus2scm_module();
#endif
}

#if HAVE_MAKE_SMOB_TYPE
/* use Guile 1.3.2 hook support (this used to use strings) */

static SCM g_c_run_progn_hook (SCM hook, SCM args)
{
  /* Guile built-in scm_c_run_hook doesn't return the value of the hook procedure(s) */
  SCM result;
  SCM procs = SCM_HOOK_PROCEDURES (hook);
  while (SCM_NIMP (procs))
    {
      result = scm_apply (SCM_CAR (procs), args, SCM_LIST0);
      procs = SCM_CDR (procs);
    }
  return(result);
}

static SCM g_c_run_or_hook (SCM hook, SCM args)
{
  /* Guile built-in scm_c_run_hook doesn't return the value of the hook procedure(s) */
  SCM result;
  SCM procs = SCM_HOOK_PROCEDURES (hook);
  while (SCM_NIMP (procs))
    {
      result = scm_apply (SCM_CAR (procs), args, SCM_LIST0);
      if (result == SCM_BOOL_T) return(result);
      procs = SCM_CDR (procs);
    }
  return(result);
}

int dont_open(snd_state *ss, char *file)
{
  SCM res = SCM_BOOL_F;
  if (!(ss->open_hook_active))
    {
      if (scm_hook_empty_p(open_hook) == SCM_BOOL_F)
	{
	  ss->open_hook_active = 1;
	  res = g_c_run_or_hook(open_hook,SCM_LIST1(gh_str02scm(mus_complete_filename(file))));
	  ss->open_hook_active = 0;
	}
    }
  return(res == SCM_BOOL_T);
}

int dont_close(snd_state *ss, snd_info *sp)
{
  SCM res = SCM_BOOL_F;
  if (!(ss->close_hook_active))
    {
      if (scm_hook_empty_p(close_hook) == SCM_BOOL_F)
	{
	  ss->close_hook_active = 1;
	  res = g_c_run_or_hook(close_hook,SCM_LIST1(gh_int2scm(sp->index)));
	  ss->close_hook_active = 0;
	}
    }
  return(res == SCM_BOOL_T);
}

int after_fft(snd_state *ss, chan_info *cp, float scaler)
{
  SCM res = SCM_BOOL_F;
  if (!(ss->fft_hook_active))
    {
      if (scm_hook_empty_p(fft_hook) == SCM_BOOL_F)
	{
	  ss->fft_hook_active = 1;
	  res = g_c_run_progn_hook(fft_hook,
				   SCM_LIST3(gh_int2scm((cp->sound)->index),
					     gh_int2scm(cp->chan),
					     gh_double2scm(scaler)));
	  ss->fft_hook_active = 0;
	}
    }
  return(res == SCM_BOOL_T);
}

int dont_graph(snd_state *ss, chan_info *cp)
{
  SCM res = SCM_BOOL_F;
  if (!(ss->graph_hook_active))
    {
      if (scm_hook_empty_p(graph_hook) == SCM_BOOL_F)
	{
	  ss->graph_hook_active = 1;
	  res = g_c_run_progn_hook(graph_hook,
				   SCM_LIST4(gh_int2scm((cp->sound)->index),
					     gh_int2scm(cp->chan),
					     gh_double2scm((cp->axis)->y0),
					     gh_double2scm((cp->axis)->y1)));
	  ss->graph_hook_active = 0;
	}
    }
  return(res == SCM_BOOL_T);
}

int dont_exit(snd_state *ss)
{
  SCM res = SCM_BOOL_F;
  if (!(ss->exit_hook_active))
    {
      if (scm_hook_empty_p(exit_hook) == SCM_BOOL_F)
	{
	  ss->exit_hook_active = 1;
	  res = g_c_run_or_hook(exit_hook,SCM_LIST0);
	  ss->exit_hook_active = 0;
	}
    }
  return(res == SCM_BOOL_T);
}
  
int dont_start(snd_state *ss, char *filename)
{
  SCM res = SCM_BOOL_F;
  if (!(ss->start_hook_active))
    {
      if (scm_hook_empty_p(start_hook) == SCM_BOOL_F)
	{
	  ss->start_hook_active = 1;
	  res = g_c_run_or_hook(start_hook,SCM_LIST1(gh_str02scm(filename)));
	  ss->start_hook_active = 0;
	}
    }
  return(res == SCM_BOOL_T);
}

int handle_mark_click(snd_state *ss, int id)
{
  SCM res = SCM_BOOL_F;
  if (scm_hook_empty_p(mark_click_hook) == SCM_BOOL_F)
    res = g_c_run_progn_hook(mark_click_hook,SCM_LIST1(gh_int2scm(id)));
  return(res == SCM_BOOL_T);
}
  
/* mouse/key events within lisp graph */

static void handle_mouse_event(SCM hook, snd_state *ss, snd_info *sp, chan_info *cp, float x, float y, int button, int state)
{
  if (scm_hook_empty_p(hook) == SCM_BOOL_F)
    g_c_run_progn_hook(hook,
		       SCM_LIST6(gh_int2scm(sp->index),
				 gh_int2scm(cp->chan),
				 gh_int2scm(button),
				 gh_int2scm(state),
				 gh_double2scm(x),
				 gh_double2scm(y)));
}

void handle_mouse_release(snd_state *ss, snd_info *sp, chan_info *cp, float x, float y, int button, int state)
{
  handle_mouse_event(mouse_release_hook,ss,sp,cp,x,y,button,state);
}

void handle_mouse_press(snd_state *ss, snd_info *sp, chan_info *cp, float x, float y, int button, int state)
{
  handle_mouse_event(mouse_press_hook,ss,sp,cp,x,y,button,state);
}

void handle_mouse_drag(snd_state *ss, snd_info *sp, chan_info *cp, float x, float y)
{
  handle_mouse_event(mouse_drag_hook,ss,sp,cp,x,y,-1,-1);
}

int handle_key_press(snd_state *ss, snd_info *sp, chan_info *cp, int key, int state)
{
  /* return TRUE to keep this key press from being passed to keyboard_command */
  SCM res = SCM_BOOL_F;
  if (scm_hook_empty_p(key_press_hook) == SCM_BOOL_F)
    res = g_c_run_or_hook(key_press_hook,
			  SCM_LIST4(gh_int2scm((cp->sound)->index),
				    gh_int2scm(cp->chan),
				    gh_int2scm(key),
				    gh_int2scm(state)));
  return(res == SCM_BOOL_T);
}

void call_stop_playing_hook(snd_info *sp)
{
  if (scm_hook_empty_p(stop_playing_hook) == SCM_BOOL_F)
    g_c_run_or_hook(stop_playing_hook,SCM_LIST1(gh_int2scm(sp->index)));
}

int call_start_playing_hook(snd_info *sp)
{
  SCM stop = SCM_BOOL_F;
  if (scm_hook_empty_p(start_playing_hook) == SCM_BOOL_F)
    stop = g_c_run_or_hook(start_playing_hook,SCM_LIST1(gh_str02scm(sp->fullname)));
  return(stop == SCM_BOOL_T);
}
#else
int dont_open(snd_state *ss, char *file) {return(0);}
int dont_close(snd_state *ss, snd_info *sp) {return(0);}
int after_fft(snd_state *ss, chan_info *cp, float scaler) {return(0);}
int dont_graph(snd_state *ss, chan_info *cp) {return(0);}
int dont_exit(snd_state *ss) {return(0);}
int dont_start(snd_state *ss, char *filename) {return(0);}
int handle_mark_click(snd_state *ss, int id) {return(0);}
void handle_mouse_release(snd_state *ss, snd_info *sp, chan_info *cp, float x, float y, int button, int state) {}
void handle_mouse_press(snd_state *ss, snd_info *sp, chan_info *cp, float x, float y, int button, int state) {}
void handle_mouse_drag(snd_state *ss, snd_info *sp, chan_info *cp, float x, float y) {}
int handle_key_press(snd_state *ss, snd_info *sp, chan_info *cp, int key, int state) {return(0);}
void call_stop_playing_hook(snd_info *sp) {}
int call_start_playing_hook(snd_info *sp) {}
#endif

void after_open(snd_info *sp)
{
  GH_INT_SET(memo_sound,sp->index);
}

int handle_keymap(chan_info *cp, char *code, SCM func) /* not a hook! */
{
  SCM result;
  if (code)
    result = scm_internal_stack_catch(SCM_BOOL_T,eval_str_wrapper,code,clm_handler,code);
  else result = gh_call0(func);
  if ((gh_number_p(result)) && (gh_exact_p(result))) return(gh_scm2int(result));
  return(KEYBOARD_NO_ACTION);
}

#endif

