// pvocheader.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "application.h"
#include "pvocheader.h"
#include "pvocdata.h"

PvocHeader::PvocHeader(int chans, int frate) 
		: HybridHeader(FloatData, frate, chans, 0) {
	data_offset = diskHeaderSize();
}

PvocHeader::PvocHeader() 
		: HybridHeader(FloatData,
			       PvocData::defaultFrameRate(),
			       PvocData::defaultNumberOfBands(),
			       0) {
	data_offset = diskHeaderSize();
}

int
PvocHeader::checkHeader() {
	char msg[64];
	msg[0] = '\0';	// null for later check
	int retcode = 0;
	if(nchans == 0 || nchans % 2 != 0)
		sprintf(msg, "Possibly corrupt header: nchans = %d", nchans);
	else if(data_type != FloatData)
		sprintf(msg, "Possibly corrupt header: unknown pvoc sample format");
	// correct in event of missing or corrupt offset information
	else if(!isRaw() && data_offset < diskHeaderInfoSize()) {
		sprintf(msg, "Warning:  corrupt header data offset (%d)", data_offset);
		setDataOffset(diskHeaderInfoSize());
		retcode = 1;		// nonfatal error
	}
	else retcode = 1;
	if(strlen(msg))
		Application::alert(msg);
	return retcode;
}

const char*
PvocHeader::magicError() {
	static char msg[120];
	sprintf(msg, "Unknown or invalid phase vocoder datafile magic number: %d",
		magic());
	return msg;
}
