// pvocdata.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
// Data subclass specialized for storage and manipulation of Phase Vocoder
// analysis data.  See phasevocoder.h, pvoceditor.h, and pvocmodifier.h.

#ifndef PVOCDATA_H
#ifdef __GNUG__
#pragma interface
#endif
#define PVOCDATA_H

#include "framedata.h"

class DataFile;
class Header;
class Range;
class Controller;
class PvocModifier;

class PvocData : public FrameData {
	typedef FrameData Super;
public:		// class methods
	static int defaultNumberOfBands() { return default_NumberOfBands; }
	static void setDefaultNumberOfBands(int bands);
	static double defaultFrameRate() { return default_FrameRate; }
	static void setDefaultFrameRate(double rate);
public:		// object methods
	PvocData(int length=16, int nchans=1026, int srate=44100, double frate=200)
		: FrameData(FloatData, length, nchans, srate, frate) {}
	virtual ~PvocData() {} 
	redefined Data *newData();
	redefined Data *newData(int length);
	redefined Data *clone(const Range &);
	redefined Data *clone(const Range &, const Range &);

	redefined void information(Controller *);
	redefined void print(FILE *);
	redefined FileType fileType() const { return Pvoc_Data; }
	redefined const char *fileSuffix() const { return ".pv"; }
	redefined Range limits(int chan=0, boolean real=false) const;
	redefined Range frameRange(RangeUnit units) const;
	redefined const char* frameRangeLabel(RangeUnit units) const;
	redefined int frameChannels() const { return 2; }

	int nBands() const { return int(channels() / 2.0); }
	int getBandNumber(double freq) const;

	// information methods for display objects
	redefined const char* windowClassName() const { return "PvocWindow"; }
	redefined const char* horizontalScaleModeAttribute() const {
		return "PvocWindowHorizontalScale";
	}
	redefined const char* channelDisplayAttribute() const {
		return "PvocWindowDisplayChannels";
	}
	redefined const char* defaultDirAttribute() const {
		return "DefaultPvocFileDir";
	}
	redefined const char* channelName(int chan) const;
	redefined Header* createHeader(DataFile *, boolean reading);
protected:
	PvocData(const PvocData *l) : FrameData(l) {}
	PvocData(const PvocData *l, int newlen) : FrameData(l, newlen) {}
	PvocData(const PvocData *l, const Range &r) : FrameData(l, r) {} 
	PvocData(const PvocData *l, const Range &r, const Range &c)
		: FrameData(l, r, c) {} 
	redefined void readFromHeader(Header *);
private:	// class members
	static int default_NumberOfBands;
	static double default_FrameRate;
};

inline Range
PvocData::frameRange(RangeUnit units) const {
	return (units == ChannelSpecialUnit) ?
		Range(0.0, sRate()/2.0) : Super::frameRange(units);
}

inline const char*
PvocData::frameRangeLabel(RangeUnit units) const {
	return (units == ChannelSpecialUnit) ? "Frequency in Hz."
		: (units == ChannelUnit) ? "Band Number"
		: Super::frameRangeLabel(units);
}

#endif
