// fftdata.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FrameData subclass for storing results of FFT analyses.

#ifndef FFTDATA_H
#ifdef __GNUG__
#pragma interface
#endif
#define FFTDATA_H

#include "framedata.h"
#include "range.h"

class DataFile;
class Header;
class Controller;

class FFTData : public FrameData {
	typedef FrameData Super;
public:
	FFTData(int len=32, int npoints=512, double framerate=100, int srate=44100)
			: FrameData(DoubleData, len, npoints, srate, framerate) {
		displayAsFrames(true);
	}
	virtual ~FFTData() {}
	redefined Data *newData();
	redefined Data *newData(int length);
	redefined Data *clone(const Range &r);
	redefined Data *clone(const Range &r, const Range &c);

	redefined int frameSize() const { return channels(); }
	redefined Range limits(int chan=0, boolean real=false) const;
	redefined Range frameRange(RangeUnit units) const {
		return (units == ChannelSpecialUnit) ?
			Range(0.0, sRate()/2.0) : FrameData::frameRange(units);
	}
	redefined const char* frameRangeLabel(RangeUnit units) const {
		return (units == ChannelSpecialUnit) ? "Frequency in Hz."
			: (units == ChannelUnit) ? "Point Number"
			: FrameData::frameRangeLabel(units);
	}
	int nPoints() const { return channels(); }

	redefined void print(FILE *);
	redefined void information(Controller *);
	redefined FileType fileType () const { return FFT_Data; }
	redefined const char *fileSuffix() const { return ".fft"; }
	// information methods for display objects
	redefined const char* windowClassName() const { return "FFTWindow"; }
	redefined const char* horizontalScaleModeAttribute() const {
		return "FFTWindowHorizontalScale";
	}
	redefined const char* channelDisplayAttribute() const {
		return "FFTWindowDisplayChannels";
	}
	redefined const char* defaultDirAttribute() const {
		return "DefaultFFTFileDir";
	}
	redefined const char *channelName(int chan) const;
	redefined Header* createHeader(DataFile *, boolean reading);
protected:
	FFTData(const FFTData *f) : FrameData(f) {}
	FFTData(const FFTData *f, int newlen) : FrameData(f, newlen) {}
	FFTData(const FFTData *f, const Range &selection)
		: FrameData(f, selection) {}
	FFTData(const FFTData *f, const Range &selection, const Range &chans)
		: FrameData(f, selection, chans) {}
};

#endif

