/*
 * GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1999 by Dave J. Andruczyk 
 * 
 * Based upon Code written by The Rasterman and DrMike from redhat.com
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>
#ifdef USE_ALSA
#include <sys/asoundlib.h>
#endif


#define WINDOW_FUNC  6

/* RATE  is sample rate (samples/sec) */
#define BUFS   12	// number of audio buffers (lag compensation)
#define RATE   44100

#define MAXBANDS 	128		// maximum number of bands
#define SUPPRESS	0x1
#define DECAY		0x2
#define BANDS		0x4
#define SENSE		0x800
#define LAG		0x1000
#define SPIKE		0x20000

#define CHANGE_X_START	0x200000
#define CHANGE_X_END	0x400000
#define CHANGE_SPEC_START	0x800000

#define LOG		0x1000000
#define LINEAR		0x2000000

#define LAND_3D		0x11
#define EQ_2D		0x12
#define SCOPE		0x13
#define SPIKE_3D	0x14
#define STARS		0x15
#define SPECGRAM	0x16
#define WINDOW		0x17
#define OK		0x19
#define CANCEL		0x20
#define FILL_3D		0x21
#define WIRE_3D		0x22
#define DOT_SCOPE	0x23
#define LINE_SCOPE	0x24
#define GRAD_SCOPE	0x25
#define ON_THE_LINE	0x26
#define OFF_THE_LINE	0x27
#define ESD		0x28
#define ALSA		0x29

gint 	      nsamp;	// number of samples
gint 	      bands;	// to start with, should be configurable
GtkWidget     *disp;
GtkWidget     *optionsbut;
GtkWidget     *dir_win;
GtkWidget     *dir_area;	// directional window area
GdkPixmap     *dir_pixmap;	// directional window pixmap
GdkPixmap     *grad_pixmap;	// color gradient window pixmap
GdkWindow     *win;
GtkWidget     *grad_disp;
GtkWidget     *window_function;
GdkGC         *gc;
GdkGC 	      *arc_gc;
GdkPixmap     *pixmap;
GtkWidget     *options;
gint           width;
gint           height;
gint           dir_width;
gint           dir_height;
gint           colortab[MAXBANDS][MAXBANDS];// ugly, statically allocated to up to MAXBANDS bands
gint           colortab[MAXBANDS][MAXBANDS];// ugly, statically allocated to up to MAXBANDS bands
gint           mode;
GdkImlibImage *im;
GdkPixmap     *grad[256];

gshort        *incoming_buf[BUFS]; // Array of pointers to audio data from esd
gshort        *mixdown_buf[BUFS]; // Array of pointers to mixed to mono data
gdouble       *datawindow;	// pointer to window function array
gdouble        datawindowsum;	// sum of above
gdouble       *audio_data;	// pointer to audio buffer being crunched 
gdouble       *audio_left;	// left channel (scope??)
gdouble       *audio_right;	// right channel (scope??)
gdouble       *audio_last_l;	// last one of above, left channel (scope??)
gdouble       *audio_last_r;	// last one of above, right channel (scope??)
gdouble       *raw_fft_out;	// RAW output of fft routine
gdouble       *norm_fft;	// normalized fft data
gint	      *pip_arr;		// array of pip values for screen
gint	      *disp_val;	// Display level for screen
gint           sound;
gint           curbuf;
gint           lag;

// New stuff (configurables)

gint seg_height;	// height per segment in 2d spectrum analyzer
gint seg_space;		// space between segments in 2d analyzer
gint slide;		// slide and decay are tied together
gint decay_val;	// decay_val ONLY works with slide "on" (1)
gint xdet_scroll;	// detailed scroll in pixels
gint zdet_scroll;	// detailed scroll in pixels
gfloat xdet_start;	// The 3d DETAILED fft's amount of horizontal
gfloat ydet_start;	// detailed y axis start position (percent)
gfloat x3d_start;	// The 3d X start point of axis (percentage)
gfloat y3d_start;	// The 3d Y start point of axis (percentage)
gfloat xdet_end;	// The 3d DETAILED fft's amount of horizontal
gfloat ydet_end;	// detailed y axis start position (percent)
gfloat x3d_end;		// 3D fft X end point of axis (percentage)
gfloat y3d_end;		// 3D fft Y end point of axis (percentage)
gint x3d_scroll;	// 3D scroll in pixels x axis
gint z3d_scroll;	// 3D scroll in pixels z axis
gint det_size;		// detailed size of each pip

gint x_draw_width;	// 3D drawing area space after calculations
gint y_draw_height;	// 3D drawing area space after calculations

gint time_border;	// border bottom of spectragram
gint x_border;		// border on right side of display
gint x_offset;		// 3D X axis offset for centering
gint x_shift;		// 3D shift factor(x axis)depending on axis tilt
gint x_shift_per_block;	// shift in pixels per block for 3D mode

gint y_border;		// border on right side of display
gint y_offset;		// 3D X axis offset for centering
gint y_shift;		// 3D shift factor(x axis)depending on axis tilt
gint y_shift_per_block;	// shift in pixels per block for 3D mode
float scale;
gint  scalefixed;	// its NOT fixed YET. (done dynamically)
gint  sensefixed;	// its NOT fixed YET. (done dynamically)
float scalefactor; 	// dynamically figured out by the program
gint show_leader;	// show leading edge on 3d landscape fft
			// space used. (just run it to see.... :)
gint sensitivity;	// Brightness sensitivity, so the colortable
			// WON'T max out when you resize
gfloat ydet_special;
gint x_fudge;		// fudge factor
gint y_fudge;		// fudge factor
gint top;		// Top of window
gint bottom;		// Bottom or window
gint lo_width;		// Local width. (window inside of window)
gint maxlevel;		// maximum level reached on Graphic Eq mode
gint prevlevel;		// maximum level reached on Graphic Eq mode
gint bar_start;		// start position for bars on graphic EQ
gfloat pix_per_block;	// pixels per block
gint pix_int;		// int version of above
gint space_used;	// space the display takes up
gint extras;
gint to_get; 
gint pos;
gint last_is_full; // its initially ready ??
gint ready;		// is everything initialized?
gfloat x_disp; // X displacement
gfloat y_disp; // Y displacement
gfloat old_x_disp; // X displacement
gfloat old_y_disp; // Y displacement
gint dir_win_present;
gint grad_win_present;

// Test for slider updates
GtkObject *x3d_start_ptr;
GtkObject *x3d_end_ptr;
GtkObject *y3d_start_ptr;
GtkObject *y3d_end_ptr;
GtkObject *xdet_start_ptr;
GtkObject *xdet_end_ptr;
GtkObject *ydet_start_ptr;
GtkObject *ydet_end_ptr;
GtkObject *x3d_scroll_ptr;
GtkObject *z3d_scroll_ptr;
GtkObject *xdet_scroll_ptr;
GtkObject *zdet_scroll_ptr;
GtkWidget *main_win_ptr;
GtkWidget *dir_win_ptr;
GtkWidget *about_but_ptr;
GtkWidget *grad_win;
GtkWidget *grad_win_ptr;

GtkWidget *colorseldlg; 


double levels[MAXBANDS];
gint pt_lock;
gint one_to_fix;
gint axis_type;
gint window_func;
gint bands_per_block;
gint main_x_origin;
gint main_y_origin;
gint grad_x_origin;
gint grad_y_origin;
gint dir_x_origin;
gint dir_y_origin;
gint tape_scroll;
gint display_markers;
gfloat spec_start;
gint rerun;
gint color_loc;		// pixel location in color gradient for color mapper
gint spec_drag; 	// spectragram is being dragged
gfloat win_scale;
gint cr[MAXBANDS],cg[MAXBANDS],cb[MAXBANDS];
gint scope_sub_mode;		// sub mode 
gint sub_mode;		// sub mode 
gint sound_source;
gint left_amplitude;
gint right_amplitude;
int alsa_fd;


GdkColor temp_color;
GdkColor start,pt2,pt3,pt4,end,final;


