/*
 * Copyright (c) 1999 Robert Woodcock <rcw@debian.org>
 * This code is hereby licensed for public consumption under either the
 * GNU GPL v2 or greater, or Larry Wall's Artistic license - your choice.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/cdrom.h>

struct cdrom_tocentry TocEntry[101];

int cddb_sum (int n)
{
	/* a number like 2344 becomes 2+3+4+4 (13) */
	int ret=0;

	while (n > 0) {
		ret = ret + (n % 10);
		n = n / 10;
	}

	return ret;
}

int main(int argc, char *argv[])
{
	int drive, i, totaltime;
	long int cksum=0;
	unsigned char first=1, last=1;
	struct cdrom_tochdr hdr;
	
	if (argc < 2) {
		fprintf(stderr, "Usage: %s <devicename>\n", argv[0]);
		exit(1);
	}

	drive = open(argv[1], 0);
	if (drive < 0) {
		perror("cd-discid: open");
		exit(1);
	}

	if (ioctl(drive,CDROMREADTOCHDR,&hdr) < 0) {
		perror("cdgrab: CDROMREADTOCHDR");
		return -1;
	}

	first=hdr.cdth_trk0;
	last=hdr.cdth_trk1;

	for (i=1; i<=last; i++) {
		TocEntry[i].cdte_track = i;
		TocEntry[i].cdte_format = CDROM_LBA;
		if (ioctl(drive, CDROMREADTOCENTRY, &TocEntry[i]) < 0) {
			perror("cdgrab: CDROMREADTOCENTRY");
		}
	}
	
	TocEntry[last+1].cdte_track = CDROM_LEADOUT;
	TocEntry[last+1].cdte_format = CDROM_LBA;
	if (ioctl(drive, CDROMREADTOCENTRY, &TocEntry[i]) < 0) {
		perror("cdgrab: CDROMREADTOCENTRY");
	}

	for (i=1; i<last+1; i++) {
		cksum += cddb_sum((TocEntry[i].cdte_addr.lba + CD_MSF_OFFSET) / CD_FRAMES);
	}

	totaltime = ((TocEntry[last+1].cdte_addr.lba + CD_MSF_OFFSET) / CD_FRAMES) -
		    ((TocEntry[1].cdte_addr.lba + CD_MSF_OFFSET) / CD_FRAMES);

	/* print discid */
	printf("%08lx", (cksum % 0xff) << 24 | totaltime << 8 | last);

	/* print number of tracks */
	printf(" %d", last);

	/* print frame offsets of all tracks */
	for (i = 1; i <= last; i++) {
		printf(" %d", TocEntry[i].cdte_addr.lba + CD_MSF_OFFSET);
	}
	
	/* print length of disc in seconds */
	printf(" %d\n", (TocEntry[last+1].cdte_addr.lba + CD_MSF_OFFSET) / CD_FRAMES);

        return 0;
}

