#
#  $Id: entitydefs.py,v 1.4 1999/05/30 09:21:22 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#
"""
"""

__version__ = '$Id: entitydefs.py,v 1.4 1999/05/30 09:21:22 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'

import htmlentitydefs

palm_entitydefs = {
    # PalmOS fills the unused portion of the character set with an
    # eclectic mix of characters from various ISO standards.
    # Entity names from HTML 4.
    'OElig':    chr(0x8c), # OE ligature
    'oelig':    chr(0x9c), # oe ligature
    'Scaron':   chr(0x8a), # S with caron
    'scaron':   chr(0x9a), # s with caron
    'Yuml':     chr(0x9f), # Y with umlaut
    'circ':     chr(0x88), # circumflex
    'tilde':    chr(0x98), # small tilde
    'ndash':    chr(0x96), # en dash
    'mdash':    chr(0x97), # em dash
    'lsquo':    chr(0x91), # left single quotation mark
    'rsquo':    chr(0x92), # right single quotation mark
    'ldquo':    chr(0x93), # left double quotation mark
    'rdquo':    chr(0x94), # right double quotation mark
    'dagger':   chr(0x86), # dagger
    'Dagger':   chr(0x87), # double dagger
    'permil':   chr(0x89), # per mille sign (wierd percent sign?)
    'lsaquo':   chr(0x8b), # left single angle quotation mark
    'rsaquo':   chr(0x9b), # right single angle quotation mark
    'fnof':     chr(0x83), # latin small f with hook (function def)
    'bull':     chr(0x95), # bullet
    'hellip':   chr(0x85), # horizontal ellipsis
    'trade':    chr(0x99), # trademark sign
    'spades':   chr(0x90), # spade suit
    'clubs':    chr(0x8e), # club suit
    'hearts':   chr(0x8f), # heart suit
    'diams':    chr(0x8d), # diamond suit
    # Characters I can't find reference to anywhere else.
    'dcomma':   chr(0x84), # double comma
    # PalmOS-specific characters.
    'grafcmd':  chr(0x9d), # graffiti command stroke
    'grafsc':   chr(0x9e), # graffiti shortcut stroke
    # RichReader supports this
    'euro':     chr(0x80),
    }


entitydefs = {}

entitydefs.update(htmlentitydefs.entitydefs)
entitydefs.update(palm_entitydefs)
