/* Track handling functions used by Track editor and writing services */

#include <stdlib.h>
#include <stdio.h>

#include "main.h"
#include "tracks.h"

/* uncomment for debugging */
/* #define DEBUG */

/* workaround to maintain compatibility while changing from enum definition
 * of tracktype to string definition */
char *data="data";
char *audio="audio";

/* a current list of tracktype definitions - they arent complete,but 
 * these are the most important ones */
char *tracks_tracktypedefinitions[]=
{
	"data","audio","cdi",NULL
}
;

tracks_trackinfo *tracks_create(char *name,
				tracks_tracktype type,
				tracks_precache precacherequired,
				int  (*openpipe)(void*),
				void (*closepipe)(void*),
				int  (*tracksize)(void*),
				int  (*dataavail)(void*),
				int  (*valid)(void*),
				void (*destroy)(void*),
				void *data)
{
	tracks_trackinfo *ti;
	
	ti=(tracks_trackinfo*)malloc(sizeof(tracks_trackinfo));
	strcpy((char*)&ti->name,name);
	ti->data=data;	
	ti->tracktype=(char*)malloc(strlen(type)+1);
	strcpy(ti->tracktype,type);
	ti->precacherequired=precacherequired;
	/* initialize user count with one here */
	ti->users=1;
	/* no updatehandlers installed yet */
	ti->updatehandlers=NULL;
	
	ti->openpipe=openpipe;
	ti->closepipe=closepipe;
	ti->tracksize=tracksize;
	ti->dataavail=dataavail;
	ti->valid=valid;
	ti->destroy=destroy;

	return ti;
}
;

int tracks_openpipe(tracks_trackinfo*ti)
{
#ifdef DEBUG
	printf ("track.c: calling openpipe() for track %s\n",
		(char*)&ti->name);
#endif
	return ti->openpipe(ti);
}
;

void tracks_closepipe(tracks_trackinfo*ti)
{
	ti->closepipe(ti);
}
;

int tracks_tracksize(tracks_trackinfo*ti)
{
	return ti->tracksize(ti);
}
;

int tracks_dataavail(tracks_trackinfo*ti)
{
	return ti->dataavail(ti);
}
;

int tracks_valid(tracks_trackinfo*ti)
{
	return ti->valid(ti);
}
;

void tracks_claim(tracks_trackinfo*ti)
{
	ti->users++;
	#ifdef DEBUG 
	    printf ("claimed track %s (new users count:%i) \n",(char*)&ti->name,ti->users);
	#endif
};

void tracks_unclaim(tracks_trackinfo*ti)
{
	#ifdef DEBUG
	    printf ("unclaiming track %s (users before unclaim():%i) \n",(char*)&ti->name,ti->users);
	#endif
	if (!--ti->users)
	  {
#ifdef DEBUG
		  printf("Track has no more users. destroyed.\n");
#endif
		  ti->destroy(ti);
		  free(ti->tracktype);
		  free(ti);
	  }
	;
}
;

int tracks_users(tracks_trackinfo*ti)
{
	return ti->users;
}
;

