/* This file implements a generic definition of a track list 
 * it provides some handler functions to manipulate the list itself */

#ifndef TRACKLIST_H
#define TRACKLIST_H

#include <gtk/gtk.h>

#include "selectlist.h"
#include "menusys.h"
#include "tracks.h"

typedef struct
{
   GtkWidget *widget;
   selectlist_info *selectlistinfo;
   int entries;           /* counts the number of entries to the track list */
   GList *updatehandlers; /* the clients that want to stay informed about tracklist changes */
} tracklist_info;

/* call this function at the beginning of each dropcallback-handler
 * couping with tracklists. its return value is 1 if the drop was
 * tracklist internal and 0 if the drop data came from outside the
 * tracklist. So essentially the dropcallback-handler should execute
 * its main task only if tracklist_handleinternaldrop returned 0.
 * p is the position within the selectlist,where the drop item was
 * placed by the user 
 * FIXME: this function currently works with one selected item only
 * the problem inherent in processing multiple selection is that
 * the clist changes whenever one item is processed so that the locations
 * of all the following item changes as well */
int tracklist_handleinternaldrop(tracklist_info*i,int p);
/* if you want to allow track rearranging,both dropcallback and send have
 * to be enabled (dropcallback has to point to a valid handler) */
tracklist_info *tracklist_info_create(selectlist_dropcallback dropcallback,
		       	  	      int send,
				      menusys_menu *popup,
				      GtkSignalFunc doubleclick);
/* add a track to the tracklist */
void tracklist_addtrack(tracklist_info *tracklist,tracks_trackinfo *track);
/* insert track into tracklist at position n. append track to the list if  n=-1 */
void tracklist_inserttrack(tracklist_info *tracklist,int n,tracks_trackinfo *track);
/* remove a track by its position in the list */
void tracklist_removetrack(tracklist_info *tracklist,int n);
/* replace a track by another track. the old track gets an unclaim() call */
/* this is essentially a call to both removetrack and inserttrack */
void tracklist_replacetrack(tracklist_info *tracklist,int n,tracks_trackinfo *track);
/* clear the whole tracklist (clear clist and deinitialize/unclaim() tracks */
void tracklist_clear(tracklist_info *tracklist);
/* get track n */
tracks_trackinfo *tracklist_gettrack(tracklist_info *tracklist,int n);
/* destroy tracklist */
void tracklist_info_destroy(tracklist_info*tracklist);
void tracklist_init();

#endif // TRACKLIST_H   
   

			    
