#
#
#
#

proc widget:do_widget_command {win class arg} {
    global widget_procs widget_superclass

    set cmd [shift arg]

    upvar \#0 $widget_procs($class) p
    if [info exists p($cmd)] {
	return [$p($cmd) $win $arg]
    } else {
	set superclass $widget_superclass($class)
	while {$superclass != ""} {
	    upvar \#0 $widget_procs($superclass) p
	    if [info exists p($cmd)] {
		return [$p($cmd) $win $arg]
	    }
	    set superclass $widget_superclass($superclass)
	}
    }
}

proc widget:create {class win arg} {
    global widget_procs widget_superclass widget_creator

    frame $win -class $class
    rename $win ${class}_${win}

    set superclass $widget_superclass($class)

    set body [concat widget:do_widget_command $win $class {$args}]
    proc $win {args} $body

    set superclass_list {}
    while {$superclass != ""} {
	set superclass_list [linsert $superclass_list 0 $superclass]
	set superclass $widget_superclass($superclass)
    }
    foreach i $superclass_list {
	if {$widget_creator($i) != ""} {
	    $widget_creator($i) $win $arg
	}
    }
    if {$widget_creator($class) != ""} {
	$widget_creator($class) $win $arg
    }
    widget:config $class $win $arg

    return $win
}

proc widget:config1 {class win opt val} {
    global widget_superclass widget_configure

    set config $widget_configure($class)
    if {$config == "" || [$config $win $opt $val]} {
	set super $widget_superclass($class)
	if {$super != ""} {
	    widget:config1 $super $win $opt $val
	}
    }
}

proc widget:config {class win arg} {
    global widget_superclass widget_configure

    while {[llength $arg] > 0} {
	set opt [shift arg]
	set val [shift arg]
	widget:config1 $class $win $opt $val
    }
}

proc Widget:DefineClass {class superclass creator configure procs} {
    global widget_procs widget_superclass widget_creator widget_configure

    set widget_procs($class)      $procs
    set widget_superclass($class) $superclass
    set widget_creator($class)    $creator
    set widget_configure($class)  $configure

    upvar \#0 $procs p
    proc widget:config_$class {win arg} \
	[concat widget:config $class {$win} {$arg}]
    set p(configure) widget:config_$class

    proc $class {w args} [concat widget:create $class {$w} {$args}]
}

proc Widget:Super {class win args} {
    global widget_superclass

    if {$widget_superclass($class) != ""} {
	return [widget:do_widget_command $win $widget_superclass($class) $args]
    }
}

proc Widget:SetEntryState {e s} {
    switch $s {
	normal {
	    set bg background
	    set fg foreground
	    set state normal
	    set focus 1
	}
	disabled {
	    set bg disabledBackground
	    set fg disabledForeground
	    set state disabled
	    set focus 0
	}
	readonly {
	    set bg readonlyBackground
	    set fg readonlyForeground
	    set state disabled
	    set focus 1
	}
    }
    $e configure -state $state -takefocus $focus \
	-background [option get $e $bg {}] \
	-foreground [option get $e $fg {}] \
}

proc Widget:SetLabelState {l s} {
    switch $s {
	normal   {set bg background;         set fg foreground}
	disabled {set bg disabledBackground; set fg disabledForeground}
	readonly {set bg readonlyBackground; set fg readonlyForeground}
    }
    $l configure -background [option get $l $bg {}] \
	-foreground [option get $l $fg {}]
}

proc Widget:SetTrace {widget varname operation command} {
    set id [set_trace $varname $operation $command]
    bind $widget <Destroy> [list del_trace $id]

    return $id
}

proc Widget:EntryDialog {entry dialog_command} {
    set val [eval $dialog_command]
    if {$val != ""} {
	$entry delete 0 end
	$entry insert 0 $val
    }
}

bind Entry <Control-Key-u> { %W delete 0 end }

foreach l {
    {ImageUp		up.xbm			black}
    {ImageDown		down.xbm		black}
    {ImageMiniDown	mini-down.xbm		black}
    {ImageMiniUp	mini-up.xbm		black}
    {ImageCircle	circle.xbm		\#e10000}
    {ImageDoubleRight	double-right.xbm	black}
} {
    global TKPPXPDIR
    set name [lindex $l 0]
    set file [lindex $l 1]
    set fg   [lindex $l 2]
    image create bitmap $name -file [file join $IMAGEDIR $file] \
	-foreground $fg
}

image create photo ImageOpenFolder -file [file join $IMAGEDIR open-folder.gif]

proc widget:auto_load {func file} {
    global WIDGETDIR
    global auto_index

    set auto_index($func) [list source [file join $WIDGETDIR $file]]
    auto_load $func
}

widget:auto_load ButtonEntry	buttonentry.tcl
widget:auto_load IpEntry	ipentry.tcl
widget:auto_load LabelFrame	labelframe.tcl
widget:auto_load ListboxMenu	listboxmenu.tcl
widget:auto_load ListFrame	listframe.tcl
widget:auto_load MenuEntry	menuentry.tcl
widget:auto_load NoteBook	notebook.tcl
widget:auto_load UpDownEntry	updownentry.tcl
widget:auto_load ButtonBox	buttonbox.tcl
widget:auto_load RadioBox	radiobox.tcl
widget:auto_load CheckBox	checkbox.tcl
