#include <stdio.h>

#include "fppxp.h"

#include <support.h>
#include <xcio.h>

extern FL_OBJECT **CreateMessagePanel();
extern FL_OBJECT **CreateIpPanel();
extern FL_OBJECT **CreateMonitorPanel();
extern FL_OBJECT **CreateUserPanel();
extern void UpdateIpPanel(), ActivateIpPanel();
extern void UpdateMonitorPanel(), ActivateMonitorPanel();
extern void ActivateUserPanel();

static struct {
    FL_OBJECT *tag, **objs;
    FL_OBJECT **(*create)();
    void (*update)(), (*activate)();
    const char *name, *key;
} *current, panels[]={
    {
	0, 0,
	CreateMonitorPanel, UpdateMonitorPanel, ActivateMonitorPanel,
	"Monitor", "#M"
    }, {
	0, 0,
	CreateIpPanel, UpdateIpPanel, ActivateIpPanel,
	"IP", "#I"
    }, {
	0, 0,
	CreateUserPanel, NULL, ActivateUserPanel,
	"User", "#U"
    },
/*    {NULL, NULL, CreateMessagePanel, "Message", "#E"},*/
};

enum {
    MONITOR_PANEL,
    IP_PANEL,
    USER_PANEL,
/*    MESSAGE_PANEL,*/
    MAX_PANELS
};

#define	PANEL_WIDTH	250
#define	PANEL_HEIGHT	150
#define	TAG_WIDTH	50
#define	TAG_HEIGHT	20

static FL_OBJECT *tagObj;

static void
TagCallBack(FL_OBJECT *obj, long arg)
{
    int n = fl_get_notetag(obj);

    if (current == &panels[n]) return;
    current->activate(FALSE);
    fl_redraw_object(obj);
    current = &panels[n];
    current->activate(TRUE);
}

void
UpdatePanels(struct pppinfo_s *old, struct pppinfo_s *new)
{
    if (current->update) current->update(old, new);
}

void
CreatePanels(FL_FORM *form)
{
    FL_OBJECT *obj;
    int i, n, x, bw;
    char *names[MAX_PANELS];

    x = FRAME_GAP;
    obj = fl_add_box(FL_FRAME_BOX, x, FRAME_GAP,
		     PANEL_WIDTH, PANEL_HEIGHT, "");
    fl_set_object_color(obj, FL_DARKORANGE, FL_COL1);
    bw = obj->bw;

    obj = fl_add_notetag(FL_NORMAL_NOTETAG, obj->x + obj->bw,
			 obj->y + obj->bw, obj->w - (obj->bw << 1),
			 obj->h - (obj->bw << 1), "");
    fl_set_object_color(obj, FL_MCOL, FL_MCOL);
    fl_set_object_boxtype(obj, FL_SHADOW_BOX);
    for (n = 0; n < MAX_PANELS; n ++) names[n] = panels[n].name;
    fl_setup_notetag(obj, names, MAX_PANELS);
/*    fl_set_notetag_color(obj, 1, FL_RED);*/
    fl_set_object_callback(obj, TagCallBack, 0);
    tagObj = obj;

    x +=  bw;
    
    for (n = 0; n < MAX_PANELS; n ++) {
	if (panels[n].create) {
	    panels[n].objs = panels[n].create(FRAME_GAP + bw,
					      FRAME_GAP + TAG_HEIGHT +
					      bw,
					      PANEL_WIDTH - bw * 2,
					      PANEL_HEIGHT - TAG_HEIGHT
					      - bw * 2, "");
	    for (i = 0; panels[n].objs[i]; i ++) {
		fl_deactivate_object(panels[n].objs[i]);
		fl_hide_object(panels[n].objs[i]);
	    }
	}
/*
	obj = fl_add_button(FL_PUSH_BUTTON, x, FRAME_GAP + bw,
			    TAG_WIDTH, TAG_HEIGHT, panels[n].name);
	x += TAG_WIDTH;
	fl_set_object_boxtype(obj, FL_FLAT_BOX);
	fl_set_object_color(obj, FL_DARKORANGE, FL_MCOL);
	fl_set_object_callback(obj, TagsCallBack, n);
	fl_set_object_shortcut(obj, panels[n].key, 1);
	panels[n].tag = obj;
*/
	if (!current) current = &panels[n];
    }
    current->activate(TRUE);
}
