/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include "main.h"

extern short netip_check(char *, char *);
extern short mycmp(char *, char *);
extern int substitute_string(char *, int);
extern short get_var_from_pftprc(FILE *, const char *, char *, int);

void import(unsigned long filesize, double *ci, int strnum)
{
#ifdef USE_POSIX_THREAD
   if (!*ci) {
      OUTPUT++;
      (*(statstr+strnum))->output = OUTPUT;
      (*statstr)->RECEIVING = 1;
   }
   if ((*(statstr+strnum))->lol) {
      if (slfp == stderr) {
         if ((*(statstr+strnum))->output == OUTPUT) fputc('\r', slfp);
         else if ((*statstr)->RECEIVING) fputc('\n', slfp);
      }
      (*statstr)->RECEIVING = 0;
   }
#else
   if ((*(statstr+strnum))->lol && slfp == stderr) fputc('\r', slfp);
#endif
   fflush(slfp);
   if (*ci > 0.0F) fprintf(slfp, "+ %s (%.0f bytes) %s from %s.\n", (*(statstr+strnum))->cwd_last_ch, *ci, (*(statstr+strnum))->_SKIP_ > 1 ? "skipped": "received", (*(statstr+strnum))->REMOTEHOSTNAME);
   else if (!*ci && (*(statstr+strnum))->lol) {
      fprintf(slfp, "\n** Receiving %s from %s failed.\n", (*(statstr+strnum))->cwd_last_ch, (*(statstr+strnum))->REMOTEHOSTNAME);
   }
   else {
      if (!(*(statstr+strnum))->_STANDARD_INPUT_ || *((*(statstr+strnum))->cwd_last_ch) != '|') (*(statstr+strnum))->lol = 1;
      if (slfp == stderr) {
         if (filesize) fprintf(slfp, "* %s %s (%ld bytes) from %s", (*(statstr+strnum))->_SKIP_ > 1 ? "Skipping": "Receiving", (*(statstr+strnum))->cwd_last_ch, filesize, (*(statstr+strnum))->REMOTEHOSTNAME);
         else fprintf(slfp, "* %s %s from %s", (*(statstr+strnum))->_SKIP_ > 1 ? "Skipping": "Receiving", (*(statstr+strnum))->cwd_last_ch, (*(statstr+strnum))->REMOTEHOSTNAME);
      }
   }
   if (!*ci && (((*(statstr+strnum))->_STANDARD_INPUT_ && !filesize) || (*statstr)->FORCE_STDOUT)) fprintf(slfp, "\n");
   fflush(slfp);
}


int check_accepted_hosts(char **accepted_hosts, int strnum)
{
   int i=0, loc=0, length=0;
   char **ahptr;

   for (ahptr=accepted_hosts; *ahptr; ahptr++) {
      loc = strlen(*ahptr);

      if (**ahptr == '.') {
         loc--;
         length = strlen((*(statstr+strnum))->REMOTEHOSTNAME);
         for (i=length-1; loc; loc--, i--) {
            if (*((*ahptr)+loc) \
               != tolower(*((*(statstr+strnum))->REMOTEHOSTNAME+i))) break;
         }
         if (!loc) return 1;
      }
      else if (**ahptr == PFTP_SPECIAL_SIGN) {
         if (netip_check((*(statstr+strnum))->REMOTEIP, (*ahptr)+1)) return 1;
      }
      else if ((length = strlen((*(statstr+strnum))->REMOTEIP)) == loc) {
#ifdef HAVE_INET6
         if (!strcasecmp(*ahptr, (*(statstr+strnum))->REMOTEIP)) return 1;
#else
         if (!mycmp(*ahptr, (*(statstr+strnum))->REMOTEIP)) return 1;
#endif
      }
   }
   if (!*ahptr) return 0;
   return 1;
}


int search_hl_entry(int strnum)
{
   char *hostname=(*(statstr+strnum))->REMOTEHOSTNAME;
   char str[SONAME], *stra=NULL, *stre=NULL;
   FILE *fp=NULL;
   int i, loc=0;

   if (!*hostname) return 0;
   if ((fp = fopen((*(statstr+strnum))->home, "r")) == NULL) {
      return 0;
   }
   fgets(str, SONAME, fp);
   if (!atoi(str)) rewind(fp);
   for ((*(statstr+strnum))->host_number=0, i=1; fgets(str, SONAME, fp); i++) {
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra || !strncmp("PFTP", stra, 4)) {
         i--;
         continue;
      }

      /*
       * Substitute string with variable or file contents.
       */
      if (*stra == PFTP_SPECIAL_SIGN && \
         (*(stra+1) == 'V' || *(stra+1) == 'F')) {
         if (!substitute_string(str, stra-str)) continue;
      }

      /*
       * Check for network respectively domain name entries.
       */
#ifdef HAVE_INET6
      if (*stra == PFTP_SPECIAL_SIGN && (isalnum(*(stra+1)) || *(stra+1) == ':'))
#else
      if (*stra == PFTP_SPECIAL_SIGN && isdigit(*(stra+1)))
#endif
      {
         if (netip_check((*(statstr+strnum))->REMOTEIP, stra+1)) {
            (*(statstr+strnum))->host_number = i;
            break;
         }
#ifndef HAVE_INET6
         continue;
#endif
      }

      if (*stra == '.') {
         int j=0;
         int length=strlen(hostname);
         loc = strlen(stra) - 1;
         for (j=length-1; loc; loc--, j--) {
            if (tolower(*(stra+loc)) != tolower(*(hostname+j))) break;
         }
         if (!loc) {
            (*(statstr+strnum))->host_number = i;
            break;
         }
         continue;
      }

      /*
       * Skip user name and password.
       */
      for (stre=stra+1; *stre && *stre != '@' && *stre != ' ' && *stre != '\t'; stre++);
      if (*stre == '@' && *(++stre)) {
         for (stra=stre; *stre && *stre != ' ' && *stre != '\t'; stre++);
      }
      *stre = '\0';
      loc = strlen(stra) - 1;

      /*
       * Finally check for a host name match.
       */
#ifdef HAVE_INET6
      if (isdigit(*(stra+loc)) && !strcasecmp(stra, (*(statstr+strnum))->REMOTEIP))
#else
      if (isdigit(*(stra+loc)) && !mycmp(stra, (*(statstr+strnum))->REMOTEIP))
#endif
      {
         (*(statstr+strnum))->host_number = i;
         break;
      }
      if (!strcasecmp(hostname, stra)) {
         (*(statstr+strnum))->host_number = i;
         break;
      }
   }
   fclose(fp);

   /*
    * Check if PFTPFORCEF is set.
    */
   if (!(*(statstr+strnum))->usefilter \
      && get_var_from_pftprc((FILE *)NULL, "PFTPFORCEF", str, strnum)) {
      if (atoi(str)) return 0;
   }

   return 1;
}
