/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "mserver.h"

bool find_cname(const char *name)
{
	char temp[1024];
	char cname[1024];
	int i, n;
	size_t len;

	bool found;

	found = false;
	config_getvalue("cname", temp, 1024);

	len = strlen(temp);

	for (i = 0, n = 0; i < len; i++, n++)
	{
		if (temp[i] == ',')
		{
			cname[n] = '\0';
			if (!strncmp(cname, name, 1024))
			{
				found = true;	
				break;
			}
			n = -1;
		}
		else
		{
			cname[n] = temp[i];
		}
	}

	cname[n] = '\0';

	if (!strncmp(cname, name, 1024))
		found = true;		

	return found;
}
