/*
 setup.c : configuration for sql plugin

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "sql.h"

static gchar *server, *user, *pass;

enum
{
    OPTION_SERVER,
    OPTION_USER,
    OPTION_PASS,
};

static SETUP_REC options[] =
{
    { SETUP_TYPE_ENTRY, &server, "server", "localhost" },
    { SETUP_TYPE_ENTRY, &user, "user", "user" },
    { SETUP_TYPE_ENTRY, &pass, "pass", "pass" },

    { 0, NULL, NULL }
};

static void read_settings(PLUGIN_DATA *data)
{
    data->server = g_strdup(server);
    data->user = g_strdup(user);
    data->pass = g_strdup(pass);
}

void plugin_sql_setup_init(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    setup_read("plugin_"PLUGIN_NAME, options);
    read_settings(data);
}

void plugin_sql_setup_deinit(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    setup_free(options);

    if (data->server != NULL) g_free(data->server);
    if (data->user != NULL) g_free(data->user);
    if (data->pass != NULL) g_free(data->pass);
}
