/**************************************************************************** 
**
** File: tcp.h
**
** Author: Mike Borella
**
** Comments: Generic TCP header structure - an attempt at OS independence
**
*****************************************************************************/

#define TH_FIN  0x01
#define TH_SYN  0x02
#define TH_RST  0x04
#define TH_PUSH 0x08
#define TH_ACK  0x10
#define TH_URG  0x20

#define TCPOPT_EOL      0
#define TCPOPT_NOP      1
#define TCPOPT_MAXSEG   2

/*
 * TCP header
 */

typedef struct _TCPHdr
{
        u_int16_t th_sport;               /* source port */
        u_int16_t th_dport;               /* destination port */
        u_int32_t th_seq;                 /* sequence number */
        u_int32_t th_ack;                 /* acknowledgement number */
#ifdef WORDS_BIGENDIAN
        u_int8_t  th_off:4,               /* data offset */
                  th_x2:4;                /* (unused) */
#else
        u_int8_t  th_x2:4,                /* (unused) */
                  th_off:4;               /* data offset */
#endif
        u_int8_t  th_flags;
        u_int16_t th_win;                 /* window */
        u_int16_t th_sum;                 /* checksum */
        u_int16_t th_urp;                 /* urgent pointer */
} TCPHdr;

void dump_tcp(u_char *, int);

