/*
 serverinfo.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"

static gchar *version, *author;
static glong ccount;
static GList *wholist;
static gint stimetag;

static GtkWidget *license_dialog = NULL, *history_dialog = NULL;
static GtkWidget *gtkwholist;
static GtkWidget *ccountlabel;

/* History / License dialog things */
static void license_delete_event(void)
{
    gtk_widget_destroy(license_dialog);
    license_dialog = NULL;
}

static void history_delete_event(void)
{
    gtk_widget_destroy(history_dialog);
    history_dialog = NULL;
}

static void handle_textfile(CALLBACK_DATA *data, gchar *title, GtkWidget **dialog, GtkSignalFunc closefunc)
{
    static GtkWidget *text;
    GtkWidget *hbox;
    GtkWidget *sbar;
#ifndef HAVE_GNOME
    GtkWidget *button;
#endif

    switch (data->u.list.type)
    {
        case LIST_START:
#ifdef HAVE_GNOME
            *dialog = gnome_dialog_new(title, GNOME_STOCK_BUTTON_CLOSE, NULL);
            gnome_dialog_button_connect(GNOME_DIALOG(*dialog), 0, closefunc, NULL);
#else
            *dialog = gtk_dialog_new();
            gtk_container_border_width(GTK_CONTAINER(*dialog), 5);

            button = gtk_button_new_with_label(_("Close"));
            gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                                      GTK_SIGNAL_FUNC(closefunc), GTK_OBJECT(*dialog));
            gtk_signal_connect(GTK_OBJECT(*dialog), "delete_event",
                               GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

            gtk_box_pack_end(GTK_BOX(GTK_DIALOG(*dialog)->action_area), button, FALSE, FALSE, 10);
#endif
            gtk_widget_set_usize(*dialog, 550, 450);
            gtk_window_set_policy(GTK_WINDOW(*dialog), TRUE, TRUE, FALSE);
            gtk_signal_connect(GTK_OBJECT(*dialog), "delete_event", closefunc, NULL);

            hbox = gtk_hbox_new(FALSE, 0);
            gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(*dialog)->vbox), hbox, TRUE, TRUE, 10);

            text = gtk_text_new(NULL, NULL);
            gtk_text_set_editable(GTK_TEXT(text), FALSE);
            gtk_box_pack_start(GTK_BOX(hbox), text, TRUE, TRUE, 0);

            sbar = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
            gtk_box_pack_start(GTK_BOX(hbox), sbar, FALSE, FALSE, 0);

            gtk_text_freeze(GTK_TEXT(text));
            break;

        case LIST_END:
            gtk_text_thaw(GTK_TEXT(text));
            gtk_widget_show_all(*dialog);
            break;

        case LIST_ITEM:
            gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, data->u.list.data, -1);
            gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, "\n", 1);
            break;
    }
}

static void callback_license(CALLBACK_DATA *data)
{
    if (data->status == 0) return;

    handle_textfile(data, _("Server license"), &license_dialog, license_delete_event);
}

static void callback_history(CALLBACK_DATA *data)
{
    if (data->status == 0) return;

    handle_textfile(data, _("Server history"), &history_dialog, history_delete_event);
}

static void show_license(void)
{
    if (license_dialog == NULL)
        mserver_license(callback_license);
    else
        gdk_window_raise(license_dialog->window);
}

static void show_history(void)
{
    if (history_dialog == NULL)
        mserver_history(callback_history);
    else
        gdk_window_raise(history_dialog->window);
}

/* Client gtkwholist things */
static void parse_who(CALLBACK_DATA *data)
{
    char *tmp, *prev;

    for (prev = tmp = data->u.text; *tmp != '\0'; tmp++)
    {
        if (*tmp == ':')
        {
            *tmp++ = '\0';
            wholist = g_list_append(wholist, g_strdup(prev));
            prev = tmp;
        }
    }
    wholist = g_list_append(wholist, g_strdup(prev));
}

static void create_wholist(void)
{
    GList *tmp;
    GtkWidget *li;

    for (tmp = g_list_first(wholist); tmp != NULL; tmp = tmp->next)
    {
        li = gtk_list_item_new_with_label(tmp->data);
        g_free(tmp->data); tmp->data = li;
    }
    gtk_list_append_items(GTK_LIST(gtkwholist), wholist);
    gtk_widget_show_all(gtkwholist);
}

static void serverinfo_who(CALLBACK_DATA *data)
{
    if (data->status == 0) return;

    parse_who(data);
    create_wholist();
}

static void serverinfo_ccount(CALLBACK_DATA *data)
{
    GString *str;

    if (data->status == 0 || ccount == data->u.digit) return;

    ccount = data->u.digit;

    str = g_string_new(NULL);
    g_string_sprintf(str, _("%ld clients connected from hosts:"), ccount);
    gtk_label_set(GTK_LABEL(ccountlabel), str->str);
    g_string_free(str, TRUE);

    gtk_list_clear_items(GTK_LIST(gtkwholist), 0, -1);
    wholist = NULL;
    mserver_listclients(serverinfo_who);
}

static int serverinfo_timefunc(void)
{
    mserver_clientcount(serverinfo_ccount);
    return 1;
}

static void delete_event(GtkWidget *dialog)
{
    gtk_widget_destroy(dialog);
    gtk_timeout_remove(stimetag);
}

static void server_dialog(void)
{
    GtkWidget *dialog;
    GtkWidget *vbox, *hbox, *sbox, *frame;
    GtkWidget *button;
    GtkWidget *label;
    GString *str;

    str = g_string_new(NULL);

#ifdef HAVE_GNOME
    dialog = gnome_dialog_new(_("Server information"), GNOME_STOCK_BUTTON_CLOSE, NULL);
    gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 0,
                                       GTK_SIGNAL_FUNC(delete_event), GTK_OBJECT(dialog));
#else
    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog), 5);

    button = gtk_button_new_with_label(_("Close"));
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                              GTK_SIGNAL_FUNC(delete_event), GTK_OBJECT(dialog));

    gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 10);
#endif
    gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                       GTK_SIGNAL_FUNC(delete_event), NULL);

    label = gtk_label_new(version);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), label, FALSE, FALSE, 10);

    g_string_sprintf(str, _("Author: %s"), author);
    label = gtk_label_new(str->str);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), label, FALSE, FALSE, 0);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), hbox, FALSE, FALSE, 10);

    button = gtk_button_new_with_label(_("Show license"));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(show_license), NULL);
    gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 10);

    button = gtk_button_new_with_label(_("Show history"));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(show_history), NULL);
    gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 10);

    /* List of connected hosts */
    frame = gtk_frame_new(NULL);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), frame, TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    g_string_sprintf(str, _("%ld clients connected from hosts:"), ccount);
    ccountlabel = gtk_label_new(str->str);
    gtk_box_pack_start(GTK_BOX(vbox), ccountlabel, FALSE, FALSE, 0);

    sbox = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sbox),
                                   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(vbox), sbox, TRUE, TRUE, 0);

    gtkwholist = gtk_list_new();
    gtk_list_set_selection_mode(GTK_LIST(gtkwholist), GTK_SELECTION_BROWSE);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sbox), gtkwholist);

    create_wholist();

    stimetag = gtk_timeout_add(1000, (GtkFunction) serverinfo_timefunc, NULL);

    gtk_widget_show_all(dialog);
    g_free(author); g_free(version);
    g_string_free(str, TRUE);
}

static void callback_author(CALLBACK_DATA *data)
{
    if (data->status == 0)
    {
        g_free(version);
        return;
    }

    author = data->u.text;
    server_dialog();
}

static void callback_version(CALLBACK_DATA *data)
{
    if (data->status == 0) return;

    version = data->u.text;
}

static void callback_who(CALLBACK_DATA *data)
{
    if (data->status == 0) return;

    parse_who(data);
}

static void callback_ccount(CALLBACK_DATA *data)
{
    if (data->status == 0) return;

    ccount = data->u.digit;
    wholist = NULL;
}

void menu_serverinfo(void)
{
    if (!mserver_connected()) return;

    mserver_clientcount(callback_ccount);
    mserver_listclients(callback_who);
    mserver_version(callback_version);
    mserver_author(callback_author);
}
