#include <stdio.h>  // for printf() etc.
#include <getopt.h> // for getopt()
#include <stdlib.h> // for atoi()
#include <string.h>	// for strerror()
#include <unistd.h> // for write()
#include <errno.h>  // for errno
#include <sys/types.h>
#include <fcntl.h>

#include <darxite.h>

int DaemonFd;

int main(void)
{
    int rc, fd, nbytes, i, url_count;
    char buffer[2048], *buf_ptr, *buf_start;
    char url_buf[256], wait_char = '<';
    BOOL get_url = FALSE, got_url = FALSE;
    
    DaemonFd = DX_ConnectClient("netscape");

    if (DaemonFd < 0)
    {
        fprintf(stderr, "Couldn't connect to daemon: %s\n",
                strerror(DX_errno));
        return 1;
    }

    rc = system("netscape -noraise -remote 'saveAs(/tmp/netscape.out)'");
    if (rc != -1)
        return 1;

    fd = open("/tmp/netscape.out", O_RDONLY);
    buf_start = buffer;
    while (1)
    {
        nbytes = read(fd, buf_start, sizeof(buffer) - (buffer - buf_start));
        if (nbytes <= 0)
            break;
        for (buf_ptr = buf_start; buf_ptr < (buf_start + nbytes); buf_ptr++)
        {
            if (get_url && (*buf_ptr != '<'))
                url_buf[url_count++] = *buf_ptr;
            else if (*buf_ptr == wait_char)
            {
                if (!get_url && !got_url)
                {
                    switch (wait_char)
                    {
                    case '<':
                        wait_char = 'a';
                        break;
                    case 'a':
                        wait_char = '>';
                        break;
                    case '>':
                        get_url = TRUE;
                        url_count = 0;
                        break;
                    }
                }
                else
                {
                    switch (wait_char)
                    {
                        case '<':
                            get_url = FALSE;
                            got_url = TRUE;
                            url_count = 0;
                            wait_char = '/';
                            printf("url: %s\n", url_buf);
                            memset(url_buf, 0, sizeof(url_buf));
                            break;
                        case '/': wait_char = 'a'; break;
                        case 'a': wait_char = '>'; break;
                        case '>': got_url = FALSE; wait_char = '<'; break;
                    }
                }
            }
            else
            {
                wait_char = '<';
            }
        }
    }
    close(fd);
    remove("/tmp/netscape.out");
    DX_DisconnectClient(DaemonFd);
    return 0;
}
