// File dealing with FTP commands etc.

#include "global.h"
#include "commands.h"
#include "connect.h"
#include "main.h"
#include "xpm.h"

void GetFile(const char *path, BOOL directory, BOOL paused, BOOL overwrite)
{
    char buffer[4096], flags[10];

    if (!Connected)
        return;
    if (directory)
        strcpy(flags, "d");
    else
        strcpy(flags, "");
    if (paused)
        strcat(flags, "p");
    if (overwrite)
        strcat(flags, "b");
    sprintf(buffer, "Get \"ftp://%s%s%s\" | \"%s%s\" | %s | %s | %s\n",
            HostName, CurrentPath[REMOTE], path, CurrentPath[LOCAL], path,
            LogIn, Password, flags);
    
    write(DaemonFd, buffer, strlen(buffer));
    DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
    AddFtpString(buffer);
}

void PutFile(const char *path, BOOL directory, BOOL paused, BOOL overwrite)
{
    char buffer[1024], path_buf[256], flags[10];

    if (!Connected)
        return;
    strcpy(path_buf, path);
    if (directory)
    {
        // remove the last bit of the path
        path_buf[strlen(path_buf) - 1] = '\0';
        if (strrchr(path_buf, '/'))
            *(strrchr(path_buf, '/') + 1) = '\0';
        else
            strcpy(path_buf, "");
        strcpy(flags, "du");
    }
    else
    {
        strcpy(flags, "u");
    }
    if (paused)
        strcat(flags, "p");
    if (!overwrite)
        strcat(flags, "c");
    // we need to do clever stuff to allow for DnD
    sprintf(buffer, "Get \"ftp://%s%s%s\" | \"%s%s\" | %s | %s | %s\n",
            HostName, CurrentPath[REMOTE],
            (*path_buf == '/') ? (strrchr(path_buf, '/') + 1) : path_buf,
            (*path == '/') ? "" : CurrentPath[LOCAL], path, LogIn, Password,
            flags);
    
    write(DaemonFd, buffer, strlen(buffer));
    DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
    AddFtpString(buffer);
}

int LocalCwd(const char *path)
{
    int rc;

    rc = chdir(path);
    if (rc == 0)
    {
        if (getcwd(CurrentPath[LOCAL], sizeof(CurrentPath[LOCAL])) == NULL)
            strcpy(CurrentPath[LOCAL], "?????");
        if (CurrentPath[LOCAL][strlen(CurrentPath[LOCAL]) - 1] != '/')
            strcat(CurrentPath[LOCAL], "/");
        gtk_entry_set_text(GTK_ENTRY(Pwd[LOCAL]), CurrentPath[LOCAL]);
        LocalLs();
    }
    else
    {
        gtk_entry_set_text(GTK_ENTRY(Pwd[LOCAL]), CurrentPath[LOCAL]);
    }
    return rc;
}

void RemoteCwd(const char *path)
{
    char buffer[4096];
    static BOOL waiting_response = FALSE;

    if (!Connected)
        return;
    if (!waiting_response)
    {
        if (!strcmp(path, ""))
            return;
        sprintf(buffer, "FTP CWD %s\n", path);
        write(DaemonFd, buffer, strlen(buffer));
        SetResponse(RESP_FUNC(RemoteCwd));
        waiting_response = TRUE;
        StartOperation();
    }
    else
    {
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        waiting_response = FALSE;
        AddFtpString(buffer);
        if (atoi(buffer) >= 400)
        {
            // if we have only just logged in
            if (!strcmp(CurrentPath[REMOTE], ""))
            {
                // make sure we don't get stuck in a loop
                strcpy(CurrentPath[REMOTE], "/");
                RemoteCwd("/");
            }
            else
            {
                gtk_entry_set_text(GTK_ENTRY(Pwd[REMOTE]),
                                   CurrentPath[REMOTE]);
                StopOperation();
            }
        }
        else
        {
            RemotePwd();
        }
    }
}

void RemoteDelete(void)
{
    static BOOL wait_response = FALSE;
    char buffer[256];

    if (!wait_response)
    {
        if (SelectedRow[REMOTE] == -1)
            return;
        StartOperation();
        wait_response = TRUE;
        SetResponse(RESP_FUNC(RemoteDelete));
        sprintf(buffer, "FTP DELE %s\n", File[REMOTE][SelectedRow[REMOTE]]);
        write(DaemonFd, buffer, strlen(buffer));
    }
    else
    {
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        AddFtpString(buffer);
        wait_response = FALSE;
        if (atoi(buffer) < 400)
            RemoteLs();
        else
            StopOperation();
    }
}

void LocalDelete(void)
{
    if (SelectedRow[LOCAL] == -1)
        return;
    if (remove(File[LOCAL][SelectedRow[LOCAL]]) == -1)
        AddFtpString(strerror(errno));
    else
        LocalLs();
}

void RemotePwd(void)
{
    static BOOL waiting_response = FALSE;
    char buffer[256], *buf_ptr;

    if (!waiting_response)
    {
        SetResponse(RESP_FUNC(RemotePwd));
        StartOperation();
        waiting_response = TRUE;
        sprintf(buffer, "FTP PWD\n");
        write(DaemonFd, buffer, strlen(buffer));
    }
    else
    {
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        AddFtpString(buffer);
        waiting_response = FALSE;
        if ((atoi(buffer) < 400) && (strchr(buffer, '"')))
        {
            buf_ptr = buffer + 4;
            while (*++buf_ptr != '"')
                ;
            *buf_ptr = '\0';
            strcpy(CurrentPath[REMOTE], buffer + 5);
        }
        if (CurrentPath[REMOTE][strlen(CurrentPath[REMOTE]) - 1] != '/')
            strcat(CurrentPath[REMOTE], "/");
        gtk_entry_set_text(GTK_ENTRY(Pwd[REMOTE]), CurrentPath[REMOTE]);
        RemoteLs();
    }
}

void OpenUrl(const char *url, const char *user, const char *password)
{
    char buffer[2048];
    static char protocol[10], server[256], path[256];
    static int resp_stage = 0;
    static char st_user[256], st_password[256];
    int i;

    switch (resp_stage)
    {
    case 0:
        strcpy(st_user, user);
        strcpy(st_password, password);
        DX_ParseUrl(url, protocol, server, sizeof(server), path, sizeof(path));
        if (strcasecmp(protocol, "ftp"))
        {
            AddFtpString("Sorry, only the FTP protocol "
                         "is currently supported.\n");
            return;
        }
        SetResponse(RESP_FUNC(OpenUrl));
        StartOperation();
        resp_stage = 1;
        if (Connected)
        {
            sprintf(buffer, "Close %s\n", HostName);
            write(DaemonFd, buffer, strlen(buffer));
            break;
        }
        else
        {
            // FALL THROUGH
        }

    case 1:
        if (Connected)
        {
            DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
            gtk_window_set_title(GTK_WINDOW(Window), "NoctFTP");
            gtk_clist_clear(GTK_CLIST(Lister[REMOTE]));
            gtk_entry_set_text(GTK_ENTRY(Pwd[REMOTE]), "");
            AddFtpString(buffer);
            strcpy(HostName, "");
            Connected = FALSE;
        }
        resp_stage = 2;
        sprintf(buffer, "Connecting to \"%s\"...\n", server);
        AddFtpString(buffer);
        sprintf(buffer, "Open %s\n", server);
        write(DaemonFd, buffer, strlen(buffer));
        gtk_window_set_title(GTK_WINDOW(Window), "NoctFTP - connecting...");
        break;
        
    case 2:
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        AddFtpString(buffer);
        if (*buffer >= '4')
        {
            gtk_window_set_title(GTK_WINDOW(Window), "NoctFTP");
            StopOperation();
            resp_stage = 0;
            return;
        }
        resp_stage = 3;
        Connected = TRUE;
        // check whether the "url" is actually an alias - we could send a
        // HostForAlias command to the daemon, but this is easier
        strcpy(HostName, server);
        for (i = 0; i < ServerCount; i++)
        {
            if (!strcasecmp(server, ServAlias[i]))
            {
                strcpy(HostName, ServHost[i]);
                break;
            }
        }
        sprintf(buffer, "FTP USER %s\n", st_user);
        write(DaemonFd, buffer, strlen(buffer));
        break;
        
    case 3:
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        AddFtpString(buffer);
        if (*buffer >= '4')
        {
            resp_stage = 0;
            CloseHost();
            return;
        }
        resp_stage = 4;
        sprintf(buffer, "FTP PASS %s\n", st_password);
        write(DaemonFd, buffer, strlen(buffer));
        break;

    case 4:
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        strcpy(CurrentPath[REMOTE], "");
        strcpy(LogIn, st_user);
        strcpy(Password, st_password);
        AddFtpString(buffer);
        resp_stage = 0;
        if (*buffer >= '4')
        {
            CloseHost();
            return;
        }
        SelectedRow[REMOTE] = -1;
        RemoteCwd(path);
        sprintf(buffer, "NoctFTP - %s", server);
        gtk_window_set_title(GTK_WINDOW(Window), buffer);
        break;
    }
}

void CloseHost(void)
{
    char buffer[2048];
    static BOOL response_wait = FALSE;

    if (!response_wait)
    {
        if (Connected)
        {
            sprintf(buffer, "Close %s\n", HostName);
            StartOperation();
            AddFtpString("Disconnecting... ");
            response_wait = TRUE;
            SetResponse(RESP_FUNC(CloseHost));
            write(DaemonFd, buffer, strlen(buffer));
        }
    }
    else
    {
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        gtk_window_set_title(GTK_WINDOW(Window), "NoctFTP");
        gtk_clist_clear(GTK_CLIST(Lister[REMOTE]));
        gtk_entry_set_text(GTK_ENTRY(Pwd[REMOTE]), "");
        response_wait = FALSE;
        AddFtpString("done.\n");
        AddFtpString(buffer);
        strcpy(HostName, "");
        Connected = FALSE;
        StopOperation();
    }
}

/* used in LocalLs for scandir() */
static int one(const struct dirent *unused)
{
    return 1;
}

void LocalLs(void)
{
    struct dirent **eps;
    struct stat stat_buf;
    char size[10], name[256];
    char date[15], perms[15], null[2];
    gchar *file_info[5];
    mode_t mode;
    struct tm *time_ptr;
    int i, n, cnt;
    BOOL is_dir;

    strcpy(null, "");
    strcpy(date, "???");
    file_info[0] = null;
    file_info[1] = name;
    file_info[2] = size;
    file_info[3] = date;
    file_info[4] = perms;
    FileCount[LOCAL] = 0;
    DirCount[LOCAL] = 0;
    SelectedRow[LOCAL] = -1;
    gtk_clist_clear(GTK_CLIST(Lister[LOCAL]));
    gtk_clist_freeze(GTK_CLIST(Lister[LOCAL]));
    n = scandir ("./", &eps, one, alphasort);
    if (n >= 0)
    {
        for (cnt = 0; cnt < n; cnt++)
        {
            // for symlinks, check whether what they point to is a dir
            stat(eps[cnt]->d_name, &stat_buf);
            sprintf(size, "%d", (int)stat_buf.st_size);
            if (S_ISDIR(stat_buf.st_mode))
                is_dir = TRUE;
            else
                is_dir = FALSE;
            lstat(eps[cnt]->d_name, &stat_buf);
            mode = stat_buf.st_mode;
            strcpy(name, eps[cnt]->d_name);
            free(eps[cnt]);
            if (!strcmp(file_info[1], ".."))
            {
                strcat(name, "/");
                strcpy(size, "");
                strcpy(perms, "");
                strcpy(date, "");
                gtk_clist_insert(GTK_CLIST(Lister[LOCAL]), 0, file_info);
                gtk_clist_set_foreground(GTK_CLIST(Lister[LOCAL]), 0, &Blue);
                gtk_clist_set_row_data(GTK_CLIST(Lister[LOCAL]), 0, 0);
                SelectIcon(name, perms, Lister[LOCAL], DirCount[LOCAL]);
                for (i = FileCount[LOCAL]; i > 0; i--)
                {
                    strcpy(File[LOCAL][i], File[LOCAL][i - 1]);
                    strcpy(FilePerms[LOCAL][i], FilePerms[LOCAL][i - 1]);
                }
                strcpy(File[LOCAL][0], name);
                strcpy(FilePerms[LOCAL][0], "");
                FileCount[LOCAL]++;
                DirCount[LOCAL]++;
            }
            else if (strcmp(file_info[1], "."))
            {
                if (!ShowHiddenFiles[LOCAL] && (*name == '.'))
                    continue;

                time_ptr = localtime(&stat_buf.st_mtime);
                // if it's very old then put the year, not the time in
                if (time(NULL) - stat_buf.st_mtime < (60 * 60 * 24 * 365))
                    strftime(date, sizeof(date), "%b %d %H:%M", time_ptr);
                else
                    strftime(date, sizeof(date), "%b %d %Y", time_ptr);
                strcpy(perms, "----------");
                if (S_ISLNK(mode))
                    perms[0] = 'l';
                else if (S_ISDIR(mode))
                    perms[0] = 'd';
                else if (S_ISSOCK(mode))
                    perms[0] = 's';
                if (S_IRUSR & mode) perms[1] = 'r';
                if (S_IWUSR & mode) perms[2] = 'w';
                if (S_IXUSR & mode) perms[3] = 'x';
                if (S_IRGRP & mode) perms[4] = 'r';
                if (S_IWGRP & mode) perms[5] = 'w';
                if (S_IXGRP & mode) perms[6] = 'x';
                if (S_IROTH & mode) perms[7] = 'r';
                if (S_IWOTH & mode) perms[8] = 'w';
                if (S_IXOTH & mode) perms[9] = 'x';
                if (is_dir)
                {
                    strcat(name, "/");
                    gtk_clist_insert(GTK_CLIST(Lister[LOCAL]),
                                     DirCount[LOCAL], file_info);
                    gtk_clist_set_foreground(GTK_CLIST(Lister[LOCAL]),
                                             DirCount[LOCAL], &Blue);
                    gtk_clist_set_row_data(GTK_CLIST(Lister[LOCAL]),
                                           DirCount[LOCAL],
                                           (gpointer)DirCount[LOCAL]);
                    SelectIcon(name, perms, Lister[LOCAL], DirCount[LOCAL]);
                    for (i = FileCount[LOCAL]; i > DirCount[LOCAL]; i--)
                    {
                        strcpy(File[LOCAL][i], File[LOCAL][i - 1]);
                        strcpy(FilePerms[LOCAL][i], FilePerms[LOCAL][i - 1]);
                    }
                    strcpy(File[LOCAL][DirCount[LOCAL]], name);
                    strcpy(FilePerms[LOCAL][DirCount[LOCAL]], perms);
                    DirCount[LOCAL]++;
                    FileCount[LOCAL]++;
                }
                else
                {
                    gtk_clist_append(GTK_CLIST(Lister[LOCAL]), file_info);
                    strcpy(File[LOCAL][FileCount[LOCAL]], name);
                    strcpy(FilePerms[LOCAL][FileCount[LOCAL]], perms);
                    SelectIcon(name, perms, Lister[LOCAL], FileCount[LOCAL]);
                    if (S_ISLNK(stat_buf.st_mode))
                    {
                        gtk_clist_set_foreground(GTK_CLIST(Lister[LOCAL]),
                                                 FileCount[LOCAL], &Cyan);
                    }
                    else if (strchr(perms, 'x'))
                    {
                        gtk_clist_set_foreground(GTK_CLIST(Lister[LOCAL]),
                                                 FileCount[LOCAL], &Green);
                    }
                    gtk_clist_set_row_data(GTK_CLIST(Lister[LOCAL]),
                                           FileCount[LOCAL],
                                           (gpointer)FileCount[LOCAL]);
                    FileCount[LOCAL]++;
                }
            }
        }
    }
    gtk_clist_thaw(GTK_CLIST(Lister[LOCAL]));
}

void RemoteLs(void)
{
    char buffer[8192], *buf_ptr = buffer;
    char file_name[256], file_size[256];
    char date[15], perms[15], null[2];
    gchar *file_info[5];
    BOOL is_link, is_dir, is_exec;
    BOOL some_left_over = FALSE;
    BOOL no_total = FALSE;
    static BOOL response_wait = FALSE;
    static char left_over[256];
    int rc, i, buf_size = 0;

    strcpy(null, "");
    strcpy(date, "");
    file_info[0] = null;
    file_info[1] = file_name;
    file_info[2] = file_size;
    file_info[3] = date;
    file_info[4] = perms;
    if (!response_wait)
    {
        if (!Connected)
            return;
        SetResponse(RESP_FUNC(RemoteLs));
        response_wait = TRUE;
        AddFtpString("Getting directory listing...");
        strcpy(buffer, "List\n");
        strcpy(left_over, "");
        gtk_clist_clear(GTK_CLIST(Lister[REMOTE]));
        gtk_clist_freeze(GTK_CLIST(Lister[REMOTE]));
        PROCESS_EVENTS;
        StartOperation();
        // add the link to the parent directory
        strcpy(file_name, "../");
        strcpy(file_size, "");
        strcpy(perms, "");
        FileCount[REMOTE] = 1;
        DirCount[REMOTE] = 1;
        SelectedRow[REMOTE] = -1;
        LinkId[0] = -1;
        LinkCount = 0;
        gtk_clist_append(GTK_CLIST(Lister[REMOTE]), file_info);
        gtk_clist_set_foreground(GTK_CLIST(Lister[REMOTE]),
                                 0, &Blue);
        gtk_clist_set_row_data(GTK_CLIST(Lister[REMOTE]), 0, 0);
        SelectIcon(file_name, perms, Lister[REMOTE], 0);
        strcpy(File[REMOTE][0], file_name);
        strcpy(FilePerms[REMOTE][0], "");
        write(DaemonFd, buffer, strlen(buffer));
    }
    else
    {
        memset(buffer, 0, sizeof(buffer));
        // left_over is any list line left over from the last call
        strcpy(buffer, left_over);
        rc = DX_GetResponse(DaemonFd, buffer + strlen(left_over),
                            sizeof(buffer) - strlen(left_over) - 1,
                            RESP_TIMEOUT);
        if (rc == DX_LIB_MORE_DATA)
            buffer[sizeof(buffer) - 1] = '\0';
        if (strcmp(left_over, ""))
            some_left_over = TRUE;
        else if (!strncasecmp(buffer, "total", 5) && strchr(buffer, '\n'))
            buf_ptr = strtok(buffer, "\n");
        else
            no_total = TRUE;
        for (i = sizeof(buffer) - 1; i > 0; i--)
        {
            if (buffer[i])
            {
                buf_size = i;
                break;
            }
        }
        //printf("size: %d >>>%s<<<", buf_size, buffer);
        while (buf_ptr)
        {
            if ((rc == DX_LIB_MORE_DATA) &&
                (buf_ptr + strlen(buf_ptr) + 2 < buffer + buf_size) &&
                (strlen(buf_ptr + strlen(buf_ptr) + 2) < 256))
            {
                strcpy(left_over, buf_ptr + strlen(buf_ptr) + 2);
            }
            if (some_left_over)
            {
                buf_ptr = strtok(buffer, " ");
                some_left_over = FALSE;
            }
            else
            {
                // we have to allow for lame Microsoft servers that don't
                // put a "total" line in
                if (no_total)
                {
                    buf_ptr = strtok(buffer, " ");
                    no_total = FALSE;
                }
                else
                {
                    buf_ptr = strtok(NULL, " ");
                }
            }
            while (buf_ptr && isspace(*buf_ptr))
                buf_ptr++;
            is_dir = FALSE;
            is_link = FALSE;
            is_exec = FALSE;
            if (buf_ptr)
            {
                strcpy(perms, buf_ptr);
                if (*buf_ptr == 'd')
                    is_dir = TRUE;
                else if (*buf_ptr == 'l')
                    is_link = TRUE;
                else if (*(buf_ptr + 3) == 'x')
                    is_exec = TRUE;
            }
            for (i = 0; buf_ptr && (i < 4); i++)
            {
                buf_ptr = strtok(NULL, " ");
            }
            if (!buf_ptr)
                break;
            strcpy(file_size, buf_ptr);
            strcpy(date, "");
            buf_ptr = strtok(NULL, " ");
            if (buf_ptr)
            {
                sprintf(date, "%s ", buf_ptr);
                buf_ptr = strtok(NULL, " ");
            }
            if (buf_ptr)
            {
                strcat(date, buf_ptr);
                strcat(date, " ");
                buf_ptr = strtok(NULL, " ");
            }
            if (buf_ptr)
                strcat(date, buf_ptr);
            if (!buf_ptr)
                break;
            buf_ptr = strtok(NULL, "\r\n");
            if (!buf_ptr)
                break;
            strcpy(file_name, buf_ptr);
            if (strcmp(file_name, ".") && strcmp(file_name, ".."))
            {
                if (!ShowHiddenFiles[REMOTE] && (*file_name == '.'))
                    continue;
                if (is_dir)
                {
                    strcat(file_name, "/");
                    gtk_clist_insert(GTK_CLIST(Lister[REMOTE]),
                                     DirCount[REMOTE], file_info);
                    gtk_clist_set_foreground(GTK_CLIST(Lister[REMOTE]),
                                             DirCount[REMOTE], &Blue);
                    gtk_clist_set_row_data(GTK_CLIST(Lister[REMOTE]),
                                           DirCount[REMOTE],
                                           (gpointer)DirCount[REMOTE]);
                    SelectIcon(file_name, perms, Lister[REMOTE],
                               DirCount[REMOTE]);
                    for (i = FileCount[REMOTE]; i > DirCount[REMOTE]; i--)
                    {
                        LinkId[i] = LinkId[i - 1];
                        strcpy(FilePerms[REMOTE][i], FilePerms[REMOTE][i-1]);
                        strcpy(File[REMOTE][i], File[REMOTE][i-1]);
                    }
                    strcpy(File[REMOTE][DirCount[REMOTE]], file_name);
                    strcpy(FilePerms[REMOTE][DirCount[REMOTE]], perms);
                    LinkId[DirCount[REMOTE]] = -1;
                    DirCount[REMOTE]++;
                    FileCount[REMOTE]++;
                }
                else
                {
                    // if it's a link, chop off the stuff after ->
                    if (is_link && strstr(file_name, " ->"))
                    {
                        LinkId[FileCount[REMOTE]] = LinkCount;
                        strcpy(LinksTo[LinkCount],
                               strstr(file_name, " ->") + 4);
                        *strstr(file_name, " ->") = '\0';
                        LinkCount++;
                    }
                    else
                    {
                        LinkId[FileCount[REMOTE]] = -1;
                    }
                    strcpy(File[REMOTE][FileCount[REMOTE]], file_name);
                    strcpy(FilePerms[REMOTE][FileCount[REMOTE]], perms);
                    gtk_clist_append(GTK_CLIST(Lister[REMOTE]), file_info);
                    if (is_link)
                    {

                        gtk_clist_set_foreground(GTK_CLIST(Lister[REMOTE]),
                                                 FileCount[REMOTE], &Cyan);
                    }
                    else if (is_exec)
                    {
                        gtk_clist_set_foreground(GTK_CLIST(Lister[REMOTE]),
                                                 FileCount[REMOTE], &Green);
                    }
                    gtk_clist_set_row_data(GTK_CLIST(Lister[REMOTE]),
                                           FileCount[REMOTE],
                                           (gpointer)FileCount[REMOTE]);
                    SelectIcon(file_name, perms, Lister[REMOTE],
                               FileCount[REMOTE]);
                    FileCount[REMOTE]++;
                }
            }
        }
        if (rc == DX_LIB_OK)
        {
            strcpy(left_over, "");
            response_wait = FALSE;
            //for (i = 0; i < FileCount[REMOTE]; i++)
            //{
            //    printf("\"%s\"", File[REMOTE][i]);
            //    if (LinkId[i] > -1)
            //      printf(" -> \"%s\" (%d)\n", LinksTo[LinkId[i]], LinkId[i]);
            //    else
            //        printf("\n");
            //}
            gtk_clist_thaw(GTK_CLIST(Lister[REMOTE]));
            AddFtpString(" done.\n");
            StopOperation();
        }
    }
}

void RemoteMkDir(const char *name)
{
    char buffer[2048];
    static BOOL waiting_reply = FALSE;

    if (!Connected)
        return;
    if (!waiting_reply)
    {
        sprintf(buffer, "FTP MKD %s\n", name);
        write(DaemonFd, buffer, strlen(buffer));
        SetResponse(RESP_FUNC(RemoteMkDir));
        waiting_reply = TRUE;
        StartOperation();
    }
    else
    {
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        AddFtpString(buffer);
        if (atoi(buffer) < 400)
            RemoteLs();
        else
            StopOperation();
        waiting_reply = FALSE;
    }
}

void LocalMkDir(const char *name)
{
    if (mkdir(name, 0755) == -1)
        AddFtpString(strerror(errno));
    else
        LocalLs();
}

void RemoteRename(const char *old, const char *new)
{
    char buffer[256];
    static int resp_stage = 0;
    static char st_new[256];

    switch (resp_stage)
    {
    case 0:
        resp_stage = 1;
        strcpy(st_new, new);
        StartOperation();
        sprintf(buffer, "FTP RNFR %s\n", old);
        SetResponse(RESP_FUNC(RemoteRename));
        write(DaemonFd, buffer, strlen(buffer));
        break;

    case 1:
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        AddFtpString(buffer);
        if (atoi(buffer) >= 400)
        {
            resp_stage = 0;
            StopOperation();
        }
        else
        {
            resp_stage = 2;
            sprintf(buffer, "FTP RNTO %s\n", st_new);
            write(DaemonFd, buffer, strlen(buffer));
        }
        break;
        
    case 2:
        DX_GetResponse(DaemonFd, buffer, sizeof(buffer), RESP_TIMEOUT);
        AddFtpString(buffer);
        resp_stage = 0;
        if (atoi(buffer) < 400)
            RemoteLs();
        else
            StopOperation();
        break;
    }
}

void LocalRename(const char *old, const char *new)
{
    if (rename(old, new) == -1)
        AddFtpString(strerror(errno));
    else
        LocalLs();
}

void StartOperation(void)
{  
    gtk_widget_set_sensitive(Pwd[REMOTE], FALSE);
    gtk_widget_set_sensitive(DisconnectMenuItem, FALSE);
    gtk_widget_set_sensitive(ButtonBox[REMOTE][0], FALSE);
    gtk_widget_set_sensitive(ButtonBox[REMOTE][1], FALSE);
    gtk_widget_set_sensitive(Lister[REMOTE], FALSE);
    gtk_pixmap_set(GTK_PIXMAP(TopPixmap), SpinIcon, NULL);
}
        
void StopOperation(void)
{
    gtk_widget_set_sensitive(Pwd[REMOTE], Connected);
    gtk_widget_set_sensitive(DisconnectMenuItem, Connected);
    gtk_widget_set_sensitive(ButtonBox[REMOTE][0], Connected);
    gtk_widget_set_sensitive(ButtonBox[REMOTE][1], Connected);
    gtk_widget_set_sensitive(Lister[REMOTE], Connected);
    gtk_pixmap_set(GTK_PIXMAP(TopPixmap), PenguinIcon, NULL);
    SetResponse(RESP_FUNC(DummyResponse));
}
