/* Gnome Darxite common code
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include <gnome.h>
#include "daemon.h"
#include "callbacks.h"

//FIXME: put pixmaps stuff in a different file
#include "pause.xpm"
#include "pause_menu.xpm"

gint
file_count_cb(gpointer pointer_data)
{
	SendToDaemon("FileCount\n");

        return TRUE;
}

void 
control_centre_cb(GtkWidget *widget, gpointer data)
{
	if (gnome_execute_shell(DX_BinPath(), "dxpref") == -1)
           show_warning("Error executing Darxite Control Centre!\n");
}


void 
run_noctftp_cb(GtkWidget *widget, gpointer data)
{

//FIXME: Perhaps "NoctFTP" should return 1 or -1 in the case the daemon is
//       not running, warn the user or do autostart...
//	if (!connected) show_warning(NULL);
//	else
//	{
	   if (gnome_execute_shell(NULL, "noctftp") == -1)
              show_warning("Error executing Noct FTP!\n(command=noctftp)\n");
//	}

}
void 
run_dxftp_cb(GtkWidget *widget, gpointer data)
{
	char *b;
	
//FIXME: Perhaps "NoctFTP" should return 1 or -1 in the case the daemon is
//       not running, warn the user or do autostart...
//	if (!daemon_active)
//	{
//	    show_warning(NULL);
//	    return;
//	}
	b = g_strconcat("xterm -e ", DX_BinPath(), "/dxftp", NULL);
	
	if (gnome_execute_shell(NULL, b) == -1)
	    g_print("Error executing dxftp!\n");
	free(b);
}

void 
run_dsgtk_cb(GtkWidget *widget, gpointer data)
{
//	if (!daemon_active) show_warning(NULL);
//	else
//	{
	   if (gnome_execute_shell(NULL, "dsgtk") == -1)
              g_print("Error executing dsgtk!\n");
//	}
}

void show_warning(gchar *warning)
{
	GtkWidget *message_box;

	if (warning == NULL)
	   warning = "This client is not connected to the daemon,\n\
		and it is required for the requested operation.\n\
		Please start it by right clicking on the applet,\n\
		by pressing the start/stop button or executing\n\
		'darxite' in the command line. Then connect to it\n
		if you have disabled \"auto_connect\"";
	message_box = gnome_message_box_new(_(warning),
		GNOME_MESSAGE_BOX_WARNING,GNOME_STOCK_BUTTON_CLOSE,NULL); 
	gtk_widget_show(message_box);
}

void create_pause_pixmap()
{
/*vvv Create a STOCK pixmap vvv*/
	GtkWidget *pixmap;
	GnomeStockPixmapEntry *entry;
	GtkRequisition req;
	
	/*Normal Pixmap*/
	pixmap = gnome_pixmap_new_from_xpm_d(pause_xpm);
	
	entry = g_malloc(sizeof(GnomeStockPixmapEntry));
	entry->type = GNOME_STOCK_PIXMAP_TYPE_GPIXMAP;
	gtk_widget_size_request(pixmap, &req);
	entry->any.width = req.width;
	entry->any.height = req.height;
	entry->any.label = NULL;
	entry->gpixmap.pixmap = GNOME_PIXMAP(pixmap);
	gnome_stock_pixmap_register("Pause",
			GNOME_STOCK_PIXMAP_REGULAR, entry);

	/*Little/Menu Pixmap*/
	pixmap = gnome_pixmap_new_from_xpm_d(pause_menu_xpm);
	
	entry = g_malloc(sizeof(GnomeStockPixmapEntry));
	entry->type = GNOME_STOCK_PIXMAP_TYPE_GPIXMAP;
	gtk_widget_size_request(pixmap, &req);
	entry->any.width = req.width;
	entry->any.height = req.height;
	entry->any.label = NULL;
	entry->gpixmap.pixmap = GNOME_PIXMAP(pixmap);
	gnome_stock_pixmap_register("Menu_Pause",
			GNOME_STOCK_PIXMAP_REGULAR, entry);

/*^^^ Create a STOCK pixmap ^^^*/
}

void SendToDaemon(gchar *command)
{
//	char buffer[256];

//	sprintf(buffer, "%s\n", command);
//	write(fd, buffer, strlen(buffer));
	write(fd, command, strlen(command));
}

// FIXME: These can be removed
// void signal_func(int signum)
// {
// 
// //FIXME: The only thing we need to do here is to remove the input_response
// //       because we have received a EXIT_EVENT.
//     switch (signum)
//     {
//     case SIGPIPE:
//         if (input_response > 0)
// 		 gdk_input_remove(input_response);
// 
// //FIXME: we should do a DisconnectClient(); here!
//         break;
// 
//     default:
//         break;
//     }
// }
