/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "setup.h"
#include "erreur.h"
#include "data.h"

//pour le fast add disk
static GtkWidget *mount_entry;// 
static GtkWidget *umount_entry;
//static GtkWidget *device_entry;// /dev/hdb
static GtkWidget *mount_point_entry;// /mnt/cdrom
static GtkWidget *include_list;

GtkWidget *include_type_entry;
GtkWidget *include_prog_entry;
GtkWidget *include_arg_entry;
GtkWidget *include_viewer_entry;
GtkWidget *include_viewer_arg_entry;

unsigned int include_files;
int include_row_selected;

char *conf_file;
unsigned int temp_include_files;
GtkWidget *add_type_window;



void setup_ok_clicked(GtkWidget *w, gpointer data)
{
  FILE *f;
  char *temp;
  int i;

  if (!(f = fopen(conf_file,"w")))
    {
      /*g_message("fopen failed: %s\n", g_strerror(errno));*/
      erreur_dialog(w,"Can't save to config file:",conf_file,"ERROR!");
      return;
    }
  //les malloc et tout peuvent paraitre superflus,  mais sinon, on perd l'info quand les entry_box sont detruites.
  temp = gtk_entry_get_text(GTK_ENTRY (mount_entry));
  free(mount);
  mount = (char *)malloc(strlen(temp +1)*sizeof(char));
  strcpy(mount,temp);
 
  temp = gtk_entry_get_text(GTK_ENTRY (umount_entry));
  free(umount);
  umount = (char *)malloc(strlen(temp +1)*sizeof(char));
  strcpy(umount,temp);
  
  temp = gtk_entry_get_text(GTK_ENTRY (mount_point_entry));
  free(mount_point);
  mount_point = (char *)malloc(strlen(temp +1)*sizeof(char));
  strcpy(mount_point,temp);

/*  temp = gtk_entry_get_text(GTK_ENTRY (device_entry));
  free(device);
  device = (char *)malloc(strlen(temp +1)*sizeof(char));
  strcpy(device,temp);*/
 
  fprintf(f,"mount_prog=%s\numount_pro=%s\nmount_fold=%s\n",mount,umount,mount_point);
  fprintf(f,"%d\n",nbIncludeData);
  for(i=0;i<nbIncludeData;i++) 
    fprintf(f,"file_type=%s\nprogram=%s\nprog_arg=%s\nviewer=%s\nviewer_arg=%s\n",IncludeData[i].type,IncludeData[i].prog,IncludeData[i].arg,IncludeData[i].viewer,IncludeData[i].viewerarg);
       
  fclose(f);

  
  gtk_widget_destroy(data); 
}

void list_include_type()
{
  unsigned int i;
  char *tmp[5];

  gtk_clist_freeze ((GtkCList *)include_list);
  gtk_clist_clear((GtkCList *)include_list);
  for(i=0;i<nbIncludeData;i++)
    {
      tmp[0] = IncludeData[i].type;
      tmp[1] = IncludeData[i].prog;
      tmp[2] = IncludeData[i].arg;
      tmp[3] = IncludeData[i].viewer;
      tmp[4] = IncludeData[i].viewerarg;
      gtk_clist_append((GtkCList *)include_list, (gchar **) tmp);
    }
   gtk_clist_thaw((GtkCList *)include_list);
}


void add_type_ok_clicked(GtkWidget *w, gpointer data)
{
  char *temp_type;
  char *temp_prog;
  char *temp_arg;
  char *temp_viewer;
  char *temp_viewerarg;

  if ((int)data == -1)
    {
      if (nbIncludeData == 0) IncludeData = (IData *) malloc(sizeof(IData));
      else IncludeData = (IData *)realloc(IncludeData,(nbIncludeData +1)*sizeof(IData));
      temp_type = gtk_entry_get_text(GTK_ENTRY(include_type_entry));
      temp_prog = gtk_entry_get_text(GTK_ENTRY(include_prog_entry));
      temp_arg = gtk_entry_get_text(GTK_ENTRY(include_arg_entry));
      temp_viewer = gtk_entry_get_text(GTK_ENTRY(include_viewer_entry));
      temp_viewerarg = gtk_entry_get_text(GTK_ENTRY(include_viewer_arg_entry)); 

      IncludeData[nbIncludeData].type = malloc((strlen(temp_type) +1)*sizeof(char));
      strcpy(IncludeData[nbIncludeData].type,temp_type);
      IncludeData[nbIncludeData].prog = malloc((strlen(temp_prog) +1)*sizeof(char));
      strcpy(IncludeData[nbIncludeData].prog,temp_prog);
      IncludeData[nbIncludeData].arg = malloc((strlen(temp_arg) +1)*sizeof(char));
      strcpy(IncludeData[nbIncludeData].arg,temp_arg);
      IncludeData[nbIncludeData].viewer = malloc((strlen(temp_viewer) +1)*sizeof(char));
      strcpy(IncludeData[nbIncludeData].viewer,temp_viewer);
      IncludeData[nbIncludeData].viewerarg = malloc((strlen(temp_viewerarg) +1)*sizeof(char));
      strcpy(IncludeData[nbIncludeData].viewerarg,temp_viewerarg);
      nbIncludeData++;
    }
  else
    {
      temp_type = gtk_entry_get_text(GTK_ENTRY(include_type_entry));
      temp_prog = gtk_entry_get_text(GTK_ENTRY(include_prog_entry));
      temp_arg = gtk_entry_get_text(GTK_ENTRY(include_arg_entry));
      temp_viewer = gtk_entry_get_text(GTK_ENTRY(include_viewer_entry));
      temp_viewerarg = gtk_entry_get_text(GTK_ENTRY(include_viewer_arg_entry)); 

      free(IncludeData[(int)data].type);
      free(IncludeData[(int)data].prog);
      free(IncludeData[(int)data].arg);
      free(IncludeData[(int)data].viewer);
      free(IncludeData[(int)data].viewerarg);
      IncludeData[(int)data].type = malloc((strlen(temp_type) +1)*sizeof(char));
      strcpy(IncludeData[(int)data].type,temp_type);
      IncludeData[(int)data].prog = malloc((strlen(temp_prog) +1)*sizeof(char));
      strcpy(IncludeData[(int)data].prog,temp_prog);
      IncludeData[(int)data].arg = malloc((strlen(temp_arg) +1)*sizeof(char));
      strcpy(IncludeData[(int)data].arg,temp_arg);
      IncludeData[(int)data].viewer = malloc((strlen(temp_viewer) +1)*sizeof(char));
      strcpy(IncludeData[(int)data].viewer,temp_viewer);
      IncludeData[(int)data].viewerarg = malloc((strlen(temp_viewerarg) +1)*sizeof(char));
      strcpy(IncludeData[(int)data].viewerarg,temp_viewerarg);
    }
  list_include_type();
  gtk_widget_destroy(add_type_window);
}


void add_type(GtkWidget *w, gpointer data)
{
  GtkWidget *vbox, *hbox, *vbox2;
  GtkWidget *ok, *cancel;
  GtkWidget *frame;
  GtkWidget *label;

 
  add_type_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position (GTK_WINDOW (add_type_window), GTK_WIN_POS_MOUSE);
  gtk_widget_set_usize( GTK_WIDGET (add_type_window), 300,295);
  gtk_window_set_title(GTK_WINDOW (add_type_window), "File type");
  gtk_window_set_policy(GTK_WINDOW(add_type_window), FALSE, FALSE, TRUE);
  gtk_container_border_width(GTK_CONTAINER(add_type_window),10);
  gtk_signal_connect(GTK_OBJECT (add_type_window), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(add_type_window));
  
  gtk_grab_add(add_type_window);
  
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (add_type_window), vbox);
  gtk_widget_show (vbox);
  /***************/	
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "File Type" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show(frame);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_type_entry = gtk_entry_new_with_max_length (80);
/*  gtk_signal_connect(GTK_OBJECT(include_type_entry), "activate",
		     GTK_SIGNAL_FUNC(ok_clicked),
		     include_type__entry);*/
  if((int)data != -1)gtk_entry_set_text (GTK_ENTRY (include_type_entry),IncludeData[(int)data].type );
  gtk_entry_select_region (GTK_ENTRY (include_type_entry),
			   0, GTK_ENTRY(include_type_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_type_entry, FALSE, FALSE, 0); 
  gtk_widget_show (include_type_entry);
   
  label = gtk_label_new("Something like *.rpm");
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0); 
  gtk_widget_show (label);
  
  /***********/	
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "Program" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show(frame);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_prog_entry = gtk_entry_new_with_max_length (80);
 /* gtk_signal_connect(GTK_OBJECT(include_prog_entry), "activate",
		     GTK_SIGNAL_FUNC(ok_clicked),
		     include_prog_entry);*/
   if((int)data != -1)gtk_entry_set_text (GTK_ENTRY (include_prog_entry),IncludeData[(int)data].prog );
  gtk_entry_select_region (GTK_ENTRY (include_prog_entry),
			   0, GTK_ENTRY(include_prog_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_prog_entry, FALSE, FALSE, 0); 
  gtk_widget_show (include_prog_entry);
    
  label = gtk_label_new("Leave blank to include all the file");
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0); 
  gtk_widget_show (label);
  
  /***********/	
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "Program Option" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show(frame);
  
  include_arg_entry = gtk_entry_new_with_max_length (80);
/*  gtk_signal_connect(GTK_OBJECT(include_arg_entry), "activate",
		     GTK_SIGNAL_FUNC(ok_clicked),
		     include_arg_entry);*/
  if((int)data != -1)gtk_entry_set_text (GTK_ENTRY (include_arg_entry),IncludeData[(int)data].arg );
  gtk_entry_select_region (GTK_ENTRY (include_arg_entry),
			   0, GTK_ENTRY(include_arg_entry)->text_length);
  gtk_container_add(GTK_CONTAINER(frame), include_arg_entry);
  gtk_widget_show (include_arg_entry);
  
  /***********/
  
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "Viewer" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show(frame);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_viewer_entry = gtk_entry_new_with_max_length (80);
 /* gtk_signal_connect(GTK_OBJECT(include_viewer_entry), "activate",
		     GTK_SIGNAL_FUNC(ok_clicked),
		     include_viewer_entry);*/
  if((int)data != -1)gtk_entry_set_text (GTK_ENTRY (include_viewer_entry),IncludeData[(int)data].viewer ); 
  gtk_entry_select_region (GTK_ENTRY (include_viewer_entry),
			   0, GTK_ENTRY(include_viewer_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_viewer_entry, FALSE, FALSE, 0);
  gtk_widget_show (include_viewer_entry);
  
  label = gtk_label_new("Leave blank to use GTKtalog viewer");
  gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, FALSE, 0); 
  gtk_widget_show (label);

 
  /***********/
  
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "Viewer Option" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
  gtk_widget_show(frame);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);

  include_viewer_arg_entry = gtk_entry_new_with_max_length (80);
 /* gtk_signal_connect(GTK_OBJECT(include_viewer_arg_entry), "activate",
		     GTK_SIGNAL_FUNC(ok_clicked),
		     include_viewer_arg_entry);*/
  if((int)data != -1)gtk_entry_set_text (GTK_ENTRY (include_viewer_arg_entry),IncludeData[(int)data].viewerarg );
  gtk_entry_select_region (GTK_ENTRY (include_viewer_arg_entry),
			   0, GTK_ENTRY(include_viewer_arg_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox2), include_viewer_arg_entry, FALSE, FALSE, 0);
  gtk_widget_show (include_viewer_arg_entry);
  

/********************************/
            

  hbox=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox),GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox),5);
  
  ok=gtk_button_new_with_label("Ok");
  gtk_object_set_user_data(GTK_OBJECT(ok),add_type_window);
  GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
  gtk_window_set_default(GTK_WINDOW(add_type_window),ok);
  gtk_box_pack_start(GTK_BOX(hbox),ok,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(ok),"clicked",GTK_SIGNAL_FUNC(add_type_ok_clicked),data);
  gtk_widget_show(ok);
  
  cancel=gtk_button_new_with_label("Cancel");
  GTK_WIDGET_SET_FLAGS(cancel,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(hbox),cancel,TRUE,TRUE,0);
  gtk_signal_connect_object(GTK_OBJECT(cancel),"clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(add_type_window));
  gtk_widget_show(cancel);
  
  gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
  gtk_widget_show(hbox);
  
  gtk_widget_show(add_type_window); 
  
} 


void include_selection_made( GtkWidget *clist, gint row, gint column, GdkEventButton *event)
{
  include_row_selected = row;
}

void include_unselection_made( GtkWidget *clist, gint row, gint column, GdkEventButton *event)
{
  include_row_selected = -1;
}

void include_edit_button_clicked(GtkWidget *w, gpointer data)
{
  if (include_row_selected != -1) add_type(w,(gpointer) include_row_selected);
}


void include_delete_button_clicked(GtkWidget *w, gpointer data)
{
  int i;
  
  if (include_row_selected != -1)
    {
      for(i=include_row_selected;i<(nbIncludeData -1);i++)
	{
	  IncludeData[i] = IncludeData[i+1]; 
	}
      nbIncludeData--;
      IncludeData = (IData *)realloc(IncludeData,nbIncludeData*sizeof(IData));
      list_include_type();
    }
}



GtkWidget *create_include_list (void)
{
  
  GtkWidget *scrolled_window;
  gchar *titles[5] = { "File type", "Program" , "Options","Viewer","Viewer Options"};
  
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, 
				  GTK_POLICY_AUTOMATIC);
  
  
  include_list = gtk_clist_new_with_titles( 5, titles);  
  gtk_signal_connect(GTK_OBJECT(include_list), "select_row",
		     GTK_SIGNAL_FUNC(include_selection_made),NULL);
  gtk_signal_connect(GTK_OBJECT(include_list), "unselect_row",
		     GTK_SIGNAL_FUNC(include_unselection_made),NULL);
  
  gtk_clist_set_shadow_type (GTK_CLIST(include_list), GTK_SHADOW_OUT);
  gtk_clist_set_column_width (GTK_CLIST(include_list), 0, 60);
  gtk_clist_set_column_width (GTK_CLIST(include_list), 1, 60);
  gtk_clist_set_column_width (GTK_CLIST(include_list), 2, 60);
  gtk_clist_set_column_width (GTK_CLIST(include_list), 3, 60);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window), include_list);
 // gtk_signal_connect(GTK_OBJECT(clist), "button_press_event", GTK_SIGNAL_FUNC(clist_pressed), NULL);
  gtk_widget_show (include_list);
  
  return scrolled_window;
}


void run_setup(GtkWidget *w, gpointer data) 
{
  GtkWidget *setup_window;
  GtkWidget *ok;
  GtkWidget *cancel;
  GtkWidget *notebook;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *hbox;
  GtkWidget *main_vbox;
  GtkWidget *bbox;
  GtkWidget *setup_vbox;
  GtkWidget *include_list_box;
  GtkWidget *add_button;
  GtkWidget *delete_button;
  GtkWidget *edit_button;
  GtkWidget *vbox2;
  
  setup_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(setup_window), FALSE, FALSE, TRUE);
  gtk_window_set_title(GTK_WINDOW (setup_window), "Setup");
  gtk_widget_set_usize( GTK_WIDGET (setup_window), 370, 335);
  gtk_signal_connect (GTK_OBJECT (setup_window), "delete_event",
		      GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(setup_window));
  gtk_container_set_border_width (GTK_CONTAINER (setup_window), 2);
  gtk_grab_add(setup_window);
  
  setup_vbox = gtk_vbox_new(FALSE,4);
  gtk_container_add (GTK_CONTAINER (setup_window), setup_vbox);
  gtk_widget_show (setup_vbox);
  
  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_box_pack_start (GTK_BOX (setup_vbox), notebook, TRUE, TRUE, 0); 
  //gtk_container_add (GTK_CONTAINER (setup_window), notebook);
  // gtk_table_attach_defaults(GTK_TABLE(table), notebook, 0,6,0,1);
  gtk_widget_show(notebook);
  
  
  // creation de la fentre des fichiers a inclure!    
  frame = gtk_frame_new ("Cases are not sensitive for files type");
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  
  gtk_widget_show (frame);
  
  label = gtk_label_new("Files to include");
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);
  
  main_vbox = gtk_vbox_new(FALSE,4);
  gtk_container_add (GTK_CONTAINER (frame), main_vbox);
  gtk_widget_show (main_vbox);
  
  include_list_box = create_include_list ();
  gtk_box_pack_start(GTK_BOX(main_vbox),include_list_box,TRUE, TRUE, 0 );
  gtk_widget_show(include_list_box);
  
  
  
  hbox=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox),GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox),5);
  
  add_button=gtk_button_new_with_label("Add");
  // gtk_object_set_user_data(GTK_OBJECT(add_button),add_type_window);
  GTK_WIDGET_SET_FLAGS(add_button,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(hbox),add_button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(add_button),"clicked",GTK_SIGNAL_FUNC(add_type),(gpointer)-1);
  gtk_widget_show(add_button);
  
  edit_button=gtk_button_new_with_label("Edit");
  // gtk_object_set_user_data(GTK_OBJECT(add_button),add_type_window);
  GTK_WIDGET_SET_FLAGS(edit_button,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(hbox),edit_button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(edit_button),"clicked",GTK_SIGNAL_FUNC(include_edit_button_clicked),setup_window);
  gtk_widget_show(edit_button);
  
  delete_button=gtk_button_new_with_label("Delete");
  GTK_WIDGET_SET_FLAGS(delete_button,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(hbox),delete_button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(delete_button),"clicked",GTK_SIGNAL_FUNC(include_delete_button_clicked),setup_window);
  gtk_widget_show(delete_button); 
  
  gtk_box_pack_start(GTK_BOX(main_vbox),hbox,FALSE,TRUE,0);
  gtk_widget_show(hbox);
  
  ////////////////////////////////////////////////////////////////////////
  //creation du paneau pour le fast add disk
  frame = gtk_frame_new ("Complete informations");
  gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
  // gtk_widget_set_usize (frame, 100, 75);
  
  gtk_widget_show (frame);
  
  
  label = gtk_label_new("Disk setup");
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);
  
  main_vbox = gtk_vbox_new(FALSE,4);
  gtk_container_add (GTK_CONTAINER (frame), main_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 3);
  gtk_widget_show (main_vbox);
  
  
  /**************/
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "Mount program" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);  
  gtk_widget_show(frame);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);    
  
  mount_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (mount_entry), mount);
  gtk_box_pack_start (GTK_BOX (vbox2), mount_entry, FALSE, FALSE, 0);
  gtk_widget_show (mount_entry);
  label = gtk_label_new("ex: /bin/mount ");
  gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0); 
  gtk_widget_show (label);

/*************/
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "Umount program" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);  
  gtk_widget_show(frame);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);    
     
  umount_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (umount_entry), umount);
  gtk_box_pack_start (GTK_BOX (vbox2), umount_entry, FALSE, FALSE, 0);
  gtk_widget_show (umount_entry);
  
  label = gtk_label_new("ex: /bin/umount");
  gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0); 
  gtk_widget_show (label);


/**************/

  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "Mount point" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);  
  gtk_widget_show(frame);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);
  
  mount_point_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (mount_point_entry), mount_point);
  gtk_box_pack_start (GTK_BOX (vbox2), mount_point_entry, FALSE, FALSE, 0);
  gtk_widget_show (mount_point_entry);
  
  label = gtk_label_new("This must be the mount point registered in /etc/fstab");
  gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0); 
  gtk_widget_show (label);

/***************/

/*  frame = gtk_frame_new(NULL);
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);
  gtk_frame_set_label( GTK_FRAME(frame), "Device" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);  
  gtk_widget_show(frame);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);    
      
  device_entry = gtk_entry_new_with_max_length (200);
  gtk_entry_set_text (GTK_ENTRY (device_entry), device);
  gtk_box_pack_start (GTK_BOX (vbox2), device_entry, FALSE, FALSE, 0);
  gtk_widget_show (device_entry);

  label = gtk_label_new("ex: /dev/cdrom or /dev/hdb use to eject CDrom");
  gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0); 
  gtk_widget_show (label);*/


  
///////////////////////////////////////////////////////////////////////
///////creation des deux bouttons du bas
    bbox=gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox),GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox),5);
    gtk_box_pack_start(GTK_BOX(setup_vbox),bbox,FALSE,FALSE,0);
    gtk_widget_show(bbox);

    ok=gtk_button_new_with_label("Ok");
    gtk_object_set_user_data(GTK_OBJECT(ok),setup_window);
    GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
    gtk_window_set_default(GTK_WINDOW(setup_window),ok);
    gtk_box_pack_start(GTK_BOX(bbox),ok,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(ok),"clicked",GTK_SIGNAL_FUNC(setup_ok_clicked),setup_window);
    gtk_widget_show(ok);
    
    cancel=gtk_button_new_with_label("Cancel");
    GTK_WIDGET_SET_FLAGS(cancel,GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(bbox),cancel,TRUE,TRUE,0);
    gtk_signal_connect_object(GTK_OBJECT(cancel),"clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(setup_window));
    gtk_widget_show(cancel);

    gtk_widget_show(setup_window);
    

    temp_include_files = include_files;
    include_row_selected = -1;
    list_include_type();
}




void load_setup()
{
  char *conf_dir;
  char *tmp_dir;
  FILE *file;
  char *home;
  struct stat dummy;
  char temp[200];
  unsigned int i;

  if ((home = getenv("HOME")) == NULL)
    {
      return;
    }
   conf_dir = g_strdup( home);
   if (conf_dir[strlen(conf_dir) - 1] != '/') conf_dir = g_strconcat(conf_dir,"/",NULL);
   tmp_dir = g_strconcat(conf_dir,".gtktalog/temp",NULL);
   conf_dir = g_strconcat(conf_dir,".gtktalog/",NULL);
   conf_file = g_strconcat(conf_dir,"gtktalog.conf",NULL);
   
   //if((file = fopen(conf_file,"r")) == NULL)
   if(stat(conf_file,&dummy) == -1)
     {
       if (stat(conf_dir, &dummy)  == -1)
	 {
	   mkdir(conf_dir,S_IRUSR|S_IXUSR|S_IWUSR);
	   chmod(conf_dir,S_IRUSR|S_IXUSR|S_IWUSR);
	 }
       if((file = fopen(conf_file,"w+")) == NULL) printf("ERROR! Can't create setup file");
       else
	 {
	   fprintf(file,"mount_prog=/bin/mount\numount_pro=/bin/umount\nmount_fold=/mnt/cdrom\n");
	   fprintf(file,"6\n");
	   fprintf(file,"file_type=*.tgz\nprogram=tar\nprog_arg=tzf\nviewer=\nviewer_arg=\n");
	   fprintf(file,"file_type=*tar.gz\nprogram=tar\nprog_arg=tzf\nviewer=\nviewer_arg=\n");
	   fprintf(file,"file_type=*.rpm\nprogram=rpm\nprog_arg=-qpil\nviewer=\nviewer_arg=\n");
	   fprintf(file,"file_type=index\nprogram=\nprog_arg=\nviewer=\nviewer_arg=\n");
	   fprintf(file,"file_type=index.html\nprogram=\nprog_arg=\nviewer=netscape\nviewer_arg=\n");
	   fprintf(file,"file_type=*.mp3\nprogram=%s/share/gtktalog/plugins/mp3info\nprog_arg=\nviewer=\nviewer_arg=\n",PREFIX); 
	   fclose(file);
	 }
     }
 
   file = fopen(conf_file,"r");
   mount = (char *)malloc(100*sizeof(char));
   umount = (char *)malloc(100*sizeof(char));
//   device = (char *)malloc(100*sizeof(char));
//   device_type = (char *)malloc(100*sizeof(char));
   mount_point = (char *)malloc(100*sizeof(char));
   fscanf(file,"%d\n",&include_files);
 
   fgets(temp,200,file);
   temp[strlen(temp) -1] = '\0';
   strcpy(mount,temp+11);

   fgets(temp,200,file);
   temp[strlen(temp) -1] = '\0';
   strcpy(umount,temp+11);

   fgets(temp,200,file);
   temp[strlen(temp) -1] = '\0';
   strcpy(mount_point,temp+11);

 /*  fgets(temp,200,file);
   temp[strlen(temp) -1] = '\0';
   strcpy(device,temp+11);*/
   
   fscanf(file,"%d\n",&nbIncludeData);
   if(nbIncludeData != 0) 
     {
       IncludeData = (IData *) malloc(nbIncludeData*sizeof(IData));  
       for(i=0;i<nbIncludeData;i++)
	 {
	   fgets(temp,200,file);
	   temp[strlen(temp) -1] = '\0';
	   IncludeData[i].type =(char *) malloc((strlen(temp)-10)*sizeof(char));
	   strcpy(IncludeData[i].type,temp+10);
	   
	   fgets(temp,200,file);
	   temp[strlen(temp) -1] = '\0';
	   IncludeData[i].prog =(char *) malloc((strlen(temp)-8)*sizeof(char));
	   strcpy(IncludeData[i].prog,temp+8);

	   fgets(temp,200,file);
	   temp[strlen(temp) -1] = '\0';
	   IncludeData[i].arg =(char *) malloc((strlen(temp)-9)*sizeof(char));
	   strcpy(IncludeData[i].arg,temp+9);

	   fgets(temp,200,file);
	   temp[strlen(temp) -1] = '\0';
	   IncludeData[i].viewer =(char *) malloc((strlen(temp)-7)*sizeof(char));
	   strcpy(IncludeData[i].viewer,temp+7);

	   
	   fgets(temp,200,file);
	   temp[strlen(temp) -1] = '\0';
	   IncludeData[i].viewerarg =(char *) malloc((strlen(temp)-11)*sizeof(char));
	   strcpy(IncludeData[i].viewerarg,temp+11);
	 }
     }
   mkdir(tmp_dir,S_IRUSR|S_IXUSR|S_IWUSR);
   chmod(tmp_dir,S_IRUSR|S_IXUSR|S_IWUSR);
} 

