/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */


#include "gstalker.h"

/********************************************************************************/
void
edit_chart_changed()
{
  extern gint edit_chart_save_flag;
  
  edit_chart_save_flag = 1;
}
/********************************************************************************/
void
edit_data_insert()
{
  gint tint;
  GtkWidget *dialog;
  gchar *data;
  extern gint grow, gcol;
  extern GtkWidget *edit_chart_data_value, *edit_chart_clist, *main_window;
  extern gchar *mess_invalid_date, *mess_invalid_entry, *mess_nothing_entered;
  extern GString *gstring;
  extern gint edit_chart_save_flag;
  

  data = gtk_entry_get_text (GTK_ENTRY (edit_chart_data_value));
  
  if (strlen(data) < 1)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_entered);
	gtk_widget_show(dialog);
	return;
  }
  
  if (gcol == 1)
  	tint = import_check_date (data);
  else
  	tint = import_check_number (data);
  	
  if (tint)
  {
  	if (gcol == 1)
  	{
  		dialog = gnome_app_error (GNOME_APP(main_window), mess_invalid_date);
		gtk_widget_show(dialog);
		return;
  	}
  	else
  	{
  		dialog = gnome_app_error (GNOME_APP(main_window), mess_invalid_entry);
		gtk_widget_show(dialog);
		return;
  	}
  }
  
  gtk_clist_set_text (GTK_CLIST(edit_chart_clist), grow, gcol, gstring->str);
  edit_chart_save_flag = 1;
}
/***********************************************************************************/
void
edit_data_nosave(gint reply)
{
  extern gint edit_chart_save_flag;
  extern GtkWidget *edit_chart_window;
  extern struct record config;
  
  
  if (reply)
  {
  	edit_chart_save_flag = 0;
  	gtk_widget_destroy (edit_chart_window);
  	config.edit_chart_window_open = 0;
  }
  else
  {
  	edit_chart_save_flag = 0;
  	edit_data_save();
  }
}
/***********************************************************************************/
void 
data_selected ()
{
  GdkModifierType state;
  gchar *text;
  gint x, y;
  extern gint grow, gcol;
  extern GtkWidget *edit_chart_data_value, *edit_chart_clist;

  
  gdk_window_get_pointer (edit_chart_clist->window, &x, &y, &state);
  gtk_clist_get_selection_info (GTK_CLIST (edit_chart_clist), x, y-25, &grow, &gcol);
  if (gcol > 0)
  {
  	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), grow, gcol, &text);
  	gtk_entry_set_text (GTK_ENTRY (edit_chart_data_value), text);
  }
}
/**************************************************************************************/
void 
yes_delete_record (gint reply)
{
  gint tint, tint2, tint3;
  GList *list;
  GString *tstring;
  extern gint edit_chart_save_flag, edit_records;
  extern GtkWidget *edit_chart_clist;


  if (reply)
	return;
	
  tstring = g_string_new(NULL);
  
  list = GTK_CLIST (edit_chart_clist)->selection;
  tint = (int) list->data;
  tint3 = tint;
  gtk_clist_remove (GTK_CLIST (edit_chart_clist), tint);
  edit_chart_save_flag = 1;
  
  edit_records--;
  
  for (tint2 = 1; tint2 <= edit_records; tint2++)
  {
  	g_string_sprintf (tstring, "%d", tint2);
  	gtk_clist_set_text (GTK_CLIST (edit_chart_clist), tint2 - 1, 0, tstring->str);
  }
  
  tint = edit_records;
  if ((tint3 + 1) > edit_records)
  	tint3 = edit_records;
  gtk_clist_select_row (GTK_CLIST (edit_chart_clist), tint3, 0);
  
  g_string_free(tstring, TRUE);
  edit_chart_save_flag = 1;
}
/********************************************************************************************/
void 
edit_data_delete ()
{
  GtkWidget *dialog;
  extern GtkWidget *main_window;
  extern gchar *mess_delete_confirm;


  dialog = gnome_app_question_modal (GNOME_APP(main_window),
		 					 mess_delete_confirm,
		 					 (GnomeReplyCallback)yes_delete_record,
		 					 NULL);

  gtk_widget_show(dialog);
}
/*************************************************************************************/
void 
edit_data_save ()
{
  FILE *outfile;
  GString *tstring;
  gchar *tstringp, *open, *high, *low, *close, *volume, *openint;
  gint tint=0;
  extern gint edit_chart_save_flag, edit_records;
  extern GtkWidget *edit_chart_clist, *edit_chart_name_value_entry;
  extern struct record config;
  extern GString *gstring, *edit_symbol, *current_symbol;
  


  tstring = g_string_new(NULL);

  g_string_sprintf (tstring, "%s%s", config.datapath, edit_symbol->str);
  outfile = fopen(tstring->str, "w");

  tstringp = gtk_entry_get_text (GTK_ENTRY (edit_chart_name_value_entry));
  save_index_name (edit_symbol->str, tstringp);
  save_index_records (edit_symbol->str, edit_records);
  gtk_clist_get_text (GTK_CLIST (edit_chart_clist), 0, 1, &tstringp);
  convert_date2(tstringp);
  save_index_first_date (edit_symbol->str, gstring->str);
  gtk_clist_get_text (GTK_CLIST (edit_chart_clist), edit_records - 1, 1, &tstringp);
  convert_date2(tstringp);
  save_index_last_date (edit_symbol->str, gstring->str);

  for (tint = 1; tint <= edit_records; tint++)
  {
  	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint - 1, 2, &open);
  	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint - 1, 3, &high);
  	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint - 1, 4, &low);
  	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint - 1, 5, &close);
  	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint - 1, 6, &volume);
  	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint - 1, 7, &openint);
  	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint - 1, 1, &tstringp);
  	convert_date2(tstringp);
  	g_string_sprintf (tstring, "%s %s %s %s %s %s %s\n", gstring->str, open, high, low,
  				  close, volume, openint); 
  	fputs(tstring->str, outfile);
  }
  fclose(outfile);
  edit_chart_save_flag = 0;
  if (! strcmp (current_symbol->str, edit_symbol->str))
  	load_file (edit_symbol->str);
  	
  g_string_free(tstring, TRUE);
}
/**************************************************************************************/
void 
edit_chart_data ()
{
  FILE *infile;
  gchar *tstringp, *line[8], open[15], high[15], low[15], close[15], volume[15];
  gchar buffer[1024], openint[15], date[15];
  GString *tstring, *tstring2;
  gint tint;
  GtkWidget *frame, *dialog, *vbox, *vbox2, *vbox3, *hbox, *hbox2, *insert_button;
  GtkWidget *label, *label2, *close_button, *save_button, *delete_button, *swindow;
  GList *list = NULL;
  extern GtkWidget *workwith_charts_clist, *edit_chart_window, *workwith_charts_window;
  extern GtkWidget *edit_chart_name_value_entry, *edit_chart_clist;
  extern GtkWidget *main_window, *edit_chart_data_value;
  extern gint edit_chart_save_flag, edit_records;
  extern gchar *mess_nothing_selected, *label_date, *label_open, *label_close, *label_high;
  extern gchar *label_low, *label_close, *label_volume, *label_ointerest, *label_save;
  extern gchar *label_delete, *label_close, *label_insert, *label_edit_chart_data;
  extern gchar *label_name, *label_data;
  extern struct record config;
  extern GString *gstring, *edit_symbol;



  if (config.edit_chart_window_open)
    return;
    
  list = GTK_CLIST (workwith_charts_clist)->selection;
  if (!list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
  
  tstring = g_string_new(NULL);
  tstring2 = g_string_new(NULL);

  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (workwith_charts_clist), tint, 0, &tstringp);
  g_string_assign (edit_symbol, tstringp);

  if (workwith_charts_window)
    gtk_widget_destroy (workwith_charts_window);


  edit_chart_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (edit_chart_window), "destroy",
		GTK_SIGNAL_FUNC (gtk_widget_destroyed), &edit_chart_window);
  gtk_window_position (GTK_WINDOW (edit_chart_window), GTK_WIN_POS_CENTER);
  gtk_container_border_width (GTK_CONTAINER (edit_chart_window), 0);
  gtk_widget_set_usize (GTK_WIDGET (edit_chart_window), 500, 300);

  hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_container_add (GTK_CONTAINER (edit_chart_window), hbox);
  gtk_widget_show (hbox);
  
  vbox = gtk_vbox_new (FALSE, 10);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_widget_show (vbox);
  
  vbox2 = gtk_vbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (vbox2), 0);
  gtk_box_pack_end (GTK_BOX (hbox), vbox2, FALSE, TRUE, 0);
  gtk_vbutton_box_set_spacing_default (5);
  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
  gtk_widget_show (vbox2);

  save_button = gtk_button_new_with_label (label_save);
  gtk_signal_connect (GTK_OBJECT (save_button), "clicked",
		      GTK_SIGNAL_FUNC (edit_data_save), (gint) 0);
  gtk_box_pack_start (GTK_BOX (vbox2), save_button, FALSE, TRUE, 0);
  gtk_widget_show (save_button);

  delete_button = gtk_button_new_with_label (label_delete);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (edit_data_delete), NULL);
  gtk_box_pack_start (GTK_BOX (vbox2), delete_button, FALSE, TRUE, 0);
  gtk_widget_show (delete_button);
  
  insert_button = gtk_button_new_with_label (label_insert);
  gtk_signal_connect (GTK_OBJECT (insert_button), "clicked",
		      GTK_SIGNAL_FUNC (edit_data_insert), NULL);
  gtk_box_pack_start (GTK_BOX (vbox2), insert_button, FALSE, TRUE, 0);
  gtk_widget_show (insert_button);

  close_button = gtk_button_new_with_label (label_close);
  gtk_signal_connect_object (GTK_OBJECT (close_button), "clicked",
  			     GTK_SIGNAL_FUNC (edit_chart_cancel), NULL);
  gtk_box_pack_start (GTK_BOX (vbox2), close_button, FALSE, TRUE, 0);
  gtk_widget_show (close_button);
  
  swindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add (GTK_CONTAINER (vbox), swindow);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow);

  edit_chart_clist = gtk_clist_new_with_titles (8, NULL);
  gtk_clist_set_column_width (GTK_CLIST (edit_chart_clist), 0, 40);
  gtk_clist_set_column_width (GTK_CLIST (edit_chart_clist), 1, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_chart_clist), 2, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_chart_clist), 3, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_chart_clist), 4, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_chart_clist), 5, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_chart_clist), 6, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_chart_clist), 7, 70);
  gtk_clist_set_selection_mode (GTK_CLIST (edit_chart_clist), GTK_SELECTION_BROWSE);
  gtk_container_add (GTK_CONTAINER (swindow), edit_chart_clist);
  gtk_container_border_width (GTK_CONTAINER (edit_chart_clist), 0);
  gtk_signal_connect (GTK_OBJECT (edit_chart_clist), "select_row",
		      GTK_SIGNAL_FUNC (data_selected), NULL);
  gtk_clist_set_column_title (GTK_CLIST(edit_chart_clist), 0, "#");
  gtk_clist_set_column_title (GTK_CLIST(edit_chart_clist), 1, label_date);
  gtk_clist_set_column_title (GTK_CLIST(edit_chart_clist), 2, label_open);
  gtk_clist_set_column_title (GTK_CLIST(edit_chart_clist), 3, label_high);
  gtk_clist_set_column_title (GTK_CLIST(edit_chart_clist), 4, label_low);
  gtk_clist_set_column_title (GTK_CLIST(edit_chart_clist), 5, label_close);
  gtk_clist_set_column_title (GTK_CLIST(edit_chart_clist), 6, label_volume);
  gtk_clist_set_column_title (GTK_CLIST(edit_chart_clist), 7, label_ointerest);
  gtk_clist_column_titles_show (GTK_CLIST(edit_chart_clist));
  gtk_widget_show (edit_chart_clist);
  

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_widget_show (frame);
  
  vbox3 = gtk_vbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (frame), vbox3);
  gtk_container_border_width (GTK_CONTAINER (vbox3), 10);
  gtk_widget_show (vbox3);

  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_container_border_width (GTK_CONTAINER (hbox2), 0);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox2, FALSE, TRUE, 0);
  gtk_widget_show (hbox2);

  label = gtk_label_new (label_name);
  gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, TRUE, 0);
  gtk_widget_show (label);

  edit_chart_name_value_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox2), edit_chart_name_value_entry, TRUE, TRUE, 0);
  gtk_widget_show (edit_chart_name_value_entry);
  
  label2 = gtk_label_new (label_data);
  gtk_box_pack_start (GTK_BOX (hbox2), label2, FALSE, TRUE, 0);
  gtk_widget_show (label2);
  
  edit_chart_data_value = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox2), edit_chart_data_value, TRUE, TRUE, 0);
  gtk_widget_show (edit_chart_data_value);
  
  edit_records = get_index_records (edit_symbol->str);
  
  gtk_clist_freeze (GTK_CLIST (edit_chart_clist));
  tint = 1;
  g_string_sprintf (tstring, "%s%s", config.datapath, edit_symbol->str);
  infile = fopen(tstring->str, "r");
  while (fgets (buffer, sizeof(buffer), infile) != NULL)
  {
      g_string_sprintf (tstring2, "%d", tint);
      line[0] = tstring2->str;
      sscanf (buffer, "%s %s %s %s %s %s %s", date, open, high, low, close, volume, openint);
      convert_date(date);
      strcpy(date, gstring->str);
      line[1] = date;
      line[2] = open;
      line[3] = high;
      line[4] = low;
      line[5] = close;
      line[6] = volume;
      line[7] = openint;
      gtk_clist_append (GTK_CLIST (edit_chart_clist), line);
      tint++;
    }
  fclose(infile);
  gtk_clist_thaw (GTK_CLIST (edit_chart_clist));
  
  get_index_name (edit_symbol->str);
  gtk_entry_set_text (GTK_ENTRY (edit_chart_name_value_entry), gstring->str);
  gtk_entry_set_text (GTK_ENTRY (edit_chart_data_value), "");

  gtk_signal_connect (GTK_OBJECT (edit_chart_name_value_entry), "changed",
		      GTK_SIGNAL_FUNC (edit_chart_changed), NULL);
		      
  g_string_sprintf (tstring, "%s - %s", label_edit_chart_data, edit_symbol->str);
  gtk_window_set_title (GTK_WINDOW (edit_chart_window), tstring->str);

  gtk_widget_show (edit_chart_window);
  
  g_string_free(tstring, TRUE);
  g_string_free(tstring2, TRUE);
  edit_chart_save_flag = 0;
  config.edit_chart_window_open = 1;
}
/********************************************************************************************/
void
edit_chart_cancel()
{
  GtkWidget *dialog;
  extern GtkWidget *main_window;
  extern gint edit_chart_save_flag;
  extern gchar *mess_save_changes;
  

  if (edit_chart_save_flag)
  {
	dialog = gnome_app_question_modal (GNOME_APP(main_window),
						mess_save_changes,
						(GnomeReplyCallback)edit_data_nosave,
						NULL);
	gtk_widget_show(dialog);
  }
  else
  	edit_data_nosave(1);
}
