#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation 
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

proc initia_initialise {} {

  global tnpath
  source $tnpath/gid/global.tcl

  set initia_array_length 22
  set initia_array(0)        echo
  set initia_array_types(0)  checkbutton
  set initia_array(1)        ndim
  set initia_array_types(1)  radiobutton
  set initia_array(2)        derivatives
  set initia_array_types(2)  checkbutton
  set initia_array(3)        condif_temperature
  set initia_array_types(3)  checkbutton
  set initia_array(4)        groundflow_velocity
  set initia_array_types(4)  checkbutton
  set initia_array(5)        groundflow_pressure
  set initia_array_types(5)  checkbutton
  set initia_array(6)        materi_damage
  set initia_array_types(6)  checkbutton
  set initia_array(7)        materi_density
  set initia_array_types(7)  checkbutton
  set initia_array(8)        materi_displacement
  set initia_array_types(8)  checkbutton
  set initia_array(9)        materi_history_variables
  set initia_array_types(9)  entry
  set initia_array(10)       materi_maxwell_stress
  set initia_array_types(10) entry
  set initia_array(11)       materi_plasti_kappa
  set initia_array_types(11) checkbutton
  set initia_array(12)       materi_plasti_rho
  set initia_array_types(12) checkbutton
  set initia_array(13)       materi_strain_elasti
  set initia_array_types(13) checkbutton
  set initia_array(14)       materi_strain_plasti
  set initia_array_types(14) checkbutton
  set initia_array(15)       materi_strain_total
  set initia_array_types(15) checkbutton
  set initia_array(16)       materi_stress
  set initia_array_types(16) checkbutton
  set initia_array(17)       materi_velocity
  set initia_array_types(17) checkbutton
  set initia_array(18)       materi_void_fraction
  set initia_array_types(18) checkbutton
  set initia_array(19)       residue
  set initia_array_types(19) checkbutton
  set initia_array(20)       wave_scalar
  set initia_array_types(20) checkbutton
  set initia_array(21)       wave_fscalar
  set initia_array_types(21) checkbutton
  for {set i 0} {$i<$initia_array_length} {incr i} { set initia_array_values($i) 0 }

  set initia_array_values(0) 1
  set initia_array_values(1) 1

  set cmd_array_member_part_list ""
  set cmd_array_member_part_list_length 0

}

proc data_initialise {} {

  global tn_switch
  global tnpath

  if { $tn_switch } { puts "In proc DATA_INITIALISE" }

#   reset
  global cmd_array
  global cmd_array_list
  global cmd_array_length

#   read tngid.cmd
  set cmd_array_length 0
  set f_cmd [open tngid.cmd r]
  while { [gets $f_cmd line]>=0 } {
    set cmd_array($cmd_array_length) $line
    set cmd_array_list($cmd_array_length) [ split $cmd_array($cmd_array_length) _ ]
    incr cmd_array_length
  }
  close $f_cmd

#   set data_array variables to global
  for {set idata 0} {$idata<$cmd_array_length} {incr idata} {

    set cmd_array_member $cmd_array($idata)

    set data_array data_array_$cmd_array_member
    global $data_array

    set data_array_values data_array_values_$cmd_array_member
    global $data_array_values

    set data_array_index data_array_index_$cmd_array_member
    global $data_array_index
    set $data_array_index 0

    set data_array_syntax data_array_syntax_$cmd_array_member
    global $data_array_syntax
    set $data_array_syntax ""

  } 

#   read tngid.ind
  set imember 0
  set f_ind [open tngid.ind r]
  while { [ gets $f_ind line ] >=0 } {
    set cmd_array_member $cmd_array($imember)
    set data_array_index data_array_index_$cmd_array_member
    set $data_array_index $line
    incr imember
  }
  close $f_ind

#   read html syntax info
  set files_list {}
  catch {set files_list [glob $tnpath/doc/tnu/node*.html]}
  foreach file $files_list { 
    set foundtitle 0
    set f_html [open $file r]
    while { [ gets $f_html tmp ] >=0 && !$foundtitle } {
      set ind [string first TITLE $tmp]
      if { $ind>=0 } {
        set length [string length $tmp]
        set last [expr $length-9]
        set line [string range $tmp 7 $last]
        set line_list [ split $line ]
        set first_word [ lindex $line_list 0 ]
        set remainder_list [ lrange $line_list 1 end ]
        set remainder [ join $remainder_list ]
        for { set imember 0 } { $imember<$cmd_array_length } { incr imember } {
          set cmd_array_member $cmd_array($imember)
          if { $first_word ==  $cmd_array_member } {
            set foundtitle 1
            set data_array_syntax data_array_syntax_$cmd_array_member
            set $data_array_syntax $remainder
          }
        }
      }
    }
    close $f_html
  }

  if { $tn_switch } { puts "Out proc DATA_INITIALISE" }

}
