/*
   Copyright (C) 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/* 
 * ComboP.h - Private definitions for Combo widget
 * 
 */

#ifndef _XawComboP_h
#define _XawComboP_h

/***********************************************************************
 *
 * Combo Widget Private Data
 *
 ***********************************************************************/

#include "Combo.h"
#include <X11/Xmu/Converters.h>

/* New fields for the Combo widget class record */
typedef struct {int empty;} ComboClassPart;

/* Full class record declaration */
typedef struct _ComboClassRec {
    CoreClassPart	core_class;
    CompositeClassPart  composite_class;
    ComboClassPart	combo_class;
} ComboClassRec;

extern ComboClassRec comboClassRec;

/* New fields for the Combo widget record */
typedef struct {
    /* resources */
	void (*text_cb)(char *);
	void (*list_cb)(char *);
	Widget topLevel;

    /* private state */
	char **data;
	int ndata;
	Widget text, cmd, shell, viewport, list;
} ComboPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _ComboRec {
    CorePart	    core;
    CompositePart   composite;
    ComboPart 	    combo;
} ComboRec;

#endif /* _XawComboP_h */
