/*
    Copyright (C) 1996-1998  Ulric Eriksson <ulric@edu.stockholm.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston,
    MA 02111-1307, USA.
*/

#ifndef FONTS_H
#define FONTS_H

#define SFMT_FAMILY (1<<0)
#define SFMT_SIZE (1<<1)
#define SFMT_BOLD (1<<2)
#define SFMT_ITALIC (1<<3)
#define SFMT_ULINE (1<<4)
#define SFMT_FG (1<<5)
#define SFMT_BG (1<<6)
#define SFMT_BORDERS (1<<7)
#define SFMT_VADJ (1<<8)
#define SFMT_HADJ (1<<9)
#define SFMT_STYLE (1<<10)

typedef struct sfmt {
	char *family;
	int size;
	int bold, italic, uline;
	char *fg, *bg;
	int borders;
	int vadj, hadj;
	int style;
} sfmt;

extern void decode_format(int, long, sfmt *);
extern int encode_format(long, sfmt *);

#define BORDER_MASK (BORDER_LEFT | BORDER_RIGHT | BORDER_TOP | BORDER_BOTTOM)
#define BORDER_LEFT (256)
#define BORDER_RIGHT (512)
#define BORDER_TOP (1024)
#define BORDER_BOTTOM (2048)

#define HADJ_MASK (4096 | 8192)
#define HADJ_LEFT (0)
#define HADJ_CENTER (8192)
#define HADJ_RIGHT (4096+8192)

#define VADJ_MASK (16384 | 32768)
#define VADJ_TOP (16384)
#define VADJ_CENTER (0)
#define VADJ_BOTTOM (16384+32768)

/* First available bit is 65536 = 0x10000 = (1 << 16) */
#define FMT_SHIFT (16)
#define FMT_MASK (15<<FMT_SHIFT)

/* not used in PW */
#define FMT_DEFAULT (0<<FMT_SHIFT)
#define FMT_INVISIBLE (1<<FMT_SHIFT)
#define FMT_INTEGER (2<<FMT_SHIFT)
#define FMT_SCIENTIFIC (3<<FMT_SHIFT)
#define FMT_FIXED (4<<FMT_SHIFT)
#define FMT_DATE (5<<FMT_SHIFT)
#define FMT_TIME (6<<FMT_SHIFT)
#define FMT_TIMEDIFF (7<<FMT_SHIFT)
#define FMT_PERCENT (8<<FMT_SHIFT)
#define FMT_HEX (9<<FMT_SHIFT)
#define FMT_CURRENCY (10<<FMT_SHIFT)
#define FMT_USER1 (11<<FMT_SHIFT)
#define FMT_USER2 (12<<FMT_SHIFT)
#define FMT_USER3 (13<<FMT_SHIFT)
#define FMT_USER4 (14<<FMT_SHIFT)
#define FMT_USER5 (15<<FMT_SHIFT)

/* only used in PW but does no harm in SIAG */
#define STY_MASK 15
#define STY_DEFAULT 0
#define STY_HEADER1 1
#define STY_HEADER2 2
#define STY_HEADER3 3
#define STY_HEADER4 4
#define STY_HEADER5 5
#define STY_HEADER6 6
#define STY_ADDRESS 7
#define STY_TITLE 8
#define STY_ABSTRACT 9
#define STY_PREFORMAT 10
#define STY_USER1 11
#define STY_USER2 12
#define STY_USER3 13
#define STY_USER4 14
#define STY_USER5 15
#define STY_EMBED STY_USER5

extern char *family2name(int);
extern char *size2name(int);
extern char *color2name(int);

extern int fmt_attr2mask(char *);
extern char *fmt_mask2attr(int);

/* new format stuff */

/* this structure holds all the format properties of a single character,
   including the XLFD name, the Postscript name and foreground and
   background colours. The last field is for the special cell format
   properties used by Siag. They will be 0 for any other application
*/
typedef struct {
	int font;	/* index into font table */
	char uline;
	int fg, bg;	/* index into colour table */
	int style;
	long siagfmt;	/* old-style Siag attributes */
} siag_format;

extern siag_format format_table[];
extern int nformat;
extern int lookup_format(int, int, int, int, int, int);

extern int register_x_font(char *, char *, char *, char *, char *);
extern int register_ps_font(char *, char *, char *, char *, char *);
extern int register_t1_font(char *, char *, char *, char *, char *);
extern int font_alias(char *, char *);
extern char *lookup_fontalias(char *);
extern int register_color(char *, unsigned short,
			  unsigned short, unsigned short);
extern int fmt_old2new(long);
extern long fmt_new2old(int);
extern void save_formats(FILE *, int);
extern int load_formats(FILE *);

extern char *ps_fontname(int);
extern int ps_fontsize(int);

extern char **font_list(int *);
extern char **color_list(int *);

extern void ps_makefonts(FILE *);
extern void ps_set_font(FILE *, int);

#endif
