static char rcsid[] = "$Id: shell_hash.c,v 1.6 1996/06/28 22:46:34 dhb Exp $";

/*
** $Log: shell_hash.c,v $
** Revision 1.6  1996/06/28 22:46:34  dhb
** Added paragon to systems requiring alignment of memory in hmalloc().
** Previous paragon port changes included this but only for machine
** type GenericMachine which was used during porting.  Using
** GenericMachine for unknown machines (i.e. MACHINE=other) is still
** a good idea as alignment of memory should be the default.
**
** Revision 1.5  1996/06/06  20:48:31  dhb
** merged in 1.3.1.1 changes.
**
** Revision 1.4  1996/05/23  23:15:45  dhb
** t3d/e port
**
** Revision 1.3.1.1  1996/06/06  20:05:49  dhb
** Paragon port.
**
** Revision 1.3  1994/04/14  16:40:57  dhb
** Merged in 1.1.1.1
**
** Revision 1.2  1993/09/17  17:02:38  dhb
** Solaris compatability.
**
** Revision 1.1.1.1  1994/04/14  16:38:20  dhb
** Alpha compatability changes from ngoddard@psc.edu.
**
** Revision 1.1  1992/12/11  19:04:30  dhb
** Initial revision
**
*/

#include "shell_ext.h"
#if defined(__hpux) || defined(CRAY)
#include <sys/param.h>
#endif
#ifdef Solaris
#include <unistd.h>
#endif

static HASH 		*info_hash_table;
static HASH 		*func_name_hash_table;
static HASH 		*func_adr_hash_table;
static HASH 		*field_hash_table;

#define HASHSIZE	10000

/*
** hash table allocation routines
*/

/*
** the 256000 blocksize is important in that it avoids a nasty
** bug in the DEC malloc routine which wastes large amounts
** of memory when allocating blocks smaller than this
*/
#define BLOCKSIZE 256000
struct mem_chunk {
    char		*adr;
    struct mem_chunk	*next;
};

/*
** start_chunk 
**	points to the beginning of the memory allocation table
**	this table consists of a linked list of table entries. Each entry
**	points to a block of memory given by BLOCKSIZE
** current_chunk 
**	points to the beginning of the current allocation table entry.
** current_ptr 
**	points to the beginning of the current memory block being allocated.
** current_offset
**	gives the offset of the next allocatable memory location in the current 
**	memory block.
*/
static struct mem_chunk start_chunk = { NULL,NULL};
static struct mem_chunk *current_chunk = &start_chunk;
static char *current_ptr = NULL;
static int current_offset = 0;
static int PAGESIZE;

/*
** return the amount of memory currently allocated by hmalloc
*/
int hmalloc_used()
{
struct mem_chunk *ptr;
int	size=0;
int 	count=0;

    /*
    ** count all the allocated blocks
    */
    for(ptr = &start_chunk;ptr;ptr=ptr->next){
	size += BLOCKSIZE;
	count++;
    }
    size -= BLOCKSIZE - current_offset;
    printf("%d in %d blocks : current offset = %d\n",
    size,count,current_offset);
    return(size);
}

/*
** allocate a new memory allocation table
*/
void init_hmalloc()
{
#ifndef i860
#ifdef __hpux
    PAGESIZE = NBPG;
#elif defined(CRAY)
    PAGESIZE = NBPC;
#elif defined(Solaris)
    PAGESIZE = sysconf(_SC_PAGESIZE);
#else
    PAGESIZE = getpagesize();
#endif
#endif
    current_chunk = &start_chunk;
    current_ptr = current_chunk->adr = (char *)malloc(BLOCKSIZE);
    current_chunk->next = NULL;
    current_offset = 0;
}

/*
** allocate a block of memory. This memory can only be freed
** using the hfree_all function which frees all blocks allocated
** using the hmalloc function.
** This malloc has minimal housekeeping overhead and is therefore
** quite efficient when dealing with once-only allocations
** particularly of many small blocks
*/
char *hmalloc(size)
int size;
{
char *ptr;

#if defined(mips) || defined(sun4) || defined(Solaris) || defined(hpux) || defined(decalpha) || defined(paragon) || defined(GenericMachine)
    /*
    ** align the current_offset to word boundaries
    */
    current_offset += WORDSIZE - ((ADDR)(current_ptr +current_offset)%WORDSIZE);
    /*
    ** align the current_offset to page boundaries
    */
    if((ADDR)(current_ptr +current_offset)%PAGESIZE + size > PAGESIZE){
	current_offset += PAGESIZE-((ADDR)(current_ptr+current_offset)%PAGESIZE);
    }
#endif
    /*
    ** check for block overflow
    */
    if(current_offset + size >= BLOCKSIZE){
	/*
	** this chunk is full so allocate another
	*/
	current_chunk->next=(struct mem_chunk*)malloc(sizeof(struct mem_chunk));
	current_chunk = current_chunk->next;
	current_chunk->next = NULL;
	current_ptr = current_chunk->adr = (char *)malloc(BLOCKSIZE);
	current_offset = 0;
    }
    /*
    ** return the memory
    */
    ptr = current_ptr + current_offset;
    current_offset += size;
    return(ptr);
}

/*
** allocate and zero a block
*/
char *hcalloc(n,size)
int n;
int size;
{
char *ptr;

    ptr = hmalloc(n*size);
    bzero(ptr,n*size);
    return(ptr);
}

/*
** place holder function for 
** individual block freeing which does nothing
** since this would require additional housekeeping overhead
** which is best left to malloc
*/
int hfree(ptr)
char *ptr;
{
}

/*
** free all memory in the allocation table
*/
int hfreeall()
{
struct mem_chunk *ptr;

    /*
    ** free all the allocated blocks
    */
    for(ptr = &start_chunk;ptr;ptr=ptr->next){
	free(ptr->adr);
	free(ptr);
    }
    /*
    ** reinitialize the allocator
    */
    init_hmalloc();
}

#undef BLOCKSIZE

HashInit(){
    InfoHashInit();
    FieldHashInit();
    FuncNameHashInit();
    FuncAdrHashInit();
}

/*
** Hash table utilities
*/
InfoHashInit()
{
HASH *hash_create();

    /*
    ** prepare the hash table memory allocator
    */
    init_hmalloc();
    /*
    ** create the hash table
    */
    info_hash_table = hash_create(HASHSIZE);
}

InfoHashPut(info)
Info *info;
{
ENTRY	item,*hash_enter();

	item.data = (char *)hmalloc(sizeof(Info));
	bcopy(info,item.data,sizeof(Info));
	item.key = (char *)(((Info *)(item.data))->name);
	/*
	* put the var into the table
	*/
	if(hash_enter(&item,info_hash_table) == NULL){
		Error();
		printf("hash table full\n");
	};
}

Info *InfoHashFind(key)
char	*key;
{
ENTRY	*found_item,*hash_find();

	/*
	* get the info from the table
	*/
	if((found_item = hash_find(key,info_hash_table)) != NULL){
		return((Info *)found_item->data);
	} else
		return(NULL);
}

FieldHashInit()
{
HASH *hash_create();

	/*
	* create the table
	*/
	field_hash_table = hash_create(HASHSIZE);
}

/*
** makes it own copies of the key and field and places it into the
** hash table
*/
FieldHashPut(key,fields)
char *key;
char *fields;
{
ENTRY	item,*hash_enter();

	item.key = (char *)hmalloc(strlen(key)+1);
	strcpy(item.key,key);
	item.data = (char *)hmalloc(strlen(fields)+1);
	strcpy(item.data,fields);
	/*
	* put the fields into the table
	*/
	if(hash_enter(&item,field_hash_table) == NULL){
		Error();
		printf("hash table full\n");
	};
}

char *FieldHashFind(key)
char	*key;
{
ENTRY	*found_item,*hash_find();

	/*
	* get the info from the table
	*/
	if((found_item = hash_find(key,field_hash_table)) != NULL){
		return(found_item->data);
	} else
		return(NULL);
}

FuncAdrHashInit()
{
HASH *hash_create();

	/*
	* create the table
	*/
	func_adr_hash_table = hash_create(HASHSIZE);
}

FuncAdrHashPut(func)
FuncTable *func;
{
ENTRY	item,*hash_enter();
char adr[80];

	item.data = (char *)hmalloc(sizeof(FuncTable));
	bcopy(func,item.data,sizeof(FuncTable));
	sprintf(adr,"%d",func->adr);
	item.key = (char *)hmalloc(strlen(adr)+1);
	strcpy(item.key,adr);
	/*
	* put the fields into the table
	*/
	if(hash_enter(&item,func_adr_hash_table) == NULL){
		Error();
		printf("hash table full\n");
	};
}

FuncTable *FuncAdrHashFind(key)
char	*key;
{
ENTRY	*found_item,*hash_find();

	/*
	* get the info from the table
	*/
	if((found_item = hash_find(key,func_adr_hash_table)) != NULL){
		return((FuncTable *)(found_item->data));
	} else
		return(NULL);
}

FuncNameHashInit()
{
HASH *hash_create();

	/*
	* create the table
	*/
	func_name_hash_table = hash_create(HASHSIZE);
}

FuncNameHashPut(func)
FuncTable *func;
{
ENTRY	item,*hash_enter();

	item.data = (char *)hmalloc(sizeof(FuncTable));
	bcopy(func,item.data,sizeof(FuncTable));
	item.key = (char *)hmalloc(strlen(func->name)+1);
	strcpy(item.key,func->name);
	/*
	* put the fields into the table
	*/
	if(hash_enter(&item,func_name_hash_table) == NULL){
		Error();
		printf("hash table full\n");
	};
}

FuncTable *FuncNameHashFind(key)
char	*key;
{
ENTRY	*found_item,*hash_find();

	/*
	* get the info from the table
	*/
	if((found_item = hash_find(key,func_name_hash_table)) != NULL){
		return((FuncTable *)(found_item->data));
	} else
		return(NULL);
}

HashFunc(name,adr,type)
char *name;
PFI adr;
char *type;
{
FuncTable func;

    func.name = CopyString(name);
    func.type = CopyString(type);
    func.adr = (PFI)adr;
    FuncNameHashPut(&func);
    FuncAdrHashPut(&func);
}

