/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef droite_h
#define droite_h
#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Class derived from the base class droite_c
// Class 'droite1', line defined by two points
class droite1:public droite_c
{
  public:
  point_c * M2;
  droite1 (void):droite_c ()
  {
    classe = DR_2PT;
  }
  droite1 (liste_elem & lp):droite_c ()
  {
    M1 = (point_c *) lp.lire (1);;
    M2 = (point_c *) lp.lire (2);
    init_nom ();
    classe = DR_2PT;
  }
  droite1 (char a, char b, char c, char d, liste_elem & lp):droite_c (a, b, c, d)
  {
    M1 = (point_c *) lp.lire (1);
    M2 = (point_c *) lp.lire (2);
    init_nom ();
    classe = DR_2PT;
  }
  virtual void init_nom (void);
  droite_s coordonnees (void);
  void move (int xm, int ym);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Class 'droite_parallele1', line parallel to another line
class droite_parallele1:public droite_c
{
  public:
  droite_c * parallele;
  droite_parallele1 (void):droite_c ()
  {
    classe = DR_PA_DR;
  }
  droite_parallele1 (liste_elem & lp):droite_c ()
  {
    figure_c *parent1, *parent2;
    parent1 = (figure_c *) lp.lire (1);
    parent2 = (figure_c *) lp.lire (2);
    if (parent1->type == FIG_POINT)
      {
	M1 = (point_c *) parent1;
	parallele = (droite_c *) parent2;
      }
    else
      {
	M1 = (point_c *) parent2;
	parallele = (droite_c *) parent1;
      }
    classe = DR_PA_DR;
    init_nom ();
  }
  droite_parallele1 (char a, char b, char c, char d, liste_elem & lp):droite_c (a, b, c, d)
  {
    figure_c *parent1, *parent2;
    parent1 = (figure_c *) lp.lire (1);
    parent2 = (figure_c *) lp.lire (2);
    if (parent1->type == FIG_POINT)
      {
	M1 = (point_c *) parent1;
	parallele = (droite_c *) parent2;
      }
    else
      {
	M1 = (point_c *) parent2;
	parallele = (droite_c *) parent1;
      }
    classe = DR_PA_DR;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s directeur (void);
  vecteur_s normal (void);
  double pente (void);
  char dependance (figure_c * fig);
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
};
// Class 'droite_parallele2',  a line parallel to a line defined by two points
class droite_parallele2:public droite_c
{
  public:
  point_c * p1, *p2;
  droite_parallele2 (void):droite_c ()
  {
    classe = DR_PA_2PT;
  }
  droite_parallele2 (liste_elem & lp):droite_c ()
  {
    M1 = (point_c *) lp.lire (1);
    p1 = (point_c *) lp.lire (2);
    p2 = (point_c *) lp.lire (3);
    classe = DR_PA_2PT;
    init_nom ();
  }
  droite_parallele2 (char a, char b, char c, char d, liste_elem & lp):droite_c (a, b, c, d)
  {
    M1 = (point_c *) lp.lire (1);
    p1 = (point_c *) lp.lire (2);
    p2 = (point_c *) lp.lire (3);
    classe = DR_PA_2PT;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s directeur (void);
  vecteur_s normal (void);
  double pente (void);
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Class 'droite_orthogonale1', a line perpendicular to a line
class droite_orthogonale1:public droite_c
{
  public:
  droite_c * orthogonale;
  droite_orthogonale1 (void):droite_c ()
  {
    classe = DR_OR_DR;
  }
  droite_orthogonale1 (liste_elem & lp):droite_c ()
  {
    figure_c *parent1, *parent2;
    parent1 = (figure_c *) lp.lire (1);
    parent2 = (figure_c *) lp.lire (2);
    if (parent1->type == FIG_POINT)
      {
	M1 = (point_c *) parent1;
	orthogonale = (droite_c *) parent2;
      }
    else
      {
	M1 = (point_c *) parent2;
	orthogonale = (droite_c *) parent1;
      }
    classe = DR_OR_DR;
    init_nom ();
  }
  droite_orthogonale1 (char a, char b, char c, char d, liste_elem & lp):droite_c (a, b, c, d)
  {
    figure_c *parent1, *parent2;
    parent1 = (figure_c *) lp.lire (1);
    parent2 = (figure_c *) lp.lire (2);
    if (parent1->type == FIG_POINT)
      {
	M1 = (point_c *) parent1;
	orthogonale = (droite_c *) parent2;
      }
    else
      {
	M1 = (point_c *) parent2;
	orthogonale = (droite_c *) parent1;
      }
    classe = DR_OR_DR;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s directeur (void);
  vecteur_s normal (void);
  double pente (void);
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Class 'droite_orthogonale2,' a line perpendicular to a line defined by two points
class droite_orthogonale2:public droite_c
{
  public:
  point_c * p1, *p2;
  droite_orthogonale2 (void):droite_c ()
  {
    classe = DR_OR_2PT;
  }
  droite_orthogonale2 (liste_elem & lp):droite_c ()
  {
    M1 = (point_c *) lp.lire (1);
    p1 = (point_c *) lp.lire (2);
    p2 = (point_c *) lp.lire (3);
    classe = DR_OR_2PT;
    init_nom ();
  }
  droite_orthogonale2 (char a, char b, char c, char d, liste_elem & lp):droite_c (a, b, c, d)
  {
    M1 = (point_c *) lp.lire (1);
    p1 = (point_c *) lp.lire (2);
    p2 = (point_c *) lp.lire (3);
    classe = DR_OR_2PT;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s directeur (void);
  vecteur_s normal (void);
  double pente (void);
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// Transformed line
// By reflexion
class reflexion_droite:public droite_c
{
  public:
  droite_c * axe, *droite;
  reflexion_droite (void):droite_c ()
  {
    classe = DR_RE;
  }
  reflexion_droite (liste_elem & lp):droite_c ()
  {
    droite = (droite_c *) lp.lire (2);
    axe = (droite_c *) lp.lire (1);
    actualise ();
    classe = DR_RE;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By symetry
class symetrie_droite:public droite_c
{
  public:
  droite_c * droite;
  point_c *symetrie;
    symetrie_droite ():droite_c ()
  {
    classe = DR_SY;
  }
  symetrie_droite (liste_elem & lp):droite_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_DROITE)
      {
	droite = (droite_c *) f1;
	symetrie = (point_c *) f2;
      }
    else
      {
	droite = (droite_c *) f2;
	symetrie = (point_c *) f1;
      }
    actualise ();
    classe = DR_SY;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By translation
class translation_droite:public droite_c
{
  public:
  droite_c * droite;
  vecteur_c *v;
    translation_droite ():droite_c ()
  {
    classe = DR_TR;
  }
  translation_droite (liste_elem & lp):droite_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_DROITE)
      {
	droite = (droite_c *) f1;
	v = (vecteur_c *) f2;
      }
    else
      {
	droite = (droite_c *) f2;
	v = (vecteur_c *) f1;
      }
    actualise ();
    classe = DR_TR;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By rotation
class rotation_droite:public droite_c
{
  public:
  droite_c * droite;
  point_c *c;
  valeur_c *v;
    rotation_droite ():droite_c ()
  {
    classe = DR_RO;
  }
  rotation_droite (liste_elem & lp):droite_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    droite = (droite_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    droite = (droite_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    droite = (droite_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    droite = (droite_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    droite = (droite_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    droite = (droite_c *) f1;
	  }
      }
    actualise ();
    classe = DR_RO;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By homothetie
class homothetie_droite:public droite_c
{
  public:
  droite_c * droite;
  point_c *c;
  valeur_c *v;
    homothetie_droite ():droite_c ()
  {
    classe = DR_HO;
  }
  homothetie_droite (liste_elem & lp):droite_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    droite = (droite_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    droite = (droite_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    droite = (droite_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    droite = (droite_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    droite = (droite_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    droite = (droite_c *) f1;
	  }
      }
    actualise ();
    classe = DR_HO;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};

#endif
